/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.slice.Slices;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcWriterOptions;
import io.prestosql.plugin.hive.AbstractTestHiveFileFormats;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.RcFileFileWriterFactory;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.orc.OrcFileWriterFactory;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetFileWriterFactory;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.testing.StructuralTestUtil;
import io.prestosql.testing.TestingConnectorSession;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveFileFormats
extends AbstractTestHiveFileFormats {
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final ConnectorSession PARQUET_SESSION = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(false));
    private static final ConnectorSession PARQUET_SESSION_USE_NAME = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(true));

    @DataProvider(name="rowCount")
    public static Object[][] rowCountProvider() {
        return new Object[][]{{0}, {1000}};
    }

    @DataProvider(name="validRowAndFileSizePadding")
    public static Object[][] validFileSizePaddingProvider() {
        return new Object[][]{{0, 0L}, {0, 16L}, {10, 1L}, {1000, 64L}};
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        Assert.assertEquals((String)TimeZone.getDefault().getID(), (String)"America/Bahia_Banderas", (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testTextFile(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testSequenceFile(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testCsvFile(int rowCount, long fileSizePadding) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(column -> column.isPartitionKey() || "string".equals(column.getType()) && !column.getName().contains("_null_")).collect(ImmutableList.toImmutableList());
        Assert.assertTrue((testColumns.size() > 5 ? 1 : 0) != 0);
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test
    public void testCsvFileWithNullAndValue() throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("t_null_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, null, Slices.utf8Slice((String)"")), (Object)new AbstractTestHiveFileFormats.TestColumn("t_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test")))).withRowsCount(2).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testJson(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_binary")).filter(column -> !column.getName().equals("t_map_tinyint")).filter(column -> !column.getName().equals("t_map_smallint")).filter(column -> !column.getName().equals("t_map_int")).filter(column -> !column.getName().equals("t_map_bigint")).filter(column -> !column.getName().equals("t_map_float")).filter(column -> !column.getName().equals("t_map_double")).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.getName().equals("t_decimal_precision_38")).filter(column -> !column.getName().equals("t_map_decimal_precision_38")).filter(column -> !column.getName().equals("t_array_decimal_precision_38")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.JSON).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testRcTextPageSource(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextOptimizedWriter(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(ImmutableList.toImmutableList());
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryOptimizedWriter(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> testColumnsNoTimestamps = testColumns.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig())).withColumns(testColumnsNoTimestamps).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrc(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrcOptimizedWriter(int rowCount, long fileSizePadding) throws Exception {
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig(), new OrcReaderConfig(), new OrcWriterConfig().setValidationPercentage(100.0), new ParquetReaderConfig(), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileSizePadding(fileSizePadding).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), false, STATS, new OrcWriterOptions())).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNames(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(ImmutableList.toImmutableList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumns).withRowsCount(rowCount).withReadColumns(Lists.reverse((List)testColumns)).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNameLowerCaseConversion(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumnsUpperCase = TEST_COLUMNS.stream().map(testColumn -> new AbstractTestHiveFileFormats.TestColumn(testColumn.getName().toUpperCase(Locale.ENGLISH), testColumn.getObjectInspector(), testColumn.getWriteValue(), testColumn.getExpectedValue(), testColumn.isPartitionKey())).collect(Collectors.toList());
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumnsUpperCase).withRowsCount(rowCount).withReadColumns(TEST_COLUMNS).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testAvro(int rowCount, long fileSizePadding) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withColumns(TestHiveFileFormats.getTestColumnsSupportedByAvro()).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="rowCount")
    public void testAvroFileInSymlinkTable(int rowCount) throws Exception {
        File file = File.createTempFile("presto_test", HiveStorageFormat.AVRO.name());
        file.delete();
        try {
            FileSplit split = TestHiveFileFormats.createTestFileHive(file.getAbsolutePath(), HiveStorageFormat.AVRO, HiveCompressionCodec.NONE, TestHiveFileFormats.getTestColumnsSupportedByAvro(), rowCount);
            Properties splitProperties = new Properties();
            splitProperties.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
            splitProperties.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerDe());
            this.testCursorProvider(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), split, splitProperties, TestHiveFileFormats.getTestColumnsSupportedByAvro(), HiveTestUtils.SESSION, file.length(), rowCount);
        }
        finally {
            file.delete();
        }
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByAvro() {
        return TEST_COLUMNS.stream().filter(column -> !column.getName().startsWith("t_map_") || column.getName().equals("t_map_string")).filter(column -> !column.getName().endsWith("_smallint")).filter(column -> !column.getName().endsWith("_tinyint")).collect(Collectors.toList());
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSource(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSourceGzip(int rowCount, long fileSizePadding) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withCompressionCodec(HiveCompressionCodec.GZIP).withFileSizePadding(fileSizePadding).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testOptimizedParquetWriter(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new ParquetWriterConfig().setParquetOptimizedWriterEnabled(true));
        Assert.assertTrue((boolean)HiveSessionProperties.isParquetOptimizedWriterEnabled((ConnectorSession)session));
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withSession((ConnectorSession)session).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new ParquetFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER)).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceSchemaEvolution(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List readColumns = writeColumns.stream().map(column -> new AbstractTestHiveFileFormats.TestColumn(column.getName() + "_new", column.getObjectInspector(), column.getWriteValue(), column.getExpectedValue(), column.isPartitionKey())).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
        readColumns = Lists.reverse(writeColumns);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByParquet() {
        return TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.getName().equals("t_null_array_int")).filter(column -> !column.getName().equals("t_array_empty")).filter(column -> column.isPartitionKey() || !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.SHORT) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.BYTE)).collect(Collectors.toList());
    }

    @Test
    public void testTruncateVarcharColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn writeColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(4)), new HiveVarchar("test", 4), Slices.utf8Slice((String)"test"));
        AbstractTestHiveFileFormats.TestColumn readColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig())).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig())).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession(PARQUET_SESSION).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testAvroProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByAvro();
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByRecordCursorPageSource(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testParquetProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testORCProjectedColumns(int rowCount) throws Exception {
        List supportedColumns = TEST_COLUMNS;
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testSequenceFileProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByRecordCursorPageSource(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testTextFileProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByRecordCursorPageSource(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRCTextProjectedColumns(int rowCount) throws Exception {
        List supportedColumns = (List)TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_struct_null") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(ImmutableList.toImmutableList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByRecordCursorPageSource(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRCTextProjectedColumnsPageSource(int rowCount) throws Exception {
        List supportedColumns = TEST_COLUMNS;
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumns(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> {
            String name = testColumn.getName();
            return !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_empty_varchar");
        }).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumnsPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).collect(Collectors.toList());
        List<AbstractTestHiveFileFormats.TestColumn> regularColumns = this.getRegularColumns(supportedColumns);
        List<AbstractTestHiveFileFormats.TestColumn> partitionColumns = this.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        this.generateProjectedColumns(regularColumns, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)writeColumns).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()));
    }

    @Test
    public void testFailForLongVarcharPartitionColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn partitionColumn = new AbstractTestHiveFileFormats.TestColumn("partition_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), "test", Slices.utf8Slice((String)"tes"), true);
        AbstractTestHiveFileFormats.TestColumn varcharColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        ImmutableList columns = ImmutableList.of((Object)partitionColumn, (Object)varcharColumn);
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_INVALID_PARTITION_VALUE;
        String expectedMessage = "Invalid partition value 'test' for varchar(3) partition key: partition_column";
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()), expectedErrorCode, expectedMessage).isFailingForRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS, new HiveConfig()), expectedErrorCode, expectedMessage).isFailingForRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HivePageSourceFactory)new OrcPageSourceFactory(new OrcReaderOptions(), HiveTestUtils.HDFS_ENVIRONMENT, STATS, DateTimeZone.UTC), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession(PARQUET_SESSION).isFailingForPageSource((HivePageSourceFactory)new ParquetPageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT, STATS, new ParquetReaderConfig(), new HiveConfig()), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor(HiveTestUtils.createGenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), expectedErrorCode, expectedMessage);
    }

    private void testRecordPageSource(HiveRecordCursorProvider cursorProvider, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session, long fileSize, int rowCount) throws Exception {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerDe());
        ConnectorPageSource pageSource = this.createPageSourceFromCursorProvider(cursorProvider, split, splitProperties, fileSize, testReadColumns, session);
        this.checkPageSource(pageSource, testReadColumns, HiveTestUtils.getTypes(this.getColumnHandles(testReadColumns)), rowCount);
    }

    private void testCursorProvider(HiveRecordCursorProvider cursorProvider, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session, long fileSize, int rowCount) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerDe());
        this.testCursorProvider(cursorProvider, split, splitProperties, testReadColumns, session, fileSize, rowCount);
    }

    private void testCursorProvider(HiveRecordCursorProvider cursorProvider, FileSplit split, Properties splitProperties, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session, long fileSize, int rowCount) {
        ConnectorPageSource pageSource = this.createPageSourceFromCursorProvider(cursorProvider, split, splitProperties, fileSize, testReadColumns, session);
        RecordCursor cursor = ((RecordPageSource)pageSource).getCursor();
        this.checkCursor(cursor, testReadColumns, rowCount);
    }

    private ConnectorPageSource createPageSourceFromCursorProvider(HiveRecordCursorProvider cursorProvider, FileSplit split, Properties splitProperties, long fileSize, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session) {
        ImmutableList.Builder splitPropertiesColumnNames = ImmutableList.builder();
        ImmutableList.Builder splitPropertiesColumnTypes = ImmutableList.builder();
        HashSet<String> baseColumnNames = new HashSet<String>();
        for (AbstractTestHiveFileFormats.TestColumn testReadColumn : testReadColumns) {
            String name = testReadColumn.getBaseName();
            if (baseColumnNames.contains(name) || testReadColumn.isPartitionKey()) continue;
            baseColumnNames.add(name);
            splitPropertiesColumnNames.add((Object)name);
            splitPropertiesColumnTypes.add((Object)testReadColumn.getBaseObjectInspector().getTypeName());
        }
        splitProperties.setProperty("columns", splitPropertiesColumnNames.build().stream().collect(Collectors.joining(",")));
        splitProperties.setProperty("columns.types", splitPropertiesColumnTypes.build().stream().collect(Collectors.joining(",")));
        List partitionKeys = testReadColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        String partitionName = String.join((CharSequence)"/", (Iterable)partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.getName(), partitionKey.getValue())).collect(ImmutableList.toImmutableList()));
        Configuration configuration = new Configuration(false);
        configuration.set("io.compression.codecs", LzoCodec.class.getName() + "," + LzopCodec.class.getName());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)cursorProvider), (Configuration)configuration, (ConnectorSession)session, (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)fileSize, (long)Instant.now().toEpochMilli(), (Properties)splitProperties, (TupleDomain)TupleDomain.all(), this.getColumnHandles(testReadColumns), (String)partitionName, partitionKeys, (TypeManager)HiveTestUtils.TYPE_MANAGER, (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), (boolean)false, Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION);
        return (ConnectorPageSource)pageSource.get();
    }

    private void testPageSourceFactory(HivePageSourceFactory sourceFactory, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testReadColumns, ConnectorSession session, long fileSize, int rowCount) throws IOException {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", storageFormat.getInputFormat());
        splitProperties.setProperty("serialization.lib", storageFormat.getSerDe());
        ImmutableList.Builder splitPropertiesColumnNames = ImmutableList.builder();
        ImmutableList.Builder splitPropertiesColumnTypes = ImmutableList.builder();
        HashSet<String> baseColumnNames = new HashSet<String>();
        for (AbstractTestHiveFileFormats.TestColumn testReadColumn : testReadColumns) {
            String name = testReadColumn.getBaseName();
            if (baseColumnNames.contains(name) || testReadColumn.isPartitionKey()) continue;
            baseColumnNames.add(name);
            splitPropertiesColumnNames.add((Object)name);
            splitPropertiesColumnTypes.add((Object)testReadColumn.getBaseObjectInspector().getTypeName());
        }
        splitProperties.setProperty("columns", splitPropertiesColumnNames.build().stream().collect(Collectors.joining(",")));
        splitProperties.setProperty("columns.types", splitPropertiesColumnTypes.build().stream().collect(Collectors.joining(",")));
        List partitionKeys = testReadColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        String partitionName = String.join((CharSequence)"/", (Iterable)partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.getName(), partitionKey.getValue())).collect(ImmutableList.toImmutableList()));
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(testReadColumns);
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)sourceFactory), (Set)ImmutableSet.of(), (Configuration)new Configuration(false), (ConnectorSession)session, (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)fileSize, (long)Instant.now().toEpochMilli(), (Properties)splitProperties, (TupleDomain)TupleDomain.all(), columnHandles, (String)partitionName, partitionKeys, (TypeManager)HiveTestUtils.TYPE_MANAGER, (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), (boolean)false, Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION);
        Assert.assertTrue((boolean)pageSource.isPresent());
        this.checkPageSource((ConnectorPageSource)pageSource.get(), testReadColumns, HiveTestUtils.getTypes(columnHandles), rowCount);
    }

    public static boolean hasType(ObjectInspector objectInspector, PrimitiveObjectInspector.PrimitiveCategory ... types) {
        if (objectInspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveInspector.getPrimitiveCategory();
            for (PrimitiveObjectInspector.PrimitiveCategory type : types) {
                if (primitiveCategory != type) continue;
                return true;
            }
            return false;
        }
        if (objectInspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(listInspector.getListElementObjectInspector(), types);
        }
        if (objectInspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(mapInspector.getMapKeyObjectInspector(), types) || TestHiveFileFormats.hasType(mapInspector.getMapValueObjectInspector(), types);
        }
        if (objectInspector instanceof StructObjectInspector) {
            for (StructField field : ((StructObjectInspector)objectInspector).getAllStructFieldRefs()) {
                if (!TestHiveFileFormats.hasType(field.getFieldObjectInspector(), types)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object inspector type " + objectInspector);
    }

    private static boolean withoutNullMapKeyTests(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_map_null_key") && !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_map_null_key_complex_value");
    }

    private static boolean withoutTimestamps(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_timestamp") && !name.equals("t_map_timestamp") && !name.equals("t_array_timestamp");
    }

    private FileFormatAssertion assertThatFileFormat(HiveStorageFormat hiveStorageFormat) {
        return new FileFormatAssertion(hiveStorageFormat.name()).withStorageFormat(hiveStorageFormat);
    }

    private static HiveConfig createParquetHiveConfig(boolean useParquetColumnNames) {
        return new HiveConfig().setUseParquetColumnNames(useParquetColumnNames);
    }

    private void generateProjectedColumns(List<AbstractTestHiveFileFormats.TestColumn> childColumns, ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn> testFullColumnsBuilder, ImmutableList.Builder<AbstractTestHiveFileFormats.TestColumn> testDereferencedColumnsBuilder) {
        for (int i = 0; i < childColumns.size(); ++i) {
            AbstractTestHiveFileFormats.TestColumn childColumn = childColumns.get(i);
            Preconditions.checkState((childColumn.getDereferenceIndices().size() == 0 ? 1 : 0) != 0);
            StandardStructObjectInspector newObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"field0"), (List)ImmutableList.of((Object)childColumn.getObjectInspector()));
            HiveType hiveType = HiveType.valueOf((String)childColumn.getObjectInspector().getTypeName());
            Type prestoType = hiveType.getType(HiveTestUtils.TYPE_MANAGER);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(childColumn.getWriteValue());
            AbstractTestHiveFileFormats.TestColumn newProjectedColumn = new AbstractTestHiveFileFormats.TestColumn("new_col" + i, (ObjectInspector)newObjectInspector, (List<String>)ImmutableList.of((Object)"field0"), (List<Integer>)ImmutableList.of((Object)0), childColumn.getObjectInspector(), childColumn.getWriteValue(), childColumn.getExpectedValue(), false);
            AbstractTestHiveFileFormats.TestColumn newFullColumn = new AbstractTestHiveFileFormats.TestColumn("new_col" + i, (ObjectInspector)newObjectInspector, list, StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)prestoType), (Object[])new Object[]{childColumn.getExpectedValue()}));
            testFullColumnsBuilder.add((Object)newFullColumn);
            testDereferencedColumnsBuilder.add((Object)newProjectedColumn);
        }
    }

    private final List<AbstractTestHiveFileFormats.TestColumn> getRegularColumns(List<AbstractTestHiveFileFormats.TestColumn> columns) {
        return (List)columns.stream().filter(column -> !column.isPartitionKey()).collect(ImmutableList.toImmutableList());
    }

    private final List<AbstractTestHiveFileFormats.TestColumn> getPartitionColumns(List<AbstractTestHiveFileFormats.TestColumn> columns) {
        return (List)columns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).collect(ImmutableList.toImmutableList());
    }

    private class FileFormatAssertion {
        private final String formatName;
        private HiveStorageFormat storageFormat;
        private HiveCompressionCodec compressionCodec = HiveCompressionCodec.NONE;
        private List<AbstractTestHiveFileFormats.TestColumn> writeColumns;
        private List<AbstractTestHiveFileFormats.TestColumn> readColumns;
        private ConnectorSession session = HiveTestUtils.SESSION;
        private int rowsCount = 1000;
        private HiveFileWriterFactory fileWriterFactory;
        private long fileSizePadding;

        private FileFormatAssertion(String formatName) {
            this.formatName = Objects.requireNonNull(formatName, "formatName is null");
        }

        public FileFormatAssertion withStorageFormat(HiveStorageFormat storageFormat) {
            this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
            return this;
        }

        public FileFormatAssertion withCompressionCodec(HiveCompressionCodec compressionCodec) {
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            return this;
        }

        public FileFormatAssertion withFileWriterFactory(HiveFileWriterFactory fileWriterFactory) {
            this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
            return this;
        }

        public FileFormatAssertion withColumns(List<AbstractTestHiveFileFormats.TestColumn> inputColumns) {
            this.withWriteColumns(inputColumns);
            this.withReadColumns(inputColumns);
            return this;
        }

        public FileFormatAssertion withWriteColumns(List<AbstractTestHiveFileFormats.TestColumn> writeColumns) {
            this.writeColumns = Objects.requireNonNull(writeColumns, "writeColumns is null");
            return this;
        }

        public FileFormatAssertion withReadColumns(List<AbstractTestHiveFileFormats.TestColumn> readColumns) {
            this.readColumns = Objects.requireNonNull(readColumns, "readColumns is null");
            return this;
        }

        public FileFormatAssertion withRowsCount(int rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }

        public FileFormatAssertion withSession(ConnectorSession session) {
            this.session = Objects.requireNonNull(session, "session is null");
            return this;
        }

        public FileFormatAssertion withFileSizePadding(long fileSizePadding) {
            this.fileSizePadding = fileSizePadding;
            return this;
        }

        public FileFormatAssertion isReadableByPageSource(HivePageSourceFactory pageSourceFactory) throws Exception {
            this.assertRead(Optional.of(pageSourceFactory), Optional.empty(), false);
            return this;
        }

        public FileFormatAssertion isReadableByRecordCursorPageSource(HiveRecordCursorProvider cursorProvider) throws Exception {
            this.assertRead(Optional.empty(), Optional.of(cursorProvider), true);
            return this;
        }

        public FileFormatAssertion isReadableByRecordCursor(HiveRecordCursorProvider cursorProvider) throws Exception {
            this.assertRead(Optional.empty(), Optional.of(cursorProvider), false);
            return this;
        }

        public FileFormatAssertion isFailingForPageSource(HivePageSourceFactory pageSourceFactory, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.of(pageSourceFactory), Optional.empty(), expectedErrorCode, expectedMessage, false);
            return this;
        }

        public FileFormatAssertion isFailingForRecordCursor(HiveRecordCursorProvider cursorProvider, HiveErrorCode expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.empty(), Optional.of(cursorProvider), expectedErrorCode, expectedMessage, false);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assertRead(Optional<HivePageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider, boolean withRecordPageSource) throws Exception {
            Assert.assertNotNull((Object)this.storageFormat, (String)"storageFormat must be specified");
            Assert.assertNotNull(this.writeColumns, (String)"writeColumns must be specified");
            Assert.assertNotNull(this.readColumns, (String)"readColumns must be specified");
            Assert.assertNotNull((Object)this.session, (String)"session must be specified");
            Assert.assertTrue((this.rowsCount >= 0 ? 1 : 0) != 0, (String)"rowsCount must be non-negative");
            String compressionSuffix = this.compressionCodec.getCodec().map(codec -> {
                try {
                    return ((CompressionCodec)codec.getConstructor(new Class[0]).newInstance(new Object[0])).getDefaultExtension();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).orElse("");
            File file = File.createTempFile("presto_test", this.formatName + compressionSuffix);
            file.delete();
            try {
                FileSplit split = this.fileWriterFactory != null ? AbstractTestHiveFileFormats.createTestFilePresto(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.session, this.rowsCount, this.fileWriterFactory) : AbstractTestHiveFileFormats.createTestFileHive(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.rowsCount);
                long fileSize = split.getLength() + this.fileSizePadding;
                if (pageSourceFactory.isPresent()) {
                    TestHiveFileFormats.this.testPageSourceFactory(pageSourceFactory.get(), split, this.storageFormat, this.readColumns, this.session, fileSize, this.rowsCount);
                }
                if (cursorProvider.isPresent()) {
                    if (withRecordPageSource) {
                        TestHiveFileFormats.this.testRecordPageSource(cursorProvider.get(), split, this.storageFormat, this.readColumns, this.session, fileSize, this.rowsCount);
                    } else {
                        TestHiveFileFormats.this.testCursorProvider(cursorProvider.get(), split, this.storageFormat, this.readColumns, this.session, fileSize, this.rowsCount);
                    }
                }
            }
            finally {
                file.delete();
            }
        }

        private void assertFailure(Optional<HivePageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider, HiveErrorCode expectedErrorCode, String expectedMessage, boolean withRecordPageSource) throws Exception {
            try {
                this.assertRead(pageSourceFactory, cursorProvider, withRecordPageSource);
                Assert.fail((String)"failure is expected");
            }
            catch (PrestoException prestoException) {
                Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)expectedErrorCode.toErrorCode());
                Assert.assertEquals((String)prestoException.getMessage(), (String)expectedMessage);
            }
        }
    }
}

