/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.QueryInfo;
import io.prestosql.metadata.InsertTableHandle;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveInsertTableHandle;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTimestampPrecision;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.planprinter.IoPlanPrinter;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import io.prestosql.testing.AbstractTestIntegrationSmokeTest;
import io.prestosql.testing.DistributedQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.ResultWithQueryId;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.sql.TestTable;
import io.prestosql.tpch.TpchTable;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.TypeDeserializer;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.inject.Provider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS");
    private final String catalog;
    private final Session bucketedSession = HiveQueryRunner.createBucketedSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))));

    public TestHiveIntegrationSmokeTest() {
        this.catalog = "hive";
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.allow-register-partition-procedure", (Object)"true", (Object)"hive.writer-sort-buffer-size", (Object)"1MB")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION, (Object)TpchTable.ORDERS, (Object)TpchTable.REGION)).build();
    }

    @Test
    public void testLackOfPartitionFilterNotAllowed() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test1(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test1(id,a,ds) values(1, 'a','a')", 1L);
        String query = "select id from partition_test1 where a = 'a'";
        String msgRegExp = "Filter required on tpch\\.partition_test1 for at least one partition column:.*";
        this.assertQueryFails(session, query, msgRegExp);
        this.assertQueryFails(session, "explain " + query, msgRegExp);
        this.assertUpdate(session, "DROP TABLE partition_test1");
    }

    @Test
    public void testPartitionFilterRemoved() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test2(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test2(id,a,ds) values(1, 'a','a')", 1L);
        this.assertQueryFails(session, "select id from partition_test2 where ds is not null or true", "Filter required on tpch\\.partition_test2 for at least one partition column:.*");
        this.assertUpdate(session, "DROP TABLE partition_test2");
    }

    @Test
    public void testPartitionFilterIncluded() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test3(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test3(id,a,ds) values(1, 'a','a')", 1L);
        String query = "select id from partition_test3 where ds = 'a'";
        this.assertQuery(session, query, "select 1");
        this.computeActual(session, "explain " + query);
        this.assertUpdate(session, "DROP TABLE partition_test3");
    }

    @Test
    public void testPartitionFilterIncluded2() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test4(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test4(id,a,ds) values(1, 'a','a')", 1L);
        this.assertQuery(session, "select id from partition_test4 where ds is not null", "select 1");
        this.assertUpdate(session, "DROP TABLE partition_test4");
    }

    @Test
    public void testPartitionFilterInferred() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test5(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "create table partition_test6(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test5(id,a,ds) values(1, 'a','a')", 1L);
        this.assertUpdate(session, "insert into partition_test6(id,a,ds) values(1, 'a','a')", 1L);
        this.assertQuery(session, "select a.id, b.id from partition_test5 a join partition_test6 b on (a.ds = b.ds) where a.ds = 'a'", "select 1,1");
        this.assertUpdate(session, "DROP TABLE partition_test5");
        this.assertUpdate(session, "DROP TABLE partition_test6");
    }

    @Test
    public void testJoinPartitionedWithMissingPartitionFilter() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test7(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "create table partition_test8(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test7(id,a,ds) values(1, 'a','a')", 1L);
        this.assertUpdate(session, "insert into partition_test8(id,a,ds) values(1, 'a','a')", 1L);
        this.assertQueryFails(session, "select a.id, b.id from partition_test7 a join partition_test8 b on (a.id = b.id) where a.ds = 'a'", "Filter required on tpch\\.partition_test8 for at least one partition column:.*");
        this.assertUpdate(session, "DROP TABLE partition_test7");
        this.assertUpdate(session, "DROP TABLE partition_test8");
    }

    @Test
    public void testNaNPartition() {
        this.assertUpdate("DROP TABLE IF EXISTS test_nan_partition");
        this.assertUpdate("CREATE TABLE test_nan_partition(a varchar, d double) WITH (partitioned_by = ARRAY['d'])");
        this.assertUpdate("INSERT INTO test_nan_partition VALUES ('b', nan())", 1L);
        this.assertQuery("SELECT a, d, regexp_replace(\"$path\", '.*(/[^/]*/[^/]*/)[^/]*', '...$1...') FROM test_nan_partition", "VALUES ('b', SQRT(-1), '.../test_nan_partition/d=NaN/...')");
        this.assertQueryReturnsEmptyResult("SELECT a FROM test_nan_partition JOIN (VALUES 33e0) u(x) ON d = x");
        this.assertQueryReturnsEmptyResult("SELECT a FROM test_nan_partition JOIN (VALUES 33e0) u(x) ON d = x OR rand() = 42");
        this.assertQueryReturnsEmptyResult("SELECT * FROM test_nan_partition t1 JOIN test_nan_partition t2 ON t1.d = t2.d");
        this.assertQuery("SHOW STATS FOR test_nan_partition", "VALUES ('a', 1, 1, 0, null, null, null), ('d', null, 1, 0, null, null, null), (null, null, null, null, 1, null, null)");
        this.assertUpdate("DROP TABLE IF EXISTS test_nan_partition");
        this.assertUpdate("CREATE TABLE test_nan_partition(a varchar, d double) WITH (partitioned_by = ARRAY['d'])");
        this.assertUpdate("INSERT INTO test_nan_partition VALUES ('a', 42e0), ('b', nan())", 2L);
        this.assertQuery("SELECT a, d, regexp_replace(\"$path\", '.*(/[^/]*/[^/]*/)[^/]*', '...$1...') FROM test_nan_partition", "VALUES   ('a', 42, '.../test_nan_partition/d=42.0/...'),   ('b', SQRT(-1), '.../test_nan_partition/d=NaN/...')");
        this.assertQueryReturnsEmptyResult("SELECT a FROM test_nan_partition JOIN (VALUES 33e0) u(x) ON d = x");
        this.assertQueryReturnsEmptyResult("SELECT a FROM test_nan_partition JOIN (VALUES 33e0) u(x) ON d = x OR rand() = 42");
        this.assertQuery("SELECT * FROM test_nan_partition t1 JOIN test_nan_partition t2 ON t1.d = t2.d", "VALUES ('a', 42, 'a', 42)");
        this.assertQuery("SHOW STATS FOR test_nan_partition", "VALUES ('a', 2, 1, 0, null, null, null), ('d', null, 2, 0, null, null, null), (null, null, null, null, 2, null, null)");
        this.assertUpdate("DROP TABLE test_nan_partition");
    }

    @Test
    public void testJoinWithPartitionFilterOnPartitionedTable() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test9(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "create table partition_test10(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET')");
        this.assertUpdate(session, "insert into partition_test9(id,a,ds) values(1, 'a','a')", 1L);
        this.assertUpdate(session, "insert into partition_test10(id,a,ds) values(1, 'a','a')", 1L);
        this.assertQuery(session, "select a.id, b.id from partition_test9 a join partition_test10 b on (a.id = b.id) where a.ds = 'a'", "SELECT 1, 1");
        this.assertUpdate(session, "DROP TABLE partition_test9");
        this.assertUpdate(session, "DROP TABLE partition_test10");
    }

    @Test
    public void testPartitionPredicateAllowed() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test11(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test11(id,a,ds) values(1, '1','1')", 1L);
        String query = "select id from partition_test11 where cast(ds as integer) = 1";
        this.assertQuery(session, query, "select 1");
        this.computeActual(session, "explain " + query);
        this.assertUpdate(session, "DROP TABLE partition_test11");
    }

    @Test
    public void testNestedQueryWithInnerPartitionPredicate() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test12(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test12(id,a,ds) values(1, '1','1')", 1L);
        String query = "select id from (select * from partition_test12 where cast(ds as integer) = 1) where cast(a as integer) = 1";
        this.assertQuery(session, query, "select 1");
        this.computeActual(session, "explain " + query);
        this.assertUpdate(session, "DROP TABLE partition_test12");
    }

    @Test
    public void testPartitionPredicateDisallowed() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "create table partition_test12(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "insert into partition_test12(id,a,ds) values(1, '1','1')", 1L);
        String query = "select id from partition_test12 where cast(b as integer) = 1";
        this.assertQueryFails(session, query, "Filter required on tpch\\.partition_test12 for at least one partition column:.*");
        this.assertQueryFails(session, "explain " + query, "Filter required on tpch\\.partition_test12 for at least one partition column:.*");
        this.assertUpdate(session, "DROP TABLE partition_test12");
    }

    @Test
    public void testAnalyzeWithPartitionsAllowed() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "CREATE TABLE partition_test14(id integer, a varchar, b varchar, ds varchar) WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO partition_test14(id,a,ds) VALUES(1, 'a','a')", 1L);
        String query = "ANALYZE partition_test14 WITH (PARTITIONS=ARRAY[ARRAY['a']])";
        this.computeActual(session, query);
        this.computeActual(session, "EXPLAIN " + query);
        this.assertUpdate(session, "DROP TABLE partition_test14");
    }

    @Test
    public void testAnalyzeFullTableDisallowed() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty("hive", "query_partition_filter_required", "true").build();
        this.assertUpdate(session, "CREATE TABLE partition_test15(id integer, a varchar, b varchar, ds varchar) WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(session, "INSERT INTO partition_test15(id,a,ds) VALUES(1, 'a','a')", 1L);
        String query = "ANALYZE partition_test15";
        String regExpMessage = "Filter required on tpch\\.partition_test15 for at least one partition column:.*";
        this.assertQueryFails(session, query, regExpMessage);
        this.assertQueryFails(session, "explain " + query, regExpMessage);
        this.assertUpdate(session, "DROP TABLE partition_test15");
    }

    @Test
    public void testIsNotNullWithNestedData() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "true").build();
        this.assertUpdate(admin, "create table nest_test(id int, a row(x varchar, y integer, z varchar), b varchar) WITH (format='PARQUET')");
        this.assertUpdate(admin, "insert into nest_test values(0, null, '1')", 1L);
        this.assertUpdate(admin, "insert into nest_test values(1, ('a', null, 'b'), '1')", 1L);
        this.assertUpdate(admin, "insert into nest_test values(2, ('b', 1, 'd'), '1')", 1L);
        this.assertQuery(admin, "select a.y from nest_test", "values (null), (null), (1)");
        this.assertQuery(admin, "select id from nest_test where a.y IS NOT NULL", "values (2)");
        this.assertUpdate(admin, "DROP TABLE nest_test");
    }

    @Test
    public void testSchemaOperations() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        this.assertUpdate(session, "CREATE SCHEMA new_schema");
        this.assertUpdate(session, "CREATE TABLE new_schema.test (x bigint)");
        this.assertQueryFails(session, "DROP SCHEMA new_schema", "Schema not empty: new_schema");
        this.assertUpdate(session, "DROP TABLE new_schema.test");
        this.assertUpdate(session, "DROP SCHEMA new_schema");
    }

    @Test
    public void testSchemaAuthorizationForUser() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_schema_authorization_user");
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_schema_authorization_user").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        Session anotherUser = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_schema_authorization_user").setIdentity(Identity.forUser((String)"anotheruser").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertQueryFails(user, "DROP SCHEMA test_schema_authorization_user", "Access Denied: Cannot drop schema test_schema_authorization_user");
        this.assertQueryFails(user, "CREATE TABLE test_schema_authorization_user.test (x bigint)", "Access Denied: Cannot create table test_schema_authorization_user.test");
        this.assertUpdate(admin, "ALTER SCHEMA test_schema_authorization_user SET AUTHORIZATION user");
        this.assertQueryFails(anotherUser, "CREATE TABLE test_schema_authorization_user.test (x bigint)", "Access Denied: Cannot create table test_schema_authorization_user.test");
        this.assertUpdate(user, "CREATE TABLE test_schema_authorization_user.test (x bigint)");
        this.assertQueryFails(anotherUser, "DROP TABLE test_schema_authorization_user.test", "Access Denied: Cannot drop table test_schema_authorization_user.test");
        this.assertQueryFails(anotherUser, "SELECT 1 FROM test_schema_authorization_user.test", "Access Denied: Cannot select from table test_schema_authorization_user.test");
        this.assertUpdate(user, "DROP TABLE test_schema_authorization_user.test");
        this.assertUpdate(user, "DROP SCHEMA test_schema_authorization_user");
    }

    @Test
    public void testSchemaAuthorizationForRole() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_schema_authorization_role");
        this.assertQueryFails(admin, "ALTER SCHEMA test_schema_authorization_role SET AUTHORIZATION ROLE nonexisting_role", ".*?Role 'nonexisting_role' does not exist");
        this.assertUpdate(admin, "CREATE ROLE authorized_users");
        this.assertUpdate(admin, "GRANT authorized_users TO user");
        this.assertUpdate(admin, "ALTER SCHEMA test_schema_authorization_role SET AUTHORIZATION ROLE authorized_users");
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_schema_authorization_role").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        Session anotherUser = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_schema_authorization_role").setIdentity(Identity.forUser((String)"anotheruser").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate(user, "CREATE TABLE test_schema_authorization_role.test (x bigint)");
        this.assertQueryFails(anotherUser, "DROP TABLE test_schema_authorization_role.test", "Access Denied: Cannot drop table test_schema_authorization_role.test");
        this.assertQueryFails(anotherUser, "SELECT 1 FROM test_schema_authorization_role.test", "Access Denied: Cannot select from table test_schema_authorization_role.test");
        this.assertUpdate(user, "DROP TABLE test_schema_authorization_role.test");
        this.assertUpdate(user, "DROP SCHEMA test_schema_authorization_role");
        this.assertUpdate(admin, "DROP ROLE authorized_users");
    }

    @Test
    public void testCreateSchemaWithAuthorizationForUser() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_createschema_authorization_user").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        Session anotherUser = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_createschema_authorization_user").setIdentity(Identity.forUser((String)"anotheruser").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_createschema_authorization_user AUTHORIZATION user");
        this.assertUpdate(user, "CREATE TABLE test_createschema_authorization_user.test (x bigint)");
        this.assertQueryFails(anotherUser, "DROP TABLE test_createschema_authorization_user.test", "Access Denied: Cannot drop table test_createschema_authorization_user.test");
        this.assertQueryFails(anotherUser, "SELECT 1 FROM test_createschema_authorization_user.test", "Access Denied: Cannot select from table test_createschema_authorization_user.test");
        this.assertUpdate(user, "DROP TABLE test_createschema_authorization_user.test");
        this.assertUpdate(user, "DROP SCHEMA test_createschema_authorization_user");
    }

    @Test
    public void testCreateSchemaWithAuthorizationForRole() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_createschema_authorization_role").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        Session userWithoutRole = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_createschema_authorization_role").setIdentity(Identity.forUser((String)"user").withRoles(Collections.emptyMap()).build()).build();
        Session anotherUser = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_createschema_authorization_role").setIdentity(Identity.forUser((String)"anotheruser").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate(admin, "CREATE ROLE authorized_users");
        this.assertUpdate(admin, "GRANT authorized_users TO user");
        this.assertQueryFails(admin, "CREATE SCHEMA test_createschema_authorization_role AUTHORIZATION ROLE nonexisting_role", ".*?Role 'nonexisting_role' does not exist");
        this.assertUpdate(admin, "CREATE SCHEMA test_createschema_authorization_role AUTHORIZATION ROLE authorized_users");
        this.assertUpdate(user, "CREATE TABLE test_createschema_authorization_role.test (x bigint)");
        this.assertQueryFails(userWithoutRole, "CREATE TABLE test_schema_authorization_role.test1 (x bigint)", "Access Denied: Cannot create table test_schema_authorization_role.test1");
        this.assertQueryFails(anotherUser, "DROP TABLE test_createschema_authorization_role.test", "Access Denied: Cannot drop table test_createschema_authorization_role.test");
        this.assertQueryFails(anotherUser, "SELECT 1 FROM test_createschema_authorization_role.test", "Access Denied: Cannot select from table test_createschema_authorization_role.test");
        this.assertUpdate(user, "DROP TABLE test_createschema_authorization_role.test");
        this.assertUpdate(user, "DROP SCHEMA test_createschema_authorization_role");
        this.assertUpdate(admin, "DROP ROLE authorized_users");
    }

    @Test
    public void testSchemaAuthorization() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_schema_authorization").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_schema_authorization");
        this.assertUpdate(admin, "CREATE ROLE admin");
        this.assertUpdate(admin, "ALTER SCHEMA test_schema_authorization SET AUTHORIZATION user");
        this.assertUpdate(user, "ALTER SCHEMA test_schema_authorization SET AUTHORIZATION ROLE admin");
        this.assertQueryFails(user, "ALTER SCHEMA test_schema_authorization SET AUTHORIZATION ROLE admin", "Access Denied: Cannot set authorization for schema test_schema_authorization to ROLE admin");
        this.assertUpdate(admin, "DROP SCHEMA test_schema_authorization");
        this.assertUpdate(admin, "DROP ROLE admin");
    }

    @Test
    public void testTableAuthorization() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_table_authorization");
        this.assertUpdate(admin, "CREATE TABLE test_table_authorization.foo (col int)");
        this.assertAccessDenied(alice, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION alice", "Cannot set authorization for table test_table_authorization.foo to USER alice", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertUpdate(admin, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION alice");
        this.assertUpdate(alice, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION admin");
        this.assertUpdate(admin, "DROP TABLE test_table_authorization.foo");
        this.assertUpdate(admin, "DROP SCHEMA test_table_authorization");
    }

    @Test
    public void testTableAuthorizationForRole() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        this.assertUpdate(admin, "CREATE SCHEMA test_table_authorization");
        this.assertUpdate(admin, "CREATE TABLE test_table_authorization.foo (col int)");
        this.assertUpdate(admin, "CREATE ROLE admin");
        this.assertAccessDenied(alice, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION ROLE admin", "Cannot set authorization for table test_table_authorization.foo to ROLE admin", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertUpdate(admin, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION alice");
        this.assertQueryFails(alice, "ALTER TABLE test_table_authorization.foo SET AUTHORIZATION ROLE admin", "Setting table owner type as a role is not supported");
        this.assertUpdate(admin, "DROP TABLE test_table_authorization.foo");
        this.assertUpdate(admin, "DROP SCHEMA test_table_authorization");
        this.assertUpdate(admin, "DROP ROLE admin");
    }

    @Test
    public void testViewAuthorization() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        String schema = "test_view_authorization" + TestTable.randomTableSuffix();
        this.assertUpdate(admin, "CREATE SCHEMA " + schema);
        this.assertUpdate(admin, "CREATE VIEW " + schema + ".test_view AS SELECT current_user AS user");
        this.assertAccessDenied(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION alice", "Cannot set authorization for view " + schema + ".test_view to USER alice", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertUpdate(admin, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION alice");
        this.assertUpdate(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION admin");
        this.assertUpdate(admin, "DROP VIEW " + schema + ".test_view");
        this.assertUpdate(admin, "DROP SCHEMA " + schema);
    }

    @Test
    public void testViewAuthorizationSecurityDefiner() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        String schema = "test_view_authorization" + TestTable.randomTableSuffix();
        this.assertUpdate(admin, "CREATE SCHEMA " + schema);
        this.assertUpdate(admin, "CREATE TABLE " + schema + ".test_table (col int)");
        this.assertUpdate(admin, "INSERT INTO " + schema + ".test_table VALUES (1)", 1L);
        this.assertUpdate(admin, "CREATE VIEW " + schema + ".test_view SECURITY DEFINER AS SELECT * from " + schema + ".test_table");
        this.assertUpdate(admin, "GRANT SELECT ON " + schema + ".test_view TO alice");
        this.assertQuery(alice, "SELECT * FROM " + schema + ".test_view", "VALUES (1)");
        this.assertUpdate(admin, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION alice");
        this.assertQueryFails(alice, "SELECT * FROM " + schema + ".test_view", "Access Denied: Cannot select from table " + schema + ".test_table");
        this.assertUpdate(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION admin");
        this.assertUpdate(admin, "DROP VIEW " + schema + ".test_view");
        this.assertUpdate(admin, "DROP TABLE " + schema + ".test_table");
        this.assertUpdate(admin, "DROP SCHEMA " + schema);
    }

    @Test
    public void testViewAuthorizationSecurityInvoker() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        String schema = "test_view_authorization" + TestTable.randomTableSuffix();
        this.assertUpdate(admin, "CREATE SCHEMA " + schema);
        this.assertUpdate(admin, "CREATE TABLE " + schema + ".test_table (col int)");
        this.assertUpdate(admin, "INSERT INTO " + schema + ".test_table VALUES (1)", 1L);
        this.assertUpdate(admin, "CREATE VIEW " + schema + ".test_view SECURITY INVOKER AS SELECT * from " + schema + ".test_table");
        this.assertUpdate(admin, "GRANT SELECT ON " + schema + ".test_view TO alice");
        this.assertQueryFails(alice, "SELECT * FROM " + schema + ".test_view", "Access Denied: Cannot select from table " + schema + ".test_table");
        this.assertUpdate(admin, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION alice");
        this.assertQueryFails(alice, "SELECT * FROM " + schema + ".test_view", "Access Denied: Cannot select from table " + schema + ".test_table");
        this.assertUpdate(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION admin");
        this.assertUpdate(admin, "DROP VIEW " + schema + ".test_view");
        this.assertUpdate(admin, "DROP TABLE " + schema + ".test_table");
        this.assertUpdate(admin, "DROP SCHEMA " + schema);
    }

    @Test
    public void testViewAuthorizationForRole() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session alice = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"alice").build()).build();
        String schema = "test_view_authorization" + TestTable.randomTableSuffix();
        this.assertUpdate(admin, "CREATE SCHEMA " + schema);
        this.assertUpdate(admin, "CREATE TABLE " + schema + ".test_table (col int)");
        this.assertUpdate(admin, "CREATE VIEW " + schema + ".test_view AS SELECT * FROM " + schema + ".test_table");
        this.assertUpdate(admin, "CREATE ROLE admin");
        this.assertAccessDenied(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION ROLE admin", "Cannot set authorization for view " + schema + ".test_view to ROLE admin", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertUpdate(admin, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION alice");
        this.assertQueryFails(alice, "ALTER VIEW " + schema + ".test_view SET AUTHORIZATION ROLE admin", "Setting table owner type as a role is not supported");
        this.assertUpdate(admin, "DROP ROLE admin");
        this.assertUpdate(admin, "DROP VIEW " + schema + ".test_view");
        this.assertUpdate(admin, "DROP TABLE " + schema + ".test_table");
        this.assertUpdate(admin, "DROP SCHEMA " + schema);
    }

    @Test
    public void testShowCreateSchema() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema("test_show_create_schema").setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate(admin, "CREATE ROLE test_show_create_schema_role");
        this.assertUpdate(admin, "GRANT test_show_create_schema_role TO user");
        this.assertUpdate(admin, "CREATE SCHEMA test_show_create_schema");
        String createSchemaSql = String.format("CREATE SCHEMA %s.test_show_create_schema\nAUTHORIZATION USER hive\nWITH \\(\n   location = '.*test_show_create_schema'\n\\)", this.getSession().getCatalog().get());
        String actualResult = Iterables.getOnlyElement((Iterable)this.computeActual(admin, "SHOW CREATE SCHEMA test_show_create_schema").getOnlyColumnAsSet()).toString();
        Assertions.assertThat((String)actualResult).matches((CharSequence)createSchemaSql);
        this.assertQueryFails(user, "SHOW CREATE SCHEMA test_show_create_schema", "Access Denied: Cannot show create schema for test_show_create_schema");
        this.assertUpdate(admin, "ALTER SCHEMA test_show_create_schema SET AUTHORIZATION ROLE test_show_create_schema_role");
        createSchemaSql = String.format("CREATE SCHEMA %s.test_show_create_schema\nAUTHORIZATION ROLE test_show_create_schema_role\nWITH \\(\n   location = '.*test_show_create_schema'\n\\)", this.getSession().getCatalog().get());
        actualResult = Iterables.getOnlyElement((Iterable)this.computeActual(admin, "SHOW CREATE SCHEMA test_show_create_schema").getOnlyColumnAsSet()).toString();
        Assertions.assertThat((String)actualResult).matches((CharSequence)createSchemaSql);
        this.assertUpdate(user, "DROP SCHEMA test_show_create_schema");
        this.assertUpdate(admin, "DROP ROLE test_show_create_schema_role");
    }

    @Test
    public void testIoExplain() {
        this.computeActual("CREATE TABLE test_io_explain WITH (partitioned_by = ARRAY['orderkey', 'processing']) AS SELECT custkey, orderkey, orderstatus = 'P' processing FROM orders WHERE orderkey < 3");
        IoPlanPrinter.EstimatedStatsAndCost estimate = new IoPlanPrinter.EstimatedStatsAndCost(2.0, 40.0, 40.0, 0.0, 0.0);
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) INSERT INTO test_io_explain SELECT custkey, orderkey, processing FROM test_io_explain WHERE custkey <= 10");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("processing", (Type)BooleanType.BOOLEAN, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("false"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("false"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("custkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.empty(), Marker.Bound.ABOVE), new IoPlanPrinter.FormattedMarker(Optional.of("10"), Marker.Bound.EXACTLY)))))), estimate)), Optional.of(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain")), estimate));
        this.assertUpdate("DROP TABLE test_io_explain");
        this.computeActual("CREATE TABLE test_io_explain WITH (partitioned_by = ARRAY['orderkey']) AS SELECT custkey, orderkey FROM orders WHERE orderkey < 200");
        estimate = new IoPlanPrinter.EstimatedStatsAndCost(55.0, 990.0, 990.0, 0.0, 0.0);
        result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) INSERT INTO test_io_explain SELECT custkey, orderkey + 10 FROM test_io_explain WHERE custkey <= 10");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("199"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("custkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.empty(), Marker.Bound.ABOVE), new IoPlanPrinter.FormattedMarker(Optional.of("10"), Marker.Bound.EXACTLY)))))), estimate)), Optional.of(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain")), estimate));
        IoPlanPrinter.EstimatedStatsAndCost finalEstimate = new IoPlanPrinter.EstimatedStatsAndCost(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        estimate = new IoPlanPrinter.EstimatedStatsAndCost(1.0, 18.0, 18.0, 0.0, 0.0);
        result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) INSERT INTO test_io_explain SELECT custkey, orderkey FROM test_io_explain WHERE orderkey = 100");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("100"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("100"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("100"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("100"), Marker.Bound.EXACTLY)))))), estimate)), Optional.of(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain")), finalEstimate));
        this.assertUpdate("DROP TABLE test_io_explain");
    }

    @Test
    public void testIoExplainColumnFilters() {
        this.computeActual("CREATE TABLE test_io_explain_column_filters WITH (partitioned_by = ARRAY['orderkey']) AS SELECT custkey, orderstatus, orderkey FROM orders WHERE orderkey < 3");
        IoPlanPrinter.EstimatedStatsAndCost estimate = new IoPlanPrinter.EstimatedStatsAndCost(2.0, 48.0, 48.0, 0.0, 0.0);
        IoPlanPrinter.EstimatedStatsAndCost finalEstimate = new IoPlanPrinter.EstimatedStatsAndCost(0.0, 0.0, 96.0, 0.0, 0.0);
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT custkey, orderkey, orderstatus FROM test_io_explain_column_filters WHERE custkey <= 10 and orderstatus='P'");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain_column_filters"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("custkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.empty(), Marker.Bound.ABOVE), new IoPlanPrinter.FormattedMarker(Optional.of("10"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("orderstatus", (Type)VarcharType.createVarcharType((int)1), new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("P"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("P"), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), finalEstimate));
        result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT custkey, orderkey, orderstatus FROM test_io_explain_column_filters WHERE custkey <= 10 and (orderstatus='P' or orderstatus='S')");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain_column_filters"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("orderstatus", (Type)VarcharType.createVarcharType((int)1), new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("P"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("P"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("S"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("S"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("custkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.empty(), Marker.Bound.ABOVE), new IoPlanPrinter.FormattedMarker(Optional.of("10"), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), finalEstimate));
        result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT custkey, orderkey, orderstatus FROM test_io_explain_column_filters WHERE custkey <= 10 and cast(orderstatus as integer) = 5");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_io_explain_column_filters"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("orderkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("custkey", (Type)BigintType.BIGINT, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.empty(), Marker.Bound.ABOVE), new IoPlanPrinter.FormattedMarker(Optional.of("10"), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), finalEstimate));
        this.assertUpdate("DROP TABLE test_io_explain_column_filters");
    }

    @Test
    public void testIoExplainNoFilter() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        this.assertUpdate(admin, "create table io_explain_test_no_filter(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(admin, "insert into io_explain_test_no_filter(id,a,ds) values(1, 'a','a')", 1L);
        IoPlanPrinter.EstimatedStatsAndCost estimate = new IoPlanPrinter.EstimatedStatsAndCost(1.0, 22.0, 22.0, 0.0, 0.0);
        IoPlanPrinter.EstimatedStatsAndCost finalEstimate = new IoPlanPrinter.EstimatedStatsAndCost(1.0, 22.0, 22.0, 0.0, 22.0);
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT * FROM io_explain_test_no_filter");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "io_explain_test_no_filter"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("ds", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), finalEstimate));
        this.assertUpdate("DROP TABLE io_explain_test_no_filter");
    }

    @Test
    public void testIoExplainFilterOnAgg() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"hive").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
        this.assertUpdate(admin, "create table io_explain_test_filter_on_agg(\nid integer,\na varchar,\nb varchar,\nds varchar)WITH (format='PARQUET', partitioned_by = ARRAY['ds'])");
        this.assertUpdate(admin, "insert into io_explain_test_filter_on_agg(id,a,ds) values(1, 'a','a')", 1L);
        IoPlanPrinter.EstimatedStatsAndCost estimate = new IoPlanPrinter.EstimatedStatsAndCost(1.0, 5.0, 5.0, 0.0, 0.0);
        IoPlanPrinter.EstimatedStatsAndCost finalEstimate = new IoPlanPrinter.EstimatedStatsAndCost(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT * FROM (SELECT COUNT(*) cnt FROM io_explain_test_filter_on_agg WHERE b = 'b') WHERE cnt > 0");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "io_explain_test_filter_on_agg"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("ds", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY))))), (Object)new IoPlanPrinter.ColumnConstraint("b", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), finalEstimate));
        this.assertUpdate("DROP TABLE io_explain_test_filter_on_agg");
    }

    @Test
    public void testIoExplainWithPrimitiveTypes() {
        LinkedHashMap<String, TypeAndEstimate> data = new LinkedHashMap<String, TypeAndEstimate>();
        data.put("foo", new TypeAndEstimate((Type)VarcharType.createUnboundedVarcharType(), new IoPlanPrinter.EstimatedStatsAndCost(1.0, 16.0, 16.0, 0.0, 0.0)));
        data.put(Byte.toString((byte)63), new TypeAndEstimate((Type)TinyintType.TINYINT, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 10.0, 10.0, 0.0, 0.0)));
        data.put(Short.toString((short)16383), new TypeAndEstimate((Type)SmallintType.SMALLINT, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 11.0, 11.0, 0.0, 0.0)));
        data.put(Integer.toString(0x3FFFFFFF), new TypeAndEstimate((Type)IntegerType.INTEGER, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 13.0, 13.0, 0.0, 0.0)));
        data.put(Long.toString(0x3FFFFFFFFFFFFFFFL), new TypeAndEstimate((Type)BigintType.BIGINT, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 17.0, 17.0, 0.0, 0.0)));
        data.put(Boolean.TRUE.toString(), new TypeAndEstimate((Type)BooleanType.BOOLEAN, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 10.0, 10.0, 0.0, 0.0)));
        data.put("bar", new TypeAndEstimate((Type)CharType.createCharType((long)3L), new IoPlanPrinter.EstimatedStatsAndCost(1.0, 16.0, 16.0, 0.0, 0.0)));
        data.put("1.2345678901234578E14", new TypeAndEstimate((Type)DoubleType.DOUBLE, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 17.0, 17.0, 0.0, 0.0)));
        data.put("123456789012345678901234.567", new TypeAndEstimate((Type)DecimalType.createDecimalType((int)30, (int)3), new IoPlanPrinter.EstimatedStatsAndCost(1.0, 25.0, 25.0, 0.0, 0.0)));
        data.put("2019-01-01", new TypeAndEstimate((Type)DateType.DATE, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 13.0, 13.0, 0.0, 0.0)));
        data.put("2019-01-01 23:22:21.123", new TypeAndEstimate((Type)TimestampType.TIMESTAMP_MILLIS, new IoPlanPrinter.EstimatedStatsAndCost(1.0, 17.0, 17.0, 0.0, 0.0)));
        int index = 0;
        for (Map.Entry entry : data.entrySet()) {
            Type type = ((TypeAndEstimate)entry.getValue()).type;
            IoPlanPrinter.EstimatedStatsAndCost estimate = ((TypeAndEstimate)entry.getValue()).estimate;
            String query = String.format("CREATE TABLE test_types_table  WITH (partitioned_by = ARRAY['my_col']) AS SELECT 'foo' my_non_partition_col, CAST('%s' AS %s) my_col", entry.getKey(), type.getDisplayName());
            this.assertUpdate(query, 1L);
            io.prestosql.testing.assertions.Assert.assertEquals((Object)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) SELECT * FROM test_types_table").getOnlyColumnAsSet())), (Object)new IoPlanPrinter.IoPlan((Set)ImmutableSet.of((Object)new IoPlanPrinter.IoPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_types_table"), (Set)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("my_col", type, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of(entry.getKey().toString()), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of(entry.getKey().toString()), Marker.Bound.EXACTLY)))))), estimate)), Optional.empty(), estimate), (String)String.format("%d) Type %s ", ++index, type));
            this.assertUpdate("DROP TABLE test_types_table");
        }
    }

    @Test
    public void testReadNoColumns() {
        this.testWithAllStorageFormats(this::testReadNoColumns);
    }

    private void testReadNoColumns(Session session, HiveStorageFormat storageFormat) {
        this.assertUpdate(session, String.format("CREATE TABLE test_read_no_columns WITH (format = '%s') AS SELECT 0 x", storageFormat), 1L);
        this.assertQuery(session, "SELECT count(*) FROM test_read_no_columns", "SELECT 1");
        this.assertUpdate(session, "DROP TABLE test_read_no_columns");
    }

    @Test
    public void createTableWithEveryType() {
        String query = "CREATE TABLE test_types_table AS SELECT 'foo' _varchar, cast('bar' as varbinary) _varbinary, cast(1 as bigint) _bigint, 2 _integer, CAST('3.14' AS DOUBLE) _double, true _boolean, DATE '1980-05-07' _date, TIMESTAMP '1980-05-07 11:22:33.456' _timestamp, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, CAST('bar' AS CHAR(10)) _char";
        this.assertUpdate(query, 1L);
        MaterializedResult results = this.getQueryRunner().execute(this.getSession(), "SELECT * FROM test_types_table").toTestTypes();
        io.prestosql.testing.assertions.Assert.assertEquals((int)results.getRowCount(), (int)1);
        MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(0);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(0), (Object)"foo");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(1), (Object)"bar".getBytes(StandardCharsets.UTF_8));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(2), (Object)1L);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(3), (Object)2);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(4), (Object)3.14);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(5), (Object)true);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(6), (Object)LocalDate.of(1980, 5, 7));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(7), (Object)LocalDateTime.of(1980, 5, 7, 11, 22, 33, 456000000));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(8), (Object)new BigDecimal("3.14"));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(9), (Object)new BigDecimal("12345678901234567890.0123456789"));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)row.getField(10), (Object)"bar       ");
        this.assertUpdate("DROP TABLE test_types_table");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_types_table"));
    }

    @Test
    public void testCreatePartitionedTable() {
        this.testWithAllStorageFormats(this::testCreatePartitionedTable);
    }

    private void testCreatePartitionedTable(Session session, HiveStorageFormat storageFormat) {
        Object createTable = "CREATE TABLE test_partitioned_table (  _string VARCHAR,  _varchar VARCHAR(65535), _char CHAR(10), _bigint BIGINT, _integer INTEGER, _smallint SMALLINT, _tinyint TINYINT, _real REAL, _double DOUBLE, _boolean BOOLEAN, _decimal_short DECIMAL(3,2), _decimal_long DECIMAL(30,10), _partition_string VARCHAR, _partition_varchar VARCHAR(65535), _partition_char CHAR(10), _partition_tinyint TINYINT, _partition_smallint SMALLINT, _partition_integer INTEGER, _partition_bigint BIGINT, _partition_boolean BOOLEAN, _partition_decimal_short DECIMAL(3,2), _partition_decimal_long DECIMAL(30,10), _partition_date DATE, _partition_timestamp TIMESTAMP) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ '_partition_string', '_partition_varchar', '_partition_char', '_partition_tinyint', '_partition_smallint', '_partition_integer', '_partition_bigint', '_partition_boolean', '_partition_decimal_short', '_partition_decimal_long', '_partition_date', '_partition_timestamp']) ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = ((String)createTable).replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = ((String)createTable).replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, (String)createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList partitionedBy = ImmutableList.of((Object)"_partition_string", (Object)"_partition_varchar", (Object)"_partition_char", (Object)"_partition_tinyint", (Object)"_partition_smallint", (Object)"_partition_integer", (Object)"_partition_bigint", (Object)"_partition_boolean", (Object)"_partition_decimal_short", (Object)"_partition_decimal_long", (Object)"_partition_date", (Object)"_partition_timestamp", (Object[])new String[0]);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            boolean partitionKey = partitionedBy.contains(columnMetadata.getName());
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
        }
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertColumnType(tableMetadata, "_partition_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_partition_varchar", (Type)VarcharType.createVarcharType((int)65535));
        MaterializedResult result = this.computeActual("SELECT * FROM test_partitioned_table");
        io.prestosql.testing.assertions.Assert.assertEquals((int)result.getRowCount(), (int)0);
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, CAST(1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, 'foo' _partition_string, 'bar' _partition_varchar, CAST('boo' AS CHAR(10)) _partition_char, CAST(1 AS TINYINT) _partition_tinyint, CAST(1 AS SMALLINT) _partition_smallint, 1 _partition_integer, CAST (1 AS BIGINT) _partition_bigint, true _partition_boolean, CAST('3.14' AS DECIMAL(3,2)) _partition_decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _partition_decimal_long, CAST('2017-05-01' AS DATE) _partition_date, CAST('2017-05-01 10:12:34' AS TIMESTAMP) _partition_timestamp";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_partitioned_table " + select, 1L);
        this.assertQuery(session, "SELECT * FROM test_partitioned_table", select);
        this.assertQuery(session, "SELECT * FROM test_partitioned_table WHERE 'foo' = _partition_string AND 'bar' = _partition_varchar AND CAST('boo' AS CHAR(10)) = _partition_char AND CAST(1 AS TINYINT) = _partition_tinyint AND CAST(1 AS SMALLINT) = _partition_smallint AND 1 = _partition_integer AND CAST(1 AS BIGINT) = _partition_bigint AND true = _partition_boolean AND CAST('3.14' AS DECIMAL(3,2)) = _partition_decimal_short AND CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) = _partition_decimal_long AND CAST('2017-05-01' AS DATE) = _partition_date AND CAST('2017-05-01 10:12:34' AS TIMESTAMP) = _partition_timestamp", select);
        this.assertUpdate(session, "DROP TABLE test_partitioned_table");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_partitioned_table"));
    }

    @Test
    public void createTableLike() {
        this.createTableLike("", false);
        this.createTableLike("EXCLUDING PROPERTIES", false);
        this.createTableLike("INCLUDING PROPERTIES", true);
    }

    private void createTableLike(String likeSuffix, boolean hasPartition) {
        String createTable = "CREATE TABLE test_table_original (  tinyint_col tinyint , smallint_col smallint)";
        this.assertUpdate(createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_table_original");
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        String createPartitionedTable = "CREATE TABLE test_partitioned_table_original (  string_col VARCHAR, decimal_long_col DECIMAL(30,10), partition_bigint BIGINT, partition_decimal_long DECIMAL(30,10)) WITH (partitioned_by = ARRAY['partition_bigint', 'partition_decimal_long'])";
        this.assertUpdate(createPartitionedTable);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_original");
        ImmutableList partitionedBy = ImmutableList.of((Object)"partition_bigint", (Object)"partition_decimal_long");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableSingleLike = "CREATE TABLE test_partitioned_table_single_like (LIKE test_partitioned_table_original " + likeSuffix + ")";
        this.assertUpdate(createTableSingleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_single_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableLikeExtra = "CREATE TABLE test_partitioned_table_like_extra (  bigint_col BIGINT, double_col DOUBLE, LIKE test_partitioned_table_single_like " + likeSuffix + ")";
        this.assertUpdate(createTableLikeExtra);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_like_extra");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "bigint_col", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "double_col", (Type)DoubleType.DOUBLE);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableDoubleLike = "CREATE TABLE test_partitioned_table_double_like (  LIKE test_table_original , LIKE test_partitioned_table_like_extra " + likeSuffix + ")";
        this.assertUpdate(createTableDoubleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_double_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        this.assertUpdate("DROP TABLE test_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_single_like");
        this.assertUpdate("DROP TABLE test_partitioned_table_like_extra");
        this.assertUpdate("DROP TABLE test_partitioned_table_double_like");
    }

    @Test
    public void testCreateTableAs() {
        this.testWithAllStorageFormats(this::testCreateTableAs);
    }

    private void testCreateTableAs(Session session, HiveStorageFormat storageFormat) {
        String select = "SELECT 'foo' _varchar, CAST('bar' AS CHAR(10)) _char, CAST (1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST ('123.45' as REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        String createTableAs = String.format("CREATE TABLE test_format_table WITH (format = '%s') AS %s", storageFormat, select);
        this.assertUpdate(session, createTableAs, 1L);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_format_table");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)3));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertQuery(session, "SELECT _integer, _varchar, _integer FROM test_format_table", "SELECT 2, 'foo', 2");
        this.assertQuery(session, "SELECT * FROM test_format_table", select);
        this.assertUpdate(session, "DROP TABLE test_format_table");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_format_table"));
    }

    @Test
    public void testCreatePartitionedTableAs() {
        this.testWithAllStorageFormats(this::testCreatePartitionedTableAs);
    }

    private void testCreatePartitionedTableAs(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_create_partitioned_table_as WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(session, createTable, "SELECT count(*) FROM orders");
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_create_partitioned_table_as");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        List<?> partitions = this.getPartitions("test_create_partitioned_table_as");
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * FROM test_create_partitioned_table_as", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE test_create_partitioned_table_as");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_create_partitioned_table_as"));
    }

    @Test
    public void testCreateTableWithUnsupportedType() {
        this.assertQueryFails("CREATE TABLE test_create_table_with_unsupported_type(x time)", "\\QUnsupported Hive type: time(3)\\E");
        this.assertQueryFails("CREATE TABLE test_create_table_with_unsupported_type AS SELECT TIME '00:00:00' x", "\\QUnsupported Hive type: time(0)\\E");
    }

    @Test
    public void testPropertiesTable() {
        String createTable = "CREATE TABLE test_show_properties WITH (format = 'orc', partitioned_by = ARRAY['ship_priority', 'order_status'],orc_bloom_filter_columns = ARRAY['ship_priority', 'order_status'],orc_bloom_filter_fpp = 0.5) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        String queryId = (String)this.computeScalar("SELECT query_id FROM system.runtime.queries WHERE query LIKE 'CREATE TABLE test_show_properties%'");
        String nodeVersion = (String)this.computeScalar("SELECT node_version FROM system.runtime.nodes WHERE coordinator");
        this.assertQuery("SELECT * FROM \"test_show_properties$properties\"", "SELECT 'workaround for potential lack of HIVE-12730', 'ship_priority,order_status', '0.5', '" + queryId + "', '" + nodeVersion + "', 'false'");
        this.assertUpdate("DROP TABLE test_show_properties");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_invalid_column_ordering\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['apple'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableAsInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_as_invalid_column_ordering WITH (partitioned_by = ARRAY['SHIP_PRIORITY', 'ORDER_STATUS']) AS SELECT shippriority AS ship_priority, orderkey AS order_key, orderstatus AS order_status FROM tpch.tiny.orders");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Table contains only partition columns")
    public void testCreateTableOnlyPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_only_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['grape', 'apple', 'orange', 'pear'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition columns .* not present in schema")
    public void testCreateTableNonExistentPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_nonexistent_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['dragonfruit'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported type .* for partition: .*")
    public void testCreateTableUnsupportedPartitionType() {
        this.assertUpdate("CREATE TABLE test_create_table_unsupported_partition_type (foo bigint, bar ARRAY(varchar)) WITH (partitioned_by = ARRAY['bar'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported type .* for partition: a")
    public void testCreateTableUnsupportedPartitionTypeAs() {
        this.assertUpdate("CREATE TABLE test_create_table_unsupported_partition_type_as WITH (partitioned_by = ARRAY['a']) AS SELECT 123 x, ARRAY ['foo'] a");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported Hive type: varchar\\(65536\\)\\. Supported VARCHAR types: VARCHAR\\(<=65535\\), VARCHAR\\.")
    public void testCreateTableNonSupportedVarcharColumn() {
        this.assertUpdate("CREATE TABLE test_create_table_non_supported_varchar_column (apple varchar(65536))");
    }

    @Test
    public void testEmptyBucketedTable() {
        this.testWithAllStorageFormats(this::testEmptyBucketedTable);
    }

    private void testEmptyBucketedTable(Session session, HiveStorageFormat storageFormat) {
        this.testEmptyBucketedTable(session, storageFormat, true);
        this.testEmptyBucketedTable(session, storageFormat, false);
    }

    private void testEmptyBucketedTable(Session session, HiveStorageFormat storageFormat, boolean createEmpty) {
        String tableName = "test_empty_bucketed_table";
        String createTable = "CREATE TABLE " + tableName + " (bucket_key VARCHAR, col_1 VARCHAR, col2 VARCHAR) WITH (format = '" + storageFormat + "', bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11 ) ";
        this.assertUpdate(createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertNull(tableMetadata.getMetadata().getProperties().get("partitioned_by"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"bucket_key"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.computeActual("SELECT * from " + tableName).getRowCount(), (int)0);
        Session parallelWriter = Session.builder((Session)this.getParallelWriteSession()).setCatalogSessionProperty(this.catalog, "create_empty_bucket_files", String.valueOf(createEmpty)).build();
        this.assertUpdate(parallelWriter, "INSERT INTO " + tableName + " VALUES ('a0', 'b0', 'c0')", 1L);
        this.assertUpdate(parallelWriter, "INSERT INTO " + tableName + " VALUES ('a1', 'b1', 'c1')", 1L);
        this.assertQuery("SELECT * from " + tableName, "VALUES ('a0', 'b0', 'c0'), ('a1', 'b1', 'c1')");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testBucketedTable() {
        this.testWithAllStorageFormats(this::testBucketedTable);
    }

    private void testBucketedTable(Session session, HiveStorageFormat storageFormat) {
        this.testBucketedTable(session, storageFormat, true);
        this.testBucketedTable(session, storageFormat, false);
    }

    private void testBucketedTable(Session session, HiveStorageFormat storageFormat, boolean createEmpty) {
        String tableName = "test_bucketed_table";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11 ) AS SELECT * FROM (VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')) t (bucket_key, col_1, col_2)";
        Session parallelWriter = Session.builder((Session)this.getParallelWriteSession()).setCatalogSessionProperty(this.catalog, "create_empty_bucket_files", String.valueOf(createEmpty)).build();
        this.assertUpdate(parallelWriter, createTable, 3L);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertNull(tableMetadata.getMetadata().getProperties().get("partitioned_by"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"bucket_key"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        this.assertQuery("SELECT * from " + tableName, "VALUES ('a', 'b', 'c'), ('aa', 'bb', 'cc'), ('aaa', 'bbb', 'ccc')");
        this.assertUpdate(parallelWriter, "INSERT INTO " + tableName + " VALUES ('a0', 'b0', 'c0')", 1L);
        this.assertUpdate(parallelWriter, "INSERT INTO " + tableName + " VALUES ('a1', 'b1', 'c1')", 1L);
        this.assertQuery("SELECT * from " + tableName, "VALUES ('a', 'b', 'c'), ('aa', 'bb', 'cc'), ('aaa', 'bbb', 'ccc'), ('a0', 'b0', 'c0'), ('a1', 'b1', 'c1')");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testBucketedTableWithTimestampColumn() {
        String tableName = "test_bucketed_table_with_timestamp_" + TestTable.randomTableSuffix();
        String createTable = "CREATE TABLE " + tableName + " (  bucket_key integer,   a_timestamp timestamp(3) )WITH (  bucketed_by = ARRAY[ 'bucket_key' ],   bucket_count = 11 ) ";
        this.assertUpdate(createTable);
        this.assertQuery("DESCRIBE " + tableName, "VALUES ('bucket_key', 'integer', '', ''), ('a_timestamp', 'timestamp(3)', '', '')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreatePartitionedBucketedTableAsFewRows() {
        this.testWithAllStorageFormats(this::testCreatePartitionedBucketedTableAsFewRows);
    }

    private void testCreatePartitionedBucketedTableAsFewRows(Session session, HiveStorageFormat storageFormat) {
        this.testCreatePartitionedBucketedTableAsFewRows(session, storageFormat, true);
        this.testCreatePartitionedBucketedTableAsFewRows(session, storageFormat, false);
    }

    private void testCreatePartitionedBucketedTableAsFewRows(Session session, HiveStorageFormat storageFormat, boolean createEmpty) {
        String tableName = "test_create_partitioned_bucketed_table_as_few_rows";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11 ) AS SELECT * FROM (VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')) t(bucket_key, col, partition_key)";
        this.assertUpdate(Session.builder((Session)this.getParallelWriteSession()).setCatalogSessionProperty(this.catalog, "create_empty_bucket_files", String.valueOf(createEmpty)).build(), createTable, 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAs() {
        this.testCreatePartitionedBucketedTableAs(HiveStorageFormat.RCBINARY);
    }

    private void testCreatePartitionedBucketedTableAs(HiveStorageFormat storageFormat) {
        String tableName = "test_create_partitioned_bucketed_table_as";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders";
        this.assertUpdate(this.getParallelWriteSession(), createTable, "SELECT count(*) FROM orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAsWithUnionAll() {
        this.testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat.RCBINARY);
    }

    private void testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat storageFormat) {
        String tableName = "test_create_partitioned_bucketed_table_as_with_union_all";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 1";
        this.assertUpdate(this.getParallelWriteSession(), createTable, "SELECT count(*) FROM orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    private void verifyPartitionedBucketedTable(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"orderstatus"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey", (Object)"custkey2"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT custkey, custkey, comment, orderstatus FROM orders");
        for (int i = 1; i <= 30; ++i) {
            this.assertQuery(String.format("SELECT * FROM %s WHERE custkey = %d AND custkey2 = %d", tableName, i, i), String.format("SELECT custkey, custkey, comment, orderstatus FROM orders WHERE custkey = %d", i));
        }
    }

    @Test
    public void testCreateInvalidBucketedTable() {
        this.testCreateInvalidBucketedTable(HiveStorageFormat.RCBINARY);
    }

    private void testCreateInvalidBucketedTable(HiveStorageFormat storageFormat) {
        String tableName = "test_create_invalid_bucketed_table";
        try {
            this.computeActual("CREATE TABLE " + tableName + " (  a BIGINT,  b DOUBLE,  p VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'p' ], bucketed_by = ARRAY[ 'a', 'c' ], bucket_count = 11 )");
            Assert.fail();
        }
        catch (Exception e) {
            io.prestosql.testing.assertions.Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [c] not present in schema");
        }
        try {
            this.computeActual("CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey3' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders");
            Assert.fail();
        }
        catch (Exception e) {
            io.prestosql.testing.assertions.Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [custkey3] not present in schema");
        }
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreatePartitionedUnionAll() {
        this.assertUpdate("CREATE TABLE test_create_partitioned_union_all (a varchar, ds varchar) WITH (partitioned_by = ARRAY['ds'])");
        this.assertUpdate("INSERT INTO test_create_partitioned_union_all SELECT 'a', '2013-05-17' UNION ALL SELECT 'b', '2013-05-17'", 2L);
        this.assertUpdate("DROP TABLE test_create_partitioned_union_all");
    }

    @Test
    public void testInsertPartitionedBucketedTableFewRows() {
        this.testWithAllStorageFormats(this::testInsertPartitionedBucketedTableFewRows);
    }

    private void testInsertPartitionedBucketedTableFewRows(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table_few_rows";
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (  bucket_key varchar,  col varchar,  partition_key varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11)");
        this.assertUpdate(this.getParallelWriteSession(), "INSERT INTO " + tableName + " VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')", 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_bucketed_table_few_rows");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    private void verifyPartitionedBucketedTableAsFewRows(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"partition_key"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"bucket_key"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
        MaterializedResult actual = this.computeActual("SELECT * FROM " + tableName);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType())}).row(new Object[]{"a", "b", "c"}).row(new Object[]{"aa", "bb", "cc"}).row(new Object[]{"aaa", "bbb", "ccc"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    @Test
    public void testCastNullToColumnTypes() {
        String tableName = "test_cast_null_to_column_types";
        this.assertUpdate("CREATE TABLE " + tableName + " (  col1 bigint,  col2 map(bigint, bigint),  partition_key varchar)WITH (  format = 'ORC',   partitioned_by = ARRAY[ 'partition_key' ] )");
        this.assertUpdate(String.format("INSERT INTO %s (col1) VALUES (1), (2), (3)", tableName), 3L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyNonBucketedPartition() {
        String tableName = "test_insert_empty_partitioned_unbucketed_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (  dummy_col bigint,  part varchar)WITH (  format = 'ORC',   partitioned_by = ARRAY[ 'part' ] )");
        this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 0");
        this.assertAccessDenied(String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['part'], ARRAY['%s'])", "tpch", tableName, "empty"), String.format("Cannot insert into table hive.tpch.%s", tableName), new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertUpdate(String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['part'], ARRAY['%s'])", "tpch", tableName, "empty"));
        this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testUnregisterRegisterPartition() {
        String tableName = "test_register_partition_for_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (  dummy_col bigint,  part varchar)WITH (  partitioned_by = ARRAY['part'] )");
        this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 0");
        this.assertUpdate(String.format("INSERT INTO %s (dummy_col, part) VALUES (1, 'first'), (2, 'second'), (3, 'third')", tableName), 3L);
        List paths = this.getQueryRunner().execute(this.getSession(), "SELECT \"$path\" FROM " + tableName + " ORDER BY \"$path\" ASC").toTestTypes().getMaterializedRows();
        io.prestosql.testing.assertions.Assert.assertEquals((int)paths.size(), (int)3);
        String firstPartition = new org.apache.hadoop.fs.Path((String)((MaterializedRow)paths.get(0)).getField(0)).getParent().toString();
        this.assertAccessDenied(String.format("CALL system.unregister_partition('%s', '%s', ARRAY['part'], ARRAY['first'])", "tpch", tableName), String.format("Cannot delete from table hive.tpch.%s", tableName), new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE)});
        this.assertQueryFails(String.format("CALL system.unregister_partition('%s', '%s', ARRAY['part'], ARRAY['empty'])", "tpch", tableName), "Partition 'part=empty' does not exist");
        this.assertUpdate(String.format("CALL system.unregister_partition('%s', '%s', ARRAY['part'], ARRAY['first'])", "tpch", tableName));
        this.assertQuery(this.getSession(), String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 2");
        this.assertQuery(this.getSession(), "SELECT count(*) FROM " + tableName, "SELECT 2");
        this.assertAccessDenied(String.format("CALL system.register_partition('%s', '%s', ARRAY['part'], ARRAY['first'])", "tpch", tableName), String.format("Cannot insert into table hive.tpch.%s", tableName), new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertUpdate(String.format("CALL system.register_partition('%s', '%s', ARRAY['part'], ARRAY['first'], '%s')", "tpch", tableName, firstPartition));
        this.assertQuery(this.getSession(), String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 3");
        this.assertQuery(this.getSession(), "SELECT count(*) FROM " + tableName, "SELECT 3");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyBucketedPartition() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testCreateEmptyBucketedPartition(storageFormat.getFormat());
        }
    }

    private void testCreateEmptyBucketedPartition(HiveStorageFormat storageFormat) {
        String tableName = "test_insert_empty_partitioned_bucketed_table";
        this.createPartitionedBucketedTable(tableName, storageFormat);
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String sql = String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['orderstatus'], ARRAY['%s'])", "tpch", tableName, orderStatusList.get(i));
            this.assertUpdate(sql);
            this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT " + (i + 1));
            this.assertQueryFails(sql, "Partition already exists.*");
        }
        this.assertUpdate("DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreateEmptyPartitionOnNonExistingTable() {
        this.assertQueryFails(String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['part'], ARRAY['%s'])", "tpch", "non_existing_table", "empty"), String.format("Table '%s.%s' does not exist", "tpch", "non_existing_table"));
    }

    @Test
    public void testInsertPartitionedBucketedTable() {
        this.testInsertPartitionedBucketedTable(HiveStorageFormat.RCBINARY);
    }

    private void testInsertPartitionedBucketedTable(HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table";
        this.createPartitionedBucketedTable(tableName, storageFormat);
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getParallelWriteSession(), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s'", orderStatus), String.format("SELECT count(*) FROM orders WHERE orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    private void createPartitionedBucketedTable(String tableName, HiveStorageFormat storageFormat) {
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
    }

    @Test
    public void testInsertPartitionedBucketedTableWithUnionAll() {
        this.testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat.RCBINARY);
    }

    private void testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_bucketed_table_with_union_all";
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getParallelWriteSession(), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' AND length(comment) %% 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' AND length(comment) %% 2 = 1", orderStatus, orderStatus), String.format("SELECT count(*) FROM orders WHERE orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsertTwiceToSamePartitionedBucket() {
        String tableName = "test_insert_twice_to_same_partitioned_bucket";
        this.createPartitionedBucketedTable(tableName, HiveStorageFormat.RCBINARY);
        String insert = "INSERT INTO " + tableName + " VALUES (1, 1, 'first_comment', 'F'), (2, 2, 'second_comment', 'G')";
        this.assertUpdate(insert, 2L);
        this.assertUpdate(insert, 2L);
        this.assertQuery("SELECT custkey, custkey2, comment, orderstatus FROM " + tableName + " ORDER BY custkey", "VALUES (1, 1, 'first_comment', 'F'), (1, 1, 'first_comment', 'F'), (2, 2, 'second_comment', 'G'), (2, 2, 'second_comment', 'G')");
        this.assertQuery("SELECT custkey, custkey2, comment, orderstatus FROM " + tableName + " WHERE custkey = 1 and custkey2 = 1", "VALUES (1, 1, 'first_comment', 'F'), (1, 1, 'first_comment', 'F')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInsert() {
        this.testWithAllStorageFormats(this::testInsert);
    }

    private void testInsert(Session session, HiveStorageFormat storageFormat) {
        Object createTable = "CREATE TABLE test_insert_format_table (  _string VARCHAR,  _varchar VARCHAR(65535),  _char CHAR(10),  _bigint BIGINT,  _integer INTEGER,  _smallint SMALLINT,  _tinyint TINYINT,  _real REAL,  _double DOUBLE,  _boolean BOOLEAN,  _decimal_short DECIMAL(3,2),  _decimal_long DECIMAL(30,10)) WITH (format = '" + storageFormat + "') ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = ((String)createTable).replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = ((String)createTable).replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, (String)createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_format_table");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, 1 _bigint, CAST(42 AS INTEGER) _integer, CAST(43 AS SMALLINT) _smallint, CAST(44 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (43 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (44 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_insert_format_table " + select, 1L);
        this.assertQuery(session, "SELECT * FROM test_insert_format_table", select);
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_tinyint, _smallint, _integer, _bigint, _real, _double) SELECT CAST(1 AS TINYINT), CAST(2 AS SMALLINT), 3, 4, cast(14.3E0 as REAL), 14.3E0", 1L);
        this.assertQuery(session, "SELECT * FROM test_insert_format_table WHERE _bigint = 4", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertQuery(session, "SELECT * FROM test_insert_format_table WHERE _real = CAST(14.3 as REAL)", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_double, _bigint) SELECT 2.72E0, 3", 1L);
        this.assertQuery(session, "SELECT * FROM test_insert_format_table WHERE _bigint = 3", "SELECT null, null, null, 3, null, null, null, null, 2.72, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_decimal_short, _decimal_long) SELECT DECIMAL '2.72', DECIMAL '98765432101234567890.0123456789'", 1L);
        this.assertQuery(session, "SELECT * FROM test_insert_format_table WHERE _decimal_long = DECIMAL '98765432101234567890.0123456789'", "SELECT null, null, null, null, null, null, null, null, null, null, 2.72, 98765432101234567890.0123456789");
        this.assertUpdate(session, "DROP TABLE test_insert_format_table");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_format_table"));
    }

    @Test
    public void testInsertPartitionedTable() {
        this.testWithAllStorageFormats(this::testInsertPartitionedTable);
    }

    private void testInsertPartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_insert_partitioned_table (  ORDER_KEY BIGINT,  SHIP_PRIORITY INTEGER,  ORDER_STATUS VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_partitioned_table");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        String partitionsTable = "\"test_insert_partitioned_table$partitions\"";
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT shippriority, orderstatus FROM orders LIMIT 0");
        this.assertUpdate(session, "INSERT INTO test_insert_partitioned_table SELECT orderkey, shippriority, orderstatus FROM tpch.tiny.orders", "SELECT count(*) FROM orders");
        List<?> partitions = this.getPartitions("test_insert_partitioned_table");
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * FROM test_insert_partitioned_table", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT DISTINCT shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " ORDER BY order_status LIMIT 2", "SELECT DISTINCT shippriority, orderstatus FROM orders ORDER BY orderstatus LIMIT 2");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE order_status = 'O'", "SELECT DISTINCT shippriority, orderstatus FROM orders WHERE orderstatus = 'O'");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE no_such_column = 1", "line \\S*: Column 'no_such_column' cannot be resolved");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE orderkey = 1", "line \\S*: Column 'orderkey' cannot be resolved");
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_table");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_partitioned_table"));
    }

    @Test
    public void testInsertPartitionedTableExistingPartition() {
        this.testWithAllStorageFormats(this::testInsertPartitionedTableExistingPartition);
    }

    private void testInsertPartitionedTableExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) FROM orders WHERE orderkey %% 3 = %d", i));
        }
        List<?> partitions = this.getPartitions(tableName);
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * FROM " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testInsertPartitionedTableOverwriteExistingPartition() {
        this.testInsertPartitionedTableOverwriteExistingPartition(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "insert_existing_partitions_behavior", "OVERWRITE").build(), HiveStorageFormat.ORC);
    }

    private void testInsertPartitionedTableOverwriteExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_overwrite_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) FROM orders WHERE orderkey %% 3 = %d", i));
            List<?> partitions = this.getPartitions(tableName);
            io.prestosql.testing.assertions.Assert.assertEquals((int)partitions.size(), (int)3);
            this.assertQuery(session, "SELECT * FROM " + tableName, String.format("SELECT orderkey, comment, orderstatus FROM orders WHERE orderkey %% 3 = %d", i));
        }
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testNullPartitionValues() {
        this.assertUpdate("CREATE TABLE test_null_partition (test VARCHAR, part VARCHAR)\nWITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO test_null_partition VALUES ('hello', 'test'), ('world', null)", 2L);
        this.assertQuery("SELECT * FROM test_null_partition", "VALUES ('hello', 'test'), ('world', null)");
        this.assertQuery("SELECT * FROM \"test_null_partition$partitions\"", "VALUES 'test', null");
        this.assertUpdate("DROP TABLE test_null_partition");
    }

    @Test
    public void testInsertUnicode() {
        this.testWithAllStorageFormats(this::testInsertUnicode);
    }

    private void testInsertUnicode(Session session, HiveStorageFormat storageFormat) {
        this.assertUpdate(session, "DROP TABLE IF EXISTS test_insert_unicode");
        this.assertUpdate(session, "CREATE TABLE test_insert_unicode(test varchar) WITH (format = '" + storageFormat + "')");
        this.assertUpdate("INSERT INTO test_insert_unicode(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
        Assertions.assertThat((Iterable)this.computeActual("SELECT test FROM test_insert_unicode").getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        this.assertUpdate(session, "DELETE FROM test_insert_unicode");
        this.assertUpdate(session, "INSERT INTO test_insert_unicode(test) VALUES 'Hello', U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' ", 2L);
        Assertions.assertThat((Iterable)this.computeActual(session, "SELECT test FROM test_insert_unicode").getOnlyColumnAsSet()).containsExactlyInAnyOrder(new Object[]{"Hello", "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"});
        this.assertUpdate(session, "DELETE FROM test_insert_unicode");
        this.assertUpdate(session, "INSERT INTO test_insert_unicode(test) VALUES 'aa', 'b\u00e9'", 2L);
        this.assertQuery(session, "SELECT test FROM test_insert_unicode", "VALUES 'aa', 'b\u00e9'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test = 'aa'", "VALUES 'aa'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test > 'ba'", "VALUES 'b\u00e9'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test < 'ba'", "VALUES 'aa'");
        this.assertQueryReturnsEmptyResult(session, "SELECT test FROM test_insert_unicode WHERE test = 'ba'");
        this.assertUpdate(session, "DELETE FROM test_insert_unicode");
        this.assertUpdate(session, "INSERT INTO test_insert_unicode(test) VALUES 'a', '\u00e9'", 2L);
        this.assertQuery(session, "SELECT test FROM test_insert_unicode", "VALUES 'a', '\u00e9'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test = 'a'", "VALUES 'a'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test > 'b'", "VALUES '\u00e9'");
        this.assertQuery(session, "SELECT test FROM test_insert_unicode WHERE test < 'b'", "VALUES 'a'");
        this.assertQueryReturnsEmptyResult(session, "SELECT test FROM test_insert_unicode WHERE test = 'b'");
        this.assertUpdate(session, "DROP TABLE test_insert_unicode");
    }

    @Test
    public void testPartitionPerScanLimit() {
        TestingHiveStorageFormat storageFormat = new TestingHiveStorageFormat(this.getSession(), HiveStorageFormat.ORC);
        TestHiveIntegrationSmokeTest.testWithStorageFormat(storageFormat, this::testPartitionPerScanLimit);
    }

    private void testPartitionPerScanLimit(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_partition_per_scan_limit";
        String partitionsTable = "\"" + tableName + "$partitions\"";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part BIGINT) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'part' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"part"));
        for (int i = 0; i < 12; ++i) {
            int partStart = i * 100;
            int partEnd = (i + 1) * 100 - 1;
            String insertPartitions = "INSERT INTO " + tableName + " SELECT 'bar' foo, part FROM UNNEST(SEQUENCE(" + partStart + ", " + partEnd + ")) AS TMP(part)";
            this.assertUpdate(session, insertPartitions, 100L);
        }
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part > 490 AND part <= 500", "VALUES 491, 492, 493, 494, 495, 496, 497, 498, 499, 500");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part < 0", "SELECT null WHERE false");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "VALUES " + LongStream.range(0L, 1200L).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part < 1000", "SELECT 1000");
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part >= 1000 AND part < 1200", "SELECT 200");
        this.assertQueryFails(session, "SELECT * FROM " + tableName + " WHERE part < 1001", String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertQueryFails(session, "SELECT * FROM " + tableName, String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testShowColumnsFromPartitions() {
        String tableName = "test_show_columns_from_partitions";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQuery(this.getSession(), "SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES ('part1', 'bigint', '', ''), ('part2', 'varchar', '', '')");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"$partitions\"", ".*Table '.*\\.tpch\\.\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"orders$partitions\"", ".*Table '.*\\.tpch\\.orders\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"blah$partitions\"", ".*Table '.*\\.tpch\\.blah\\$partitions' does not exist");
    }

    @Test
    public void testPartitionsTableInvalidAccess() {
        String createTable = "CREATE TABLE test_partitions_invalid (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"test_partitions_invalid$partitions$partitions\"", ".*Table '.*\\.tpch\\.test_partitions_invalid\\$partitions\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"non_existent$partitions\"", ".*Table '.*\\.tpch\\.non_existent\\$partitions' does not exist");
    }

    @Test
    public void testInsertUnpartitionedTable() {
        this.testWithAllStorageFormats(this::testInsertUnpartitionedTable);
    }

    private void testInsertUnpartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_unpartitioned_table";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "') ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) FROM orders WHERE orderkey %% 3 = %d", i));
        }
        this.assertQuery(session, "SELECT * FROM " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testDeleteFromUnpartitionedTable() {
        this.assertUpdate("CREATE TABLE test_delete_unpartitioned AS SELECT orderstatus FROM tpch.tiny.orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM test_delete_unpartitioned");
        MaterializedResult result = this.computeActual("SELECT * FROM test_delete_unpartitioned");
        io.prestosql.testing.assertions.Assert.assertEquals((int)result.getRowCount(), (int)0);
        this.assertUpdate("DROP TABLE test_delete_unpartitioned");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_delete_unpartitioned"));
    }

    @Test
    public void testMetadataDelete() {
        String createTable = "CREATE TABLE test_metadata_delete (  ORDER_KEY BIGINT,  LINE_NUMBER INTEGER,  LINE_STATUS VARCHAR) WITH (partitioned_by = ARRAY[ 'LINE_NUMBER', 'LINE_STATUS' ]) ";
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO test_metadata_delete SELECT orderkey, linenumber, linestatus FROM tpch.tiny.lineitem", "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='F' AND LINE_NUMBER=CAST(3 AS INTEGER)");
        this.assertQuery("SELECT * FROM test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'F' or linenumber<>3");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='O'");
        this.assertQuery("SELECT * FROM test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' AND linenumber<>3");
        try {
            this.getQueryRunner().execute("DELETE FROM test_metadata_delete WHERE ORDER_KEY=1");
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            io.prestosql.testing.assertions.Assert.assertEquals((String)e.getMessage(), (String)"Deletes must match whole partitions for non-transactional tables");
        }
        this.assertQuery("SELECT * FROM test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' AND linenumber<>3");
        this.assertUpdate("DROP TABLE test_metadata_delete");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_metadata_delete"));
    }

    private TableMetadata getTableMetadata(String catalog, String schema, String tableName) {
        Session session = this.getSession();
        Metadata metadata = this.getDistributedQueryRunner().getCoordinator().getMetadata();
        return (TableMetadata)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            Optional tableHandle = metadata.getTableHandle(transactionSession, new QualifiedObjectName(catalog, schema, tableName));
            Assert.assertTrue((boolean)tableHandle.isPresent());
            return metadata.getTableMetadata(transactionSession, (TableHandle)tableHandle.get());
        });
    }

    private Object getHiveTableProperty(String tableName, Function<HiveTableHandle, Object> propertyGetter) {
        Session session = this.getSession();
        Metadata metadata = this.getDistributedQueryRunner().getCoordinator().getMetadata();
        return TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            QualifiedObjectName name = new QualifiedObjectName(this.catalog, "tpch", tableName);
            TableHandle table = (TableHandle)metadata.getTableHandle(transactionSession, name).orElseThrow(() -> new AssertionError((Object)("table not found: " + name)));
            table = (TableHandle)((ConstraintApplicationResult)metadata.applyFilter(transactionSession, table, Constraint.alwaysTrue()).orElseThrow(() -> new AssertionError((Object)"applyFilter did not return a result"))).getHandle();
            return propertyGetter.apply((HiveTableHandle)table.getConnectorHandle());
        });
    }

    private List<?> getPartitions(String tableName) {
        return (List)this.getHiveTableProperty(tableName, handle -> handle.getPartitions().get());
    }

    private int getBucketCount(String tableName) {
        return (Integer)this.getHiveTableProperty(tableName, table -> ((HiveBucketHandle)table.getBucketHandle().get()).getTableBucketCount());
    }

    @Test
    public void testShowColumnsPartitionKey() {
        this.assertUpdate("CREATE TABLE test_show_columns_partition_key\n(grape bigint, orange bigint, pear varchar(65535), mango integer, lychee smallint, kiwi tinyint, apple varchar, pineapple varchar(65535))\nWITH (partitioned_by = ARRAY['apple', 'pineapple'])");
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM test_show_columns_partition_key");
        Type unboundedVarchar = this.canonicalizeType((Type)VarcharType.VARCHAR);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{unboundedVarchar, unboundedVarchar, unboundedVarchar, unboundedVarchar}).row(new Object[]{"grape", this.canonicalizeType((Type)BigintType.BIGINT).toString(), "", ""}).row(new Object[]{"orange", this.canonicalizeType((Type)BigintType.BIGINT).toString(), "", ""}).row(new Object[]{"pear", this.canonicalizeType((Type)VarcharType.createVarcharType((int)65535)).toString(), "", ""}).row(new Object[]{"mango", this.canonicalizeType((Type)IntegerType.INTEGER).toString(), "", ""}).row(new Object[]{"lychee", this.canonicalizeType((Type)SmallintType.SMALLINT).toString(), "", ""}).row(new Object[]{"kiwi", this.canonicalizeType((Type)TinyintType.TINYINT).toString(), "", ""}).row(new Object[]{"apple", this.canonicalizeType((Type)VarcharType.VARCHAR).toString(), "partition key", ""}).row(new Object[]{"pineapple", this.canonicalizeType((Type)VarcharType.createVarcharType((int)65535)).toString(), "partition key", ""}).build();
        io.prestosql.testing.assertions.Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testArrays() {
        this.assertUpdate("CREATE TABLE tmp_array1 AS SELECT ARRAY[1, 2, NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array1", "SELECT 2");
        this.assertQuery("SELECT col[3] FROM tmp_array1", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array2 AS SELECT ARRAY[1.0E0, 2.5E0, 3.5E0] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array2", "SELECT 2.5");
        this.assertUpdate("CREATE TABLE tmp_array3 AS SELECT ARRAY['puppies', 'kittens', NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array3", "SELECT 'kittens'");
        this.assertQuery("SELECT col[3] FROM tmp_array3", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array4 AS SELECT ARRAY[TRUE, NULL] AS col", 1L);
        this.assertQuery("SELECT col[1] FROM tmp_array4", "SELECT TRUE");
        this.assertQuery("SELECT col[2] FROM tmp_array4", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array5 AS SELECT ARRAY[ARRAY[1, 2], NULL, ARRAY[3, 4]] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array5", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array6 AS SELECT ARRAY[ARRAY['\"hi\"'], NULL, ARRAY['puppies']] AS col", 1L);
        this.assertQuery("SELECT col[1][1] FROM tmp_array6", "SELECT '\"hi\"'");
        this.assertQuery("SELECT col[3][1] FROM tmp_array6", "SELECT 'puppies'");
        this.assertUpdate("CREATE TABLE tmp_array7 AS SELECT ARRAY[ARRAY[INTEGER'1', INTEGER'2'], NULL, ARRAY[INTEGER'3', INTEGER'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array7", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array8 AS SELECT ARRAY[ARRAY[SMALLINT'1', SMALLINT'2'], NULL, ARRAY[SMALLINT'3', SMALLINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array8", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array9 AS SELECT ARRAY[ARRAY[TINYINT'1', TINYINT'2'], NULL, ARRAY[TINYINT'3', TINYINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array9", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array10 AS SELECT ARRAY[ARRAY[DECIMAL '3.14']] AS col1, ARRAY[ARRAY[DECIMAL '12345678901234567890.0123456789']] AS col2", 1L);
        this.assertQuery("SELECT col1[1][1] FROM tmp_array10", "SELECT 3.14");
        this.assertQuery("SELECT col2[1][1] FROM tmp_array10", "SELECT 12345678901234567890.0123456789");
        this.assertUpdate("CREATE TABLE tmp_array13 AS SELECT ARRAY[ARRAY[REAL'1.234', REAL'2.345'], NULL, ARRAY[REAL'3.456', REAL'4.567']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array13", "SELECT 2.345");
    }

    @Test(dataProvider="timestampPrecision")
    public void testTemporalArrays(HiveTimestampPrecision timestampPrecision) {
        Session session = this.withTimestampPrecision(this.getSession(), timestampPrecision);
        this.assertUpdate("DROP TABLE IF EXISTS tmp_array11");
        this.assertUpdate("CREATE TABLE tmp_array11 AS SELECT ARRAY[DATE '2014-09-30'] AS col", 1L);
        this.assertOneNotNullResult("SELECT col[1] FROM tmp_array11");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_array12");
        this.assertUpdate("CREATE TABLE tmp_array12 AS SELECT ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'] AS col", 1L);
        this.assertOneNotNullResult(session, "SELECT col[1] FROM tmp_array12");
    }

    @Test(dataProvider="timestampPrecision")
    public void testMaps(HiveTimestampPrecision timestampPrecision) {
        Session session = this.withTimestampPrecision(this.getSession(), timestampPrecision);
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map1");
        this.assertUpdate("CREATE TABLE tmp_map1 AS SELECT MAP(ARRAY[0,1], ARRAY[2,NULL]) AS col", 1L);
        this.assertQuery("SELECT col[0] FROM tmp_map1", "SELECT 2");
        this.assertQuery("SELECT col[1] FROM tmp_map1", "SELECT NULL");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map2");
        this.assertUpdate("CREATE TABLE tmp_map2 AS SELECT MAP(ARRAY[INTEGER'1'], ARRAY[INTEGER'2']) AS col", 1L);
        this.assertQuery("SELECT col[INTEGER'1'] FROM tmp_map2", "SELECT 2");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map3");
        this.assertUpdate("CREATE TABLE tmp_map3 AS SELECT MAP(ARRAY[SMALLINT'1'], ARRAY[SMALLINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[SMALLINT'1'] FROM tmp_map3", "SELECT 2");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map4");
        this.assertUpdate("CREATE TABLE tmp_map4 AS SELECT MAP(ARRAY[TINYINT'1'], ARRAY[TINYINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[TINYINT'1'] FROM tmp_map4", "SELECT 2");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map5");
        this.assertUpdate("CREATE TABLE tmp_map5 AS SELECT MAP(ARRAY[1.0], ARRAY[2.5]) AS col", 1L);
        this.assertQuery("SELECT col[1.0] FROM tmp_map5", "SELECT 2.5");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map6");
        this.assertUpdate("CREATE TABLE tmp_map6 AS SELECT MAP(ARRAY['puppies'], ARRAY['kittens']) AS col", 1L);
        this.assertQuery("SELECT col['puppies'] FROM tmp_map6", "SELECT 'kittens'");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map7");
        this.assertUpdate("CREATE TABLE tmp_map7 AS SELECT MAP(ARRAY[TRUE], ARRAY[FALSE]) AS col", 1L);
        this.assertQuery("SELECT col[TRUE] FROM tmp_map7", "SELECT FALSE");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map8");
        this.assertUpdate("CREATE TABLE tmp_map8 AS SELECT MAP(ARRAY[DATE '2014-09-30'], ARRAY[DATE '2014-09-29']) AS col", 1L);
        this.assertOneNotNullResult("SELECT col[DATE '2014-09-30'] FROM tmp_map8");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map9");
        this.assertUpdate("CREATE TABLE tmp_map9 AS SELECT MAP(ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'], ARRAY[TIMESTAMP '2001-08-22 03:04:05.321']) AS col", 1L);
        this.assertOneNotNullResult(session, "SELECT col[TIMESTAMP '2001-08-22 03:04:05.321'] FROM tmp_map9");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map10");
        this.assertUpdate("CREATE TABLE tmp_map10 AS SELECT MAP(ARRAY[DECIMAL '3.14', DECIMAL '12345678901234567890.0123456789'], ARRAY[DECIMAL '12345678901234567890.0123456789', DECIMAL '3.0123456789']) AS col", 1L);
        this.assertQuery("SELECT col[DECIMAL '3.14'], col[DECIMAL '12345678901234567890.0123456789'] FROM tmp_map10", "SELECT 12345678901234567890.0123456789, 3.0123456789");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map11");
        this.assertUpdate("CREATE TABLE tmp_map11 AS SELECT MAP(ARRAY[REAL'1.234'], ARRAY[REAL'2.345']) AS col", 1L);
        this.assertQuery("SELECT col[REAL'1.234'] FROM tmp_map11", "SELECT 2.345");
        this.assertUpdate("DROP TABLE IF EXISTS tmp_map12");
        this.assertUpdate("CREATE TABLE tmp_map12 AS SELECT MAP(ARRAY[1.0E0], ARRAY[ARRAY[1, 2]]) AS col", 1L);
        this.assertQuery("SELECT col[1.0][2] FROM tmp_map12", "SELECT 2");
    }

    @Test
    public void testRowsWithAllFormats() {
        this.testWithAllStorageFormats(this::testRows);
    }

    private void testRows(Session session, HiveStorageFormat format) {
        String tableName = "test_dereferences";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + format + "') AS SELECT CAST(row(CAST(1 as BIGINT), CAST(NULL as BIGINT)) AS row(col0 bigint, col1 bigint)) AS a, CAST(row(row(CAST('abc' as VARCHAR), CAST(5 as BIGINT)), CAST(3.0 AS DOUBLE)) AS row(field0 row(col0 varchar, col1 bigint), field1 double)) AS b";
        this.assertUpdate(session, createTable, 1L);
        this.assertQuery(session, "SELECT a.col0, a.col1, b.field0.col0, b.field0.col1, b.field1 FROM " + tableName, "SELECT 1, cast(null as bigint), CAST('abc' as VARCHAR), CAST(5 as BIGINT), CAST(3.0 AS DOUBLE)");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testRowsWithNulls() {
        this.testRowsWithNulls(this.getSession(), HiveStorageFormat.ORC);
        this.testRowsWithNulls(this.getSession(), HiveStorageFormat.PARQUET);
    }

    private void testRowsWithNulls(Session session, HiveStorageFormat format) {
        String tableName = "test_dereferences_with_nulls";
        String createTable = "CREATE TABLE " + tableName + "\n(col0 BIGINT, col1 row(f0 BIGINT, f1 BIGINT), col2 row(f0 BIGINT, f1 ROW(f0 BIGINT, f1 BIGINT)))\nWITH (format = '" + format + "')";
        this.assertUpdate(session, createTable);
        String insertTable = "INSERT INTO " + tableName + " VALUES \nrow(1,     row(2, 3),      row(4, row(5, 6))),\nrow(7,     row(8, 9),      row(10, row(11, NULL))),\nrow(NULL,  NULL,           row(12, NULL)),\nrow(13,    row(NULL, 14),  NULL),\nrow(15,    row(16, NULL),  row(NULL, row(17, 18)))";
        this.assertUpdate(session, insertTable, 5L);
        this.assertQuery(session, String.format("SELECT col0, col1.f0, col2.f1.f1 FROM %s", tableName), "SELECT * FROM \n    (SELECT 1, 2, 6) UNION\n    (SELECT 7, 8, NULL) UNION\n    (SELECT NULL, NULL, NULL) UNION\n    (SELECT 13, NULL, NULL) UNION\n    (SELECT 15, 16, 18)");
        this.assertQuery(session, String.format("SELECT col0 FROM %s WHERE col2.f1.f1 IS NOT NULL", tableName), "SELECT * FROM UNNEST(array[1, 15])");
        this.assertQuery(session, String.format("SELECT col0, col1.f0, col1.f1 FROM %s WHERE col2.f1.f1 = 18", tableName), "SELECT 15, 16, NULL");
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testComplex() {
        this.assertUpdate("CREATE TABLE tmp_complex1 AS SELECT ARRAY [MAP(ARRAY['a', 'b'], ARRAY[2.0E0, 4.0E0]), MAP(ARRAY['c', 'd'], ARRAY[12.0E0, 14.0E0])] AS a", 1L);
        this.assertQuery("SELECT a[1]['a'], a[2]['d'] FROM tmp_complex1", "SELECT 2.0, 14.0");
    }

    @Test
    public void testBucketedCatalog() {
        String bucketedCatalog = (String)this.bucketedSession.getCatalog().get();
        String bucketedSchema = (String)this.bucketedSession.getSchema().get();
        TableMetadata ordersTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "orders");
        io.prestosql.testing.assertions.Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        io.prestosql.testing.assertions.Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        TableMetadata customerTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "customer");
        io.prestosql.testing.assertions.Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        io.prestosql.testing.assertions.Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
    }

    @Test
    public void testBucketedExecution() {
        this.assertQuery(this.bucketedSession, "SELECT count(*) a FROM orders t1 JOIN orders t2 on t1.custkey=t2.custkey");
        this.assertQuery(this.bucketedSession, "SELECT count(*) a FROM orders t1 JOIN customer t2 on t1.custkey=t2.custkey", "SELECT count(*) FROM orders");
        this.assertQuery(this.bucketedSession, "SELECT count(distinct custkey) FROM orders");
        this.assertQuery(Session.builder((Session)this.bucketedSession).setSystemProperty("task_writer_count", "1").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
        this.assertQuery(Session.builder((Session)this.bucketedSession).setSystemProperty("task_writer_count", "4").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testScaleWriters() {
        this.testWithAllStorageFormats(this::testSingleWriter);
        this.testWithAllStorageFormats(this::testMultipleWriters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSingleWriter(Session session, HiveStorageFormat storageFormat) {
        try {
            String createTableSql = String.format("CREATE TABLE scale_writers_small WITH (format = '%s') AS SELECT * FROM tpch.tiny.orders", storageFormat);
            this.assertUpdate(Session.builder((Session)session).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "32MB").build(), createTableSql, (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders").getOnlyValue());
            io.prestosql.testing.assertions.Assert.assertEquals((Object)this.computeActual("SELECT count(DISTINCT \"$path\") FROM scale_writers_small").getOnlyValue(), (Object)1L);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_small");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultipleWriters(Session session, HiveStorageFormat storageFormat) {
        try {
            String createTableSql = String.format("CREATE TABLE scale_writers_large WITH (format = '%s') AS SELECT * FROM tpch.sf1.orders", storageFormat);
            this.assertUpdate(Session.builder((Session)session).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "1MB").setCatalogSessionProperty(this.catalog, "parquet_writer_block_size", "4MB").build(), createTableSql, (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            long files = (Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM scale_writers_large");
            long workers = (Long)this.computeScalar("SELECT count(*) FROM system.runtime.nodes");
            Assertions.assertThat((long)files).isBetween(Long.valueOf(2L), Long.valueOf(workers));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_large");
        }
    }

    @Test
    public void testTableCommentsTable() {
        this.assertUpdate("CREATE TABLE test_comment (c1 bigint) COMMENT 'foo'");
        String selectTableComment = String.format("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '%s' AND schema_name = '%s' AND table_name = 'test_comment'", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQuery(selectTableComment, "SELECT 'foo'");
        this.assertUpdate("DROP TABLE IF EXISTS test_comment");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((Object)this.computeActual("SHOW CREATE TABLE orders").getOnlyValue()).isEqualTo((Object)"CREATE TABLE hive.tpch.orders (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar(1),\n   totalprice double,\n   orderdate date,\n   orderpriority varchar(15),\n   clerk varchar(15),\n   shippriority integer,\n   comment varchar(79)\n)\nWITH (\n   format = 'ORC'\n)");
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint,\n   c2 double,\n   \"c 3\" varchar,\n   \"c'4\" array(bigint),\n   c5 map(bigint, varchar)\n)\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_show_create_table");
        this.assertUpdate(createTableSql);
        MaterializedResult actualResult = this.computeActual("SHOW CREATE TABLE test_show_create_table");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
        createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint,\n   \"c 2\" varchar,\n   \"c'3\" array(bigint),\n   c4 map(bigint, varchar) COMMENT 'comment test4',\n   c5 double COMMENT ''\n)\nCOMMENT 'test'\nWITH (\n   bucket_count = 5,\n   bucketed_by = ARRAY['c1','c 2'],\n   bucketing_version = 1,\n   format = 'ORC',\n   orc_bloom_filter_columns = ARRAY['c1','c2'],\n   orc_bloom_filter_fpp = 7E-1,\n   partitioned_by = ARRAY['c5'],\n   sorted_by = ARRAY['c1','c 2 DESC'],\n   transactional = true\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "\"test_show_create_table'2\"");
        this.assertUpdate(createTableSql);
        actualResult = this.computeActual("SHOW CREATE TABLE \"test_show_create_table'2\"");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
        createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 ROW(\"$a\" bigint, \"$b\" varchar)\n)\nWITH (\n   format = 'ORC'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_show_create_table_with_special_characters");
        this.assertUpdate(createTableSql);
        actualResult = this.computeActual("SHOW CREATE TABLE test_show_create_table_with_special_characters");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
    }

    private void testCreateExternalTable(String tableName, String fileContents, String expectedResults, List<String> tableProperties) throws Exception {
        File tempDir = Files.createTempDir();
        File dataFile = new File(tempDir, "test.txt");
        Files.asCharSink((File)dataFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)fileContents);
        StringJoiner propertiesSql = new StringJoiner(",\n   ");
        propertiesSql.add(String.format("external_location = '%s'", new org.apache.hadoop.fs.Path(tempDir.toURI().toASCIIString())));
        propertiesSql.add("format = 'TEXTFILE'");
        tableProperties.forEach(propertiesSql::add);
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   col1 varchar,\n   col2 varchar\n)\nWITH (\n   %s\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), tableName, propertiesSql);
        this.assertUpdate(createTableSql);
        MaterializedResult actual = this.computeActual(String.format("SHOW CREATE TABLE %s", tableName));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        this.assertQuery(String.format("SELECT col1, col2 from %s", tableName), expectedResults);
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        FileAssert.assertFile((File)dataFile);
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        this.testCreateExternalTable("test_create_external", "hello\u0001world\nbye\u0001world", "VALUES ('hello', 'world'), ('bye', 'world')", (List<String>)ImmutableList.of());
    }

    @Test
    public void testCreateExternalTableWithFieldSeparator() throws Exception {
        this.testCreateExternalTable("test_create_external_with_field_separator", "helloXworld\nbyeXworld", "VALUES ('hello', 'world'), ('bye', 'world')", (List<String>)ImmutableList.of((Object)"textfile_field_separator = 'X'"));
    }

    @Test
    public void testCreateExternalTableWithFieldSeparatorEscape() throws Exception {
        this.testCreateExternalTable("test_create_external_text_file_with_field_separator_and_escape", "HelloEFFWorld\nByeEFFWorld", "VALUES ('HelloF', 'World'), ('ByeF', 'World')", (List<String>)ImmutableList.of((Object)"textfile_field_separator = 'F'", (Object)"textfile_field_separator_escape = 'E'"));
    }

    @Test
    public void testCreateExternalTableWithNullFormat() throws Exception {
        this.testCreateExternalTable("test_create_external_textfile_with_null_format", "hello\u0001NULL_VALUE\nNULL_VALUE\u0001123\n\\N\u0001456", "VALUES ('hello', NULL), (NULL, 123), ('\\N', 456)", (List<String>)ImmutableList.of((Object)"null_format = 'NULL_VALUE'"));
    }

    @Test
    public void testCreateExternalTableWithDataNotAllowed() throws IOException {
        File tempDir = Files.createTempDir();
        String createTableSql = String.format("CREATE TABLE test_create_external_with_data_not_allowed WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tempDir.toURI().toASCIIString());
        this.assertQueryFails(createTableSql, "Writes to non-managed Hive tables is disabled");
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_comment_table");
        this.assertUpdate(createTableSql);
        MaterializedResult actualResult = this.computeActual("SHOW CREATE TABLE test_comment_table");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
        this.assertUpdate("COMMENT ON TABLE test_comment_table IS 'new comment'");
        String commentedCreateTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint\n)\nCOMMENT 'new comment'\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_comment_table");
        actualResult = this.computeActual("SHOW CREATE TABLE test_comment_table");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)commentedCreateTableSql);
        this.assertUpdate("COMMENT ON TABLE test_comment_table IS 'updated comment'");
        commentedCreateTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint\n)\nCOMMENT 'updated comment'\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_comment_table");
        actualResult = this.computeActual("SHOW CREATE TABLE test_comment_table");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)commentedCreateTableSql);
        this.assertUpdate("COMMENT ON TABLE test_comment_table IS ''");
        commentedCreateTableSql = String.format("CREATE TABLE %s.%s.%s (\n   c1 bigint\n)\nCOMMENT ''\nWITH (\n   format = 'RCBINARY'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_comment_table");
        actualResult = this.computeActual("SHOW CREATE TABLE test_comment_table");
        io.prestosql.testing.assertions.Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)commentedCreateTableSql);
        this.assertUpdate("DROP TABLE test_comment_table");
    }

    private void testCreateTableWithHeaderAndFooter(String format) {
        String name = format.toLowerCase(Locale.ENGLISH);
        String catalog = (String)this.getSession().getCatalog().get();
        String schema = (String)this.getSession().getSchema().get();
        String createTableSql = String.format("CREATE TABLE %s.%s.%s_table_skip_header (\n   name varchar\n)\nWITH (\n   format = '%s',\n   skip_header_line_count = 1\n)", catalog, schema, name, format);
        this.assertUpdate(createTableSql);
        MaterializedResult actual = this.computeActual(String.format("SHOW CREATE TABLE %s_table_skip_header", format));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        this.assertUpdate(String.format("DROP TABLE %s_table_skip_header", format));
        createTableSql = String.format("CREATE TABLE %s.%s.%s_table_skip_footer (\n   name varchar\n)\nWITH (\n   format = '%s',\n   skip_footer_line_count = 1\n)", catalog, schema, name, format);
        this.assertUpdate(createTableSql);
        actual = this.computeActual(String.format("SHOW CREATE TABLE %s_table_skip_footer", format));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        this.assertUpdate(String.format("DROP TABLE %s_table_skip_footer", format));
        createTableSql = String.format("CREATE TABLE %s.%s.%s_table_skip_header_footer (\n   name varchar\n)\nWITH (\n   format = '%s',\n   skip_footer_line_count = 1,\n   skip_header_line_count = 1\n)", catalog, schema, name, format);
        this.assertUpdate(createTableSql);
        actual = this.computeActual(String.format("SHOW CREATE TABLE %s_table_skip_header_footer", format));
        io.prestosql.testing.assertions.Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        this.assertUpdate(String.format("DROP TABLE %s_table_skip_header_footer", format));
    }

    @Test
    public void testCreateTableWithHeaderAndFooterForTextFile() {
        this.testCreateTableWithHeaderAndFooter("TEXTFILE");
    }

    @Test
    public void testCreateTableWithHeaderAndFooterForCsv() {
        this.testCreateTableWithHeaderAndFooter("CSV");
    }

    @Test
    public void testInsertTableWithHeaderAndFooterForCsv() {
        String createTableSql = String.format("CREATE TABLE %s.%s.csv_table_skip_header (\n   name VARCHAR\n)\nWITH (\n   format = 'CSV',\n   skip_header_line_count = 1\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertUpdate(createTableSql);
        Assertions.assertThatThrownBy(() -> this.assertUpdate(String.format("INSERT INTO %s.%s.csv_table_skip_header VALUES ('name')", this.getSession().getCatalog().get(), this.getSession().getSchema().get()))).hasMessageMatching("Inserting into Hive table with skip.header.line.count property not supported");
        this.assertUpdate("DROP TABLE csv_table_skip_header");
        createTableSql = String.format("CREATE TABLE %s.%s.csv_table_skip_footer (\n   name VARCHAR\n)\nWITH (\n   format = 'CSV',\n   skip_footer_line_count = 1\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertUpdate(createTableSql);
        Assertions.assertThatThrownBy(() -> this.assertUpdate(String.format("INSERT INTO %s.%s.csv_table_skip_footer VALUES ('name')", this.getSession().getCatalog().get(), this.getSession().getSchema().get()))).hasMessageMatching("Inserting into Hive table with skip.footer.line.count property not supported");
        createTableSql = String.format("CREATE TABLE %s.%s.csv_table_skip_header_footer (\n   name VARCHAR\n)\nWITH (\n   format = 'CSV',\n   skip_footer_line_count = 1,\n   skip_header_line_count = 1\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertUpdate(createTableSql);
        Assertions.assertThatThrownBy(() -> this.assertUpdate(String.format("INSERT INTO %s.%s.csv_table_skip_header_footer VALUES ('name')", this.getSession().getCatalog().get(), this.getSession().getSchema().get()))).hasMessageMatching("Inserting into Hive table with skip.header.line.count property not supported");
        this.assertUpdate("DROP TABLE csv_table_skip_header_footer");
    }

    @Test
    public void testCreateTableWithInvalidProperties() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 bigint) WITH (format = 'TEXTFILE', orc_bloom_filter_columns = ARRAY['col1'])")).hasMessageMatching("Cannot specify orc_bloom_filter_columns table property for storage format: TEXTFILE");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE test_orc_skip_header (col1 bigint) WITH (format = 'ORC', skip_header_line_count = 1)")).hasMessageMatching("Cannot specify skip_header_line_count table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE test_orc_skip_footer (col1 bigint) WITH (format = 'ORC', skip_footer_line_count = 1)")).hasMessageMatching("Cannot specify skip_footer_line_count table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE test_orc_skip_footer (col1 bigint) WITH (format = 'ORC', null_format = 'ERROR')")).hasMessageMatching("Cannot specify null_format table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE test_invalid_skip_header (col1 bigint) WITH (format = 'TEXTFILE', skip_header_line_count = -1)")).hasMessageMatching("Invalid value for skip_header_line_count property: -1");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE test_invalid_skip_footer (col1 bigint) WITH (format = 'TEXTFILE', skip_footer_line_count = -1)")).hasMessageMatching("Invalid value for skip_footer_line_count property: -1");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 bigint) WITH (format = 'ORC', csv_separator = 'S')")).hasMessageMatching("Cannot specify csv_separator table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_separator = 'SS')")).hasMessageMatching("csv_separator must be a single character string, but was: 'SS'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 bigint) WITH (format = 'ORC', csv_quote = 'Q')")).hasMessageMatching("Cannot specify csv_quote table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_quote = 'QQ')")).hasMessageMatching("csv_quote must be a single character string, but was: 'QQ'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'ORC', csv_escape = 'E')")).hasMessageMatching("Cannot specify csv_escape table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_escape = 'EE')")).hasMessageMatching("csv_escape must be a single character string, but was: 'EE'");
    }

    @Test
    public void testPathHiddenColumn() {
        this.testWithAllStorageFormats(this::testPathHiddenColumn);
    }

    private void testPathHiddenColumn(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_path WITH (format = '" + storageFormat + "',partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(session, createTable, 8L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_path"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_path");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time", (Object)"$partition");
        List columnMetadatas = tableMetadata.getColumns();
        io.prestosql.testing.assertions.Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$path")) continue;
            Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.getPartitions("test_path").size(), (int)3);
        MaterializedResult results = this.computeActual(session, String.format("SELECT *, \"%s\" FROM test_path", "$path"));
        HashMap<Integer, String> partitionPathMap = new HashMap<Integer, String>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            String pathName = (String)row.getField(2);
            String parentDirectory = new org.apache.hadoop.fs.Path(pathName).getParent().toString();
            Assert.assertTrue((pathName.length() > 0 ? 1 : 0) != 0);
            io.prestosql.testing.assertions.Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (partitionPathMap.containsKey(col1)) {
                io.prestosql.testing.assertions.Assert.assertEquals((String)((String)partitionPathMap.get(col1)), (String)parentDirectory);
                continue;
            }
            partitionPathMap.put(col1, parentDirectory);
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)partitionPathMap.size(), (int)3);
        this.assertUpdate(session, "DROP TABLE test_path");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_path"));
    }

    @Test
    public void testBucketHiddenColumn() {
        String createTable = "CREATE TABLE test_bucket_hidden_column WITH (bucketed_by = ARRAY['col0'],bucket_count = 2) AS SELECT * FROM (VALUES (0, 11), (1, 12), (2, 13), (3, 14), (4, 15), (5, 16), (6, 17), (7, 18), (8, 19) ) t (col0, col1) ";
        this.assertUpdate(createTable, 9L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_bucket_hidden_column");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"col0"));
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)2);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$bucket", (Object)"$file_size", (Object)"$file_modified_time");
        List columnMetadatas = tableMetadata.getColumns();
        io.prestosql.testing.assertions.Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$bucket")) continue;
            Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.getBucketCount("test_bucket_hidden_column"), (int)2);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%1$s\" FROM test_bucket_hidden_column WHERE \"%1$s\" = 1", "$bucket"));
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            int bucket = (Integer)row.getField(2);
            io.prestosql.testing.assertions.Assert.assertEquals((int)col1, (int)(col0 + 11));
            Assert.assertTrue((col1 % 2 == 0 ? 1 : 0) != 0);
            io.prestosql.testing.assertions.Assert.assertEquals((int)bucket, (int)(col0 % 2));
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)results.getRowCount(), (int)4);
        this.assertUpdate("DROP TABLE test_bucket_hidden_column");
        Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
    }

    @Test
    public void testFileSizeHiddenColumn() {
        String createTable = "CREATE TABLE test_file_size WITH (partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(createTable, 8L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_file_size"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_file_size");
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time", (Object)"$partition");
        List columnMetadatas = tableMetadata.getColumns();
        io.prestosql.testing.assertions.Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$file_size")) continue;
            Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.getPartitions("test_file_size").size(), (int)3);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%s\" FROM test_file_size", "$file_size"));
        HashMap<Integer, Long> fileSizeMap = new HashMap<Integer, Long>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            long fileSize = (Long)row.getField(2);
            Assert.assertTrue((fileSize > 0L ? 1 : 0) != 0);
            io.prestosql.testing.assertions.Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (fileSizeMap.containsKey(col1)) {
                io.prestosql.testing.assertions.Assert.assertEquals((long)((Long)fileSizeMap.get(col1)), (long)fileSize);
                continue;
            }
            fileSizeMap.put(col1, fileSize);
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)fileSizeMap.size(), (int)3);
        this.assertUpdate("DROP TABLE test_file_size");
    }

    @Test
    public void testFileModifiedTimeHiddenColumn() {
        long testStartTime = Instant.now().toEpochMilli();
        String createTable = "CREATE TABLE test_file_modified_time WITH (partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(createTable, 8L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_file_modified_time"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_file_modified_time");
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time", (Object)"$partition");
        List columnMetadatas = tableMetadata.getColumns();
        io.prestosql.testing.assertions.Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$file_modified_time")) continue;
            Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.getPartitions("test_file_modified_time").size(), (int)3);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%s\" FROM test_file_modified_time", "$file_modified_time"));
        HashMap<Integer, Instant> fileModifiedTimeMap = new HashMap<Integer, Instant>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            Instant fileModifiedTime = ((ZonedDateTime)row.getField(2)).toInstant();
            Assert.assertTrue((fileModifiedTime.toEpochMilli() > testStartTime - 2000L ? 1 : 0) != 0);
            io.prestosql.testing.assertions.Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (fileModifiedTimeMap.containsKey(col1)) {
                io.prestosql.testing.assertions.Assert.assertEquals(fileModifiedTimeMap.get(col1), (Object)fileModifiedTime);
                continue;
            }
            fileModifiedTimeMap.put(col1, fileModifiedTime);
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)fileModifiedTimeMap.size(), (int)3);
        this.assertUpdate("DROP TABLE test_file_modified_time");
    }

    @Test
    public void testPartitionHiddenColumn() {
        String createTable = "CREATE TABLE test_partition_hidden_column WITH (partitioned_by = ARRAY['col1', 'col2']) AS SELECT * FROM (VALUES (0, 11, 21), (1, 12, 22), (2, 13, 23), (3, 14, 24), (4, 15, 25), (5, 16, 26), (6, 17, 27), (7, 18, 28), (8, 19, 29) ) t (col0, col1, col2) ";
        this.assertUpdate(createTable, 9L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_partition_hidden_column"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partition_hidden_column");
        io.prestosql.testing.assertions.Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"col1", (Object)"col2"));
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"col2", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time", (Object)"$partition");
        List columnMetadatas = tableMetadata.getColumns();
        io.prestosql.testing.assertions.Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$partition")) continue;
            Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)this.getPartitions("test_partition_hidden_column").size(), (int)9);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%s\" FROM test_partition_hidden_column", "$partition"));
        for (MaterializedRow row : results.getMaterializedRows()) {
            String actualPartition = (String)row.getField(3);
            String expectedPartition = String.format("col1=%s/col2=%s", row.getField(1), row.getField(2));
            io.prestosql.testing.assertions.Assert.assertEquals((String)actualPartition, (String)expectedPartition);
        }
        io.prestosql.testing.assertions.Assert.assertEquals((int)results.getRowCount(), (int)9);
        this.assertUpdate("DROP TABLE test_partition_hidden_column");
    }

    @Test
    public void testDeleteAndInsert() {
        Session session = this.getSession();
        this.assertUpdate(session, "CREATE TABLE tmp_delete_insert WITH (partitioned_by=array ['z']) AS SELECT * FROM (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2), (401, 4), (402, 4), (403, 4)) t(a, z)", 6L);
        List expectedBefore = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{401L, 4L}).row(new Object[]{402L, 4L}).row(new Object[]{403L, 4L}).build().getMaterializedRows();
        List expectedAfter = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{203L, 2L}).row(new Object[]{204L, 2L}).row(new Object[]{205L, 2L}).row(new Object[]{301L, 2L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        try {
            TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
                this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
                this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
                MaterializedResult actualFromAnotherTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromAnotherTransaction, (Iterable)expectedBefore);
                MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expectedAfter);
                this.rollback();
            });
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        MaterializedResult actualAfterRollback = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterRollback, (Iterable)expectedBefore);
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
            MaterializedResult actualOutOfTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualOutOfTransaction, (Iterable)expectedBefore);
            MaterializedResult actualInTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualInTransaction, (Iterable)expectedAfter);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expectedAfter);
    }

    @Test
    public void testCreateAndInsert() {
        Session session = this.getSession();
        List expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{301L, 3L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "CREATE TABLE tmp_create_insert WITH (partitioned_by=array ['z']) AS SELECT * FROM (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2)) t(a, z)", 3L);
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_create_insert VALUES (301, 3), (302, 3)", 2L);
            MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_create_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expected);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_create_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expected);
    }

    @Test
    public void testRenameView() {
        this.assertUpdate("CREATE VIEW rename_view_original AS SELECT COUNT(*) as count FROM orders");
        this.assertQuery("SELECT * FROM rename_view_original", "SELECT COUNT(*) FROM orders");
        this.assertUpdate("CREATE SCHEMA view_rename");
        this.assertUpdate("ALTER VIEW rename_view_original RENAME TO view_rename.rename_view_new");
        this.assertQuery("SELECT * FROM view_rename.rename_view_new", "SELECT COUNT(*) FROM orders");
        this.assertQueryFails("SELECT * FROM rename_view_original", ".*rename_view_original' does not exist");
        this.assertUpdate("DROP VIEW view_rename.rename_view_new");
    }

    @Test
    public void testAddColumn() {
        this.assertUpdate("CREATE TABLE test_add_column (a bigint COMMENT 'test comment AAA')");
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN b bigint COMMENT 'test comment BBB'");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN a varchar", ".* Column 'a' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN c bad_type", ".* Unknown type 'bad_type' for column 'c'");
        this.assertQuery("SHOW COLUMNS FROM test_add_column", "VALUES ('a', 'bigint', '', 'test comment AAA'), ('b', 'bigint', '', 'test comment BBB')");
        this.assertUpdate("DROP TABLE test_add_column");
    }

    @Test
    public void testRenameColumn() {
        String createTable = "CREATE TABLE test_rename_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN orderkey TO new_orderkey");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN \"$path\" TO test", ".* Cannot rename hidden column");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN orderstatus TO new_orderstatus", "Renaming partition columns is not supported");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_rename_column");
    }

    @Test
    public void testDropColumn() {
        String createTable = "CREATE TABLE test_drop_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT custkey, orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT orderkey, orderstatus FROM test_drop_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN \"$path\"", ".* Cannot drop hidden column");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN orderstatus", "Cannot drop partition columns");
        this.assertUpdate("ALTER TABLE test_drop_column DROP COLUMN orderkey");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN custkey", "Cannot drop the only non-partition column in a table");
        this.assertQuery("SELECT * FROM test_drop_column", "SELECT custkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_drop_column");
    }

    @Test
    public void testAvroTypeValidation() {
        this.assertQueryFails("CREATE TABLE test_avro_types (x map(bigint, bigint)) WITH (format = 'AVRO')", "Column 'x' has a non-varchar map key, which is not supported by Avro");
        this.assertQueryFails("CREATE TABLE test_avro_types (x tinyint) WITH (format = 'AVRO')", "Column 'x' is tinyint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types (x smallint) WITH (format = 'AVRO')", "Column 'x' is smallint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types WITH (format = 'AVRO') AS SELECT cast(42 AS smallint) z", "Column 'z' is smallint, which is not supported by Avro. Use integer instead.");
    }

    @Test
    public void testOrderByChar() {
        this.assertUpdate("CREATE TABLE char_order_by (c_char char(2))");
        this.assertUpdate("INSERT INTO char_order_by (c_char) VALUES(CAST('a' as CHAR(2))),(CAST('a\u0000' as CHAR(2))),(CAST('a  ' as CHAR(2)))", 3L);
        MaterializedResult actual = this.computeActual(this.getSession(), "SELECT * FROM char_order_by ORDER BY c_char ASC");
        this.assertUpdate("DROP TABLE char_order_by");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{CharType.createCharType((long)2L)}).row(new Object[]{"a\u0000"}).row(new Object[]{"a "}).row(new Object[]{"a "}).build();
        io.prestosql.testing.assertions.Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPredicatePushDownToTableScan() {
        this.assertUpdate("CREATE TABLE test_table_with_char (a char(20))");
        try {
            this.assertUpdate("INSERT INTO test_table_with_char (a) VALUES(cast('aaa' as char(20))),(cast('bbb' as char(20))),(cast('bbc' as char(20))),(cast('bbd' as char(20)))", 4L);
            this.assertQuery("SELECT a, a <= 'bbc' FROM test_table_with_char", "VALUES (cast('aaa' as char(20)), true), (cast('bbb' as char(20)), true), (cast('bbc' as char(20)), true), (cast('bbd' as char(20)), false)");
            this.assertQuery("SELECT a FROM test_table_with_char WHERE a <= 'bbc'", "VALUES cast('aaa' as char(20)), cast('bbb' as char(20)), cast('bbc' as char(20))");
        }
        finally {
            this.assertUpdate("DROP TABLE test_table_with_char");
        }
    }

    @DataProvider
    public Object[][] timestampPrecisionAndValues() {
        return new Object[][]{{HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("2012-10-31T01:00:08.123")}, {HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("2012-10-31T01:00:08.123456")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2012-10-31T01:00:08.123000000")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2012-10-31T01:00:08.123000001")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2012-10-31T01:00:08.123456789")}, {HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("1965-10-31T01:00:08.123")}, {HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("1965-10-31T01:00:08.123456")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("1965-10-31T01:00:08.123000000")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("1965-10-31T01:00:08.123000001")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("1965-10-31T01:00:08.123456789")}};
    }

    @Test(dataProvider="timestampPrecisionAndValues")
    public void testParquetTimestampPredicatePushdown(HiveTimestampPrecision timestampPrecision, LocalDateTime value) {
        Session session = this.withTimestampPrecision(this.getSession(), timestampPrecision);
        this.assertUpdate("DROP TABLE IF EXISTS test_parquet_timestamp_predicate_pushdown");
        this.assertUpdate("CREATE TABLE test_parquet_timestamp_predicate_pushdown (t TIMESTAMP) WITH (format = 'PARQUET')");
        this.assertUpdate(session, String.format("INSERT INTO test_parquet_timestamp_predicate_pushdown VALUES (%s)", TestHiveIntegrationSmokeTest.formatTimestamp(value)), 1L);
        this.assertQuery(session, "SELECT * FROM test_parquet_timestamp_predicate_pushdown", String.format("VALUES (%s)", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
        DistributedQueryRunner queryRunner = (DistributedQueryRunner)this.getQueryRunner();
        ResultWithQueryId queryResult = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_parquet_timestamp_predicate_pushdown WHERE t < %s", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
        io.prestosql.testing.assertions.Assert.assertEquals((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)queryResult).getQueryStats().getProcessedInputDataSize().toBytes(), (long)0L);
        queryResult = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_parquet_timestamp_predicate_pushdown WHERE t > %s", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
        io.prestosql.testing.assertions.Assert.assertEquals((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)queryResult).getQueryStats().getProcessedInputDataSize().toBytes(), (long)0L);
        ExponentialSleeper sleeper = new ExponentialSleeper();
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(30.0, TimeUnit.SECONDS), () -> {
            ResultWithQueryId result = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_parquet_timestamp_predicate_pushdown WHERE t = %s", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
            sleeper.sleep();
            Assertions.assertThat((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)result).getQueryStats().getProcessedInputDataSize().toBytes()).isGreaterThan(0L);
        });
    }

    @Test(dataProvider="timestampPrecisionAndValues")
    public void testOrcTimestampPredicatePushdown(HiveTimestampPrecision timestampPrecision, LocalDateTime value) {
        Session session = this.withTimestampPrecision(this.getSession(), timestampPrecision);
        this.assertUpdate("DROP TABLE IF EXISTS test_orc_timestamp_predicate_pushdown");
        this.assertUpdate("CREATE TABLE test_orc_timestamp_predicate_pushdown (t TIMESTAMP) WITH (format = 'ORC')");
        this.assertUpdate(session, String.format("INSERT INTO test_orc_timestamp_predicate_pushdown VALUES (%s)", TestHiveIntegrationSmokeTest.formatTimestamp(value)), 1L);
        this.assertQuery(session, "SELECT * FROM test_orc_timestamp_predicate_pushdown", String.format("VALUES (%s)", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        ResultWithQueryId queryResult = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_orc_timestamp_predicate_pushdown WHERE t < %s", TestHiveIntegrationSmokeTest.formatTimestamp(value.minusNanos(TimeUnit.MILLISECONDS.toNanos(1L)))));
        io.prestosql.testing.assertions.Assert.assertEquals((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)queryResult).getQueryStats().getProcessedInputDataSize().toBytes(), (long)0L);
        queryResult = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_orc_timestamp_predicate_pushdown WHERE t > %s", TestHiveIntegrationSmokeTest.formatTimestamp(value.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L)))));
        io.prestosql.testing.assertions.Assert.assertEquals((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)queryResult).getQueryStats().getProcessedInputDataSize().toBytes(), (long)0L);
        this.assertQuery(session, "SELECT * FROM test_orc_timestamp_predicate_pushdown WHERE t < " + TestHiveIntegrationSmokeTest.formatTimestamp(value.plusNanos(1L)), String.format("VALUES (%s)", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
        ExponentialSleeper sleeper = new ExponentialSleeper();
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(30.0, TimeUnit.SECONDS), () -> {
            ResultWithQueryId result = queryRunner.executeWithQueryId(session, String.format("SELECT * FROM test_orc_timestamp_predicate_pushdown WHERE t = %s", TestHiveIntegrationSmokeTest.formatTimestamp(value)));
            sleeper.sleep();
            Assertions.assertThat((long)this.getQueryInfo(queryRunner, (ResultWithQueryId<MaterializedResult>)result).getQueryStats().getProcessedInputDataSize().toBytes()).isGreaterThan(0L);
        });
    }

    private static String formatTimestamp(LocalDateTime timestamp) {
        return String.format("TIMESTAMP '%s'", TIMESTAMP_FORMATTER.format(timestamp));
    }

    private QueryInfo getQueryInfo(DistributedQueryRunner queryRunner, ResultWithQueryId<MaterializedResult> queryResult) {
        return queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(queryResult.getQueryId());
    }

    @Test
    public void testPartitionPruning() {
        this.assertUpdate("CREATE TABLE test_partition_pruning (v bigint, k varchar) WITH (partitioned_by = array['k'])");
        this.assertUpdate("INSERT INTO test_partition_pruning (v, k) VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'e')", 4L);
        try {
            String query = "SELECT * FROM test_partition_pruning WHERE k = 'a'";
            this.assertQuery(query, "VALUES (1, 'a')");
            this.assertConstraints(query, (Set<IoPlanPrinter.ColumnConstraint>)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("k", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY)))))));
            query = "SELECT * FROM test_partition_pruning WHERE k IN ('a', 'b')";
            this.assertQuery(query, "VALUES (1, 'a'), (2, 'b')");
            this.assertConstraints(query, (Set<IoPlanPrinter.ColumnConstraint>)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("k", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("a"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY)))))));
            query = "SELECT * FROM test_partition_pruning WHERE k >= 'b'";
            this.assertQuery(query, "VALUES (2, 'b'), (3, 'c'), (4, 'e')");
            this.assertConstraints(query, (Set<IoPlanPrinter.ColumnConstraint>)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("k", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("c"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("c"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("e"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("e"), Marker.Bound.EXACTLY)))))));
            query = "SELECT * FROM (    SELECT *     FROM test_partition_pruning     WHERE v IN (1, 2, 4) ) t WHERE t.k >= 'b'";
            this.assertQuery(query, "VALUES (2, 'b'), (4, 'e')");
            this.assertConstraints(query, (Set<IoPlanPrinter.ColumnConstraint>)ImmutableSet.of((Object)new IoPlanPrinter.ColumnConstraint("k", (Type)VarcharType.VARCHAR, new IoPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("b"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("c"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("c"), Marker.Bound.EXACTLY)), (Object)new IoPlanPrinter.FormattedRange(new IoPlanPrinter.FormattedMarker(Optional.of("e"), Marker.Bound.EXACTLY), new IoPlanPrinter.FormattedMarker(Optional.of("e"), Marker.Bound.EXACTLY)))))));
        }
        finally {
            this.assertUpdate("DROP TABLE test_partition_pruning");
        }
    }

    @Test
    public void testBucketFilteringByInPredicate() {
        String createTable = "CREATE TABLE test_bucket_filtering (bucket_key_1 BIGINT, bucket_key_2 VARCHAR, col3 BOOLEAN) WITH (bucketed_by = ARRAY[ 'bucket_key_1', 'bucket_key_2' ], bucket_count = 11) ";
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO test_bucket_filtering (bucket_key_1, bucket_key_2, col3) VALUES (1, 'd', true), (2, 'c', null), (3, 'b', false), (4, null, true), (null, 'a', true)", 5L);
        try {
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (1, 2) AND bucket_key_2 IN ('b', 'd')", "VALUES (1, 'd', true)");
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (1, 2, 5, 6) AND bucket_key_2 IN ('b', 'd', 'x')", "VALUES (1, 'd', true)");
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE (bucket_key_1 IN (1, 2) OR bucket_key_1 IS NULL) AND (bucket_key_2 IN ('a', 'd') OR bucket_key_2 IS NULL)", "VALUES (1, 'd', true), (null, 'a', true)");
            this.assertQueryReturnsEmptyResult("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (5, 6) AND bucket_key_2 IN ('x', 'y')");
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (1, 2, 3) AND bucket_key_2 IN ('b', 'c', 'd') AND col3 = true", "VALUES (1, 'd', true)");
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (1, 2) AND bucket_key_2 IN ('c', 'd') AND col3 IS NULL", "VALUES (2, 'c', null)");
            this.assertQuery("SELECT * FROM test_bucket_filtering WHERE bucket_key_1 IN (1, 2) AND bucket_key_2 IN ('b', 'c') OR col3 = false", "VALUES (2, 'c', null), (3, 'b', false)");
        }
        finally {
            this.assertUpdate("DROP TABLE test_bucket_filtering");
        }
    }

    @Test
    public void schemaMismatchesWithDereferenceProjections() {
        for (TestingHiveStorageFormat format : this.getAllTestingHiveStorageFormat()) {
            this.schemaMismatchesWithDereferenceProjections(format.getFormat());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schemaMismatchesWithDereferenceProjections(HiveStorageFormat format) {
        try {
            this.assertUpdate("CREATE TABLE evolve_test (dummy bigint, a row(b bigint, c varchar), d bigint) with (format = '" + format + "', partitioned_by=array['d'])");
            this.assertUpdate("INSERT INTO evolve_test values (1, row(1, 'abc'), 1)", 1L);
            this.assertUpdate("ALTER TABLE evolve_test DROP COLUMN a");
            this.assertUpdate("ALTER TABLE evolve_test ADD COLUMN a row(c varchar, b bigint)");
            this.assertUpdate("INSERT INTO evolve_test values (2, row('def', 2), 2)", 1L);
            this.assertQueryFails("SELECT a.b FROM evolve_test where d = 1", ".*There is a mismatch between the table and partition schemas.*");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS evolve_test");
        }
        try {
            this.assertUpdate("CREATE TABLE evolve_test (dummy bigint, a row(b bigint), d bigint) with (format = '" + format + "', partitioned_by=array['d'])");
            this.assertUpdate("INSERT INTO evolve_test values (1, row(1), 1)", 1L);
            this.assertUpdate("ALTER TABLE evolve_test DROP COLUMN a");
            this.assertUpdate("ALTER TABLE evolve_test ADD COLUMN a row(b bigint, c varchar)");
            this.assertUpdate("INSERT INTO evolve_test values (2, row(2, 'def'), 2)", 1L);
            this.assertQuery("SELECT a.c FROM evolve_test", "SELECT 'def' UNION SELECT null");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS evolve_test");
        }
        try {
            this.assertUpdate("CREATE TABLE evolve_test (dummy bigint, a row(b bigint, c varchar), d bigint) with (format = '" + format + "', partitioned_by=array['d'])");
            this.assertUpdate("INSERT INTO evolve_test values (1, row(1, 'abc'), 1)", 1L);
            this.assertUpdate("ALTER TABLE evolve_test DROP COLUMN a");
            this.assertUpdate("ALTER TABLE evolve_test ADD COLUMN a row(b bigint, c varchar, e int)");
            this.assertUpdate("INSERT INTO evolve_test values (2, row(2, 'def', 2), 2)", 1L);
            this.assertQuery("SELECT a.b FROM evolve_test", "VALUES 1, 2");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS evolve_test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubfieldReordering() {
        ImmutableList formats = ImmutableList.of((Object)HiveStorageFormat.ORC, (Object)HiveStorageFormat.PARQUET);
        for (HiveStorageFormat format : formats) {
            try {
                this.assertUpdate("CREATE TABLE evolve_test (dummy bigint, a row(b bigint, c varchar)) with (format = '" + format + "')");
                this.assertUpdate("INSERT INTO evolve_test values (1, row(1, 'abc'))", 1L);
                this.assertUpdate("ALTER TABLE evolve_test DROP COLUMN a");
                this.assertUpdate("ALTER TABLE evolve_test ADD COLUMN a row(c varchar, b bigint)");
                this.assertQuery("SELECT a.b FROM evolve_test", "VALUES 1");
            }
            finally {
                this.assertUpdate("DROP TABLE IF EXISTS evolve_test");
            }
            try {
                this.assertUpdate("CREATE TABLE evolve_test (dummy bigint, a row(b bigint, c row(x bigint, y varchar))) with (format = '" + format + "')");
                this.assertUpdate("INSERT INTO evolve_test values (1, row(1, row(3, 'abc')))", 1L);
                this.assertUpdate("ALTER TABLE evolve_test DROP COLUMN a");
                this.assertUpdate("ALTER TABLE evolve_test ADD COLUMN a row(c row(y varchar, x bigint), b bigint)");
                this.assertQuerySucceeds("SELECT a.c.y, a.c FROM evolve_test");
            }
            finally {
                this.assertUpdate("DROP TABLE IF EXISTS evolve_test");
            }
        }
    }

    @Test
    public void testParquetColumnNameMappings() {
        Session sessionUsingColumnIndex = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "false").build();
        Session sessionUsingColumnName = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "true").build();
        String tableName = "test_parquet_by_column_index";
        this.assertUpdate(sessionUsingColumnIndex, String.format("CREATE TABLE %s(  a varchar,   b varchar) WITH (format='PARQUET')", tableName));
        this.assertUpdate(sessionUsingColumnIndex, "INSERT INTO " + tableName + " VALUES ('a', 'b')", 1L);
        this.assertQuery(sessionUsingColumnIndex, "SELECT a, b FROM " + tableName, "VALUES ('a', 'b')");
        this.assertQuery(sessionUsingColumnIndex, "SELECT a FROM " + tableName + " WHERE b = 'b'", "VALUES ('a')");
        String tableLocation = (String)this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + tableName).getOnlyValue();
        String reversedTableName = "test_parquet_by_column_index_reversed";
        this.assertUpdate(sessionUsingColumnIndex, String.format("CREATE TABLE %s(  b varchar,   a varchar) WITH (format='PARQUET', external_location='%s')", reversedTableName, tableLocation));
        this.assertQuery(sessionUsingColumnIndex, "SELECT a, b FROM " + reversedTableName, "VALUES ('b', 'a')");
        this.assertQuery(sessionUsingColumnIndex, "SELECT a FROM " + reversedTableName + " WHERE b = 'a'", "VALUES ('b')");
        this.assertQuery(sessionUsingColumnName, "SELECT a, b FROM " + reversedTableName, "VALUES ('a', 'b')");
        this.assertQuery(sessionUsingColumnName, "SELECT a FROM " + reversedTableName + " WHERE b = 'b'", "VALUES ('a')");
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + reversedTableName);
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + tableName);
    }

    @Test
    public void testParquetWithMissingColumns() {
        Session sessionUsingColumnIndex = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "false").build();
        Session sessionUsingColumnName = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "true").build();
        String singleColumnTableName = "test_parquet_with_missing_columns_one";
        this.assertUpdate(String.format("CREATE TABLE %s(  a varchar) WITH (format='PARQUET')", singleColumnTableName));
        this.assertUpdate(sessionUsingColumnIndex, "INSERT INTO " + singleColumnTableName + " VALUES ('a')", 1L);
        String tableLocation = (String)this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + singleColumnTableName).getOnlyValue();
        String multiColumnTableName = "test_parquet_missing_columns_two";
        this.assertUpdate(sessionUsingColumnIndex, String.format("CREATE TABLE %s(  b varchar,   a varchar) WITH (format='PARQUET', external_location='%s')", multiColumnTableName, tableLocation));
        this.assertQuery(sessionUsingColumnName, "SELECT a FROM " + multiColumnTableName + " WHERE b IS NULL", "VALUES ('a')");
        this.assertQuery(sessionUsingColumnName, "SELECT a FROM " + multiColumnTableName + " WHERE a = 'a'", "VALUES ('a')");
        this.assertQuery(sessionUsingColumnIndex, "SELECT b FROM " + multiColumnTableName + " WHERE b = 'a'", "VALUES ('a')");
        this.assertQuery(sessionUsingColumnIndex, "SELECT b FROM " + multiColumnTableName + " WHERE a IS NULL", "VALUES ('a')");
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + singleColumnTableName);
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + multiColumnTableName);
    }

    @Test
    public void testParquetWithMissingNestedColumns() {
        Session sessionUsingColumnIndex = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "false").build();
        Session sessionUsingColumnName = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "true").build();
        String missingNestedFieldsTableName = "test_parquet_missing_nested_fields";
        this.assertUpdate(String.format("CREATE TABLE %s(  an_array ARRAY(ROW(a2 int))) WITH (format='PARQUET')", missingNestedFieldsTableName));
        this.assertUpdate(sessionUsingColumnIndex, "INSERT INTO " + missingNestedFieldsTableName + " VALUES (ARRAY[ROW(2)])", 1L);
        String tableLocation = (String)this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + missingNestedFieldsTableName).getOnlyValue();
        String missingNestedArrayTableName = "test_parquet_missing_nested_array";
        this.assertUpdate(sessionUsingColumnIndex, String.format("CREATE TABLE %s(  an_array ARRAY(ROW(nested_array ARRAY(varchar), a2 int))) WITH (format='PARQUET', external_location='%s')", missingNestedArrayTableName, tableLocation));
        this.assertQuery(sessionUsingColumnIndex, "SELECT an_array[1].nested_array FROM " + missingNestedArrayTableName, "VALUES (null)");
        this.assertQuery(sessionUsingColumnName, "SELECT an_array[1].nested_array FROM " + missingNestedArrayTableName, "VALUES (null)");
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + missingNestedFieldsTableName);
        this.assertUpdate(sessionUsingColumnIndex, "DROP TABLE " + missingNestedArrayTableName);
    }

    @Test
    public void testNestedColumnWithDuplicateName() {
        String tableName = "test_nested_column_with_duplicate_name";
        this.assertUpdate(String.format("CREATE TABLE %s(  foo varchar,   root ROW (foo varchar)) WITH (format='PARQUET')", tableName));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('a', ROW('b'))", 1L);
        this.assertQuery("SELECT root.foo FROM " + tableName + " WHERE foo = 'a'", "VALUES ('b')");
        this.assertQuery("SELECT root.foo FROM " + tableName + " WHERE root.foo = 'b'", "VALUES ('b')");
        this.assertQuery("SELECT root.foo FROM " + tableName + " WHERE foo = 'a' AND root.foo = 'b'", "VALUES ('b')");
        this.assertQuery("SELECT foo FROM " + tableName + " WHERE foo = 'a'", "VALUES ('a')");
        this.assertQuery("SELECT foo FROM " + tableName + " WHERE root.foo = 'b'", "VALUES ('a')");
        this.assertQuery("SELECT foo FROM " + tableName + " WHERE foo = 'a' AND root.foo = 'b'", "VALUES ('a')");
        Assert.assertTrue((boolean)this.computeActual("SELECT foo FROM " + tableName + " WHERE foo = 'a' AND root.foo = 'a'").getMaterializedRows().isEmpty());
        Assert.assertTrue((boolean)this.computeActual("SELECT foo FROM " + tableName + " WHERE foo = 'b' AND root.foo = 'b'").getMaterializedRows().isEmpty());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testParquetNaNStatistics() {
        String tableName = "test_parquet_nan_statistics";
        this.assertUpdate("CREATE TABLE " + tableName + " (c_double DOUBLE, c_real REAL, c_string VARCHAR) WITH (format = 'PARQUET')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (nan(), cast(nan() as REAL), 'all nan')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (nan(), null, 'null real'), (null, nan(), 'null double')", 2L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (nan(), 4.2, '4.2 real'), (4.2, nan(), '4.2 double')", 2L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (0.1, 0.1, 'both 0.1')", 1L);
        this.assertQuery("SELECT c_string FROM " + tableName + " WHERE c_double > 4", "VALUES ('4.2 double')");
        this.assertQuery("SELECT c_string FROM " + tableName + " WHERE c_real > 4", "VALUES ('4.2 real')");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMismatchedBucketing() {
        try {
            this.assertUpdate("CREATE TABLE test_mismatch_bucketing16\nWITH (bucket_count = 16, bucketed_by = ARRAY['key16']) AS\nSELECT orderkey key16, comment value16 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_mismatch_bucketing32\nWITH (bucket_count = 32, bucketed_by = ARRAY['key32']) AS\nSELECT orderkey key32, comment value32 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_mismatch_bucketingN AS\nSELECT orderkey keyN, comment valueN FROM orders", 15000L);
            Session withMismatchOptimization = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("enable_dynamic_filtering", "false").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "true").build();
            Session withoutMismatchOptimization = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("enable_dynamic_filtering", "false").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "false").build();
            String writeToTableWithMoreBuckets = "CREATE TABLE test_mismatch_bucketing_out32\nWITH (bucket_count = 32, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, keyN, valueN\nFROM\n  test_mismatch_bucketing16\nJOIN\n  test_mismatch_bucketing32\nON key16=key32\nJOIN\n  test_mismatch_bucketingN\nON key16=keyN";
            String writeToTableWithFewerBuckets = "CREATE TABLE test_mismatch_bucketing_out8\nWITH (bucket_count = 8, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, keyN, valueN\nFROM\n  test_mismatch_bucketing16\nJOIN\n  test_mismatch_bucketing32\nON key16=key32\nJOIN\n  test_mismatch_bucketingN\nON key16=keyN";
            this.assertUpdate(withoutMismatchOptimization, writeToTableWithMoreBuckets, 15000L, this.assertRemoteExchangesCount(3));
            this.assertQuery("SELECT * FROM test_mismatch_bucketing_out32", "SELECT orderkey, comment, orderkey, comment, orderkey, comment FROM orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing_out32");
            this.assertUpdate(withMismatchOptimization, writeToTableWithMoreBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery("SELECT * FROM test_mismatch_bucketing_out32", "SELECT orderkey, comment, orderkey, comment, orderkey, comment FROM orders");
            this.assertUpdate(withMismatchOptimization, writeToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery("SELECT * FROM test_mismatch_bucketing_out8", "SELECT orderkey, comment, orderkey, comment, orderkey, comment FROM orders");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing16");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing32");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketingN");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing_out32");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing_out8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupedExecution() {
        try {
            this.assertUpdate("CREATE TABLE test_grouped_join1\nWITH (bucket_count = 13, bucketed_by = ARRAY['key1']) AS\nSELECT orderkey key1, comment value1 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_join2\nWITH (bucket_count = 13, bucketed_by = ARRAY['key2']) AS\nSELECT orderkey key2, comment value2 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_join3\nWITH (bucket_count = 13, bucketed_by = ARRAY['key3']) AS\nSELECT orderkey key3, comment value3 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_join4\nWITH (bucket_count = 13, bucketed_by = ARRAY['key4_bucket']) AS\nSELECT orderkey key4_bucket, orderkey key4_non_bucket, comment value4 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_joinN AS\nSELECT orderkey keyN, comment valueN FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_grouped_joinDual\nWITH (bucket_count = 13, bucketed_by = ARRAY['keyD']) AS\nSELECT orderkey keyD, comment valueD FROM orders CROSS JOIN UNNEST(repeat(NULL, 2))", 30000L);
            this.assertUpdate("CREATE TABLE test_grouped_window\nWITH (bucket_count = 5, bucketed_by = ARRAY['key']) AS\nSELECT custkey key, orderkey value FROM orders WHERE custkey <= 5 ORDER BY orderkey LIMIT 10", 10L);
            Session notColocated = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "false").setSystemProperty("grouped_execution", "false").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session colocatedAllGroupsAtOnce = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "0").setSystemProperty("dynamic_schedule_for_grouped_execution", "false").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session colocatedOneGroupAtATime = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").setSystemProperty("dynamic_schedule_for_grouped_execution", "false").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session colocatedAllGroupsAtOnceDynamic = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "0").setSystemProperty("dynamic_schedule_for_grouped_execution", "true").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session colocatedOneGroupAtATimeDynamic = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").setSystemProperty("dynamic_schedule_for_grouped_execution", "true").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session broadcastOneGroupAtATime = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").setSystemProperty("enable_dynamic_filtering", "false").build();
            Session broadcastOneGroupAtATimeDynamic = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").setSystemProperty("dynamic_schedule_for_grouped_execution", "true").setSystemProperty("enable_dynamic_filtering", "false").build();
            String joinThreeBucketedTable = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_join3\nON key2 = key3";
            String joinThreeMixedTable = "SELECT key1, value1, key2, value2, keyN, valueN\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_joinN\nON key2 = keyN";
            String expectedJoinQuery = "SELECT orderkey, comment, orderkey, comment, orderkey, comment FROM orders";
            String leftJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM test_grouped_join1\nLEFT JOIN (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nON key1 = key2";
            String rightJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nRIGHT JOIN test_grouped_join1\nON key1 = key2";
            String expectedOuterJoinQuery = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN orderkey END, CASE mod(orderkey, 2) WHEN 0 THEN comment END FROM orders";
            this.assertQuery(notColocated, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(notColocated, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(notColocated, rightJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnceDynamic, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnceDynamic, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnceDynamic, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnceDynamic, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            String crossJoin = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nCROSS JOIN (SELECT * FROM test_grouped_join3 WHERE key3 <= 3)";
            String expectedCrossJoinQuery = "SELECT key1, value1, key1, value1, key3, value3\nFROM\n  (SELECT orderkey key1, comment value1 FROM orders)\nCROSS JOIN\n  (SELECT orderkey key3, comment value3 FROM orders WHERE orderkey <= 3)";
            this.assertQuery(notColocated, crossJoin, expectedCrossJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, crossJoin, expectedCrossJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, crossJoin, expectedCrossJoinQuery, this.assertRemoteExchangesCount(2));
            String bucketedAndUnbucketedJoin = "SELECT key1, value1, keyN, valueN, key2, value2, key3, value3\nFROM\n  test_grouped_join1\nJOIN (\n  SELECT *\n  FROM test_grouped_joinN\n  JOIN test_grouped_join2\n  ON keyN = key2\n)\nON key1 = keyN\nJOIN test_grouped_join3\nON key1 = key3";
            String expectedBucketedAndUnbucketedJoinQuery = "SELECT orderkey, comment, orderkey, comment, orderkey, comment, orderkey, comment FROM orders";
            this.assertQuery(notColocated, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery);
            this.assertQuery(colocatedAllGroupsAtOnce, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            String groupBySingleBucketed = "SELECT\n  keyD,\n  count(valueD)\nFROM\n  test_grouped_joinDual\nGROUP BY keyD";
            String expectedSingleGroupByQuery = "SELECT orderkey, 2 FROM orders";
            String groupByOfUnionBucketed = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(value3)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL value3\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL value3\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT key3 key, NULL value1, NULL value2, value3\n  FROM test_grouped_join3\n  WHERE key3 % 3 = 0\n)\nGROUP BY key";
            String groupByOfUnionMixed = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(valueN)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL valueN\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL valueN\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT keyN key, NULL value1, NULL value2, valueN\n  FROM test_grouped_joinN\n  WHERE keyN % 3 = 0\n)\nGROUP BY key";
            String expectedGroupByOfUnion = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN comment END, CASE mod(orderkey, 3) WHEN 0 THEN comment END FROM orders";
            String groupByOfUnionOfGroupByMixed = "SELECT\n  key, sum(cnt) cnt\nFROM (\n  SELECT keyD key, count(valueD) cnt\n  FROM test_grouped_joinDual\n  GROUP BY keyD\nUNION ALL\n  SELECT keyN key, 1 cnt\n  FROM test_grouped_joinN\n)\ngroup by key";
            String expectedGroupByOfUnionOfGroupBy = "SELECT orderkey, 3 FROM orders";
            this.assertQuery(colocatedAllGroupsAtOnce, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionMixed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionOfGroupByMixed, expectedGroupByOfUnionOfGroupBy, this.assertRemoteExchangesCount(2));
            String joinGroupedWithGrouped = "SELECT key1, count1, count2\nFROM (\n  SELECT keyD key1, count(valueD) count1\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyD key2, count(valueD) count2\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON key1 = key2";
            String expectedJoinGroupedWithGrouped = "SELECT orderkey, 2, 2 FROM orders";
            String joinGroupedWithUngrouped = "SELECT keyD, countD, valueN\nFROM (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n)\nON keyD = keyN";
            String expectedJoinGroupedWithUngrouped = "SELECT orderkey, 2, comment FROM orders";
            String joinUngroupedWithGrouped = "SELECT keyN, valueN, countD\nFROM (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n) JOIN (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON keyN = keyD";
            String expectedJoinUngroupedWithGrouped = "SELECT orderkey, comment, 2 FROM orders";
            String groupOnJoinResult = "SELECT keyD, count(valueD), count(valueN)\nFROM\n  test_grouped_joinDual\nJOIN\n  test_grouped_joinN\nON keyD=keyN\nGROUP BY keyD";
            String expectedGroupOnJoinResult = "SELECT orderkey, 2, 2 FROM orders";
            String groupOnUngroupedJoinResult = "SELECT key4_bucket, count(value4), count(valueN)\nFROM\n  test_grouped_join4\nJOIN\n  test_grouped_joinN\nON key4_non_bucket=keyN\nGROUP BY key4_bucket";
            String expectedGroupOnUngroupedJoinResult = "SELECT orderkey, count(*), count(*) FROM orders group by orderkey";
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(broadcastOneGroupAtATime, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(broadcastOneGroupAtATime, groupOnUngroupedJoinResult, expectedGroupOnUngroupedJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(broadcastOneGroupAtATimeDynamic, groupOnUngroupedJoinResult, expectedGroupOnUngroupedJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinUngroupedWithGrouped, expectedJoinUngroupedWithGrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupOnUngroupedJoinResult, expectedGroupOnUngroupedJoinResult, this.assertRemoteExchangesCount(4));
            String chainedOuterJoin = "SELECT key1, value1, key2, value2, key3, value3\nFROM\n  (SELECT * FROM test_grouped_join1 WHERE mod(key1, 2) = 0)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_join2 WHERE mod(key2, 3) = 0)\nON key1 = key2\nFULL JOIN\n  (SELECT * FROM test_grouped_join3 WHERE mod(key3, 5) = 0)\nON key2 = key3";
            String sharedBuildOuterJoin = "SELECT key1, value1, keyN, valueN\nFROM\n  (SELECT key1, arbitrary(value1) value1 FROM test_grouped_join1 WHERE mod(key1, 2) = 0 group by key1)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_joinN WHERE mod(keyN, 3) = 0)\nON key1 = keyN";
            String chainedSharedBuildOuterJoin = "SELECT key1, value1, keyN, valueN, key3, value3\nFROM\n  (SELECT key1, arbitrary(value1) value1 FROM test_grouped_join1 WHERE mod(key1, 2) = 0 group by key1)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_joinN WHERE mod(keyN, 3) = 0)\nON key1 = keyN\nFULL JOIN\n  (SELECT * FROM test_grouped_join3 WHERE mod(key3, 5) = 0)\nON keyN = key3";
            String expectedChainedOuterJoinResult = "SELECT\n  CASE WHEN mod(orderkey, 2 * 3) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 2 * 3) = 0 THEN comment END,\n  CASE WHEN mod(orderkey, 3) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 3) = 0 THEN comment END,\n  CASE WHEN mod(orderkey, 5) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 5) = 0 THEN comment END\nFROM ORDERS\nWHERE mod(orderkey, 3) = 0 OR mod(orderkey, 5) = 0";
            String expectedSharedBuildOuterJoinResult = "SELECT\n  CASE WHEN mod(orderkey, 2) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 2) = 0 THEN comment END,\n  orderkey,\n  comment\nFROM ORDERS\nWHERE mod(orderkey, 3) = 0";
            this.assertQuery(notColocated, chainedOuterJoin, expectedChainedOuterJoinResult);
            this.assertQuery(colocatedAllGroupsAtOnce, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocated, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult);
            this.assertQuery(colocatedAllGroupsAtOnce, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, chainedSharedBuildOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATimeDynamic, chainedSharedBuildOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, count(*) OVER (PARTITION BY key ORDER BY value) FROM test_grouped_window", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(4, 3),\n(4, 4),\n(4, 5),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, row_number() OVER (PARTITION BY key ORDER BY value) FROM test_grouped_window", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(4, 3),\n(4, 4),\n(4, 5),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, n FROM (SELECT key, row_number() OVER (PARTITION BY key ORDER BY value) AS n FROM test_grouped_window) WHERE n <= 2", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            String noSplits = "SELECT key1, arbitrary(value1)\nFROM test_grouped_join1\nWHERE \"$bucket\" < 0\nGROUP BY key1";
            String joinMismatchedBuckets = "SELECT key1, value1, key2, value2\nFROM (\n  SELECT *\n  FROM test_grouped_join1\n  WHERE \"$bucket\"=1\n)\nFULL OUTER JOIN (\n  SELECT *\n  FROM test_grouped_join2\n  WHERE \"$bucket\"=11\n)\nON key1=key2";
            String expectedNoSplits = "SELECT 1, 'a' WHERE FALSE";
            String expectedJoinMismatchedBuckets = "SELECT\n  CASE WHEN mod(orderkey, 13) = 1 THEN orderkey END,\n  CASE WHEN mod(orderkey, 13) = 1 THEN comment END,\n  CASE WHEN mod(orderkey, 13) = 11 THEN orderkey END,\n  CASE WHEN mod(orderkey, 13) = 11 THEN comment END\nFROM ORDERS\nWHERE mod(orderkey, 13) IN (1, 11)";
            this.assertQuery(notColocated, noSplits, expectedNoSplits);
            this.assertQuery(colocatedAllGroupsAtOnce, noSplits, expectedNoSplits, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, noSplits, expectedNoSplits, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocated, joinMismatchedBuckets, expectedJoinMismatchedBuckets);
            this.assertQuery(colocatedAllGroupsAtOnce, joinMismatchedBuckets, expectedJoinMismatchedBuckets, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinMismatchedBuckets, expectedJoinMismatchedBuckets, this.assertRemoteExchangesCount(1));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join1");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join2");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join3");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_join4");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_joinN");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_joinDual");
            this.assertUpdate("DROP TABLE IF EXISTS test_grouped_window");
        }
    }

    private Consumer<Plan> assertRemoteExchangesCount(int expectedRemoteExchangesCount) {
        return plan -> {
            int actualRemoteExchangesCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE).findAll().size();
            if (actualRemoteExchangesCount != expectedRemoteExchangesCount) {
                Session session = this.getSession();
                Metadata metadata = this.getDistributedQueryRunner().getCoordinator().getMetadata();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (Metadata)metadata, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] remote exchanges but found [\n%s\n] remote exchanges. Actual plan is [\n\n%s\n]", expectedRemoteExchangesCount, actualRemoteExchangesCount, formattedPlan));
            }
        };
    }

    @Test
    public void testRcTextCharDecoding() {
        this.assertUpdate("CREATE TABLE test_table_with_char_rc WITH (format = 'RCTEXT') AS SELECT CAST('khaki' AS CHAR(7)) char_column", 1L);
        try {
            this.assertQuery("SELECT * FROM test_table_with_char_rc WHERE char_column = 'khaki  '", "VALUES (CAST('khaki' AS CHAR(7)))");
        }
        finally {
            this.assertUpdate("DROP TABLE test_table_with_char_rc");
        }
    }

    @Test
    public void testInvalidPartitionValue() {
        this.assertUpdate("CREATE TABLE invalid_partition_value (a int, b varchar) WITH (partitioned_by = ARRAY['b'])");
        this.assertQueryFails("INSERT INTO invalid_partition_value VALUES (4, 'test' || chr(13))", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: 74 65 73 74 0D\\E");
        this.assertUpdate("DROP TABLE invalid_partition_value");
        this.assertQueryFails("CREATE TABLE invalid_partition_value (a, b) WITH (partitioned_by = ARRAY['b']) AS SELECT 4, chr(9731)", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: E2 98 83\\E");
    }

    @Test
    public void testShowColumnMetadata() {
        String tableName = "test_show_column_table";
        String createTable = "CREATE TABLE " + tableName + " (a bigint, b varchar, c double)";
        Session testSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_access_owner")).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertUpdate(createTable);
        this.assertAccessAllowed("SHOW COLUMNS FROM " + tableName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied(testSession, "SHOW COLUMNS FROM " + tableName, "Cannot show columns of table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_COLUMNS)});
        String getColumnsSql = "SELECT lower(column_name) FROM information_schema.columns WHERE table_name = '" + tableName + "'";
        io.prestosql.testing.assertions.Assert.assertEquals((Set)this.computeActual(getColumnsSql).getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"));
        this.executeExclusively(() -> {
            try {
                this.getQueryRunner().getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
                this.assertQueryReturnsEmptyResult(testSession, getColumnsSql);
            }
            finally {
                this.getQueryRunner().getAccessControl().reset();
            }
        });
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRoleAuthorizationDescriptors() {
        Session user = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setIdentity(Identity.forUser((String)"user").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertUpdate("CREATE ROLE test_r_a_d1");
        this.assertUpdate("CREATE ROLE test_r_a_d2");
        this.assertUpdate("CREATE ROLE test_r_a_d3");
        this.assertQueryReturnsEmptyResult("SELECT * FROM information_schema.role_authorization_descriptors");
        this.assertQueryFails(user, "SELECT * FROM information_schema.role_authorization_descriptors", "Access Denied: Cannot select from table information_schema.role_authorization_descriptors");
        this.assertUpdate("GRANT test_r_a_d1 TO USER user");
        this.assertUpdate("GRANT test_r_a_d2 TO USER test_r_a_d1");
        this.assertUpdate("GRANT test_r_a_d2 TO USER user1 WITH ADMIN OPTION");
        this.assertUpdate("GRANT test_r_a_d2 TO USER user2");
        this.assertUpdate("GRANT test_r_a_d2 TO ROLE test_r_a_d1");
        this.assertQueryFails(user, "SELECT * FROM information_schema.role_authorization_descriptors", "Access Denied: Cannot select from table information_schema.role_authorization_descriptors");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO'),('test_r_a_d2', null, null, 'user2', 'USER', 'NO'),('test_r_a_d2', null, null, 'user1', 'USER', 'YES'),('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO'),('test_r_a_d1', null, null, 'user', 'USER', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors LIMIT 1000000000", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO'),('test_r_a_d2', null, null, 'user2', 'USER', 'NO'),('test_r_a_d2', null, null, 'user1', 'USER', 'YES'),('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO'),('test_r_a_d1', null, null, 'user', 'USER', 'NO')");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM information_schema.role_authorization_descriptors LIMIT 2)", "VALUES (2)");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE role_name = 'test_r_a_d2'", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO'),('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO'),('test_r_a_d2', null, null, 'user1', 'USER', 'YES'),('test_r_a_d2', null, null, 'user2', 'USER', 'NO')");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM information_schema.role_authorization_descriptors WHERE role_name = 'test_r_a_d2' LIMIT 1)", "VALUES 1");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee = 'user'", "VALUES ('test_r_a_d1', null, null, 'user', 'USER', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee like 'user%'", "VALUES ('test_r_a_d1', null, null, 'user', 'USER', 'NO'),('test_r_a_d2', null, null, 'user2', 'USER', 'NO'),('test_r_a_d2', null, null, 'user1', 'USER', 'YES')");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee like 'user%' LIMIT 2)", "VALUES 2");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee = 'test_r_a_d1'", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO'),('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee = 'test_r_a_d1' LIMIT 1", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee = 'test_r_a_d1' AND grantee_type = 'USER'", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'USER', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee = 'test_r_a_d1' AND grantee_type = 'ROLE'", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO')");
        this.assertQuery("SELECT * FROM information_schema.role_authorization_descriptors WHERE grantee_type = 'ROLE'", "VALUES ('test_r_a_d2', null, null, 'test_r_a_d1', 'ROLE', 'NO')");
        this.assertUpdate("DROP ROLE test_r_a_d1");
        this.assertUpdate("DROP ROLE test_r_a_d2");
        this.assertUpdate("DROP ROLE test_r_a_d3");
    }

    @Test
    public void testShowViews() {
        String viewName = "test_show_views";
        Session testSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_view_access_owner")).setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).build();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT abs(1) as whatever");
        String showViews = String.format("SELECT * FROM information_schema.views WHERE table_name = '%s'", viewName);
        this.assertQuery(String.format("SELECT table_name FROM information_schema.views WHERE table_name = '%s'", viewName), String.format("VALUES '%s'", viewName));
        this.executeExclusively(() -> {
            try {
                this.getQueryRunner().getAccessControl().denyTables(table -> false);
                this.assertQueryReturnsEmptyResult(testSession, showViews);
            }
            finally {
                this.getQueryRunner().getAccessControl().reset();
            }
        });
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testShowTablePrivileges() {
        try {
            this.assertUpdate("CREATE SCHEMA bar");
            this.assertUpdate("CREATE TABLE bar.one(t integer)");
            this.assertUpdate("CREATE TABLE bar.two(t integer)");
            this.assertUpdate("CREATE VIEW bar.three AS SELECT t FROM bar.one");
            this.assertUpdate("CREATE SCHEMA foo");
            this.computeActual("SELECT * FROM information_schema.table_privileges");
            this.assertQuery("SELECT * FROM information_schema.table_privileges WHERE table_schema = 'bar'", "VALUES ('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'one', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'one', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'one', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'one', 'UPDATE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'UPDATE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'UPDATE', 'YES', null)");
            this.assertQuery("SELECT * FROM information_schema.table_privileges WHERE table_schema = 'bar' AND table_name = 'two'", "VALUES ('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'UPDATE', 'YES', null)");
            this.assertQuery("SELECT * FROM information_schema.table_privileges WHERE table_name = 'two'", "VALUES ('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'two', 'UPDATE', 'YES', null)");
            this.assertQuery("SELECT * FROM information_schema.table_privileges WHERE table_name = 'three'", "VALUES ('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'SELECT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'DELETE', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'INSERT', 'YES', null),('admin', 'USER', 'hive', 'USER', 'hive', 'bar', 'three', 'UPDATE', 'YES', null)");
        }
        finally {
            this.computeActual("DROP SCHEMA IF EXISTS foo");
            this.computeActual("DROP VIEW IF EXISTS bar.three");
            this.computeActual("DROP TABLE IF EXISTS bar.two");
            this.computeActual("DROP TABLE IF EXISTS bar.one");
            this.computeActual("DROP SCHEMA IF EXISTS bar");
        }
    }

    @Test
    public void testCurrentUserInView() {
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String testAccountsUnqualifiedName = "test_accounts";
        String testAccountsViewUnqualifiedName = "test_accounts_view";
        String testAccountsViewFullyQualifiedName = String.format("%s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), testAccountsViewUnqualifiedName);
        this.assertUpdate(String.format("CREATE TABLE %s AS SELECT user_name, account_name  FROM (VALUES ('user1', 'account1'), ('user2', 'account2'))  t (user_name, account_name)", testAccountsUnqualifiedName), 2L);
        this.assertUpdate(String.format("CREATE VIEW %s AS SELECT account_name FROM test_accounts WHERE user_name = CURRENT_USER", testAccountsViewUnqualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user1", testAccountsViewFullyQualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user2", testAccountsViewFullyQualifiedName));
        Session user1 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(Identity.forUser((String)"user1").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        Session user2 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(Identity.forUser((String)"user2").withPrincipal(this.getSession().getIdentity().getPrincipal()).build()).build();
        this.assertQuery(user1, "SELECT account_name FROM test_accounts_view", "VALUES 'account1'");
        this.assertQuery(user2, "SELECT account_name FROM test_accounts_view", "VALUES 'account2'");
        this.assertUpdate("DROP VIEW test_accounts_view");
        this.assertUpdate("DROP TABLE test_accounts");
    }

    @Test
    public void testCollectColumnStatisticsOnCreateTable() {
        String tableName = "test_collect_column_statistics_on_create_table";
        this.assertUpdate(String.format("CREATE TABLE %s WITH (    partitioned_by = ARRAY['p_varchar'] ) AS SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar FROM (   VALUES     (null, null, null, null, null, null, 'p1'),     (null, null, null, null, null, null, 'p1'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00:00.000', CAST('abc1' AS VARCHAR), CAST('bcd1' AS VARBINARY), 'p1'),    (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00:00.000', CAST('abc2' AS VARCHAR), CAST('bcd2' AS VARBINARY), 'p1'),    (null, null, null, null, null, null, 'p2'),     (null, null, null, null, null, null, 'p2'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00:00.000', CAST('cba1' AS VARCHAR), CAST('dcb1' AS VARBINARY), 'p2'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00:00.000', CAST('cba2' AS VARCHAR), CAST('dcb2' AS VARBINARY), 'p2') ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar)", tableName), 8L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '0', '1'), ('c_double', null, 2.0E0, 0.5E0, null, '1.2', '2.2'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '1', '2'), ('c_double', null, 2.0E0, 0.5E0, null, '2.3', '3.3'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3')", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCollectStatisticsOnCreateTableTimestampWithPrecision() {
        Session nanosecondsTimestamp = this.withTimestampPrecision(this.getSession(), HiveTimestampPrecision.NANOSECONDS);
        String tableName = "test_stats_on_create_timestamp_with_precision";
        try {
            this.assertUpdate(nanosecondsTimestamp, "CREATE TABLE " + tableName + "(c_timestamp) AS VALUES TIMESTAMP '1988-04-08 02:03:04.111', TIMESTAMP '1988-04-08 02:03:04.115', TIMESTAMP '1988-04-08 02:03:04.115', TIMESTAMP '1988-04-08 02:03:04.119', TIMESTAMP '1988-04-08 02:03:04.111111', TIMESTAMP '1988-04-08 02:03:04.111115', TIMESTAMP '1988-04-08 02:03:04.111115', TIMESTAMP '1988-04-08 02:03:04.111999', TIMESTAMP '1988-04-08 02:03:04.111111111', TIMESTAMP '1988-04-08 02:03:04.111111115', TIMESTAMP '1988-04-08 02:03:04.111111115', TIMESTAMP '1988-04-08 02:03:04.111111999' ", 12L);
            this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_timestamp', null, 9.0, 0.0, null, null, null), (null, null, null, null, 12.0, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testCollectColumnStatisticsOnInsert() {
        String tableName = "test_collect_column_statistics_on_insert";
        this.assertUpdate(String.format("CREATE TABLE %s (    c_boolean BOOLEAN,    c_bigint BIGINT,    c_double DOUBLE,    c_timestamp TIMESTAMP,    c_varchar VARCHAR,    c_varbinary VARBINARY,    p_varchar VARCHAR ) WITH (    partitioned_by = ARRAY['p_varchar'] )", tableName));
        this.assertUpdate(String.format("INSERT INTO %s SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar FROM (   VALUES     (null, null, null, null, null, null, 'p1'),     (null, null, null, null, null, null, 'p1'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00', CAST('abc1' AS VARCHAR), CAST('bcd1' AS VARBINARY), 'p1'),    (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00', CAST('abc2' AS VARCHAR), CAST('bcd2' AS VARBINARY), 'p1'),    (null, null, null, null, null, null, 'p2'),     (null, null, null, null, null, null, 'p2'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00', CAST('cba1' AS VARCHAR), CAST('dcb1' AS VARBINARY), 'p2'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00', CAST('cba2' AS VARCHAR), CAST('dcb2' AS VARBINARY), 'p2') ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar)", tableName), 8L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '0', '1'), ('c_double', null, 2.0E0, 0.5E0, null, '1.2', '2.2'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '1', '2'), ('c_double', null, 2.0E0, 0.5E0, null, '2.3', '3.3'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3')", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCollectColumnStatisticsOnInsertToEmptyTable() {
        String tableName = "test_collect_column_statistics_empty_table";
        this.assertUpdate(String.format("CREATE TABLE %s (col INT)", tableName));
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('col', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("INSERT INTO %s (col) VALUES 50, 100, 1, 200, 2", tableName), 5L);
        this.assertQuery(String.format("SHOW STATS FOR %s", tableName), "SELECT * FROM VALUES ('col', null, 5.0, 0.0, null, 1, 200), (null, null, null, null, 5.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCollectColumnStatisticsOnInsertToPartiallyAnalyzedTable() {
        String tableName = "test_collect_column_statistics_partially_analyzed_table";
        this.assertUpdate(String.format("CREATE TABLE %s (col INT, col2 INT)", tableName));
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('col', 0.0, 0.0, 1.0, null, null, null), ('col2', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (columns = ARRAY['col2'])", tableName), 0L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('col', 0.0, 0.0, 1.0, null, null, null), ('col2', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("INSERT INTO %s (col, col2) VALUES (50, 49), (100, 99), (1, 0), (200, 199), (2, 1)", tableName), 5L);
        this.assertQuery(String.format("SHOW STATS FOR %s", tableName), "SELECT * FROM VALUES ('col', null, 5.0, 0.0, null, 1, 200), ('col2', null, 5.0, 0.0, null, 0, 199), (null, null, null, null, 5.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzePropertiesSystemTable() {
        this.assertQuery("SELECT * FROM system.metadata.analyze_properties WHERE catalog_name = 'hive'", "SELECT * FROM VALUES ('hive', 'partitions', '', 'array(array(varchar))', 'Partitions to be analyzed'), ('hive', 'columns', '', 'array(varchar)', 'Columns to be analyzed')");
    }

    @Test
    public void testAnalyzeEmptyTable() {
        String tableName = "test_analyze_empty_table";
        this.assertUpdate(String.format("CREATE TABLE %s (c_bigint BIGINT, c_varchar VARCHAR(2))", tableName));
        this.assertUpdate("ANALYZE " + tableName, 0L);
    }

    @Test
    public void testInvalidAnalyzePartitionedTable() {
        String tableName = "test_invalid_analyze_partitioned_table";
        this.assertQueryFails("ANALYZE " + tableName, String.format(".*Table 'hive.tpch.%s' does not exist.*", tableName));
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertQueryFails(String.format("ANALYZE %s WITH (error = 1)", tableName), ".*'hive' does not support analyze property 'error'.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = 1)", tableName), "\\QInvalid value for analyze property 'partitions': Cannot convert [1] to array(array(varchar))\\E");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = NULL)", tableName), "\\QInvalid value for analyze property 'partitions': Cannot convert [null] to array(array(varchar))\\E");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[NULL])", tableName), ".*Invalid null value in analyze partitions property.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4', '10']])", tableName), ".*Partition no longer exists.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4']])", tableName), "Partition value count does not match partition column count");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4', '10', 'error']])", tableName), "Partition value count does not match partition column count");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInvalidAnalyzeUnpartitionedTable() {
        String tableName = "test_invalid_analyze_unpartitioned_table";
        this.assertQueryFails("ANALYZE " + tableName, ".*Table.*does not exist.*");
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[])", tableName), "Partition list provided but table is not partitioned");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p1']])", tableName), "Partition list provided but table is not partitioned");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzePartitionedTable() {
        String tableName = "test_analyze_partitioned_table";
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (partitions = ARRAY[])", tableName), 0L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p1', '7'], ARRAY['p2', '7'], ARRAY['p2', '7'], ARRAY[NULL, NULL]])", tableName), 12L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '2', '3'), ('c_double', null, 2.0, 0.5, null, '3.4', '4.4'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzePartitionedTableWithColumnSubset() {
        String tableName = "test_analyze_columns_partitioned_table";
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p1', '7'], ARRAY['p2', '7'], ARRAY['p2', '7'], ARRAY[NULL, NULL]], columns = ARRAY['c_timestamp', 'c_varchar', 'c_timestamp'])", tableName), 12L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (columns = ARRAY['c_bigint', 'c_double'])", tableName), 16L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '2', '3'), ('c_double', null, 2.0, 0.5, null, '3.4', '4.4'), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzeUnpartitionedTable() {
        String tableName = "test_analyze_unpartitioned_table";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.375, null, null, null), ('c_bigint', null, 8.0, 0.375, null, '0', '7'), ('c_double', null, 10.0, 0.375, null, '1.2', '7.7'), ('c_timestamp', null, 10.0, 0.375, null, null, null), ('c_varchar', 40.0, 10.0, 0.375, null, null, null), ('c_varbinary', 20.0, null, 0.375, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnalyzeTableTimestampWithPrecision() {
        String catalog = (String)this.getSession().getCatalog().get();
        Session nanosecondsTimestamp = Session.builder((Session)this.withTimestampPrecision(this.getSession(), HiveTimestampPrecision.NANOSECONDS)).setCatalogSessionProperty(catalog, "collect_column_statistics_on_write", "false").build();
        Session microsecondsTimestamp = this.withTimestampPrecision(this.getSession(), HiveTimestampPrecision.MICROSECONDS);
        Session millisecondsTimestamp = this.withTimestampPrecision(this.getSession(), HiveTimestampPrecision.MILLISECONDS);
        String tableName = "test_analyze_timestamp_with_precision";
        try {
            this.assertUpdate(nanosecondsTimestamp, "CREATE TABLE " + tableName + "(c_timestamp) AS VALUES TIMESTAMP '1988-04-08 02:03:04.111', TIMESTAMP '1988-04-08 02:03:04.115', TIMESTAMP '1988-04-08 02:03:04.115', TIMESTAMP '1988-04-08 02:03:04.119', TIMESTAMP '1988-04-08 02:03:04.111111', TIMESTAMP '1988-04-08 02:03:04.111115', TIMESTAMP '1988-04-08 02:03:04.111115', TIMESTAMP '1988-04-08 02:03:04.111999', TIMESTAMP '1988-04-08 02:03:04.111111111', TIMESTAMP '1988-04-08 02:03:04.111111115', TIMESTAMP '1988-04-08 02:03:04.111111115', TIMESTAMP '1988-04-08 02:03:04.111111999' ", 12L);
            this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_timestamp', null, null, null, null, null, null), (null, null, null, null, 12.0, null, null)");
            this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
            this.assertUpdate(nanosecondsTimestamp, "ANALYZE " + tableName, 12L);
            this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_timestamp', null, 9.0, 0.0, null, null, null), (null, null, null, null, 12.0, null, null)");
            this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
            this.assertUpdate(microsecondsTimestamp, "ANALYZE " + tableName, 12L);
            this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_timestamp', null, 7.0, 0.0, null, null, null), (null, null, null, null, 12.0, null, null)");
            this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
            this.assertUpdate(millisecondsTimestamp, "ANALYZE " + tableName, 12L);
            this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_timestamp', null, 4.0, 0.0, null, null, null), (null, null, null, null, 12.0, null, null)");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testInvalidColumnsAnalyzeTable() {
        String tableName = "test_invalid_analyze_table";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQueryFails("ANALYZE " + tableName + " WITH (columns = ARRAY[null])", ".*Invalid null value in analyze columns property.*");
        this.assertQueryFails("ANALYZE " + tableName + " WITH (columns = ARRAY['invalid_name'])", ".*Invalid columns specified for analysis.*");
        this.assertQueryFails("ANALYZE " + tableName + " WITH (columns = ARRAY[42])", "\\QInvalid value for analyze property 'columns': Cannot convert [ARRAY[42]] to array(varchar)\\E");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzeUnpartitionedTableWithColumnSubset() {
        String tableName = "test_analyze_columns_unpartitioned_table";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName + " WITH (columns = ARRAY['c_bigint', 'c_double'])", 16L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, 8.0, 0.375, null, '0', '7'), ('c_double', null, 10.0, 0.375, null, '1.2', '7.7'), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAnalyzeUnpartitionedTableWithEmptyColumnSubset() {
        String tableName = "test_analyze_columns_unpartitioned_table_with_empty_column_subset";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertUpdate("ANALYZE " + tableName + " WITH (columns = ARRAY[])", 16L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropStatsPartitionedTable() {
        String tableName = "test_drop_stats_partitioned_table";
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '2', '3'), ('c_double', null, 2.0, 0.5, null, '3.4', '4.4'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['p2', '7'], ARRAY['p3', '8']])", "tpch", tableName));
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', 0.0, 0.0, 1.0, null, null, null), ('c_bigint', 0.0, 0.0, 1.0, null, null, null), ('c_double', 0.0, 0.0, 1.0, null, null, null), ('c_timestamp', 0.0, 0.0, 1.0, null, null, null), ('c_varchar', 0.0, 0.0, 1.0, null, null, null), ('c_varbinary', 0.0, 0.0, 1.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', 0.0, 0.0, 1.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropStatsUnpartitionedTable() {
        String tableName = "test_drop_all_stats_unpartitioned_table";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.375, null, null, null), ('c_bigint', null, 8.0, 0.375, null, '0', '7'), ('c_double', null, 10.0, 0.375, null, '1.2', '7.7'), ('c_timestamp', null, 10.0, 0.375, null, null, null), ('c_varchar', 40.0, 10.0, 0.375, null, null, null), ('c_varbinary', 20.0, null, 0.375, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("CALL system.drop_stats('%s', '%s')", "tpch", tableName));
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, null, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testInvalidDropStats() {
        String unpartitionedTableName = "test_invalid_drop_all_stats_unpartitioned_table";
        this.createUnpartitionedTableForAnalyzeTest(unpartitionedTableName);
        String partitionedTableName = "test_invalid_drop_all_stats_partitioned_table";
        this.createPartitionedTableForAnalyzeTest(partitionedTableName);
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['p2', '7']])", "tpch", unpartitionedTableName), "Cannot specify partition values for an unpartitioned table");
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['p2', '7'], NULL])", "tpch", partitionedTableName), "Null partition value");
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[])", "tpch", partitionedTableName), "No partitions provided");
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['p2', '7', 'dummy']])", "tpch", partitionedTableName), ".*don't match the number of partition columns.*");
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['WRONG', 'KEY']])", "tpch", partitionedTableName), "Partition '.*' not found");
        this.assertQueryFails(String.format("CALL system.drop_stats('%s', '%s', ARRAY[ARRAY['WRONG', 'KEY']])", "tpch", "non_existing_table"), String.format("Table '%s.non_existing_table' does not exist", "tpch"));
        this.assertAccessDenied(String.format("CALL system.drop_stats('%s', '%s')", "tpch", unpartitionedTableName), String.format("Cannot insert into table hive.tpch.%s", unpartitionedTableName), new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)unpartitionedTableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertUpdate("DROP TABLE " + unpartitionedTableName);
        this.assertUpdate("DROP TABLE " + partitionedTableName);
    }

    protected void createPartitionedTableForAnalyzeTest(String tableName) {
        this.createTableForAnalyzeTest(tableName, true);
    }

    protected void createUnpartitionedTableForAnalyzeTest(String tableName) {
        this.createTableForAnalyzeTest(tableName, false);
    }

    private void createTableForAnalyzeTest(String tableName, boolean partitioned) {
        Session defaultSession = this.getSession();
        Session disableColumnStatsSession = Session.builder((Session)defaultSession).setCatalogSessionProperty((String)defaultSession.getCatalog().get(), "collect_column_statistics_on_write", "false").build();
        this.assertUpdate(disableColumnStatsSession, "CREATE TABLE " + tableName + (partitioned ? " WITH (partitioned_by = ARRAY['p_varchar', 'p_bigint'])\n" : " ") + "AS SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar, p_bigint FROM (   VALUES     (null, null, null, null, null, null, 'p1', BIGINT '7'),     (null, null, null, null, null, null, 'p1', BIGINT '7'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00:00.000', 'abc1', X'bcd1', 'p1', BIGINT '7'),     (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00:00.000', 'abc2', X'bcd2', 'p1', BIGINT '7'),     (null, null, null, null, null, null, 'p2', BIGINT '7'),     (null, null, null, null, null, null, 'p2', BIGINT '7'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00:00.000', 'cba1', X'dcb1', 'p2', BIGINT '7'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00:00.000', 'cba2', X'dcb2', 'p2', BIGINT '7'),     (null, null, null, null, null, null, 'p3', BIGINT '8'),     (null, null, null, null, null, null, 'p3', BIGINT '8'),     (true, BIGINT '3', DOUBLE '4.4', TIMESTAMP '2012-10-10 01:00:00.000', 'bca1', X'cdb1', 'p3', BIGINT '8'),     (false, BIGINT '2', DOUBLE '3.4', TIMESTAMP '2012-10-10 00:00:00.000', 'bca2', X'cdb2', 'p3', BIGINT '8'),     (false, BIGINT '7', DOUBLE '7.7', TIMESTAMP '1977-07-07 07:07:00.000', 'efa1', X'efa1', NULL, NULL),     (false, BIGINT '6', DOUBLE '6.7', TIMESTAMP '1977-07-07 07:06:00.000', 'efa2', X'efa2', NULL, NULL),     (false, BIGINT '5', DOUBLE '5.7', TIMESTAMP '1977-07-07 07:05:00.000', 'efa3', X'efa3', NULL, NULL),     (false, BIGINT '4', DOUBLE '4.7', TIMESTAMP '1977-07-07 07:04:00.000', 'efa4', X'efa4', NULL, NULL) ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, p_varchar, p_bigint)", 16L);
        if (partitioned) {
            this.assertUpdate(disableColumnStatsSession, String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['p_varchar', 'p_bigint'], ARRAY['%s', '%s'])", "tpch", tableName, "e1", "9"));
            this.assertUpdate(disableColumnStatsSession, String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['p_varchar', 'p_bigint'], ARRAY['%s', '%s'])", "tpch", tableName, "e2", "9"));
        }
    }

    @Test
    public void testInsertMultipleColumnsFromSameChannel() {
        String tableName = "test_insert_multiple_columns_same_channel";
        this.assertUpdate(String.format("CREATE TABLE %s (    c_bigint_1 BIGINT,    c_bigint_2 BIGINT,    p_varchar_1 VARCHAR,    p_varchar_2 VARCHAR ) WITH (    partitioned_by = ARRAY['p_varchar_1', 'p_varchar_2'] )", tableName));
        this.assertUpdate(String.format("INSERT INTO %s SELECT 1 c_bigint_1, 1 c_bigint_2, '2' p_varchar_1, '2' p_varchar_2 ", tableName), 1L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar_1 = '2' AND p_varchar_2 = '2')", tableName), "SELECT * FROM VALUES ('c_bigint_1', null, 1.0E0, 0.0E0, null, '1', '1'), ('c_bigint_2', null, 1.0E0, 0.0E0, null, '1', '1'), ('p_varchar_1', 1.0E0, 1.0E0, 0.0E0, null, null, null), ('p_varchar_2', 1.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 1.0E0, null, null)");
        this.assertUpdate(String.format("INSERT INTO %s (c_bigint_1, c_bigint_2, p_varchar_1, p_varchar_2) SELECT orderkey, orderkey, orderstatus, orderstatus FROM orders WHERE orderstatus='O' AND orderkey = 15008", tableName), 1L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar_1 = 'O' AND p_varchar_2 = 'O')", tableName), "SELECT * FROM VALUES ('c_bigint_1', null, 1.0E0, 0.0E0, null, '15008', '15008'), ('c_bigint_2', null, 1.0E0, 0.0E0, null, '15008', '15008'), ('p_varchar_1', 1.0E0, 1.0E0, 0.0E0, null, null, null), ('p_varchar_2', 1.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 1.0E0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAvroTableWithSchemaUrl() throws Exception {
        String tableName = "test_create_avro_table_with_schema_url";
        File schemaFile = TestHiveIntegrationSmokeTest.createAvroSchemaFile();
        String createTableSql = this.getAvroCreateTableSql(tableName, schemaFile.getAbsolutePath());
        String expectedShowCreateTable = this.getAvroCreateTableSql(tableName, schemaFile.toURI().toString());
        this.assertUpdate(createTableSql);
        try {
            MaterializedResult actual = this.computeActual("SHOW CREATE TABLE " + tableName);
            io.prestosql.testing.assertions.Assert.assertEquals((Object)actual.getOnlyValue(), (Object)expectedShowCreateTable);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
        }
    }

    @Test
    public void testAlterAvroTableWithSchemaUrl() throws Exception {
        this.testAlterAvroTableWithSchemaUrl(true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAlterAvroTableWithSchemaUrl(boolean renameColumn, boolean addColumn, boolean dropColumn) throws Exception {
        String tableName = "test_alter_avro_table_with_schema_url";
        File schemaFile = TestHiveIntegrationSmokeTest.createAvroSchemaFile();
        this.assertUpdate(this.getAvroCreateTableSql(tableName, schemaFile.getAbsolutePath()));
        try {
            if (renameColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s RENAME COLUMN dummy_col TO new_dummy_col", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
            if (addColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s ADD COLUMN new_dummy_col VARCHAR", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
            if (dropColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s DROP COLUMN dummy_col", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
            Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
        }
    }

    private String getAvroCreateTableSql(String tableName, String schemaFile) {
        return String.format("CREATE TABLE %s.%s.%s (\n   dummy_col varchar,\n   another_dummy_col varchar\n)\nWITH (\n   avro_schema_url = '%s',\n   format = 'AVRO'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), tableName, schemaFile);
    }

    private static File createAvroSchemaFile() throws Exception {
        File schemaFile = File.createTempFile("avro_single_column-", ".avsc");
        String schema = "{\n  \"namespace\": \"io.prestosql.test\",\n  \"name\": \"single_column\",\n  \"type\": \"record\",\n  \"fields\": [\n    { \"name\":\"string_col\", \"type\":\"string\" }\n]}";
        Files.asCharSink((File)schemaFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)schema);
        return schemaFile;
    }

    @Test
    public void testCreateOrcTableWithSchemaUrl() {
        String createTableSql = String.format("CREATE TABLE %s.%s.test_orc (\n   dummy_col varchar\n)\nWITH (\n   avro_schema_url = 'dummy.avsc',\n   format = 'ORC'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQueryFails(createTableSql, "Cannot specify avro_schema_url table property for storage format: ORC");
    }

    @Test
    public void testCtasFailsWithAvroSchemaUrl() {
        String ctasSqlWithoutData = "CREATE TABLE create_avro\nWITH (avro_schema_url = 'dummy_schema')\nAS SELECT 'dummy_value' as dummy_col WITH NO DATA";
        this.assertQueryFails(ctasSqlWithoutData, "CREATE TABLE AS not supported when Avro schema url is set");
        String ctasSql = "CREATE TABLE create_avro\nWITH (avro_schema_url = 'dummy_schema')\nAS SELECT * FROM (VALUES('a')) t (a)";
        this.assertQueryFails(ctasSql, "CREATE TABLE AS not supported when Avro schema url is set");
    }

    @Test
    public void testBucketedTablesFailWithAvroSchemaUrl() {
        String createSql = "CREATE TABLE create_avro (dummy VARCHAR)\nWITH (avro_schema_url = 'dummy_schema',\n      bucket_count = 2, bucketed_by=ARRAY['dummy'])";
        this.assertQueryFails(createSql, "Bucketing/Partitioning columns not supported when Avro schema url is set");
    }

    @Test
    public void testPartitionedTablesFailWithAvroSchemaUrl() {
        String createSql = "CREATE TABLE create_avro (dummy VARCHAR)\nWITH (avro_schema_url = 'dummy_schema',\n      partitioned_by=ARRAY['dummy'])";
        this.assertQueryFails(createSql, "Bucketing/Partitioning columns not supported when Avro schema url is set");
    }

    @Test
    public void testPrunePartitionFailure() {
        this.assertUpdate("CREATE TABLE test_prune_failure\nWITH (partitioned_by = ARRAY['p']) AS\nSELECT 123 x, 'abc' p", 1L);
        this.assertQueryReturnsEmptyResult("SELECT * FROM test_prune_failure\nWHERE x < 0 AND cast(p AS int) > 0");
        this.assertUpdate("DROP TABLE test_prune_failure");
    }

    @Test
    public void testTemporaryStagingDirectorySessionProperties() {
        String tableName = "test_temporary_staging_directory_session_properties";
        this.assertUpdate(String.format("CREATE TABLE %s(i int)", tableName));
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "temporary_staging_directory_enabled", "false").build();
        HiveInsertTableHandle hiveInsertTableHandle = this.getHiveInsertTableHandle(session, tableName);
        io.prestosql.testing.assertions.Assert.assertEquals((Object)hiveInsertTableHandle.getLocationHandle().getWritePath(), (Object)hiveInsertTableHandle.getLocationHandle().getTargetPath());
        session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "temporary_staging_directory_enabled", "true").setCatalogSessionProperty("hive", "temporary_staging_directory_path", "/tmp/custom/temporary-${USER}").build();
        hiveInsertTableHandle = this.getHiveInsertTableHandle(session, tableName);
        Assert.assertNotEquals((Object)hiveInsertTableHandle.getLocationHandle().getWritePath(), (Object)hiveInsertTableHandle.getLocationHandle().getTargetPath());
        Assert.assertTrue((boolean)hiveInsertTableHandle.getLocationHandle().getWritePath().toString().startsWith("file:/tmp/custom/temporary-"));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private HiveInsertTableHandle getHiveInsertTableHandle(Session session, String tableName) {
        Metadata metadata = this.getDistributedQueryRunner().getCoordinator().getMetadata();
        return (HiveInsertTableHandle)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            QualifiedObjectName objectName = new QualifiedObjectName(this.catalog, "tpch", tableName);
            Optional handle = metadata.getTableHandle(transactionSession, objectName);
            ImmutableList columns = ImmutableList.copyOf(metadata.getColumnHandles(transactionSession, (TableHandle)handle.get()).values());
            InsertTableHandle insertTableHandle = metadata.beginInsert(transactionSession, (TableHandle)handle.get(), (List)columns);
            HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)insertTableHandle.getConnectorHandle();
            metadata.finishInsert(transactionSession, insertTableHandle, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
            return hiveInsertTableHandle;
        });
    }

    @Test
    public void testSortedWritingTempStaging() {
        String tableName = "test_sorted_writing";
        String createTableSql = String.format("CREATE TABLE %s WITH (   bucket_count = 7,   bucketed_by = ARRAY['shipmode'],   sorted_by = ARRAY['shipmode']) AS SELECT * FROM tpch.tiny.lineitem", tableName);
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "sorted_writing_enabled", "true").setCatalogSessionProperty("hive", "temporary_staging_directory_enabled", "true").setCatalogSessionProperty("hive", "temporary_staging_directory_path", "/tmp/custom/temporary-${USER}").build();
        this.assertUpdate(session, createTableSql, 60175L);
        MaterializedResult expected = this.computeActual("SELECT * FROM tpch.tiny.lineitem");
        MaterializedResult actual = this.computeActual("SELECT * FROM " + tableName);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSelectWithNoColumns() {
        this.testWithAllStorageFormats(this::testSelectWithNoColumns);
    }

    private void testSelectWithNoColumns(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_select_with_no_columns";
        String createTable = String.format("CREATE TABLE %s (col0) WITH (format = '%s') AS VALUES 5, 6, 7", tableName, storageFormat);
        this.assertUpdate(session, createTable, 3L);
        Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
        this.assertQuery("SELECT 1 FROM " + tableName, "VALUES 1, 1, 1");
        this.assertQuery("SELECT count(*) FROM " + tableName, "SELECT 3");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testColumnPruning() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "orc_use_column_names", "true").setCatalogSessionProperty(this.catalog, "parquet_use_column_names", "true").build();
        TestHiveIntegrationSmokeTest.testWithStorageFormat(new TestingHiveStorageFormat(session, HiveStorageFormat.ORC), this::testColumnPruning);
        TestHiveIntegrationSmokeTest.testWithStorageFormat(new TestingHiveStorageFormat(session, HiveStorageFormat.PARQUET), this::testColumnPruning);
    }

    private void testColumnPruning(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_schema_evolution_column_pruning_" + storageFormat.name().toLowerCase(Locale.ENGLISH);
        String evolvedTableName = tableName + "_evolved";
        this.assertUpdate(session, "DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate(session, "DROP TABLE IF EXISTS " + evolvedTableName);
        this.assertUpdate(session, String.format("CREATE TABLE %s(  a bigint,   b varchar,   c row(    f1 row(      g1 bigint,      g2 bigint),     f2 varchar,     f3 varbinary),   d integer) WITH (format='%s')", tableName, storageFormat));
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES (42, 'ala', ROW(ROW(177, 873321), 'ma kota', X'abcdef'), 12345678)", 1L);
        this.assertQuery(session, "SELECT a, b, c.f1.g1, c.f1.g2, c.f2, c.f3, d FROM " + tableName, "VALUES (42, 'ala', 177, 873321, 'ma kota', X'abcdef', 12345678)");
        this.assertQuery(session, "SELECT b, c.f1.g2, c.f3, d FROM " + tableName, "VALUES ('ala', 873321, X'abcdef', 12345678)");
        String tableLocation = (String)this.computeActual("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + tableName).getOnlyValue();
        this.assertUpdate(session, String.format("CREATE TABLE %s(  e tinyint,   a bigint,   bxx varchar,   c row(    f1 row(      g1xx bigint,      g2 bigint),     f2xx varchar,     f3 varbinary),   d integer,   f smallint) WITH (format='%s', external_location='%s')", evolvedTableName, storageFormat, tableLocation));
        this.assertQuery(session, "SELECT a, bxx, c.f1.g1xx, c.f1.g2, c.f2xx, c.f3,  d, e, f FROM " + evolvedTableName + " t", "VALUES (42, NULL, NULL, 873321, NULL, X'abcdef', 12345678, NULL, NULL)");
        this.assertUpdate(session, "DROP TABLE " + evolvedTableName);
        this.assertUpdate(session, "DROP TABLE " + tableName);
    }

    @Test
    public void testUnsupportedCsvTable() {
        this.assertQueryFails("CREATE TABLE create_unsupported_csv(i INT, bound VARCHAR(10), unbound VARCHAR, dummy VARCHAR) WITH (format = 'CSV')", "\\QHive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: i integer, bound varchar(10)\\E");
    }

    @Test
    public void testWriteInvalidPrecisionTimestamp() {
        Session session = this.withTimestampPrecision(this.getSession(), HiveTimestampPrecision.MICROSECONDS);
        this.assertQueryFails(session, "CREATE TABLE test_invalid_precision_timestamp(ts) AS SELECT TIMESTAMP '2001-02-03 11:22:33.123456789'", "\\QIncorrect timestamp precision for timestamp(9); the configured precision is " + HiveTimestampPrecision.MICROSECONDS);
        this.assertQueryFails(session, "CREATE TABLE test_invalid_precision_timestamp (ts TIMESTAMP(9))", "\\QIncorrect timestamp precision for timestamp(9); the configured precision is " + HiveTimestampPrecision.MICROSECONDS);
        this.assertQueryFails(session, "CREATE TABLE test_invalid_precision_timestamp(ts) AS SELECT TIMESTAMP '2001-02-03 11:22:33.123'", "\\QIncorrect timestamp precision for timestamp(3); the configured precision is " + HiveTimestampPrecision.MICROSECONDS);
        this.assertQueryFails(session, "CREATE TABLE test_invalid_precision_timestamp (ts TIMESTAMP(3))", "\\QIncorrect timestamp precision for timestamp(3); the configured precision is " + HiveTimestampPrecision.MICROSECONDS);
    }

    @Test
    public void testTimestampPrecisionInsert() {
        this.testWithAllStorageFormats(this::testTimestampPrecisionInsert);
    }

    private void testTimestampPrecisionInsert(Session session, HiveStorageFormat storageFormat) {
        if (storageFormat == HiveStorageFormat.AVRO) {
            return;
        }
        String tableName = "test_timestamp_precision_" + TestTable.randomTableSuffix();
        String createTable = "CREATE TABLE " + tableName + " (ts TIMESTAMP) WITH (format = '%s')";
        String insert = "INSERT INTO " + tableName + " VALUES (TIMESTAMP '%s')";
        this.testTimestampPrecisionWrites(session, tableName, (ts, precision) -> {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
            this.assertUpdate(String.format(createTable, storageFormat));
            this.assertUpdate(this.withTimestampPrecision(session, (HiveTimestampPrecision)precision), String.format(insert, ts), 1L);
        });
    }

    @Test
    public void testTimestampPrecisionCtas() {
        this.testWithAllStorageFormats(this::testTimestampPrecisionCtas);
    }

    private void testTimestampPrecisionCtas(Session session, HiveStorageFormat storageFormat) {
        if (storageFormat == HiveStorageFormat.AVRO) {
            return;
        }
        String tableName = "test_timestamp_precision_" + TestTable.randomTableSuffix();
        String createTableAs = "CREATE TABLE " + tableName + " WITH (format = '%s') AS SELECT TIMESTAMP '%s' ts";
        this.testTimestampPrecisionWrites(session, tableName, (ts, precision) -> {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
            this.assertUpdate(this.withTimestampPrecision(session, (HiveTimestampPrecision)precision), String.format(createTableAs, storageFormat, ts), 1L);
        });
    }

    private void testTimestampPrecisionWrites(Session session, String tableName, BiConsumer<String, HiveTimestampPrecision> populateData) {
        populateData.accept("2019-02-03 18:30:00.123", HiveTimestampPrecision.MILLISECONDS);
        String sql = "SELECT ts FROM " + tableName;
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MILLISECONDS), sql, "VALUES ('2019-02-03 18:30:00.123')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MICROSECONDS), sql, "VALUES ('2019-02-03 18:30:00.123')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.NANOSECONDS), sql, "VALUES ('2019-02-03 18:30:00.123')");
        populateData.accept("2019-02-03 18:30:00.456789", HiveTimestampPrecision.MICROSECONDS);
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MILLISECONDS), sql, "VALUES ('2019-02-03 18:30:00.457')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MICROSECONDS), sql, "VALUES ('2019-02-03 18:30:00.456789')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.NANOSECONDS), sql, "VALUES ('2019-02-03 18:30:00.456789000')");
        populateData.accept("2019-02-03 18:30:00.456789876", HiveTimestampPrecision.NANOSECONDS);
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MILLISECONDS), sql, "VALUES ('2019-02-03 18:30:00.457')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MICROSECONDS), sql, "VALUES ('2019-02-03 18:30:00.456790')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.NANOSECONDS), sql, "VALUES ('2019-02-03 18:30:00.456789876')");
        populateData.accept("2019-02-03 18:30:00.999999", HiveTimestampPrecision.MICROSECONDS);
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MILLISECONDS), sql, "VALUES ('2019-02-03 18:30:01.000')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MICROSECONDS), sql, "VALUES ('2019-02-03 18:30:00.999999')");
        populateData.accept("2019-02-03 18:30:00.999999999", HiveTimestampPrecision.NANOSECONDS);
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MILLISECONDS), sql, "VALUES ('2019-02-03 18:30:01.000')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.MICROSECONDS), sql, "VALUES ('2019-02-03 18:30:01.000000')");
        this.assertQuery(this.withTimestampPrecision(session, HiveTimestampPrecision.NANOSECONDS), sql, "VALUES ('2019-02-03 18:30:00.999999999')");
    }

    @Test
    public void testSelectFromViewWithoutDefaultCatalogAndSchema() {
        String viewName = "select_from_view_without_catalog_and_schema_" + TestTable.randomTableSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM nation WHERE nationkey=1");
        this.assertQuery("SELECT count(*) FROM " + viewName, "VALUES 1");
        this.assertQuery("SELECT count(*) FROM hive.tpch." + viewName, "VALUES 1");
        Session sessionNoCatalog = Session.builder((Session)this.getSession()).setCatalog(null).setSchema(null).build();
        this.assertQueryFails(sessionNoCatalog, "SELECT count(*) FROM " + viewName, ".*Schema must be specified when session schema is not set.*");
        this.assertQuery(sessionNoCatalog, "SELECT count(*) FROM hive.tpch." + viewName, "VALUES 1");
    }

    private Session getParallelWriteSession() {
        return Session.builder((Session)this.getSession()).setSystemProperty("task_writer_count", "4").build();
    }

    private void assertOneNotNullResult(@Language(value="SQL") String query) {
        this.assertOneNotNullResult(this.getSession(), query);
    }

    private void assertOneNotNullResult(Session session, @Language(value="SQL") String query) {
        MaterializedResult results = this.getQueryRunner().execute(session, query).toTestTypes();
        io.prestosql.testing.assertions.Assert.assertEquals((int)results.getRowCount(), (int)1);
        io.prestosql.testing.assertions.Assert.assertEquals((int)((MaterializedRow)results.getMaterializedRows().get(0)).getFieldCount(), (int)1);
        Assert.assertNotNull((Object)((MaterializedRow)results.getMaterializedRows().get(0)).getField(0));
    }

    private Type canonicalizeType(Type type) {
        return HiveTestUtils.TYPE_MANAGER.getType(HiveType.toHiveType((Type)type).getTypeSignature());
    }

    private void assertColumnType(TableMetadata tableMetadata, String columnName, Type expectedType) {
        io.prestosql.testing.assertions.Assert.assertEquals((Object)tableMetadata.getColumn(columnName).getType(), (Object)this.canonicalizeType(expectedType));
    }

    private void assertConstraints(@Language(value="SQL") String query, Set<IoPlanPrinter.ColumnConstraint> expected) {
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) " + query);
        Set constraints = ((IoPlanPrinter.IoPlan.TableColumnInfo)((IoPlanPrinter.IoPlan)this.getIoPlanCodec().fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()))).getInputTableColumnInfos().stream().findFirst().get()).getColumnConstraints();
        Assert.assertTrue((boolean)constraints.containsAll(expected));
    }

    private void verifyPartition(boolean hasPartition, TableMetadata tableMetadata, List<String> partitionKeys) {
        Object partitionByProperty = tableMetadata.getMetadata().getProperties().get("partitioned_by");
        if (hasPartition) {
            io.prestosql.testing.assertions.Assert.assertEquals(partitionByProperty, partitionKeys);
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                boolean partitionKey = partitionKeys.contains(columnMetadata.getName());
                io.prestosql.testing.assertions.Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
            }
        } else {
            Assert.assertNull(partitionByProperty);
        }
    }

    private void rollback() {
        throw new RollbackException();
    }

    private void testWithAllStorageFormats(BiConsumer<Session, HiveStorageFormat> test) {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            TestHiveIntegrationSmokeTest.testWithStorageFormat(storageFormat, test);
        }
    }

    private static void testWithStorageFormat(TestingHiveStorageFormat storageFormat, BiConsumer<Session, HiveStorageFormat> test) {
        Objects.requireNonNull(storageFormat, "storageFormat is null");
        Objects.requireNonNull(test, "test is null");
        Session session = storageFormat.getSession();
        try {
            test.accept(session, storageFormat.getFormat());
        }
        catch (AssertionError | Exception e) {
            Assert.fail((String)String.format("Failure for format %s with properties %s", storageFormat.getFormat(), session.getConnectorProperties()), (Throwable)e);
        }
    }

    private List<TestingHiveStorageFormat> getAllTestingHiveStorageFormat() {
        Session session = this.getSession();
        ImmutableList.Builder formats = ImmutableList.builder();
        for (HiveStorageFormat hiveStorageFormat : HiveStorageFormat.values()) {
            if (hiveStorageFormat == HiveStorageFormat.CSV) continue;
            formats.add((Object)new TestingHiveStorageFormat(session, hiveStorageFormat));
        }
        return formats.build();
    }

    private JsonCodec<IoPlanPrinter.IoPlan> getIoPlanCodec() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(this.getQueryRunner().getMetadata())));
        return new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(IoPlanPrinter.IoPlan.class);
    }

    @DataProvider
    public Object[][] timestampPrecision() {
        return new Object[][]{{HiveTimestampPrecision.MILLISECONDS}, {HiveTimestampPrecision.MICROSECONDS}, {HiveTimestampPrecision.NANOSECONDS}};
    }

    private Session withTimestampPrecision(Session session, HiveTimestampPrecision precision) {
        return Session.builder((Session)session).setCatalogSessionProperty(this.catalog, "timestamp_precision", precision.name()).build();
    }

    private static class ExponentialSleeper {
        private Duration nextSleepTime;
        private final Duration maxSleepTime;
        private final Duration minSleepIncrement;
        private final double sleepIncrementFactor;

        ExponentialSleeper(Duration minSleepTime, Duration maxSleepTime, Duration minSleepIncrement, double sleepIncrementFactor) {
            this.nextSleepTime = minSleepTime;
            this.maxSleepTime = maxSleepTime;
            this.minSleepIncrement = minSleepIncrement;
            this.sleepIncrementFactor = sleepIncrementFactor;
        }

        ExponentialSleeper() {
            this(new Duration(0.0, TimeUnit.SECONDS), new Duration(5.0, TimeUnit.SECONDS), new Duration(100.0, TimeUnit.MILLISECONDS), 2.0);
        }

        public void sleep() {
            try {
                Thread.sleep(this.nextSleepTime.toMillis());
                long incrementMillis = (long)((double)this.nextSleepTime.toMillis() * this.sleepIncrementFactor - (double)this.nextSleepTime.toMillis());
                if (incrementMillis < this.minSleepIncrement.toMillis()) {
                    incrementMillis = this.minSleepIncrement.toMillis();
                }
                this.nextSleepTime = new Duration((double)(this.nextSleepTime.toMillis() + incrementMillis), TimeUnit.MILLISECONDS);
                if (this.nextSleepTime.compareTo(this.maxSleepTime) > 0) {
                    this.nextSleepTime = this.maxSleepTime;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static class TypeAndEstimate {
        public final Type type;
        public final IoPlanPrinter.EstimatedStatsAndCost estimate;

        public TypeAndEstimate(Type type, IoPlanPrinter.EstimatedStatsAndCost estimate) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.estimate = Objects.requireNonNull(estimate, "estimate is null");
        }
    }

    private static class TestingHiveStorageFormat {
        private final Session session;
        private final HiveStorageFormat format;

        TestingHiveStorageFormat(Session session, HiveStorageFormat format) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.format = Objects.requireNonNull(format, "format is null");
        }

        public Session getSession() {
            return this.session;
        }

        public HiveStorageFormat getFormat() {
            return this.format;
        }
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

