/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveLocationService;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.TestBackgroundHiveSplitLoader;
import io.prestosql.spi.PrestoException;
import java.util.List;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveLocationService {
    @Test
    public void testGetTableWriteInfoAppend() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), false).producesWriteInfo(new LocationService.WriteInfo(new Path("/target"), new Path("/write"), LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), false).producesWriteInfo(new LocationService.WriteInfo(new Path("/target"), new Path("/target"), LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY));
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), false).producesWriteInfo(new LocationService.WriteInfo(new Path("/target"), new Path("/target"), LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY));
    }

    @Test
    public void testGetTableWriteInfoOverwriteSuccess() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY), true).producesWriteInfo(new LocationService.WriteInfo(new Path("/target"), new Path("/write"), LocationHandle.WriteMode.STAGE_AND_MOVE_TO_TARGET_DIRECTORY));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Overwriting unpartitioned table not supported when writing directly to target directory")
    public void testGetTableWriteInfoOverwriteFailDirectNew() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY, "/target", "/target"), true);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Overwriting unpartitioned table not supported when writing directly to target directory")
    public void testGetTableWriteInfoOverwriteFailDirectExisting() {
        TestHiveLocationService.assertThat(TestHiveLocationService.locationHandle(LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY, "/target", "/target"), true);
    }

    private static Assertion assertThat(LocationHandle locationHandle, boolean overwrite) {
        return new Assertion(locationHandle, overwrite);
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode) {
        return TestHiveLocationService.locationHandle(writeMode, "/target", "/write");
    }

    private static LocationHandle locationHandle(LocationHandle.WriteMode writeMode, String targetPath, String writePath) {
        return new LocationHandle(new Path(targetPath), new Path(writePath), true, writeMode);
    }

    public static class Assertion {
        private final LocationService.WriteInfo actual;

        public Assertion(LocationHandle locationHandle, boolean overwrite) {
            TestBackgroundHiveSplitLoader.TestingHdfsEnvironment hdfsEnvironment = new TestBackgroundHiveSplitLoader.TestingHdfsEnvironment((List<LocatedFileStatus>)ImmutableList.of());
            HiveLocationService service = new HiveLocationService((HdfsEnvironment)hdfsEnvironment);
            this.actual = service.getTableWriteInfo(locationHandle, overwrite);
        }

        public void producesWriteInfo(LocationService.WriteInfo expected) {
            Assert.assertEquals((Object)this.actual.getWritePath(), (Object)expected.getWritePath());
            Assert.assertEquals((Object)this.actual.getTargetPath(), (Object)expected.getTargetPath());
            Assert.assertEquals((Object)this.actual.getWriteMode(), (Object)expected.getWriteMode());
        }
    }
}

