/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.concurrent.MoreFutures;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.prestosql.GroupByHashPageIndexerFactory;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveEventClient;
import io.prestosql.plugin.hive.HiveLocationService;
import io.prestosql.plugin.hive.HiveOutputTableHandle;
import io.prestosql.plugin.hive.HivePageSinkProvider;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastore;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingNodeManager;
import io.prestosql.tpch.LineItem;
import io.prestosql.tpch.LineItemColumn;
import io.prestosql.tpch.LineItemGenerator;
import io.prestosql.tpch.TpchColumnType;
import io.prestosql.tpch.TpchColumnTypes;
import io.prestosql.type.BlockTypeOperators;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHivePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllFormats() throws Exception {
        HiveConfig config = new HiveConfig();
        File tempDir = Files.createTempDir();
        try {
            FileHiveMetastore metastore = FileHiveMetastore.createTestingFileHiveMetastore((File)new File(tempDir, "metastore"));
            for (HiveStorageFormat format : HiveStorageFormat.values()) {
                if (format == HiveStorageFormat.CSV) continue;
                config.setHiveStorageFormat(format);
                config.setHiveCompressionCodec(HiveCompressionCodec.NONE);
                long uncompressedLength = TestHivePageSink.writeTestFile(config, (HiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(uncompressedLength), (Comparable)Long.valueOf(0L));
                for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
                    if (codec == HiveCompressionCodec.NONE) continue;
                    config.setHiveCompressionCodec(codec);
                    long length = TestHivePageSink.writeTestFile(config, (HiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                    Assert.assertTrue((uncompressedLength > length ? 1 : 0) != 0, (String)String.format("%s with %s compressed to %s which is not less than %s", format, codec, length, uncompressedLength));
                }
            }
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static String makeFileName(File tempDir, HiveConfig config) {
        return tempDir.getAbsolutePath() + "/" + config.getHiveStorageFormat().name() + "." + config.getHiveCompressionCodec().name();
    }

    private static long writeTestFile(HiveConfig config, HiveMetastore metastore, String outputPath) {
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        HiveWriterStats stats = new HiveWriterStats();
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink(transaction, config, metastore, new org.apache.hadoop.fs.Path("file:///" + outputPath), stats);
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List<Type> columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getHiveType).map(hiveType -> hiveType.getType(HiveTestUtils.TYPE_MANAGER)).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        int rows = 0;
        for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
            if (++rows >= 1000) break;
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                LineItemColumn column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                        continue block8;
                    }
                    case DATE: {
                        DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + column.getType());
                    }
                }
            }
        }
        Page page = pageBuilder.build();
        pageSink.appendPage(page);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        File outputDir = new File(outputPath);
        ImmutableList files = ImmutableList.copyOf((Object[])outputDir.listFiles((dir, name) -> !name.endsWith(".crc")));
        File outputFile = (File)Iterables.getOnlyElement((Iterable)files);
        long length = outputFile.length();
        ConnectorPageSource pageSource = TestHivePageSink.createPageSource(transaction, config, outputFile);
        ArrayList<Page> pages = new ArrayList<Page>();
        while (!pageSource.isFinished()) {
            Page nextPage = pageSource.getNextPage();
            if (nextPage == null) continue;
            pages.add(nextPage.getLoadedPage());
        }
        MaterializedResult expectedResults = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, (List<Page>)ImmutableList.of((Object)page));
        MaterializedResult results = TestHivePageSink.toMaterializedResult(HiveTestUtils.getHiveSession(config), columnTypes, pages);
        io.prestosql.testing.assertions.Assert.assertEquals((Iterable)results, (Iterable)expectedResults);
        io.prestosql.testing.assertions.Assert.assertEquals((long)Math.round(stats.getInputPageSizeInBytes().getAllTime().getMax()), (long)page.getRetainedSizeInBytes());
        return length;
    }

    public static MaterializedResult toMaterializedResult(ConnectorSession session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    private static ConnectorPageSource createPageSource(HiveTransactionHandle transaction, HiveConfig config, File outputFile) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", config.getHiveStorageFormat().getInputFormat());
        splitProperties.setProperty("serialization.lib", config.getHiveStorageFormat().getSerDe());
        splitProperties.setProperty("columns", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList())));
        splitProperties.setProperty("columns.types", Joiner.on((char)',').join((Iterable)TestHivePageSink.getColumnHandles().stream().map(HiveColumnHandle::getHiveType).map(hiveType -> hiveType.getHiveTypeName().toString()).collect(ImmutableList.toImmutableList())));
        HiveSplit split = new HiveSplit("test", "test", "", "file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), outputFile.lastModified(), splitProperties, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), 0, false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), false, Optional.empty());
        HiveTableHandle table = new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        HivePageSourceProvider provider = new HivePageSourceProvider(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, config, HiveTestUtils.getDefaultHivePageSourceFactories(HiveTestUtils.HDFS_ENVIRONMENT, config), HiveTestUtils.getDefaultHiveRecordCursorProviders(config, HiveTestUtils.HDFS_ENVIRONMENT), new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT, config), Optional.empty());
        return provider.createPageSource((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorSplit)split, (ConnectorTableHandle)table, (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()), DynamicFilter.EMPTY);
    }

    private static ConnectorPageSink createPageSink(HiveTransactionHandle transaction, HiveConfig config, HiveMetastore metastore, org.apache.hadoop.fs.Path outputPath, HiveWriterStats stats) {
        ConnectorSession session = HiveTestUtils.getHiveSession(config);
        HiveIdentity identity = new HiveIdentity(session);
        LocationHandle locationHandle = new LocationHandle(outputPath, outputPath, false, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
        HiveOutputTableHandle handle = new HiveOutputTableHandle("test", "test", TestHivePageSink.getColumnHandles(), new HivePageSinkMetadata(new SchemaTableName("test", "test"), metastore.getTable(identity, "test", "test"), (Map)ImmutableMap.of()), locationHandle, config.getHiveStorageFormat(), config.getHiveStorageFormat(), (List)ImmutableList.of(), Optional.empty(), "test", (Map)ImmutableMap.of(), AcidTransaction.NO_ACID_TRANSACTION, false);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        HivePageSinkProvider provider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config, HiveTestUtils.HDFS_ENVIRONMENT), HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.PAGE_SORTER, metastore, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler(typeOperators), blockTypeOperators), HiveTestUtils.TYPE_MANAGER, config, (LocationService)new HiveLocationService(HiveTestUtils.HDFS_ENVIRONMENT), partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), HiveTestUtils.getHiveSessionProperties(config), stats);
        return provider.createPageSink((ConnectorTransactionHandle)transaction, HiveTestUtils.getHiveSession(config), (ConnectorOutputTableHandle)handle);
    }

    private static List<HiveColumnHandle> getColumnHandles() {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            HiveType hiveType = TestHivePageSink.getHiveType(column.getType());
            handles.add((Object)HiveColumnHandle.createBaseColumn((String)column.getColumnName(), (int)i, (HiveType)hiveType, (Type)hiveType.getType(HiveTestUtils.TYPE_MANAGER), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static List<LineItemColumn> getTestColumns() {
        return Stream.of(LineItemColumn.values()).filter(column -> !column.getType().equals((Object)TpchColumnTypes.DATE)).collect(Collectors.toList());
    }

    private static HiveType getHiveType(TpchColumnType type) {
        switch (type.getBase()) {
            case IDENTIFIER: {
                return HiveType.HIVE_LONG;
            }
            case INTEGER: {
                return HiveType.HIVE_INT;
            }
            case DATE: {
                return HiveType.HIVE_DATE;
            }
            case DOUBLE: {
                return HiveType.HIVE_DOUBLE;
            }
            case VARCHAR: {
                return HiveType.HIVE_STRING;
            }
        }
        throw new UnsupportedOperationException();
    }
}

