/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.type.InternalTypeManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestHiveReaderProjectionsUtil {
    public static final RowType ROWTYPE_OF_PRIMITIVES = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_0")), BigintType.BIGINT.getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_1")), BigintType.BIGINT.getTypeSignature())));
    public static final RowType ROWTYPE_OF_ROW_AND_PRIMITIVES = HiveTestUtils.rowType((List<NamedTypeSignature>)ImmutableList.of((Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_row_0")), ROWTYPE_OF_PRIMITIVES.getTypeSignature()), (Object)new NamedTypeSignature(Optional.of(new RowFieldName("f_bigint_0")), BigintType.BIGINT.getTypeSignature())));
    public static final TypeManager TYPE_MANAGER = new InternalTypeManager((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators());

    private TestHiveReaderProjectionsUtil() {
    }

    public static Map<String, HiveColumnHandle> createTestFullColumns(List<String> names, Map<String, Type> types) {
        Preconditions.checkArgument((names.size() == types.size() ? 1 : 0) != 0);
        ImmutableMap.Builder hiveColumns = ImmutableMap.builder();
        int regularColumnHiveIndex = 0;
        for (String name : names) {
            HiveType hiveType = HiveType.toHiveType((Type)types.get(name));
            hiveColumns.put((Object)name, (Object)HiveColumnHandle.createBaseColumn((String)name, (int)regularColumnHiveIndex, (HiveType)hiveType, (Type)types.get(name), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
            ++regularColumnHiveIndex;
        }
        return hiveColumns.build();
    }

    public static HiveColumnHandle createProjectedColumnHandle(HiveColumnHandle column, List<Integer> indices) {
        Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)"base column is expected here");
        if (indices.size() == 0) {
            return column;
        }
        HiveType baseHiveType = column.getHiveType();
        List names = baseHiveType.getHiveDereferenceNames(indices);
        HiveType hiveType = (HiveType)baseHiveType.getHiveTypeForDereferences(indices).get();
        HiveColumnProjectionInfo columnProjection = new HiveColumnProjectionInfo(indices, names, hiveType, hiveType.getType(TYPE_MANAGER));
        return new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(columnProjection), column.getColumnType(), column.getComment());
    }
}

