/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.plugin.hive.HiveQueryRunner;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.AbstractTestQueryFramework;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveRoles
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.create();
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        for (String role : this.listRoles()) {
            this.executeFromAdmin("DROP ROLE " + role);
        }
    }

    @Test
    public void testCreateRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
    }

    @Test
    public void testCreateDuplicateRole() {
        this.executeFromAdmin("CREATE ROLE duplicate_role");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE duplicate_role", ".*?Role 'duplicate_role' already exists");
    }

    @Test
    public void testCreateRoleWithAdminOption() {
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE role1 WITH ADMIN admin", ".*?Hive Connector does not support WITH ADMIN statement");
    }

    @Test
    public void testCreateReservedRole() {
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE all", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE default", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE none", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
        this.assertQueryFails(this.createAdminSession(), "CREATE ROLE None", "Role name cannot be one of the reserved roles: \\[all, default, none\\]");
    }

    @Test
    public void testCreateRoleByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "CREATE ROLE role1", "Access Denied: Cannot create role role1");
    }

    @Test
    public void testDropRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of((Object)"role1"));
        this.executeFromAdmin("DROP ROLE role1");
        Assert.assertEquals(this.listRoles(), (Set)ImmutableSet.of());
    }

    @Test
    public void testDropNonExistentRole() {
        this.assertQueryFails(this.createAdminSession(), "DROP ROLE non_existent_role", ".*?Role 'non_existent_role' does not exist");
    }

    @Test
    public void testDropRoleByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "DROP ROLE role1", "Access Denied: Cannot drop role role1");
    }

    @Test
    public void testListRolesByNonAdminUser() {
        this.assertQueryFails(this.createUserSession("non_admin_user"), "SELECT * FROM hive.information_schema.roles", "Access Denied: Cannot select from table information_schema.roles");
    }

    @Test
    public void testPublicRoleIsGrantedToAnyone() {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("some_user"), (MaterializedResult)this.applicableRoles("some_user", "USER", "public", "NO"));
    }

    @Test
    public void testAdminRoleIsGrantedToAdmin() {
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("admin"), (MaterializedResult)this.applicableRoles("admin", "USER", "admin", "YES"));
    }

    @Test
    public void testGrantRoleToUser() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
    }

    @Test
    public void testGrantRoleToRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testGrantRoleWithAdminOption() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantRoleMultipleTimes() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
    }

    @Test
    public void testGrantNonExistingRole() {
        this.assertQueryFails("GRANT grant_revoke_role_existing_1 TO USER grant_revoke_existing_user_1", ".*?Role 'grant_revoke_role_existing_1' does not exist");
        this.executeFromAdmin("CREATE ROLE grant_revoke_role_existing_1");
        this.assertQueryFails("GRANT grant_revoke_role_existing_1 TO ROLE grant_revoke_role_existing_2", ".*?Role 'grant_revoke_role_existing_2' does not exist");
    }

    @Test
    public void testRevokeRoleFromUser() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeRoleFromRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropGrantedRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("GRANT role1 TO USER user");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO"));
        this.executeFromAdmin("DROP ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromUser() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeTransitiveRoleFromRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testDropTransitiveRole() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("CREATE ROLE role3");
        this.executeFromAdmin("GRANT role1 TO USER user");
        this.executeFromAdmin("GRANT role2 TO ROLE role1");
        this.executeFromAdmin("GRANT role3 TO ROLE role2");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO", "role2", "ROLE", "role3", "NO"));
        this.executeFromAdmin("DROP ROLE role2");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO", "user", "USER", "role1", "NO"));
    }

    @Test
    public void testRevokeAdminOption() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
    }

    @Test
    public void testRevokeRoleMultipleTimes() {
        this.executeFromAdmin("CREATE ROLE role1");
        this.executeFromAdmin("CREATE ROLE role2");
        this.executeFromAdmin("GRANT role1 TO USER user WITH ADMIN OPTION");
        this.executeFromAdmin("GRANT role2 TO ROLE role1 WITH ADMIN OPTION");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "YES", "role1", "ROLE", "role2", "YES"));
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role1 FROM USER user");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        this.executeFromAdmin("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1");
        QueryAssertions.assertContains((MaterializedResult)this.listApplicableRoles("user"), (MaterializedResult)this.applicableRoles("user", "USER", "role1", "NO", "role1", "ROLE", "role2", "NO"));
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        this.executeFromAdmin("REVOKE role1 FROM USER user");
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        this.executeFromAdmin("REVOKE role2 FROM ROLE role1");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.listApplicableRoles("user"), (Iterable)this.applicableRoles("user", "USER", "public", "NO"));
    }

    @Test
    public void testRevokeNonExistingRole() {
        this.assertQueryFails(this.createAdminSession(), "REVOKE grant_revoke_role_existing_1 FROM USER grant_revoke_existing_user_1", ".*?Role 'grant_revoke_role_existing_1' does not exist");
        this.executeFromAdmin("CREATE ROLE grant_revoke_role_existing_1");
        this.assertQueryFails(this.createAdminSession(), "REVOKE grant_revoke_role_existing_1 FROM ROLE grant_revoke_role_existing_2", ".*?Role 'grant_revoke_role_existing_2' does not exist");
    }

    @Test
    public void testSetRole() {
        this.executeFromAdmin("CREATE ROLE set_role_1");
        this.executeFromAdmin("CREATE ROLE set_role_2");
        this.executeFromAdmin("CREATE ROLE set_role_3");
        this.executeFromAdmin("CREATE ROLE set_role_4");
        this.executeFromAdmin("GRANT set_role_1 TO USER set_user_1");
        this.executeFromAdmin("GRANT set_role_2 TO ROLE set_role_1");
        this.executeFromAdmin("GRANT set_role_3 TO ROLE set_role_2");
        Session unsetRole = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.ofUser((String)"set_user_1")).build();
        Session setRoleAll = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.ALL, Optional.empty())).build()).build();
        Session setRoleNone = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.NONE, Optional.empty())).build()).build();
        Session setRole1 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_1"))).build()).build();
        Session setRole2 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_2"))).build()).build();
        Session setRole3 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_3"))).build()).build();
        Session setRole4 = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"set_user_1").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("set_role_4"))).build()).build();
        MaterializedResult actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.applicable_roles");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType(), VarcharType.createUnboundedVarcharType()}).row(new Object[]{"set_user_1", "USER", "public", "NO"}).row(new Object[]{"set_user_1", "USER", "set_role_1", "NO"}).row(new Object[]{"set_role_1", "ROLE", "set_role_2", "NO"}).row(new Object[]{"set_role_2", "ROLE", "set_role_3", "NO"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(unsetRole, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)unsetRole, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleAll, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleAll, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRoleNone, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRoleNone, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole1, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole1, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_1"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole2, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole2, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_2"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        actual = this.getQueryRunner().execute(setRole3, "SELECT * FROM hive.information_schema.enabled_roles");
        expected = MaterializedResult.resultBuilder((Session)setRole3, (Type[])new Type[]{VarcharType.createUnboundedVarcharType()}).row(new Object[]{"public"}).row(new Object[]{"set_role_3"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected);
        this.assertQueryFails(setRole4, "SELECT * FROM hive.information_schema.enabled_roles", ".*?Cannot set role set_role_4");
        this.executeFromAdmin("DROP ROLE set_role_1");
        this.executeFromAdmin("DROP ROLE set_role_2");
        this.executeFromAdmin("DROP ROLE set_role_3");
        this.executeFromAdmin("DROP ROLE set_role_4");
    }

    private Set<String> listRoles() {
        return this.executeFromAdmin("SELECT * FROM hive.information_schema.roles").getMaterializedRows().stream().map(row -> row.getField(0).toString()).collect(Collectors.toSet());
    }

    private MaterializedResult listApplicableRoles(String user) {
        return this.executeFromUser(user, "SELECT * FROM hive.information_schema.applicable_roles");
    }

    private MaterializedResult applicableRoles(String ... values) {
        ImmutableList types = ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType());
        int rowLength = types.size();
        Preconditions.checkArgument((values.length % rowLength == 0 ? 1 : 0) != 0);
        MaterializedResult.Builder result = MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Iterable)types);
        Object[] row = null;
        for (int i = 0; i < values.length; ++i) {
            if (i % rowLength == 0) {
                if (row != null) {
                    result.row(row);
                }
                row = new Object[rowLength];
            }
            Preconditions.checkState((row != null ? 1 : 0) != 0);
            row[i % rowLength] = values[i];
        }
        if (row != null) {
            result.row(row);
        }
        return result.build();
    }

    private MaterializedResult executeFromAdmin(String sql) {
        return this.getQueryRunner().execute(this.createAdminSession(), sql);
    }

    private MaterializedResult executeFromUser(String user, String sql) {
        return this.getQueryRunner().execute(this.createUserSession(user), sql);
    }

    private Session createAdminSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.forUser((String)"admin").withRole("hive", new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))).build()).build();
    }

    private Session createUserSession(String user) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(Identity.ofUser((String)user)).build();
    }
}

