/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CounterStat;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HivePartitionHandle;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplitSource {
    @Test
    public void testOutstandingSplitCount() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)9);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 4).size(), (int)4);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)5);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 20).size(), (int)5);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)0);
    }

    @Test
    public void testEvenlySizedSplitRemainder() {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newSingleThreadExecutor(), (CounterStat)new CounterStat());
        DataSize fileSize = DataSize.ofBytes((long)(initialSplitSize.toBytes() + 1L));
        long halfOfSize = fileSize.toBytes() / 2L;
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(1, OptionalInt.empty(), fileSize));
        HiveSplit first = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assert.assertEquals((long)first.getLength(), (long)halfOfSize);
        HiveSplit second = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assert.assertEquals((long)second.getLength(), (long)(fileSize.toBytes() - halfOfSize));
    }

    @Test
    public void testFail() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        for (int i = 0; i < 5; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("test"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(99));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("another failure"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWaitsForSplits() throws Exception {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        SettableFuture splits = SettableFuture.create();
        CountDownLatch started = new CountDownLatch(1);
        Thread getterThread = new Thread(() -> {
            try {
                started.countDown();
                List<ConnectorSplit> batch = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
                Assert.assertEquals((int)batch.size(), (int)1);
                splits.set((Object)batch.get(0));
            }
            catch (Throwable e) {
                splits.setException(e);
            }
        });
        getterThread.start();
        try {
            Assert.assertTrue((boolean)started.await(1L, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(200L);
            Assert.assertTrue((!splits.isDone() ? 1 : 0) != 0);
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(33));
            ConnectorSplit split = (ConnectorSplit)splits.get(800L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((String)((HiveSplit)split).getSchema().getProperty("id"), (String)"33");
        }
        finally {
            getterThread.interrupt();
        }
    }

    @Test
    public void testOutstandingSplitSize() {
        int i;
        DataSize maxOutstandingSplitsSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10000, (DataSize)maxOutstandingSplitsSize, (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        int testSplitSizeInBytes = new TestSplit(0).getEstimatedSizeInBytes();
        int maxSplitCount = Math.toIntExact(maxOutstandingSplitsSize.toBytes()) / testSplitSizeInBytes;
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, maxSplitCount).size(), (int)maxSplitCount);
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        try {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0));
            Assert.fail((String)"expect failure");
        }
        catch (PrestoException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"Split buffering for database.table exceeded memory limit");
        }
    }

    @Test
    public void testEmptyBucket() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketed((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (int)10, (int)10, (DataSize)DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)Executors.newFixedThreadPool(5), (CounterStat)new CounterStat());
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0, OptionalInt.of(2)));
        hiveSplitSource.noMoreSplits();
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(1), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(2), 10).size(), (int)1);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(3), 10).size(), (int)0);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, int maxSize) {
        return TestHiveSplitSource.getSplits(source, OptionalInt.empty(), maxSize);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, OptionalInt bucketNumber, int maxSize) {
        if (bucketNumber.isPresent()) {
            return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch((ConnectorPartitionHandle)new HivePartitionHandle(bucketNumber.getAsInt()), maxSize))).getSplits();
        }
        return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, maxSize))).getSplits();
    }

    private static class TestSplit
    extends InternalHiveSplit {
        private TestSplit(int id) {
            this(id, OptionalInt.empty());
        }

        private TestSplit(int id, OptionalInt bucketNumber) {
            this(id, bucketNumber, DataSize.ofBytes((long)100L));
        }

        private TestSplit(int id, OptionalInt bucketNumber, DataSize fileSize) {
            super("partition-name", "path", 0L, fileSize.toBytes(), fileSize.toBytes(), Instant.now().toEpochMilli(), TestSplit.properties("id", String.valueOf(id)), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(0L, fileSize.toBytes(), (List)ImmutableList.of())), bucketNumber, 0, true, false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), false, Optional.empty());
        }

        private static Properties properties(String key, String value) {
            Properties properties = new Properties();
            properties.setProperty(key, value);
            return properties;
        }
    }

    private static class TestingHiveSplitLoader
    implements HiveSplitLoader {
        private TestingHiveSplitLoader() {
        }

        public void start(HiveSplitSource splitSource) {
        }

        public void stop() {
        }
    }
}

