/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.IonSqlQueryBuilder;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.InternalTypeManager;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIonSqlQueryBuilder {
    private final TypeManager typeManager = new InternalTypeManager((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators());

    @Test
    public void testBuildSQL() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(this.typeManager);
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"n_nationkey", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"n_name", (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"n_regionkey", (int)2, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s", (String)queryBuilder.buildSql((List)columns, TupleDomain.all()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L))), (boolean)false)));
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE (case s._3 when '' then null else CAST(s._3 AS INT) end = 3)", (String)queryBuilder.buildSql((List)columns, tupleDomain));
    }

    @Test
    public void testEmptyColumns() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(this.typeManager);
        Assert.assertEquals((String)"SELECT ' ' FROM S3Object s", (String)queryBuilder.buildSql((List)ImmutableList.of(), TupleDomain.all()));
    }

    @Test
    public void testDecimalColumns() {
        TypeManager typeManager = this.typeManager;
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager);
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"quantity", (int)0, (HiveType)HiveType.valueOf((String)"decimal(20,0)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"extendedprice", (int)1, (HiveType)HiveType.valueOf((String)"decimal(20,2)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"discount", (int)2, (HiveType)HiveType.valueOf((String)"decimal(10,2)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        DecimalType decimalType = DecimalType.createDecimalType((int)10, (int)2);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(0)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DecimalType.createDecimalType((int)20, (int)0), (Object)HiveTestUtils.longDecimal("50")), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)HiveType.valueOf((String)"decimal(20,2)").getType(typeManager), (Object)HiveTestUtils.longDecimal("0.05")), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)decimalType, (Object)HiveTestUtils.shortDecimal("0.0"), (boolean)true, (Object)HiveTestUtils.shortDecimal("0.02"), (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS DECIMAL(20,0)) end < 50)) AND (case s._2 when '' then null else CAST(s._2 AS DECIMAL(20,2)) end = 0.05) AND ((case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end >= 0.00 AND case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end <= 0.02))", (String)queryBuilder.buildSql((List)columns, tupleDomain));
    }

    @Test
    public void testDateColumn() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(this.typeManager);
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"t1", (int)0, (HiveType)HiveType.HIVE_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MILLIS, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"t2", (int)1, (HiveType)HiveType.HIVE_DATE, (Type)DateType.DATE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)DateType.DATE, (List)ImmutableList.of((Object)Range.equal((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-08-22")))), (boolean)false)));
        Assert.assertEquals((String)"SELECT s._1, s._2 FROM S3Object s WHERE (case s._2 when '' then null else CAST(s._2 AS TIMESTAMP) end = `2001-08-22`)", (String)queryBuilder.buildSql((List)columns, tupleDomain));
    }

    @Test
    public void testNotPushDoublePredicates() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(this.typeManager);
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"quantity", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"extendedprice", (int)1, (HiveType)HiveType.HIVE_DOUBLE, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"discount", (int)2, (HiveType)HiveType.HIVE_DOUBLE, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(0)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)50L), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)DoubleType.DOUBLE, (Object)0.05), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)0.02, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS INT) end < 50))", (String)queryBuilder.buildSql((List)columns, tupleDomain));
    }
}

