/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.TempFile;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSource;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.hive.util.HiveBucketing;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.EmptyPageSource;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.TestingConnectorSession;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeLocalDynamicSplitPruning {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";
    private static final Column BUCKET_COLUMN = new Column("l_orderkey", HiveType.HIVE_INT, Optional.empty());
    private static final HiveColumnHandle BUCKET_HIVE_COLUMN_HANDLE = new HiveColumnHandle(BUCKET_COLUMN.getName(), 0, BUCKET_COLUMN.getType(), BUCKET_COLUMN.getType().getType(HiveTestUtils.TYPE_MANAGER), Optional.empty(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());

    @Test
    public void testDynamicBucketPruning() throws IOException {
        HiveConfig config = new HiveConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (TempFile tempFile = new TempFile();){
            ConnectorPageSource emptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getTupleDomainForSplitPruning()));
            Assert.assertEquals(emptyPageSource.getClass(), EmptyPageSource.class);
            ConnectorPageSource nonEmptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getNonSelectiveTupleDomain()));
            Assert.assertEquals(nonEmptyPageSource.getClass(), HivePageSource.class);
        }
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, HiveConfig hiveConfig, File outputFile, DynamicFilter dynamicFilter) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", hiveConfig.getHiveStorageFormat().getInputFormat());
        splitProperties.setProperty("serialization.lib", hiveConfig.getHiveStorageFormat().getSerDe());
        HiveSplit split = new HiveSplit("test", "test", "", "file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), outputFile.lastModified(), splitProperties, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.of(1), 0, false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), false, Optional.empty());
        TableHandle tableHandle = new TableHandle(new CatalogName(HIVE_CATALOG_NAME), (ConnectorTableHandle)new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), Optional.of(new HiveBucketHandle((List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), HiveBucketing.BucketingVersion.BUCKETING_V1, 20, 20))), (ConnectorTransactionHandle)transaction, Optional.empty());
        HivePageSourceProvider provider = new HivePageSourceProvider(HiveTestUtils.TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig, HiveTestUtils.getDefaultHivePageSourceFactories(HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig), HiveTestUtils.getDefaultHiveRecordCursorProviders(hiveConfig, HiveTestUtils.HDFS_ENVIRONMENT), new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig), Optional.empty());
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestNodeLocalDynamicSplitPruning.getSession(hiveConfig), (ConnectorSplit)split, tableHandle.getConnectorHandle(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), dynamicFilter);
    }

    private static TupleDomain<ColumnHandle> getTupleDomainForSplitPruning() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L)));
    }

    private static TupleDomain<ColumnHandle> getNonSelectiveTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private static TestingConnectorSession getSession(HiveConfig config) {
        return TestingConnectorSession.builder().setPropertyMetadata(new HiveSessionProperties(config, new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();
    }

    private static DynamicFilter getDynamicFilter(final TupleDomain<ColumnHandle> tupleDomain) {
        return new DynamicFilter(){

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public boolean isComplete() {
                return true;
            }

            public boolean isAwaitable() {
                return false;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return tupleDomain;
            }
        };
    }
}

