/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestOrcWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OrcWriterConfig)ConfigAssertions.recordDefaults(OrcWriterConfig.class)).setStripeMinSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStripeMaxSize(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(10000000).setRowGroupMaxRowCount(10000).setDictionaryMaxMemory(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(DataSize.ofBytes((long)64L)).setMaxCompressionBufferSize(DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setDefaultBloomFilterFpp(0.05).setUseLegacyVersion(false).setValidationPercentage(0.0).setValidationMode(OrcWriteValidation.OrcWriteValidationMode.BOTH));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.orc.writer.stripe-min-size", (Object)"13MB").put((Object)"hive.orc.writer.stripe-max-size", (Object)"27MB").put((Object)"hive.orc.writer.stripe-max-rows", (Object)"44").put((Object)"hive.orc.writer.row-group-max-rows", (Object)"11").put((Object)"hive.orc.writer.dictionary-max-memory", (Object)"13MB").put((Object)"hive.orc.writer.string-statistics-limit", (Object)"17MB").put((Object)"hive.orc.writer.max-compression-buffer-size", (Object)"19MB").put((Object)"hive.orc.default-bloom-filter-fpp", (Object)"0.96").put((Object)"hive.orc.writer.use-legacy-version-number", (Object)"true").put((Object)"hive.orc.writer.validation-percentage", (Object)"0.16").put((Object)"hive.orc.writer.validation-mode", (Object)"DETAILED").build();
        OrcWriterConfig expected = new OrcWriterConfig().setStripeMinSize(DataSize.of((long)13L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStripeMaxSize(DataSize.of((long)27L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStripeMaxRowCount(44).setRowGroupMaxRowCount(11).setDictionaryMaxMemory(DataSize.of((long)13L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStringStatisticsLimit(DataSize.of((long)17L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxCompressionBufferSize(DataSize.of((long)19L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setDefaultBloomFilterFpp(0.96).setUseLegacyVersion(true).setValidationPercentage(0.16).setValidationMode(OrcWriteValidation.OrcWriteValidationMode.DETAILED);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

