/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.io.Resources;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.orc.OriginalFilesUtils;
import io.prestosql.testing.TestingConnectorSession;
import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOriginalFilesUtils {
    private String tablePath;
    private Configuration config;

    @BeforeClass
    public void setup() throws Exception {
        this.tablePath = new File(Resources.getResource((String)"dummy_id_data_orc").toURI()).getPath();
        this.config = new JobConf(new Configuration(false));
    }

    @Test
    public void testGetPrecedingRowCountSingleFile() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfoList = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfoList.add(new AcidInfo.OriginalFileInfo("000001_0", 730L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfoList, (Path)new Path(this.tablePath + "/000001_0"), (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (String)TestingConnectorSession.SESSION.getUser(), (OrcReaderOptions)new OrcReaderOptions(), (Configuration)this.config, (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        Assert.assertEquals((long)rowCountResult, (long)0L, (String)"Original file should have 0 as the starting row count");
    }

    @Test
    public void testGetPrecedingRowCount() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfos = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0", 741L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_1", 768L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_2", 743L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfos, (Path)new Path(this.tablePath + "/000002_0_copy_2"), (HdfsEnvironment)HiveTestUtils.HDFS_ENVIRONMENT, (String)TestingConnectorSession.SESSION.getUser(), (OrcReaderOptions)new OrcReaderOptions(), (Configuration)this.config, (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        Assert.assertEquals((long)rowCountResult, (long)8L, (String)"Original file 000002_0_copy_2 should have 8 as the starting row count");
    }
}

