/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.PartitionOfflineException;
import io.prestosql.spi.connector.SchemaTableName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionOfflineException {
    @Test
    public void testMessage() {
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", false, "", "Table 'schema.table' partition 'pk=1' is offline");
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", false, null, "Table 'schema.table' partition 'pk=1' is offline");
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", true, "", "Table 'schema.table' partition 'pk=1' is offline for Presto");
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", true, null, "Table 'schema.table' partition 'pk=1' is offline for Presto");
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", false, "offline reason", "Table 'schema.table' partition 'pk=1' is offline: offline reason");
        TestPartitionOfflineException.assertMessage(new SchemaTableName("schema", "table"), "pk=1", true, "offline reason", "Table 'schema.table' partition 'pk=1' is offline for Presto: offline reason");
    }

    private static void assertMessage(SchemaTableName tableName, String partitionName, boolean forPresto, String offlineMessage, String expectedMessage) {
        PartitionOfflineException tableOfflineException = new PartitionOfflineException(tableName, partitionName, forPresto, offlineMessage);
        Assert.assertEquals((String)tableOfflineException.getMessage(), (String)expectedMessage);
    }
}

