/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.prestosql.plugin.hive.PartitionUpdate;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionUpdate {
    private static final JsonCodec<PartitionUpdate> CODEC = JsonCodec.jsonCodec(PartitionUpdate.class);

    @Test
    public void testRoundTrip() {
        PartitionUpdate expected = new PartitionUpdate("test", PartitionUpdate.UpdateMode.APPEND, "/writePath", "/targetPath", (List)ImmutableList.of((Object)"file1", (Object)"file3"), 123L, 456L, 789L);
        PartitionUpdate actual = (PartitionUpdate)CODEC.fromJson(CODEC.toJson((Object)expected));
        Assert.assertEquals((String)actual.getName(), (String)"test");
        Assert.assertEquals((Object)actual.getUpdateMode(), (Object)PartitionUpdate.UpdateMode.APPEND);
        Assert.assertEquals((Object)actual.getWritePath(), (Object)new Path("/writePath"));
        Assert.assertEquals((Object)actual.getTargetPath(), (Object)new Path("/targetPath"));
        Assert.assertEquals((Collection)actual.getFileNames(), (Collection)ImmutableList.of((Object)"file1", (Object)"file3"));
        Assert.assertEquals((long)actual.getRowCount(), (long)123L);
        Assert.assertEquals((long)actual.getInMemoryDataSizeInBytes(), (long)456L);
        Assert.assertEquals((long)actual.getOnDiskDataSizeInBytes(), (long)789L);
    }
}

