/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.plugin.hive.authentication.HdfsKerberosConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHdfsKerberosConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HdfsKerberosConfig)ConfigAssertions.recordDefaults(HdfsKerberosConfig.class)).setHdfsPrestoPrincipal(null).setHdfsPrestoKeytab(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path keytab = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.hdfs.presto.principal", (Object)"presto@EXAMPLE.COM").put((Object)"hive.hdfs.presto.keytab", (Object)keytab.toString()).build();
        HdfsKerberosConfig expected = new HdfsKerberosConfig().setHdfsPrestoPrincipal("presto@EXAMPLE.COM").setHdfsPrestoKeytab(keytab.toString());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

