/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.plugin.hive.authentication.MetastoreKerberosConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestMetastoreKerberosConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MetastoreKerberosConfig)ConfigAssertions.recordDefaults(MetastoreKerberosConfig.class)).setHiveMetastoreServicePrincipal(null).setHiveMetastoreClientPrincipal(null).setHiveMetastoreClientKeytab(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path clientKeytabFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore.service.principal", (Object)"hive/_HOST@EXAMPLE.COM").put((Object)"hive.metastore.client.principal", (Object)"metastore@EXAMPLE.COM").put((Object)"hive.metastore.client.keytab", (Object)clientKeytabFile.toString()).build();
        MetastoreKerberosConfig expected = new MetastoreKerberosConfig().setHiveMetastoreServicePrincipal("hive/_HOST@EXAMPLE.COM").setHiveMetastoreClientPrincipal("metastore@EXAMPLE.COM").setHiveMetastoreClientKeytab(clientKeytabFile.toString());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

