/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.hadoop.HadoopNative;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import io.prestosql.plugin.hive.benchmark.FormatWriter;
import io.prestosql.plugin.hive.benchmark.TestData;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.tpch.OrderColumn;
import io.prestosql.tpch.TpchColumn;
import io.prestosql.tpch.TpchEntity;
import io.prestosql.tpch.TpchTable;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.util.Statistics;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Measurement(iterations=50)
@Warmup(iterations=20)
@Fork(value=3)
public class BenchmarkHiveFileFormat {
    private static final long MIN_DATA_SIZE = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    @Param(value={"LINEITEM", "BIGINT_SEQUENTIAL", "BIGINT_RANDOM", "VARCHAR_SMALL", "VARCHAR_LARGE", "VARCHAR_DICTIONARY", "MAP_VARCHAR_DOUBLE", "LARGE_MAP_VARCHAR_DOUBLE", "MAP_INT_DOUBLE", "LARGE_MAP_INT_DOUBLE", "LARGE_ARRAY_VARCHAR"})
    private DataSet dataSet;
    @Param(value={"NONE", "SNAPPY", "GZIP"})
    private HiveCompressionCodec compression;
    @Param(value={"PRESTO_RCBINARY", "PRESTO_RCTEXT", "PRESTO_ORC", "PRESTO_PARQUET", "HIVE_RCBINARY", "HIVE_RCTEXT", "HIVE_ORC", "HIVE_PARQUET"})
    private FileFormat fileFormat;
    private TestData data;
    private File dataFile;
    private final File targetDir = BenchmarkHiveFileFormat.createTempDir("presto-benchmark");

    public BenchmarkHiveFileFormat() {
    }

    public BenchmarkHiveFileFormat(DataSet dataSet, HiveCompressionCodec compression, FileFormat fileFormat) {
        this.dataSet = dataSet;
        this.compression = compression;
        this.fileFormat = fileFormat;
    }

    @Setup
    public void setup() throws IOException {
        this.data = this.dataSet.createTestData(this.fileFormat);
        this.targetDir.mkdirs();
        this.dataFile = new File(this.targetDir, UUID.randomUUID().toString());
        this.writeData(this.dataFile);
    }

    @TearDown
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.targetDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Benchmark
    public List<Page> read(CompressionCounter counter) throws IOException {
        if (!this.fileFormat.supports(this.data)) {
            throw new RuntimeException(this.fileFormat + " does not support data set " + this.dataSet);
        }
        ArrayList<Page> pages = new ArrayList<Page>(100);
        try (ConnectorPageSource pageSource = this.fileFormat.createFileFormatReader(HiveTestUtils.SESSION, HiveTestUtils.HDFS_ENVIRONMENT, this.dataFile, this.data.getColumnNames(), this.data.getColumnTypes());){
            while (!pageSource.isFinished()) {
                Page page = pageSource.getNextPage();
                if (page == null) continue;
                pages.add(page.getLoadedPage());
            }
        }
        counter.inputSize += (long)this.data.getSize();
        counter.outputSize += this.dataFile.length();
        return pages;
    }

    @Benchmark
    public File write(CompressionCounter counter) throws IOException {
        File targetFile = new File(this.targetDir, UUID.randomUUID().toString());
        this.writeData(targetFile);
        counter.inputSize += (long)this.data.getSize();
        counter.outputSize += targetFile.length();
        return targetFile;
    }

    private void writeData(File targetFile) throws IOException {
        List<Page> inputPages = this.data.getPages();
        try (FormatWriter formatWriter = this.fileFormat.createFileFormatWriter(HiveTestUtils.SESSION, targetFile, this.data.getColumnNames(), this.data.getColumnTypes(), this.compression);){
            for (Page page : inputPages) {
                formatWriter.writePage(page);
            }
        }
    }

    @SafeVarargs
    private static <E extends TpchEntity> TestData createTpchDataSet(FileFormat format, TpchTable<E> tpchTable, TpchColumn<E> ... columns) {
        return BenchmarkHiveFileFormat.createTpchDataSet(format, tpchTable, ImmutableList.copyOf((Object[])columns));
    }

    private static <E extends TpchEntity> TestData createTpchDataSet(FileFormat format, TpchTable<E> tpchTable, List<TpchColumn<E>> columns) {
        List<String> columnNames = columns.stream().map(TpchColumn::getColumnName).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().map(BenchmarkHiveFileFormat::getColumnType).map(type -> format.supportsDate() || !DateType.DATE.equals(type) ? type : VarcharType.createUnboundedVarcharType()).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        ImmutableList.Builder pages = ImmutableList.builder();
        long dataSize = 0L;
        for (TpchEntity row : tpchTable.createGenerator(10.0, 1, 1)) {
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                TpchColumn<E> column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(row));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(row));
                        continue block8;
                    }
                    case DATE: {
                        if (format.supportsDate()) {
                            DateType.DATE.writeLong(blockBuilder, (long)column.getDate(row));
                            continue block8;
                        }
                        VarcharType.createUnboundedVarcharType().writeString(blockBuilder, column.getString(row));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(row));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(row)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + column.getType());
                    }
                }
            }
            if (!pageBuilder.isFull()) continue;
            Page page = pageBuilder.build();
            pages.add((Object)page);
            pageBuilder.reset();
            if ((dataSize += page.getSizeInBytes()) < MIN_DATA_SIZE) continue;
            break;
        }
        return new TestData(columnNames, columnTypes, (List<Page>)pages.build());
    }

    private static Type getColumnType(TpchColumn<?> input) {
        switch (input.getType().getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case VARCHAR: {
                return VarcharType.createUnboundedVarcharType();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + input.getType());
    }

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(".*\\." + BenchmarkHiveFileFormat.class.getSimpleName() + ".*").jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g", "-XX:+UseG1GC"}).build();
        Collection results = new Runner(opt).run();
        for (RunResult result : results) {
            Statistics inputSizeStats = ((Result)result.getSecondaryResults().get("inputSize")).getStatistics();
            Statistics outputSizeStats = ((Result)result.getSecondaryResults().get("outputSize")).getStatistics();
            double compressionRatio = 1.0 * inputSizeStats.getSum() / outputSizeStats.getSum();
            String compression = result.getParams().getParam("compression");
            String fileFormat = result.getParams().getParam("fileFormat");
            String dataSet = result.getParams().getParam("dataSet");
            System.out.printf("  %-10s  %-30s  %-10s  %-25s  %2.2f  %10s \u00b1 %11s (%5.2f%%) (N = %d, \u03b1 = 99.9%%)\n", result.getPrimaryResult().getLabel(), dataSet, compression, fileFormat, compressionRatio, BenchmarkHiveFileFormat.toHumanReadableSpeed((long)inputSizeStats.getMean()), BenchmarkHiveFileFormat.toHumanReadableSpeed((long)inputSizeStats.getMeanErrorAt(0.999)), inputSizeStats.getMeanErrorAt(0.999) * 100.0 / inputSizeStats.getMean(), inputSizeStats.getN());
        }
        System.out.println();
    }

    private static String toHumanReadableSpeed(long bytesPerSecond) {
        String humanReadableSpeed = bytesPerSecond < 10240L ? String.format("%dB/s", bytesPerSecond) : (bytesPerSecond < 0xA00000L ? String.format("%.1fkB/s", Float.valueOf((float)bytesPerSecond / 1024.0f)) : (bytesPerSecond < 0x280000000L ? String.format("%.1fMB/s", Float.valueOf((float)bytesPerSecond / 1048576.0f)) : String.format("%.1fGB/s", Float.valueOf((float)bytesPerSecond / 1.0737418E9f))));
        return humanReadableSpeed;
    }

    private static int nextRandomBetween(Random random, int min, int max) {
        return min + random.nextInt(max - min);
    }

    private static File createTempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        HadoopNative.requireHadoopNative();
    }

    public static enum DataSet {
        LINEITEM{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.LINE_ITEM, TpchTable.LINE_ITEM.getColumns());
            }
        }
        ,
        BIGINT_SEQUENTIAL{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.ORDER_KEY});
            }
        }
        ,
        BIGINT_RANDOM{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CUSTOMER_KEY});
            }
        }
        ,
        VARCHAR_SMALL{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CLERK});
            }
        }
        ,
        VARCHAR_LARGE{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CLERK});
            }
        }
        ,
        VARCHAR_DICTIONARY{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkHiveFileFormat.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.ORDER_PRIORITY});
            }
        }
        ,
        MAP_VARCHAR_DOUBLE{
            private static final int MIN_ENTRIES = 1;
            private static final int MAX_ENTRIES = 5;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                int[] keys = new int[]{1, 2, 3, 4, 5};
                long dataSize = 0L;
                while (dataSize < MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkHiveFileFormat.nextRandomBetween(random, 1, 5);
                    IntArrays.shuffle((int[])keys, (Random)random);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + keys[entryId])));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_MAP_VARCHAR_DOUBLE{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 15000;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkHiveFileFormat.nextRandomBetween(random, 5000, 15000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + random.nextInt(10000000))));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        MAP_INT_DOUBLE{
            private static final int MIN_ENTRIES = 1;
            private static final int MAX_ENTRIES = 5;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                int[] keys = new int[]{1, 2, 3, 4, 5};
                long dataSize = 0L;
                while (dataSize < MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkHiveFileFormat.nextRandomBetween(random, 1, 5);
                    IntArrays.shuffle((int[])keys, (Random)random);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        IntegerType.INTEGER.writeLong(mapBuilder, (long)keys[entryId]);
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_MAP_INT_DOUBLE{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 150000;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkHiveFileFormat.nextRandomBetween(random, 5000, 150000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        IntegerType.INTEGER.writeLong(mapBuilder, (long)random.nextInt(10000000));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_ARRAY_VARCHAR{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 150000;

            @Override
            public TestData createTestData(FileFormat format) {
                ArrayType type = new ArrayType((Type)VarcharType.createUnboundedVarcharType());
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkHiveFileFormat.nextRandomBetween(random, 5000, 150000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + random.nextInt(10000000))));
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        };


        public abstract TestData createTestData(FileFormat var1);
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class CompressionCounter {
        public long inputSize;
        public long outputSize;
    }
}

