/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.hadoop.HadoopNative;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.TestHiveReaderProjectionsUtil;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import io.prestosql.plugin.hive.benchmark.FormatWriter;
import io.prestosql.plugin.hive.benchmark.TestData;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Measurement(iterations=50)
@Warmup(iterations=20)
@Fork(value=3)
public class BenchmarkProjectionPushdownHive {
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final int TOTAL_ROW_COUNT = 10000;
    private static final int POSITIONS_PER_PAGE = 1000;
    private static final int DEFAULT_ARRAY_SIZE = 30;
    private static final String TOP_LEVEL = "toplevel";
    private static final String STRUCT = "struct";
    private static final String WITH_PUSHDOWN = "with_pushdown";
    private static final String WITHOUT_PUSHDOWN = "without_pushdown";
    private static final String ROW_OF_STRINGS = "ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR)";
    private static final String NESTED_STRUCT = "ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR, f3 ARRAY(ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR)))";

    @Benchmark
    public List<Page> readPages(BenchmarkContext context) {
        ArrayList<Page> pages = new ArrayList<Page>(100);
        ConnectorPageSource pageSource = context.createPageSource();
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            pages.add(page.getLoadedPage());
        }
        return pages;
    }

    @Test
    public void testBenchmark() throws IOException {
        BenchmarkContext context = new BenchmarkContext();
        try {
            context.setup();
            this.readPages(context);
        }
        catch (Throwable t) {
            throw new RuntimeException("Benchmark execution failed", t);
        }
        finally {
            context.tearDown();
        }
    }

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(".*\\." + BenchmarkProjectionPushdownHive.class.getSimpleName() + ".*").jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g", "-XX:+UseG1GC"}).build();
        new Runner(opt).run();
    }

    private static File createTempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String generateRandomString(Random random, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = LETTERS.charAt(random.nextInt(LETTERS.length()));
        }
        return new String(chars);
    }

    private static boolean isSupportedType(Type type) {
        if (type == VarcharType.VARCHAR) {
            return true;
        }
        if (type instanceof RowType) {
            return type.getTypeParameters().stream().allMatch(BenchmarkProjectionPushdownHive::isSupportedType);
        }
        if (type instanceof ArrayType) {
            return BenchmarkProjectionPushdownHive.isSupportedType(((ArrayType)type).getElementType());
        }
        return false;
    }

    static {
        HadoopNative.requireHadoopNative();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkContext {
        private final Random random = new Random();
        private List<Type> columnTypesToWrite;
        private List<String> columnNamesToWrite;
        private List<HiveType> columnHiveTypesToWrite;
        @Param(value={"struct", "toplevel"})
        private String writeStrategy = "struct";
        @Param(value={"without_pushdown", "with_pushdown"})
        private String readStrategy = "with_pushdown";
        @Param(value={"ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR)", "ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR, f3 ARRAY(ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR)))"})
        private String columnTypeString = "ROW(f0 VARCHAR, f1 VARCHAR, f2 VARCHAR)";
        @Param(value={"1"})
        private int readColumnCount = 1;
        @Param(value={"PRESTO_ORC", "PRESTO_PARQUET"})
        private FileFormat fileFormat = FileFormat.PRESTO_ORC;
        private TestData dataToWrite;
        private File dataFile;
        private final File targetDir = BenchmarkProjectionPushdownHive.createTempDir("presto-benchmark");

        @Setup
        public void setup() throws IOException {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            Type columnType = metadata.fromSqlType(this.columnTypeString);
            Preconditions.checkState((boolean)(columnType instanceof RowType), (Object)"expected column to have RowType");
            if (BenchmarkProjectionPushdownHive.STRUCT.equals(this.writeStrategy)) {
                this.columnTypesToWrite = ImmutableList.of((Object)columnType);
                this.columnHiveTypesToWrite = ImmutableList.of((Object)HiveType.toHiveType((Type)columnType));
                this.columnNamesToWrite = ImmutableList.of((Object)"column_0");
            } else if (BenchmarkProjectionPushdownHive.TOP_LEVEL.equals(this.writeStrategy)) {
                List fieldTypes = ((RowType)columnType).getTypeParameters();
                this.columnTypesToWrite = ImmutableList.copyOf((Collection)fieldTypes);
                this.columnHiveTypesToWrite = (List)this.columnTypesToWrite.stream().map(HiveType::toHiveType).collect(ImmutableList.toImmutableList());
                this.columnNamesToWrite = (List)IntStream.range(0, this.columnTypesToWrite.size()).mapToObj(Integer::toString).map("column_"::concat).collect(ImmutableList.toImmutableList());
            } else {
                throw new UnsupportedOperationException(String.format("Write strategy %s not supported", this.writeStrategy));
            }
            Preconditions.checkState((boolean)this.columnTypesToWrite.stream().allMatch(x$0 -> BenchmarkProjectionPushdownHive.isSupportedType(x$0)), (Object)"Type not supported for benchmark");
            this.dataToWrite = this.createTestData(this.columnTypesToWrite, this.columnNamesToWrite);
            this.targetDir.mkdirs();
            this.dataFile = new File(this.targetDir, UUID.randomUUID().toString());
            this.writeData(this.dataFile);
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.targetDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }

        private void writeData(File targetFile) throws IOException {
            List<Page> inputPages = this.dataToWrite.getPages();
            try (FormatWriter formatWriter = this.fileFormat.createFileFormatWriter(HiveTestUtils.SESSION, targetFile, this.dataToWrite.getColumnNames(), this.dataToWrite.getColumnTypes(), HiveCompressionCodec.ZSTD);){
                for (Page page : inputPages) {
                    formatWriter.writePage(page);
                }
            }
        }

        private ConnectorPageSource createPageSource() {
            if (BenchmarkProjectionPushdownHive.TOP_LEVEL.equals(this.writeStrategy)) {
                List readColumns = (List)IntStream.range(0, this.readColumnCount).boxed().map(index -> HiveColumnHandle.createBaseColumn((String)this.columnNamesToWrite.get((int)index), (int)0, (HiveType)this.columnHiveTypesToWrite.get((int)index), (Type)this.columnTypesToWrite.get((int)index), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
                return this.fileFormat.createGenericReader(HiveTestUtils.SESSION, HiveTestUtils.HDFS_ENVIRONMENT, this.dataFile, readColumns, this.columnNamesToWrite, this.columnTypesToWrite);
            }
            if (BenchmarkProjectionPushdownHive.STRUCT.equals(this.writeStrategy)) {
                Object readColumnHandles;
                Preconditions.checkState((this.columnTypesToWrite.size() == 1 ? 1 : 0) != 0);
                HiveColumnHandle baseColumn = HiveColumnHandle.createBaseColumn((String)this.columnNamesToWrite.get(0), (int)0, (HiveType)this.columnHiveTypesToWrite.get(0), (Type)this.columnTypesToWrite.get(0), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
                if (BenchmarkProjectionPushdownHive.WITH_PUSHDOWN.equals(this.readStrategy)) {
                    readColumnHandles = (List)IntStream.range(0, this.readColumnCount).boxed().map(i -> TestHiveReaderProjectionsUtil.createProjectedColumnHandle(baseColumn, (List<Integer>)ImmutableList.of((Object)i))).collect(ImmutableList.toImmutableList());
                } else if (BenchmarkProjectionPushdownHive.WITHOUT_PUSHDOWN.equals(this.readStrategy)) {
                    readColumnHandles = ImmutableList.of((Object)baseColumn);
                } else {
                    throw new UnsupportedOperationException(String.format("Read strategy %s not supported", this.readStrategy));
                }
                return this.fileFormat.createGenericReader(HiveTestUtils.SESSION, HiveTestUtils.HDFS_ENVIRONMENT, this.dataFile, (List<ColumnHandle>)readColumnHandles, this.columnNamesToWrite, this.columnTypesToWrite);
            }
            throw new UnsupportedOperationException(String.format("Write strategy %s not supported", this.writeStrategy));
        }

        private TestData createTestData(List<Type> columnTypes, List<String> columnNames) {
            ImmutableList.Builder pages = ImmutableList.builder();
            int pageCount = 10;
            for (int i = 0; i < pageCount; ++i) {
                Block[] blocks = new Block[columnTypes.size()];
                for (int column = 0; column < columnTypes.size(); ++column) {
                    Type type = columnTypes.get(column);
                    blocks[column] = this.createBlock(type, 1000);
                }
                pages.add((Object)new Page(blocks));
            }
            return new TestData(columnNames, columnTypes, (List<Page>)pages.build());
        }

        private Block createBlock(Type type, int rowCount) {
            Preconditions.checkState((boolean)BenchmarkProjectionPushdownHive.isSupportedType(type), (Object)String.format("Type %s not supported", type.getDisplayName()));
            if (type instanceof RowType) {
                List parameters = type.getTypeParameters();
                Block[] fieldBlocks = new Block[parameters.size()];
                for (int field = 0; field < parameters.size(); ++field) {
                    fieldBlocks[field] = this.createBlock((Type)parameters.get(field), rowCount);
                }
                return RowBlock.fromFieldBlocks((int)rowCount, Optional.empty(), (Block[])fieldBlocks);
            }
            if (type instanceof VarcharType) {
                BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    VarcharType.VARCHAR.writeString(builder, BenchmarkProjectionPushdownHive.generateRandomString(this.random, 500));
                }
                return builder.build();
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                Type elementType = arrayType.getElementType();
                BlockBuilder blockBuilder = type.createBlockBuilder(null, rowCount);
                for (int i = 0; i < rowCount; ++i) {
                    Block elementBlock = this.createBlock(elementType, 30);
                    blockBuilder.appendStructure(elementBlock);
                }
                return blockBuilder.build();
            }
            throw new UnsupportedOperationException("Only VARCHAR, ROW and ARRAY types supported");
        }
    }
}

