/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.benchmark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.OrcWriter;
import io.prestosql.orc.OrcWriterOptions;
import io.prestosql.orc.OrcWriterStats;
import io.prestosql.orc.OutputStreamOrcDataSink;
import io.prestosql.orc.metadata.OrcType;
import io.prestosql.parquet.writer.ParquetSchemaConverter;
import io.prestosql.parquet.writer.ParquetWriter;
import io.prestosql.parquet.writer.ParquetWriterOptions;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.ReaderPageSource;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.plugin.hive.TableToPartitionMapping;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.benchmark.FormatWriter;
import io.prestosql.plugin.hive.benchmark.TestData;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.prestosql.plugin.hive.util.CompressionConfigUtil;
import io.prestosql.rcfile.AircompressorCodecFactory;
import io.prestosql.rcfile.HadoopCodecFactory;
import io.prestosql.rcfile.RcFileCodecFactory;
import io.prestosql.rcfile.RcFileEncoding;
import io.prestosql.rcfile.RcFileWriter;
import io.prestosql.rcfile.binary.BinaryRcFileEncoding;
import io.prestosql.rcfile.text.TextRcFileEncoding;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.TestingConnectorTransactionHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public enum FileFormat {
    PRESTO_RCBINARY{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCBINARY;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats(), new HiveConfig().setRcfileTimeZone("UTC")));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new BinaryRcFileEncoding(DateTimeZone.UTC), compressionCodec);
        }
    }
    ,
    PRESTO_RCTEXT{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCTEXT;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new RcFilePageSourceFactory(HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats(), new HiveConfig().setRcfileTimeZone("UTC")));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new TextRcFileEncoding(), compressionCodec);
        }
    }
    ,
    PRESTO_ORC{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.ORC;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new OrcPageSourceFactory(new OrcReaderOptions(), hdfsEnvironment, new FileFormatDataSourceStats(), DateTimeZone.UTC));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoOrcFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    }
    ,
    PRESTO_PARQUET{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.PARQUET;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new ParquetPageSourceFactory(hdfsEnvironment, new FileFormatDataSourceStats(), new ParquetReaderConfig(), new HiveConfig().setParquetTimeZone("UTC")));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoParquetFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    }
    ,
    HIVE_RCBINARY{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCBINARY;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCBINARY, session);
        }
    }
    ,
    HIVE_RCTEXT{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCTEXT;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCTEXT, session);
        }
    }
    ,
    HIVE_ORC{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.ORC;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.ORC, session);
        }
    }
    ,
    HIVE_PARQUET{

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.PARQUET;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.PARQUET, session);
        }
    };

    private static final JobConf conf;

    public boolean supportsDate() {
        return true;
    }

    public abstract HiveStorageFormat getFormat();

    public abstract FormatWriter createFileFormatWriter(ConnectorSession var1, File var2, List<String> var3, List<Type> var4, HiveCompressionCodec var5) throws IOException;

    public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment environment) {
        return Optional.empty();
    }

    public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment environment) {
        return Optional.empty();
    }

    public final ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
        Optional<HivePageSourceFactory> pageSourceFactory = this.getHivePageSourceFactory(hdfsEnvironment);
        Optional<HiveRecordCursorProvider> recordCursorProvider = this.getHiveRecordCursorProvider(hdfsEnvironment);
        Preconditions.checkArgument((boolean)(pageSourceFactory.isPresent() ^ recordCursorProvider.isPresent()));
        if (pageSourceFactory.isPresent()) {
            return FileFormat.createPageSource(pageSourceFactory.get(), session, targetFile, columnNames, columnTypes, this.getFormat());
        }
        return FileFormat.createPageSource(recordCursorProvider.get(), session, targetFile, columnNames, columnTypes, this.getFormat());
    }

    public final ConnectorPageSource createGenericReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<ColumnHandle> readColumns, List<String> schemaColumnNames, List<Type> schemaColumnTypes) {
        HivePageSourceProvider factory = new HivePageSourceProvider(HiveTestUtils.TYPE_MANAGER, hdfsEnvironment, new HiveConfig(), (Set)this.getHivePageSourceFactory(hdfsEnvironment).map(ImmutableSet::of).orElse(ImmutableSet.of()), (Set)this.getHiveRecordCursorProvider(hdfsEnvironment).map(ImmutableSet::of).orElse(ImmutableSet.of()), new GenericHiveRecordCursorProvider(hdfsEnvironment, new HiveConfig()), Optional.empty());
        Properties schema = FileFormat.createSchema(this.getFormat(), schemaColumnNames, schemaColumnTypes);
        HiveSplit split = new HiveSplit("schema_name", "table_name", "", targetFile.getPath(), 0L, targetFile.length(), targetFile.length(), targetFile.lastModified(), schema, (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), 0, false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), false, Optional.empty());
        ConnectorPageSource hivePageSource = factory.createPageSource((ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, session, (ConnectorSplit)split, (ConnectorTableHandle)new HiveTableHandle("schema_name", "table_name", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty()), readColumns, DynamicFilter.EMPTY);
        return hivePageSource;
    }

    public boolean supports(TestData testData) {
        return true;
    }

    private static ConnectorPageSource createPageSource(HiveRecordCursorProvider cursorProvider, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes should have the same size");
        List<HiveColumnHandle> readColumns = FileFormat.getBaseColumns(columnNames, columnTypes);
        Optional recordCursorWithProjections = cursorProvider.createRecordCursor((Configuration)conf, session, new Path(targetFile.getAbsolutePath()), 0L, targetFile.length(), targetFile.length(), FileFormat.createSchema(format, columnNames, columnTypes), readColumns, TupleDomain.all(), HiveTestUtils.TYPE_MANAGER, false);
        Preconditions.checkState((boolean)recordCursorWithProjections.isPresent(), (Object)"readerPageSourceWithProjections is not present");
        Preconditions.checkState((!((HiveRecordCursorProvider.ReaderRecordCursorWithProjections)recordCursorWithProjections.get()).getProjectedReaderColumns().isPresent() ? 1 : 0) != 0, (Object)"projection should not be required");
        return new RecordPageSource(columnTypes, ((HiveRecordCursorProvider.ReaderRecordCursorWithProjections)recordCursorWithProjections.get()).getRecordCursor());
    }

    private static ConnectorPageSource createPageSource(HivePageSourceFactory pageSourceFactory, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes should have the same size");
        List<HiveColumnHandle> readColumns = FileFormat.getBaseColumns(columnNames, columnTypes);
        Properties schema = FileFormat.createSchema(format, columnNames, columnTypes);
        Optional readerPageSourceWithProjections = pageSourceFactory.createPageSource((Configuration)conf, session, new Path(targetFile.getAbsolutePath()), 0L, targetFile.length(), targetFile.length(), schema, readColumns, TupleDomain.all(), Optional.empty(), OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION);
        Preconditions.checkState((boolean)readerPageSourceWithProjections.isPresent(), (Object)"readerPageSourceWithProjections is not present");
        Preconditions.checkState((!((ReaderPageSource)readerPageSourceWithProjections.get()).getReaderColumns().isPresent() ? 1 : 0) != 0, (Object)"projection should not be required");
        return ((ReaderPageSource)readerPageSourceWithProjections.get()).get();
    }

    private static List<HiveColumnHandle> getBaseColumns(List<String> columnNames, List<Type> columnTypes) {
        return (List)IntStream.range(0, columnNames.size()).boxed().map(index -> HiveColumnHandle.createBaseColumn((String)((String)columnNames.get((int)index)), (int)index, (HiveType)HiveType.toHiveType((Type)((Type)columnTypes.get((int)index))), (Type)((Type)columnTypes.get((int)index)), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
    }

    private static Properties createSchema(HiveStorageFormat format, List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", format.getSerDe());
        schema.setProperty("file.inputformat", format.getInputFormat());
        schema.setProperty("columns", String.join((CharSequence)",", columnNames));
        schema.setProperty("columns.types", columnTypes.stream().map(HiveType::toHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    static {
        conf = new JobConf(new Configuration(false));
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
    }

    private static class PrestoParquetFormatWriter
    implements FormatWriter {
        private final ParquetWriter writer;

        public PrestoParquetFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames);
            this.writer = new ParquetWriter((OutputStream)new FileOutputStream(targetFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().build(), compressionCodec.getParquetCompressionCodec());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoOrcFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoOrcFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((OrcDataSink)new OutputStreamOrcDataSink((OutputStream)new FileOutputStream(targetFile)), columnNames, types, OrcType.createRootOrcType(columnNames, types), compressionCodec.getOrcCompressionKind(), new OrcWriterOptions(), false, (Map)ImmutableMap.of(), false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoRcFileFormatWriter
    implements FormatWriter {
        private final RcFileWriter writer;

        public PrestoRcFileFormatWriter(File targetFile, List<Type> types, RcFileEncoding encoding, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new RcFileWriter((SliceOutput)new OutputStreamSliceOutput((OutputStream)new FileOutputStream(targetFile)), types, encoding, compressionCodec.getCodec().map(Class::getName), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(this.getClass().getClassLoader())), (Map)ImmutableMap.of(), true);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class RecordFormatWriter
    implements FormatWriter {
        private final RecordFileWriter recordWriter;

        public RecordFormatWriter(File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec, HiveStorageFormat format, ConnectorSession session) {
            JobConf config = new JobConf((Configuration)conf);
            CompressionConfigUtil.configureCompression((Configuration)config, (HiveCompressionCodec)compressionCodec);
            this.recordWriter = new RecordFileWriter(new Path(targetFile.toURI()), columnNames, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)format), FileFormat.createSchema(format, columnNames, columnTypes), format.getEstimatedWriterSystemMemoryUsage(), config, HiveTestUtils.TYPE_MANAGER, DateTimeZone.UTC, session);
        }

        @Override
        public void writePage(Page page) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.recordWriter.appendRow(page, position);
            }
        }

        @Override
        public void close() {
            this.recordWriter.commit();
        }
    }
}

