/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.benchmark;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Page;
import io.prestosql.spi.type.Type;
import java.util.List;

public class TestData {
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private final List<Page> pages;
    private final int size;

    public TestData(List<String> columnNames, List<Type> columnTypes, List<Page> pages) {
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.columnTypes = ImmutableList.copyOf(columnTypes);
        this.pages = ImmutableList.copyOf(pages);
        this.size = (int)pages.stream().mapToLong(Page::getSizeInBytes).sum();
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public int getSize() {
        return this.size;
    }
}

