/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.benchmark;

import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.benchmark.BenchmarkHiveFileFormat;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import java.io.IOException;
import org.testng.annotations.Test;

public class TestHiveFileFormatBenchmark {
    @Test
    public void testSomeFormats() throws Exception {
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, FileFormat.HIVE_RCBINARY);
    }

    @Test
    public void testAllCompression() throws Exception {
        for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, codec, FileFormat.PRESTO_RCBINARY);
        }
    }

    @Test
    public void testAllDataSets() throws Exception {
        for (BenchmarkHiveFileFormat.DataSet dataSet : BenchmarkHiveFileFormat.DataSet.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(dataSet, HiveCompressionCodec.SNAPPY, FileFormat.PRESTO_RCBINARY);
        }
    }

    private static void executeBenchmark(BenchmarkHiveFileFormat.DataSet dataSet, HiveCompressionCodec codec, FileFormat format) throws IOException {
        BenchmarkHiveFileFormat benchmark = new BenchmarkHiveFileFormat(dataSet, codec, format);
        try {
            benchmark.setup();
            benchmark.read(new BenchmarkHiveFileFormat.CompressionCounter());
            benchmark.write(new BenchmarkHiveFileFormat.CompressionCounter());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed " + dataSet + " " + codec + " " + format, e);
        }
        finally {
            benchmark.tearDown();
        }
    }
}

