/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMetastoreUtil {
    private static final List<FieldSchema> TEST_SCHEMA = ImmutableList.of((Object)new FieldSchema("col1", "bigint", "comment1"), (Object)new FieldSchema("col2", "binary", null), (Object)new FieldSchema("col3", "string", null));
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 1)), (Map)ImmutableMap.of());
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 0, 0, 0, TEST_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION;
    private static final StorageDescriptor TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Table TEST_TABLE_WITH_UNSUPPORTED_FIELDS;
    private static final org.apache.hadoop.hive.metastore.api.Partition TEST_PARTITION_WITH_UNSUPPORTED_FIELDS;

    @Test
    public void testTableRoundTrip() {
        Table table = ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE, TEST_SCHEMA);
        PrincipalPrivileges privileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
        org.apache.hadoop.hive.metastore.api.Table metastoreApiTable = ThriftMetastoreUtil.toMetastoreApiTable((Table)table, (PrincipalPrivileges)privileges);
        Assert.assertEquals((Object)metastoreApiTable, (Object)TEST_TABLE);
    }

    @Test
    public void testPartitionRoundTrip() {
        Partition partition = ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION);
        org.apache.hadoop.hive.metastore.api.Partition metastoreApiPartition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partition);
        Assert.assertEquals((Object)metastoreApiPartition, (Object)TEST_PARTITION);
    }

    @Test
    public void testHiveSchemaTable() {
        Properties expected = MetaStoreUtils.getTableMetadata((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        expected.remove("column.name.delimiter");
        Properties actual = MetastoreUtil.getHiveSchema((Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testHiveSchemaPartition() {
        Properties expected = MetaStoreUtils.getPartitionMetadata((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS, (org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS);
        expected.remove("column.name.delimiter");
        Properties actual = MetastoreUtil.getHiveSchema((Partition)ThriftMetastoreUtil.fromMetastoreApiPartition((org.apache.hadoop.hive.metastore.api.Partition)TEST_PARTITION_WITH_UNSUPPORTED_FIELDS), (Table)ThriftMetastoreUtil.fromMetastoreApiTable((org.apache.hadoop.hive.metastore.api.Table)TEST_TABLE_WITH_UNSUPPORTED_FIELDS, TEST_SCHEMA));
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testComputePartitionKeyFilter() {
        HiveColumnHandle dsColumn = TestMetastoreUtil.partitionColumn("ds");
        HiveColumnHandle typeColumn = TestMetastoreUtil.partitionColumn("type");
        ImmutableList partitionKeys = ImmutableList.of((Object)dsColumn, (Object)typeColumn);
        Domain dsDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2018-05-06")), (Range[])new Range[0]), (boolean)false);
        Domain typeDomain = Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"fruit"), (Object[])new Object[0]), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)HiveColumnHandle.bucketColumnHandle(), (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)123L, (Object[])new Object[0]), (boolean)false)).put((Object)dsColumn, (Object)dsDomain).put((Object)typeColumn, (Object)typeDomain).build());
        TupleDomain filter = MetastoreUtil.computePartitionKeyFilter((List)partitionKeys, (TupleDomain)tupleDomain);
        ((OptionalAssert)Assertions.assertThat((Optional)filter.getDomains()).as("output contains only the partition keys", new Object[0])).contains((Object)ImmutableMap.builder().put((Object)"ds", (Object)dsDomain).put((Object)"type", (Object)typeDomain).build());
    }

    private static HiveColumnHandle partitionColumn(String name) {
        return new HiveColumnHandle(name, 0, HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    }

    static {
        TEST_TABLE.setPrivileges(new PrincipalPrivilegeSet((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        TEST_PARTITION = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 0, 0, TEST_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS = new StorageDescriptor(TEST_SCHEMA, "hdfs://VOL1:9000/db_name/table_name", "com.facebook.hive.orc.OrcInputFormat", "com.facebook.hive.orc.OrcOutputFormat", false, 100, new SerDeInfo("table_name", "com.facebook.hive.orc.OrcSerde", (Map)ImmutableMap.of((Object)"sdk1", (Object)"sdv1", (Object)"sdk2", (Object)"sdv2")), (List)ImmutableList.of((Object)"col2", (Object)"col3"), (List)ImmutableList.of((Object)new Order("col2", 0), (Object)new Order("col3", 1)), (Map)ImmutableMap.of((Object)"sk1", (Object)"sv1"));
        TEST_TABLE_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Table("table_name", "db_name", "owner_name", 1234567890, 1234567891, 34, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (List)ImmutableList.of((Object)new FieldSchema("pk1", "string", "comment pk1"), (Object)new FieldSchema("pk2", "string", null)), (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"), "view original text", "view extended text", "MANAGED_TABLE");
        TEST_PARTITION_WITH_UNSUPPORTED_FIELDS = new org.apache.hadoop.hive.metastore.api.Partition((List)ImmutableList.of((Object)"pk1v", (Object)"pk2v"), "db_name", "table_name", 1234567892, 1234567893, TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS, (Map)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2", (Object)"k3", (Object)"v3"));
        TEST_STORAGE_DESCRIPTOR_WITH_UNSUPPORTED_FIELDS.setSkewedInfo(new SkewedInfo((List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)ImmutableList.of((Object)"val1")), (Map)ImmutableMap.of((Object)ImmutableList.of((Object)"val1"), (Object)"loc1")));
    }
}

