/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.spi.security.PrincipalType;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPrincipalPrivileges {
    @Test
    public void testGetTablePrincipalPrivileges() {
        PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos((Set)ImmutableSet.of((Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.USER, "user001"), (Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.USER, "user002"), (Object)TestPrincipalPrivileges.hivePrivilegeInfo(PrincipalType.ROLE, "role001")));
        Assert.assertNotNull((Object)principalPrivileges);
        Assert.assertEquals((int)principalPrivileges.getUserPrivileges().size(), (int)2);
        Assert.assertEquals((int)principalPrivileges.getRolePrivileges().size(), (int)1);
    }

    private static HivePrivilegeInfo hivePrivilegeInfo(PrincipalType type, String key) {
        return new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, false, new HivePrincipal(type, key), new HivePrincipal(type, key));
    }
}

