/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.alluxio;

import alluxio.grpc.table.Database;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.LayoutSpec;
import alluxio.grpc.table.Partition;
import alluxio.grpc.table.PartitionSpec;
import alluxio.grpc.table.Schema;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.layout.hive.HiveBucketProperty;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.grpc.table.layout.hive.SortingColumn;
import alluxio.grpc.table.layout.hive.Storage;
import alluxio.grpc.table.layout.hive.StorageFormat;
import alluxio.shaded.client.com.google.protobuf.ByteString;

public final class TestingAlluxioMetastoreObjects {
    public static final String DATABASE_NAME = "test_db";
    public static final String OWNER_NAME = "test_owner";
    public static final String COLUMN_NAME = "test_owner";
    public static final String TABLE_NAME = "test_table";
    public static final String LOCATION = "alluxio:///";
    public static final String SPEC_NAME = "spec";

    private TestingAlluxioMetastoreObjects() {
    }

    public static Database.Builder getTestingDatabase() {
        return Database.newBuilder().setDbName(DATABASE_NAME).setDescription("test").setLocation(LOCATION);
    }

    public static FieldSchema.Builder getTestingFieldSchema() {
        return FieldSchema.newBuilder().setId(0).setName("test_owner").setType("int").setComment("");
    }

    public static PartitionInfo.Builder getTestingPartitionInfo() {
        return PartitionInfo.newBuilder().setDbName(DATABASE_NAME).setTableName(TABLE_NAME).addValues("1").setPartitionName(String.format("%s=1", "test_owner")).setStorage(TestingAlluxioMetastoreObjects.getTestingStorage()).addDataCols(TestingAlluxioMetastoreObjects.getTestingFieldSchema());
    }

    public static Layout.Builder getTestingHiveLayout() {
        return Layout.newBuilder().setLayoutSpec(LayoutSpec.newBuilder().setSpec(SPEC_NAME).build()).setLayoutData(TestingAlluxioMetastoreObjects.getTestingPartitionInfo().build().toByteString()).setLayoutType("hive");
    }

    public static Layout.Builder getTestingNonHiveLayout() {
        return Layout.newBuilder().setLayoutData(ByteString.EMPTY).setLayoutSpec(LayoutSpec.newBuilder().setSpec(SPEC_NAME).build()).setLayoutType("not-hive");
    }

    public static TableInfo.Builder getTestingTableInfo() {
        return TableInfo.newBuilder().setLayout(TestingAlluxioMetastoreObjects.getTestingHiveLayout()).setTableName(TABLE_NAME).setOwner("test_owner").setType(TableInfo.TableType.IMPORTED).addPartitionCols(TestingAlluxioMetastoreObjects.getTestingFieldSchema()).setSchema(TestingAlluxioMetastoreObjects.getTestingSchema()).putParameters("table", "parameter");
    }

    public static Schema.Builder getTestingSchema() {
        return Schema.newBuilder().addCols(TestingAlluxioMetastoreObjects.getTestingFieldSchema());
    }

    public static Storage.Builder getTestingStorage() {
        return Storage.newBuilder().setStorageFormat(TestingAlluxioMetastoreObjects.getTestingStorageFormat()).setLocation(LOCATION).setBucketProperty(TestingAlluxioMetastoreObjects.getTestingHiveBucketProperty()).setSkewed(false).putSerdeParameters("serde_param_key", "serde_param_value");
    }

    public static StorageFormat.Builder getTestingStorageFormat() {
        return StorageFormat.newBuilder().setSerde("serde").setInputFormat("TextFile").setOutputFormat("TextFile").putSerdelibParameters("serdelib_key", "serdelib_value");
    }

    public static HiveBucketProperty.Builder getTestingHiveBucketProperty() {
        return HiveBucketProperty.newBuilder().addBucketedBy("test_owner").setBucketCount(1L).addSortedBy(TestingAlluxioMetastoreObjects.getTestingSortingColumn());
    }

    public static SortingColumn.Builder getTestingSortingColumn() {
        return SortingColumn.newBuilder().setColumnName("test_owner").setOrder(SortingColumn.SortingOrder.ASCENDING);
    }

    public static Partition.Builder getTestingPartition() {
        return Partition.newBuilder().setBaseLayout(TestingAlluxioMetastoreObjects.getTestingHiveLayout()).setPartitionSpec(TestingAlluxioMetastoreObjects.getTestingPartitionSpec());
    }

    public static PartitionSpec.Builder getTestingPartitionSpec() {
        return PartitionSpec.newBuilder().setSpec(SPEC_NAME);
    }
}

