/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastore;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingConnectorSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCachingHiveMetastore {
    private static final HiveIdentity IDENTITY = new HiveIdentity(TestingConnectorSession.SESSION);
    private static final PartitionStatistics TEST_STATS = PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)"column", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build();
    private MockThriftMetastoreClient mockClient;
    private ListeningExecutorService executor;
    private CachingHiveMetastore metastore;
    private ThriftMetastoreStats stats;

    @BeforeMethod
    public void setUp() {
        this.mockClient = new MockThriftMetastoreClient();
        ThriftHiveMetastore thriftHiveMetastore = this.createThriftHiveMetastore();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s"))));
        this.metastore = (CachingHiveMetastore)CachingHiveMetastore.cachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore((ThriftMetastore)thriftHiveMetastore), (Executor)this.executor, (Duration)new Duration(5.0, TimeUnit.MINUTES), Optional.of(new Duration(1.0, TimeUnit.MINUTES)), (long)1000L);
        this.stats = thriftHiveMetastore.getStats();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.metastore = null;
    }

    private ThriftHiveMetastore createThriftHiveMetastore() {
        MockMetastoreLocator metastoreLocator = new MockMetastoreLocator(this.mockClient);
        return new ThriftHiveMetastore((MetastoreLocator)metastoreLocator, new HiveConfig(), new MetastoreConfig(), new ThriftMetastoreConfig(), HiveTestUtils.HDFS_ENVIRONMENT, false);
    }

    @Test
    public void testGetAllDatabases() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getDatabaseNamesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getDatabaseNamesStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testGetAllTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getTableNamesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableNamesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableNamesStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableNamesStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testInvalidDbGetAllTAbles() {
        Assert.assertTrue((boolean)this.metastore.getAllTables("baddb").isEmpty());
    }

    @Test
    public void testGetTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable(IDENTITY, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getTable(IDENTITY, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertNotNull((Object)this.metastore.getTable(IDENTITY, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testSetTableAuthorization() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable(IDENTITY, "testdb", "testtbl"));
        Assert.assertNotNull((Object)this.metastore.getDatabase("testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.setTableOwner(IDENTITY, "testdb", "testtbl", new HivePrincipal(PrincipalType.USER, "ignore"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertNotNull((Object)this.metastore.getTable(IDENTITY, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertNotNull((Object)this.metastore.getDatabase("testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    @Test
    public void testInvalidDbGetTable() {
        Assert.assertFalse((boolean)this.metastore.getTable(IDENTITY, "baddb", "testtbl").isPresent());
        Assert.assertEquals((long)this.stats.getGetTable().getThriftExceptions().getTotalCount(), (long)0L);
        Assert.assertEquals((long)this.stats.getGetTable().getTotalFailures().getTotalCount(), (long)0L);
    }

    @Test
    public void testGetPartitionNames() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testInvalidGetPartitionNamesByFilterAll() {
        Assert.assertTrue((boolean)this.metastore.getPartitionNamesByFilter(IDENTITY, "baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).isEmpty());
    }

    @Test
    public void testGetPartitionNamesByParts() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getPartitionFilterStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getPartitionFilterStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getPartitionFilterStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getPartitionFilterStats().getHitRate(), (Object)0.3333333333333333);
        ImmutableList partitionColumnNames = ImmutableList.of((Object)"date_key", (Object)"key");
        HiveColumnHandle dateKeyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(0)), (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        HiveColumnHandle keyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(1)), (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dateKeyColumn, (Object)keyColumn);
        TupleDomain withNoFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.all());
        TupleDomain withSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val"), (Object[])new Object[0]), (boolean)false)).build()));
        TupleDomain withNoSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val1"), (boolean)true, (Object)Slices.utf8Slice((String)"val2"), (boolean)true), (Range[])new Range[0]), (boolean)false)).build()));
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)0.0);
        this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", (List)partitionColumnNames, withNoFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)0.0);
        this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", (List)partitionColumnNames, withSingleValueFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)1.0);
        this.metastore.getPartitionNamesByFilter(IDENTITY, "testdb", "testtbl", (List)partitionColumnNames, withNoSingleValueFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)2.0);
    }

    @Test
    public void testInvalidGetPartitionNamesByParts() {
        Assert.assertFalse((boolean)this.metastore.getPartitionNamesByFilter(IDENTITY, "baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).isPresent());
    }

    @Test
    public void testGetPartitionsByNames() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable(IDENTITY, "testdb", "testtbl").get();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition2")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.flushCache();
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
    }

    @Test
    public void testListRoles() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getRolesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getRolesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.createRole("role", "grantor");
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.dropRole("testrole");
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertEquals((long)this.metastore.getRolesStats().getRequestCount(), (long)5L);
        Assert.assertEquals((Object)this.metastore.getRolesStats().getHitRate(), (Object)0.2);
    }

    @Test
    public void testGetTableStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable(IDENTITY, "testdb", "testtbl").get();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Object)this.metastore.getTableStatistics(IDENTITY, table), (Object)TEST_STATS);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableStatisticsStats().getRequestCount(), (long)1L);
        Assert.assertEquals((Object)this.metastore.getTableStatisticsStats().getHitRate(), (Object)0.0);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.5);
    }

    @Test
    public void testGetPartitionStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable(IDENTITY, "testdb", "testtbl").get();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Partition partition = (Partition)this.metastore.getPartition(IDENTITY, table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1).get();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((Map)this.metastore.getPartitionStatistics(IDENTITY, table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((long)this.metastore.getPartitionStatisticsStats().getRequestCount(), (long)1L);
        Assert.assertEquals((Object)this.metastore.getPartitionStatisticsStats().getHitRate(), (Object)0.0);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.6666666666666666);
        Assert.assertEquals((long)this.metastore.getPartitionStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getPartitionStats().getHitRate(), (Object)0.5);
    }

    @Test
    public void testUpdatePartitionStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        HiveMetastoreClosure hiveMetastoreClosure = new HiveMetastoreClosure((HiveMetastore)this.metastore);
        Table table = (Table)hiveMetastoreClosure.getTable(IDENTITY, "testdb", "testtbl").get();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        hiveMetastoreClosure.updatePartitionStatistics(IDENTITY, table.getDatabaseName(), table.getTableName(), "key=testpartition1", Function.identity());
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
    }

    @Test
    public void testInvalidGetPartitionsByNames() {
        Table table = (Table)this.metastore.getTable(IDENTITY, "testdb", "testtbl").get();
        Map partitionsByNames = this.metastore.getPartitionsByNames(IDENTITY, table, (List)ImmutableList.of((Object)"key=badpartition1"));
        Assert.assertEquals((int)partitionsByNames.size(), (int)1);
        Optional onlyElement = (Optional)Iterables.getOnlyElement(partitionsByNames.values());
        Assert.assertFalse((boolean)onlyElement.isPresent());
    }

    @Test
    public void testNoCacheExceptions() {
        this.mockClient.setThrowException(true);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testCachingHiveMetastoreCreationWithTtlOnly() {
        CachingHiveMetastoreConfig config = new CachingHiveMetastoreConfig();
        config.setMetastoreCacheTtl(new Duration(10.0, TimeUnit.MILLISECONDS));
        CachingHiveMetastore metastore = this.createMetastoreWithDirectExecutor(config);
        Assertions.assertThat((Object)metastore).isNotNull();
    }

    @Test
    public void testCachingHiveMetastoreCreationViaMemoize() {
        ThriftHiveMetastore thriftHiveMetastore = this.createThriftHiveMetastore();
        this.metastore = CachingHiveMetastore.memoizeMetastore((HiveMetastore)new BridgingHiveMetastore((ThriftMetastore)thriftHiveMetastore), (long)1000L);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)0L);
    }

    private CachingHiveMetastore createMetastoreWithDirectExecutor(CachingHiveMetastoreConfig config) {
        return (CachingHiveMetastore)CachingHiveMetastore.cachingHiveMetastore((HiveMetastore)new BridgingHiveMetastore((ThriftMetastore)this.createThriftHiveMetastore()), (Executor)MoreExecutors.directExecutor(), (CachingHiveMetastoreConfig)config);
    }

    private static class MockMetastoreLocator
    implements MetastoreLocator {
        private final ThriftMetastoreClient client;

        private MockMetastoreLocator(ThriftMetastoreClient client) {
            this.client = client;
        }

        public ThriftMetastoreClient createMetastoreClient(Optional<String> delegationToken) {
            return this.client;
        }
    }
}

