/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.cache;

import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.plugin.hive.metastore.cache.ReentrantBoundedExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestReentrantBoundedExecutor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReentrantBoundedExecutor() throws ExecutionException, InterruptedException {
        AtomicInteger callCounter = new AtomicInteger();
        SettableFuture future = SettableFuture.create();
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            ReentrantBoundedExecutor reentrantExecutor = new ReentrantBoundedExecutor((Executor)executor, 1);
            reentrantExecutor.execute(() -> TestReentrantBoundedExecutor.lambda$testReentrantBoundedExecutor$1(callCounter, (Executor)reentrantExecutor, future));
            future.get();
            SettableFuture secondFuture = SettableFuture.create();
            reentrantExecutor.execute(() -> secondFuture.set(null));
            secondFuture.get();
            Assert.assertEquals((int)callCounter.get(), (int)2);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$testReentrantBoundedExecutor$1(AtomicInteger callCounter, Executor reentrantExecutor, SettableFuture future) {
        callCounter.incrementAndGet();
        reentrantExecutor.execute(() -> {
            callCounter.incrementAndGet();
            future.set(null);
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

