/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.glue.TestingMetastoreObjects;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueInputConverter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGlueInputConverter {
    private final Database testDb = TestingMetastoreObjects.getPrestoTestDatabase();
    private final Table testTbl = TestingMetastoreObjects.getPrestoTestTable(this.testDb.getDatabaseName());
    private final Partition testPartition = TestingMetastoreObjects.getPrestoTestPartition(this.testDb.getDatabaseName(), this.testTbl.getTableName(), (List<String>)ImmutableList.of((Object)"val1"));

    @Test
    public void testConvertDatabase() {
        DatabaseInput dbInput = GlueInputConverter.convertDatabase((Database)this.testDb);
        Assert.assertEquals((String)dbInput.getName(), (String)this.testDb.getDatabaseName());
        Assert.assertEquals((String)dbInput.getDescription(), (String)((String)this.testDb.getComment().get()));
        Assert.assertEquals((String)dbInput.getLocationUri(), (String)((String)this.testDb.getLocation().get()));
        Assert.assertEquals((Map)dbInput.getParameters(), (Map)this.testDb.getParameters());
    }

    @Test
    public void testConvertTable() {
        TableInput tblInput = GlueInputConverter.convertTable((Table)this.testTbl);
        Assert.assertEquals((String)tblInput.getName(), (String)this.testTbl.getTableName());
        Assert.assertEquals((String)tblInput.getOwner(), (String)this.testTbl.getOwner());
        Assert.assertEquals((String)tblInput.getTableType(), (String)this.testTbl.getTableType());
        Assert.assertEquals((Map)tblInput.getParameters(), (Map)this.testTbl.getParameters());
        TestGlueInputConverter.assertColumnList(tblInput.getStorageDescriptor().getColumns(), this.testTbl.getDataColumns());
        TestGlueInputConverter.assertColumnList(tblInput.getPartitionKeys(), this.testTbl.getPartitionColumns());
        TestGlueInputConverter.assertStorage(tblInput.getStorageDescriptor(), this.testTbl.getStorage());
        Assert.assertEquals((String)tblInput.getViewExpandedText(), (String)((String)this.testTbl.getViewExpandedText().get()));
        Assert.assertEquals((String)tblInput.getViewOriginalText(), (String)((String)this.testTbl.getViewOriginalText().get()));
    }

    @Test
    public void testConvertPartition() {
        PartitionInput partitionInput = GlueInputConverter.convertPartition((Partition)this.testPartition);
        Assert.assertEquals((Map)partitionInput.getParameters(), (Map)this.testPartition.getParameters());
        TestGlueInputConverter.assertStorage(partitionInput.getStorageDescriptor(), this.testPartition.getStorage());
        Assert.assertEquals((Collection)partitionInput.getValues(), (Collection)this.testPartition.getValues());
    }

    private static void assertColumnList(List<com.amazonaws.services.glue.model.Column> actual, List<Column> expected) {
        if (expected == null) {
            Assert.assertNull(actual);
        }
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueInputConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(com.amazonaws.services.glue.model.Column actual, Column expected) {
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getType(), (String)expected.getType().getHiveTypeName().toString());
        Assert.assertEquals((String)actual.getComment(), (String)((String)expected.getComment().get()));
    }

    private static void assertStorage(StorageDescriptor actual, Storage expected) {
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((String)actual.getSerdeInfo().getSerializationLibrary(), (String)expected.getStorageFormat().getSerDe());
        Assert.assertEquals((String)actual.getInputFormat(), (String)expected.getStorageFormat().getInputFormat());
        Assert.assertEquals((String)actual.getOutputFormat(), (String)expected.getStorageFormat().getOutputFormat());
        if (expected.getBucketProperty().isPresent()) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)expected.getBucketProperty().get();
            Assert.assertEquals((Collection)actual.getBucketColumns(), (Collection)bucketProperty.getBucketedBy());
            Assert.assertEquals((int)actual.getNumberOfBuckets(), (int)bucketProperty.getBucketCount());
        }
    }
}

