/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.util.CollectionUtils;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.glue.TestingMetastoreObjects;
import io.prestosql.plugin.hive.metastore.glue.converter.GlueToPrestoConverter;
import io.prestosql.spi.security.PrincipalType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.TableType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGlueToPrestoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";
    private com.amazonaws.services.glue.model.Database testDatabase;
    private com.amazonaws.services.glue.model.Table testTable;
    private com.amazonaws.services.glue.model.Partition testPartition;

    @BeforeMethod
    public void setup() {
        this.testDatabase = TestingMetastoreObjects.getGlueTestDatabase();
        this.testTable = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        this.testPartition = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), (List<String>)ImmutableList.of((Object)"val1"));
    }

    private static GlueToPrestoConverter.GluePartitionConverter createPartitionConverter(com.amazonaws.services.glue.model.Table table) {
        return new GlueToPrestoConverter.GluePartitionConverter(GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)table, (String)table.getDatabaseName()));
    }

    @Test
    public void testConvertDatabase() {
        Database prestoDatabase = GlueToPrestoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDatabase);
        Assert.assertEquals((String)prestoDatabase.getDatabaseName(), (String)this.testDatabase.getName());
        Assert.assertEquals((String)((String)prestoDatabase.getLocation().get()), (String)this.testDatabase.getLocationUri());
        Assert.assertEquals((String)((String)prestoDatabase.getComment().get()), (String)this.testDatabase.getDescription());
        Assert.assertEquals((Map)prestoDatabase.getParameters(), (Map)this.testDatabase.getParameters());
        Assert.assertEquals((String)prestoDatabase.getOwnerName(), (String)PUBLIC_OWNER);
        Assert.assertEquals((Object)prestoDatabase.getOwnerType(), (Object)PrincipalType.ROLE);
    }

    @Test
    public void testConvertTable() {
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertEquals((String)prestoTable.getTableName(), (String)this.testTable.getName());
        Assert.assertEquals((String)prestoTable.getDatabaseName(), (String)this.testDatabase.getName());
        Assert.assertEquals((String)prestoTable.getTableType(), (String)this.testTable.getTableType());
        Assert.assertEquals((String)prestoTable.getOwner(), (String)this.testTable.getOwner());
        Assert.assertEquals((Map)prestoTable.getParameters(), (Map)this.testTable.getParameters());
        TestGlueToPrestoConverter.assertColumnList(prestoTable.getDataColumns(), this.testTable.getStorageDescriptor().getColumns());
        TestGlueToPrestoConverter.assertColumnList(prestoTable.getPartitionColumns(), this.testTable.getPartitionKeys());
        TestGlueToPrestoConverter.assertStorage(prestoTable.getStorage(), this.testTable.getStorageDescriptor());
        Assert.assertEquals((String)((String)prestoTable.getViewOriginalText().get()), (String)this.testTable.getViewOriginalText());
        Assert.assertEquals((String)((String)prestoTable.getViewExpandedText().get()), (String)this.testTable.getViewExpandedText());
    }

    @Test
    public void testConvertTableWithoutTableType() {
        com.amazonaws.services.glue.model.Table table = TestingMetastoreObjects.getGlueTestTable(this.testDatabase.getName());
        table.setTableType(null);
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)table, (String)this.testDatabase.getName());
        Assert.assertEquals((String)prestoTable.getTableType(), (String)TableType.EXTERNAL_TABLE.name());
    }

    @Test
    public void testConvertTableNullPartitions() {
        this.testTable.setPartitionKeys(null);
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertTrue((boolean)prestoTable.getPartitionColumns().isEmpty());
    }

    @Test
    public void testConvertTableUppercaseColumnType() {
        com.amazonaws.services.glue.model.Column uppercaseColumn = TestingMetastoreObjects.getGlueTestColumn().withType("String");
        this.testTable.getStorageDescriptor().setColumns((Collection)ImmutableList.of((Object)uppercaseColumn));
        GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
    }

    @Test
    public void testConvertPartition() {
        GlueToPrestoConverter.GluePartitionConverter converter = TestGlueToPrestoConverter.createPartitionConverter(this.testTable);
        Partition prestoPartition = converter.apply(this.testPartition);
        Assert.assertEquals((String)prestoPartition.getDatabaseName(), (String)this.testPartition.getDatabaseName());
        Assert.assertEquals((String)prestoPartition.getTableName(), (String)this.testPartition.getTableName());
        TestGlueToPrestoConverter.assertColumnList(prestoPartition.getColumns(), this.testPartition.getStorageDescriptor().getColumns());
        Assert.assertEquals((Collection)prestoPartition.getValues(), (Collection)this.testPartition.getValues());
        TestGlueToPrestoConverter.assertStorage(prestoPartition.getStorage(), this.testPartition.getStorageDescriptor());
        Assert.assertEquals((Map)prestoPartition.getParameters(), (Map)this.testPartition.getParameters());
    }

    @Test
    public void testPartitionConversionMemoization() {
        String fakeS3Location = "s3://some-fake-location";
        this.testPartition.getStorageDescriptor().setLocation(fakeS3Location);
        com.amazonaws.services.glue.model.Partition partitionTwo = TestingMetastoreObjects.getGlueTestPartition(this.testDatabase.getName(), this.testTable.getName(), new ArrayList<String>(this.testPartition.getValues()));
        partitionTwo.getStorageDescriptor().setColumns(new ArrayList(this.testPartition.getStorageDescriptor().getColumns()));
        partitionTwo.getStorageDescriptor().setBucketColumns(new ArrayList(this.testPartition.getStorageDescriptor().getBucketColumns()));
        partitionTwo.getStorageDescriptor().setLocation(fakeS3Location);
        partitionTwo.getStorageDescriptor().setInputFormat(this.testPartition.getStorageDescriptor().getInputFormat());
        partitionTwo.getStorageDescriptor().setOutputFormat(this.testPartition.getStorageDescriptor().getOutputFormat());
        partitionTwo.getStorageDescriptor().setParameters(new HashMap(this.testPartition.getStorageDescriptor().getParameters()));
        GlueToPrestoConverter.GluePartitionConverter converter = TestGlueToPrestoConverter.createPartitionConverter(this.testTable);
        Partition prestoPartition = converter.apply(this.testPartition);
        Partition prestoPartition2 = converter.apply(partitionTwo);
        Assert.assertNotSame((Object)prestoPartition, (Object)prestoPartition2);
        Assert.assertSame((Object)prestoPartition2.getDatabaseName(), (Object)prestoPartition.getDatabaseName());
        Assert.assertSame((Object)prestoPartition2.getTableName(), (Object)prestoPartition.getTableName());
        Assert.assertSame((Object)prestoPartition2.getColumns(), (Object)prestoPartition.getColumns());
        Assert.assertSame((Object)prestoPartition2.getParameters(), (Object)prestoPartition.getParameters());
        Assert.assertNotSame((Object)prestoPartition2.getValues(), (Object)prestoPartition.getValues());
        Storage storage = prestoPartition.getStorage();
        Storage storage2 = prestoPartition2.getStorage();
        Assert.assertSame((Object)storage2.getStorageFormat(), (Object)storage.getStorageFormat());
        Assert.assertSame((Object)storage2.getBucketProperty(), (Object)storage.getBucketProperty());
        Assert.assertSame((Object)storage2.getSerdeParameters(), (Object)storage.getSerdeParameters());
        Assert.assertNotSame((Object)storage2.getLocation(), (Object)storage.getLocation());
    }

    @Test
    public void testDatabaseNullParameters() {
        this.testDatabase.setParameters(null);
        Assert.assertNotNull((Object)GlueToPrestoConverter.convertDatabase((com.amazonaws.services.glue.model.Database)this.testDatabase).getParameters());
    }

    @Test
    public void testTableNullParameters() {
        this.testTable.setParameters(null);
        this.testTable.getStorageDescriptor().getSerdeInfo().setParameters(null);
        Table prestoTable = GlueToPrestoConverter.convertTable((com.amazonaws.services.glue.model.Table)this.testTable, (String)this.testDatabase.getName());
        Assert.assertNotNull((Object)prestoTable.getParameters());
        Assert.assertNotNull((Object)prestoTable.getStorage().getSerdeParameters());
    }

    @Test
    public void testPartitionNullParameters() {
        this.testPartition.setParameters(null);
        Assert.assertNotNull((Object)TestGlueToPrestoConverter.createPartitionConverter(this.testTable).apply(this.testPartition).getParameters());
    }

    private static void assertColumnList(List<Column> actual, List<com.amazonaws.services.glue.model.Column> expected) {
        if (expected == null) {
            Assert.assertNull(actual);
        }
        Assert.assertEquals((int)actual.size(), (int)expected.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestGlueToPrestoConverter.assertColumn(actual.get(i), expected.get(i));
        }
    }

    private static void assertColumn(Column actual, com.amazonaws.services.glue.model.Column expected) {
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((String)actual.getType().getHiveTypeName().toString(), (String)expected.getType());
        Assert.assertEquals((String)((String)actual.getComment().get()), (String)expected.getComment());
    }

    private static void assertStorage(Storage actual, StorageDescriptor expected) {
        Assert.assertEquals((String)actual.getLocation(), (String)expected.getLocation());
        Assert.assertEquals((String)actual.getStorageFormat().getSerDe(), (String)expected.getSerdeInfo().getSerializationLibrary());
        Assert.assertEquals((String)actual.getStorageFormat().getInputFormat(), (String)expected.getInputFormat());
        Assert.assertEquals((String)actual.getStorageFormat().getOutputFormat(), (String)expected.getOutputFormat());
        if (!CollectionUtils.isNullOrEmpty((Collection)expected.getBucketColumns())) {
            HiveBucketProperty bucketProperty = (HiveBucketProperty)actual.getBucketProperty().get();
            Assert.assertEquals((Collection)bucketProperty.getBucketedBy(), (Collection)expected.getBucketColumns());
            Assert.assertEquals((int)bucketProperty.getBucketCount(), (int)expected.getNumberOfBuckets());
        }
    }
}

