/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.AbstractTestHiveLocal;
import io.prestosql.plugin.hive.HiveMetastoreClosure;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.glue.DefaultGlueMetastoreTableFilterProvider;
import io.prestosql.plugin.hive.metastore.glue.DisabledGlueColumnStatisticsProvider;
import io.prestosql.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.prestosql.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.prestosql.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.prestosql.plugin.hive.metastore.glue.PartitionFilterBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.TestingConnectorSession;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.hadoop.hive.common.FileUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHiveGlueMetastore
extends AbstractTestHiveLocal {
    private static final HiveIdentity HIVE_CONTEXT = new HiveIdentity(TestingConnectorSession.SESSION);
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS = ImmutableList.builder().add((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT)).build();
    private static final String PARTITION_KEY = "part_key_1";
    private static final String PARTITION_KEY2 = "part_key_2";
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("part_key_2", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)TinyintType.TINYINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)SmallintType.SMALLINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)IntegerType.INTEGER)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)BigintType.BIGINT)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)PartitionFilterBuilder.DECIMAL_TYPE)).build();
    private static final List<ColumnMetadata> CREATE_TABLE_COLUMNS_PARTITIONED_DATE = ImmutableList.builder().addAll(CREATE_TABLE_COLUMNS).add((Object)new ColumnMetadata("part_key_1", (Type)DateType.DATE)).build();
    private static final List<String> VARCHAR_PARTITION_VALUES = ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01");

    public TestHiveGlueMetastore() {
        super("test_glue" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", ""));
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void initialize() {
        super.initialize();
    }

    @Override
    protected HiveMetastore createMetastore(File tempDir) {
        GlueHiveMetastoreConfig glueConfig = new GlueHiveMetastoreConfig();
        glueConfig.setDefaultWarehouseDir(tempDir.toURI().toString());
        glueConfig.setAssumeCanonicalPartitionKeys(true);
        BoundedExecutor executor = new BoundedExecutor((Executor)this.executor, 10);
        return new GlueHiveMetastore(HiveTestUtils.HDFS_ENVIRONMENT, glueConfig, (GlueColumnStatisticsProvider)new DisabledGlueColumnStatisticsProvider(), (Executor)executor, Optional.empty(), new DefaultGlueMetastoreTableFilterProvider(new MetastoreConfig().setHideDeltaLakeTables(true)).get());
    }

    @Override
    public void testRenameTable() {
    }

    @Override
    public void testPartitionStatisticsSampling() {
    }

    @Override
    public void testUpdateTableColumnStatistics() {
    }

    @Override
    public void testUpdateTableColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testUpdatePartitionColumnStatistics() {
    }

    @Override
    public void testUpdatePartitionColumnStatisticsEmptyOptionalFields() {
    }

    @Override
    public void testStorePartitionWithStatistics() throws Exception {
        this.testStorePartitionWithStatistics(STATISTICS_PARTITIONED_TABLE_COLUMNS, BASIC_STATISTICS_1, BASIC_STATISTICS_2, BASIC_STATISTICS_1, EMPTY_TABLE_STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testGetPartitions() throws Exception {
        try {
            SchemaTableName tableName = this.temporaryTable("get_partitions");
            this.createDummyPartitionedTable(tableName, CREATE_TABLE_COLUMNS_PARTITIONED);
            HiveMetastore metastoreClient = this.getMetastoreClient();
            Optional partitionNames = metastoreClient.getPartitionNamesByFilter(HIVE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), (List)ImmutableList.of((Object)"ds"), TupleDomain.all());
            Assert.assertTrue((boolean)partitionNames.isPresent());
            Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)ImmutableList.of((Object)"ds=2016-01-01", (Object)"ds=2016-01-02"));
        }
        finally {
            this.dropTable(this.tablePartitionFormat);
        }
    }

    @Test
    public void testGetDatabasesLogsStats() {
        GlueHiveMetastore metastore = (GlueHiveMetastore)this.getMetastoreClient();
        GlueMetastoreStats stats = metastore.getStats();
        double initialCallCount = stats.getGetAllDatabases().getTime().getAllTime().getCount();
        long initialFailureCount = stats.getGetAllDatabases().getTotalFailures().getTotalCount();
        this.getMetastoreClient().getAllDatabases();
        Assert.assertEquals((Object)stats.getGetAllDatabases().getTime().getAllTime().getCount(), (Object)(initialCallCount + 1.0));
        Assert.assertTrue((stats.getGetAllDatabases().getTime().getAllTime().getAvg() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)stats.getGetAllDatabases().getTotalFailures().getTotalCount(), (long)initialFailureCount);
    }

    @Test
    public void testGetDatabaseFailureLogsStats() {
        GlueHiveMetastore metastore = (GlueHiveMetastore)this.getMetastoreClient();
        GlueMetastoreStats stats = metastore.getStats();
        long initialFailureCount = stats.getGetDatabase().getTotalFailures().getTotalCount();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getMetastoreClient().getDatabase(null)).isInstanceOf(PrestoException.class)).hasMessageStartingWith("Database name cannot be equal to null or empty");
        Assert.assertEquals((long)stats.getGetDatabase().getTotalFailures().getTotalCount(), (long)(initialFailureCount + 1L));
    }

    @Test
    public void testGetPartitionsFilterVarChar() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-01-01").build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01"), (boolean)true, (Object)Slices.utf8Slice((String)"2020-03-01"), (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-01-01", "2020-02-01").build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-03-01")), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-02-01", (Object)"2020-03-01"), (Object)ImmutableList.of((Object)"2020-03-01", (Object)"2020-04-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01"), (Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterBigInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addBigintValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)BigintType.BIGINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addBigintValues(PARTITION_KEY, 1L, 1000000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)BigintType.BIGINT, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_BIGINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterInteger() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addIntegerValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)IntegerType.INTEGER, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addIntegerValues(PARTITION_KEY, 1L, 1000000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)IntegerType.INTEGER, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_INTEGER, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"1000000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"1000000")));
    }

    @Test
    public void testGetPartitionsFilterSmallInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addSmallintValues(PARTITION_KEY, 1000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)SmallintType.SMALLINT, (Object)100L, (boolean)true, (Object)1000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)SmallintType.SMALLINT, (Object)100L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addSmallintValues(PARTITION_KEY, 1L, 10000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)SmallintType.SMALLINT, (Object)1000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_SMALLINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"1000"), (Object)ImmutableList.of((Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"100", (Object)"1000"), (Object)ImmutableList.of((Object)"100", (Object)"1000", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"10000"), (Object)ImmutableList.of((Object)"1", (Object)"100"), (Object)ImmutableList.of((Object)"1", (Object)"100", (Object)"1000", (Object)"10000")));
    }

    @Test
    public void testGetPartitionsFilterTinyInt() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 127L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)10L, (boolean)true, (Object)100L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)10L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 1L, 127L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)100L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"127"), (Object)ImmutableList.of((Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"10", (Object)"100"), (Object)ImmutableList.of((Object)"10", (Object)"100", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"127"), (Object)ImmutableList.of((Object)"1", (Object)"10"), (Object)ImmutableList.of((Object)"1", (Object)"10", (Object)"100", (Object)"127")));
    }

    @Test
    public void testGetPartitionsFilterTinyIntNegatives() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, -128L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)TinyintType.TINYINT, (Object)0L, (boolean)true, (Object)50L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addTinyintValues(PARTITION_KEY, 0L, -128L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)TinyintType.TINYINT, (Object)0L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TINYINT, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"-128", (Object)"0", (Object)"50", (Object)"100"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"50"), (Object)ImmutableList.of((Object)"0", (Object)"100", (Object)"50"), (Object)ImmutableList.of((Object)"-128", (Object)"0"), (Object)ImmutableList.of((Object)"-128"), (Object)ImmutableList.of((Object)"-128", (Object)"0", (Object)"100", (Object)"50")));
    }

    @Test
    public void testGetPartitionsFilterDecimal() throws Exception {
        String value1 = "1.000";
        String value2 = "10.134";
        String value3 = "25.111";
        String value4 = "30.333";
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addDecimalValues(PARTITION_KEY, value1).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value2)), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value2), (boolean)true, (Object)PartitionFilterBuilder.decimalOf(value3), (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf(value3)), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addDecimalValues(PARTITION_KEY, value1, value4).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)PartitionFilterBuilder.DECIMAL_TYPE, (Object)PartitionFilterBuilder.decimalOf("25.5")), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DECIMAL, PARTITION_KEY, (List<String>)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)value1), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value3, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value4), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3), (Object)ImmutableList.of((Object)value1, (Object)value2, (Object)value3, (Object)value4)));
    }

    @Test
    public void testGetPartitionsFilterDate() throws Exception {
        TupleDomain<String> singleEquals = new PartitionFilterBuilder().addDateValues(PARTITION_KEY, 18000L).build();
        TupleDomain<String> greaterThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThan((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        TupleDomain<String> betweenInclusive = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.range((Type)DateType.DATE, (Object)19000L, (boolean)true, (Object)20000L, (boolean)true), new Range[0]).build();
        TupleDomain<String> greaterThanOrEquals = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)DateType.DATE, (Object)19000L), new Range[0]).build();
        TupleDomain<String> inClause = new PartitionFilterBuilder().addDateValues(PARTITION_KEY, 18000L, 21000L).build();
        TupleDomain<String> lessThan = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.lessThan((Type)DateType.DATE, (Object)20000L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_DATE, PARTITION_KEY, (List<String>)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (List<TupleDomain<String>>)ImmutableList.of(singleEquals, greaterThan, betweenInclusive, greaterThanOrEquals, inClause, lessThan, (Object)TupleDomain.all()), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000"), (Object)ImmutableList.of((Object)"18000", (Object)"19000", (Object)"20000", (Object)"21000")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeys() throws Exception {
        TupleDomain<String> equalsFilter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "2020-03-01").addBigintValues(PARTITION_KEY2, 300L).build();
        TupleDomain<String> rangeFilter = new PartitionFilterBuilder().addRanges(PARTITION_KEY, Range.greaterThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-02-01")), new Range[0]).addRanges(PARTITION_KEY2, Range.greaterThan((Type)BigintType.BIGINT, (Object)200L), new Range[0]).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (List<TupleDomain<String>>)ImmutableList.of(equalsFilter, rangeFilter, (Object)TupleDomain.all()), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300")), (Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (Object)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400"))));
    }

    @Test
    public void testGetPartitionsFilterMaxLengthWildcard() throws Exception {
        TupleDomain<String> filter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "x".repeat(2048)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(filter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterTwoPartitionKeysPartialQuery() throws Exception {
        TupleDomain<String> equalsFilter = new PartitionFilterBuilder().addStringValues(PARTITION_KEY, "x".repeat(2048)).addBigintValues(PARTITION_KEY2, 300L).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_TWO_KEYS, (List<String>)ImmutableList.of((Object)PARTITION_KEY, (Object)PARTITION_KEY2), (List<PartitionValues>)ImmutableList.of((Object)PartitionValues.make("2020-01-01", "100"), (Object)PartitionValues.make("2020-02-01", "200"), (Object)PartitionValues.make("2020-03-01", "300"), (Object)PartitionValues.make("2020-04-01", "400")), (List<TupleDomain<String>>)ImmutableList.of(equalsFilter), (List<List<PartitionValues>>)ImmutableList.of((Object)ImmutableList.of((Object)PartitionValues.make("2020-03-01", "300"))));
    }

    @Test
    public void testGetPartitionsFilterNone() throws Exception {
        TupleDomain<String> noneFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.none((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of((Object)TupleDomain.none(), noneFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of()));
    }

    @Test
    public void testGetPartitionsFilterNotNull() throws Exception {
        TupleDomain<String> notNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.notNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(notNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"2020-01-01", (Object)"2020-02-01", (Object)"2020-03-01", (Object)"2020-04-01")));
    }

    @Test
    public void testGetPartitionsFilterIsNull() throws Exception {
        TupleDomain<String> isNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, VARCHAR_PARTITION_VALUES, (List<TupleDomain<String>>)ImmutableList.of(isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of()));
    }

    @Test
    public void testGetPartitionsFilterIsNullWithValue() throws Exception {
        TupleDomain<String> isNullFilter = new PartitionFilterBuilder().addDomain(PARTITION_KEY, Domain.onlyNull((Type)VarcharType.VARCHAR)).build();
        ArrayList<String> partitionList = new ArrayList<String>();
        partitionList.add(null);
        this.doGetPartitionsFilterTest(CREATE_TABLE_COLUMNS_PARTITIONED_VARCHAR, PARTITION_KEY, partitionList, (List<TupleDomain<String>>)ImmutableList.of(isNullFilter), (List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"__HIVE_DEFAULT_PARTITION__")));
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, String partitionColumnName, List<String> partitionStringValues, List<TupleDomain<String>> filterList, List<List<String>> expectedSingleValueList) throws Exception {
        List partitionValuesList = (List)partitionStringValues.stream().map(xva$0 -> PartitionValues.make(xva$0)).collect(ImmutableList.toImmutableList());
        List expectedPartitionValuesList = (List)expectedSingleValueList.stream().map(expectedValue -> (ImmutableList)expectedValue.stream().map(xva$0 -> PartitionValues.make(xva$0)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        this.doGetPartitionsFilterTest(columnMetadata, (List<String>)ImmutableList.of((Object)partitionColumnName), partitionValuesList, filterList, expectedPartitionValuesList);
    }

    private void doGetPartitionsFilterTest(List<ColumnMetadata> columnMetadata, List<String> partitionColumnNames, List<PartitionValues> partitionValues, List<TupleDomain<String>> filterList, List<List<PartitionValues>> expectedValuesList) throws Exception {
        try (CloseableSchamaTableName closeableTableName = new CloseableSchamaTableName(this.temporaryTable("get_partitions"));){
            SchemaTableName tableName = closeableTableName.getSchemaTableName();
            this.createDummyPartitionedTable(tableName, columnMetadata, partitionColumnNames, partitionValues);
            HiveMetastore metastoreClient = this.getMetastoreClient();
            for (int i = 0; i < filterList.size(); ++i) {
                TupleDomain<String> filter = filterList.get(i);
                List<PartitionValues> expectedValues = expectedValuesList.get(i);
                List expectedResults = (List)expectedValues.stream().map(expectedPartitionValues -> FileUtils.makePartName((List)partitionColumnNames, expectedPartitionValues.getValues())).collect(ImmutableList.toImmutableList());
                Optional partitionNames = metastoreClient.getPartitionNamesByFilter(HIVE_CONTEXT, tableName.getSchemaName(), tableName.getTableName(), partitionColumnNames, filter);
                Assert.assertTrue((boolean)partitionNames.isPresent());
                Assert.assertEquals((Collection)((Collection)partitionNames.get()), (Collection)expectedResults, (String)String.format("lists \nactual: %s\nexpected: %s\nmismatch for filter %s (input index %d)\n", partitionNames.get(), expectedResults, filter, i));
            }
        }
    }

    private void createDummyPartitionedTable(SchemaTableName tableName, List<ColumnMetadata> columns, List<String> partitionColumnNames, List<PartitionValues> partitionValues) throws Exception {
        this.doCreateEmptyTable(tableName, HiveStorageFormat.ORC, columns, partitionColumnNames);
        HiveMetastoreClosure metastoreClient = new HiveMetastoreClosure(this.getMetastoreClient());
        HiveIdentity identity = new HiveIdentity(HiveTestUtils.SESSION);
        Table table = (Table)metastoreClient.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        ArrayList partitions = new ArrayList();
        ArrayList partitionNames = new ArrayList();
        partitionValues.stream().map(partitionValue -> FileUtils.makePartName((List)partitionColumnNames, partitionValue.values)).forEach(partitionName -> {
            partitions.add(new PartitionWithStatistics(this.createDummyPartition(table, (String)partitionName), partitionName, PartitionStatistics.empty()));
            partitionNames.add(partitionName);
        });
        metastoreClient.addPartitions(identity, tableName.getSchemaName(), tableName.getTableName(), partitions);
        partitionNames.forEach(partitionName -> metastoreClient.updatePartitionStatistics(identity, tableName.getSchemaName(), tableName.getTableName(), partitionName, currentStatistics -> EMPTY_TABLE_STATISTICS));
    }

    private static class PartitionValues {
        private final List<String> values;

        private static PartitionValues make(String ... values) {
            return new PartitionValues(Arrays.asList(values));
        }

        private static PartitionValues make(List<String> values) {
            return new PartitionValues(values);
        }

        private PartitionValues(List<String> values) {
            this.values = values;
        }

        public List<String> getValues() {
            return this.values;
        }
    }

    private class CloseableSchamaTableName
    implements AutoCloseable {
        private final SchemaTableName schemaTableName;

        private CloseableSchamaTableName(SchemaTableName schemaTableName) {
            this.schemaTableName = schemaTableName;
        }

        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public void close() {
            TestHiveGlueMetastore.this.dropTable(this.schemaTableName);
        }
    }
}

