/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Storage;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.security.PrincipalType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.apache.hadoop.hive.metastore.TableType;

public final class TestingMetastoreObjects {
    private static final Consumer<Storage.Builder> STORAGE_CONSUMER = storage -> storage.setStorageFormat(StorageFormat.create((String)"SerdeLib", (String)"InputFormat", (String)"OutputFormat")).setLocation("/test-tbl").setBucketProperty(Optional.empty()).setSerdeParameters((Map)ImmutableMap.of());

    private TestingMetastoreObjects() {
    }

    public static com.amazonaws.services.glue.model.Database getGlueTestDatabase() {
        return new com.amazonaws.services.glue.model.Database().withName("test-db" + TestingMetastoreObjects.generateRandom()).withDescription("database desc").withLocationUri("/db").withParameters((Map)ImmutableMap.of());
    }

    public static com.amazonaws.services.glue.model.Table getGlueTestTable(String dbName) {
        return new com.amazonaws.services.glue.model.Table().withDatabaseName(dbName).withName("test-tbl" + TestingMetastoreObjects.generateRandom()).withOwner("owner").withParameters((Map)ImmutableMap.of()).withPartitionKeys((Collection)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn())).withStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor()).withTableType(TableType.EXTERNAL_TABLE.name()).withViewOriginalText("originalText").withViewExpandedText("expandedText");
    }

    public static com.amazonaws.services.glue.model.Column getGlueTestColumn() {
        return new com.amazonaws.services.glue.model.Column().withName("test-col" + TestingMetastoreObjects.generateRandom()).withType("string").withComment("column comment");
    }

    public static StorageDescriptor getGlueTestStorageDescriptor() {
        return new StorageDescriptor().withBucketColumns((Collection)ImmutableList.of((Object)"test-bucket-col")).withColumns((Collection)ImmutableList.of((Object)TestingMetastoreObjects.getGlueTestColumn())).withParameters((Map)ImmutableMap.of()).withSerdeInfo(new SerDeInfo().withSerializationLibrary("SerdeLib").withParameters((Map)ImmutableMap.of())).withInputFormat("InputFormat").withOutputFormat("OutputFormat").withLocation("/test-tbl").withNumberOfBuckets(Integer.valueOf(1));
    }

    public static com.amazonaws.services.glue.model.Partition getGlueTestPartition(String dbName, String tblName, List<String> values) {
        return new com.amazonaws.services.glue.model.Partition().withDatabaseName(dbName).withTableName(tblName).withValues(values).withParameters((Map)ImmutableMap.of()).withStorageDescriptor(TestingMetastoreObjects.getGlueTestStorageDescriptor());
    }

    public static Database getPrestoTestDatabase() {
        return Database.builder().setDatabaseName("test-db" + TestingMetastoreObjects.generateRandom()).setComment(Optional.of("database desc")).setLocation(Optional.of("/db")).setParameters((Map)ImmutableMap.of()).setOwnerName("PUBLIC").setOwnerType(PrincipalType.ROLE).build();
    }

    public static Table getPrestoTestTable(String dbName) {
        return Table.builder().setDatabaseName(dbName).setTableName("test-tbl" + TestingMetastoreObjects.generateRandom()).setOwner("owner").setParameters((Map)ImmutableMap.of()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getPrestoTestColumn())).setPartitionColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getPrestoTestColumn())).setViewOriginalText(Optional.of("originalText")).setViewExpandedText(Optional.of("expandedText")).withStorage(STORAGE_CONSUMER).build();
    }

    public static Partition getPrestoTestPartition(String dbName, String tblName, List<String> values) {
        return Partition.builder().setDatabaseName(dbName).setTableName(tblName).setValues(values).setColumns((List)ImmutableList.of((Object)TestingMetastoreObjects.getPrestoTestColumn())).setParameters((Map)ImmutableMap.of()).withStorage(STORAGE_CONSUMER).build();
    }

    public static Column getPrestoTestColumn() {
        return new Column("test-col" + TestingMetastoreObjects.generateRandom(), HiveType.HIVE_STRING, Optional.of("column comment"));
    }

    private static String generateRandom() {
        return String.format("%04x", ThreadLocalRandom.current().nextInt());
    }
}

