/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.prestosql.plugin.hive.acid.AcidOperation;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class MockThriftMetastoreClient
implements ThriftMetastoreClient {
    public static final String TEST_DATABASE = "testdb";
    public static final String BAD_DATABASE = "baddb";
    public static final String TEST_TABLE = "testtbl";
    public static final String TEST_PARTITION1 = "key=testpartition1";
    public static final String TEST_COLUMN = "column";
    public static final String TEST_PARTITION2 = "key=testpartition2";
    public static final String BAD_PARTITION = "key=badpartition1";
    public static final List<String> TEST_PARTITION_VALUES1 = ImmutableList.of((Object)"testpartition1");
    public static final List<String> TEST_PARTITION_VALUES2 = ImmutableList.of((Object)"testpartition2");
    public static final List<String> TEST_ROLES = ImmutableList.of((Object)"testrole");
    public static final List<RolePrincipalGrant> TEST_ROLE_GRANTS = ImmutableList.of((Object)new RolePrincipalGrant("role1", "user", PrincipalType.USER, false, 0, "grantor1", PrincipalType.USER), (Object)new RolePrincipalGrant("role2", "role1", PrincipalType.ROLE, true, 0, "grantor2", PrincipalType.ROLE));
    public static final List<String> PARTITION_COLUMN_NAMES = ImmutableList.of((Object)"column");
    private static final StorageDescriptor DEFAULT_STORAGE_DESCRIPTOR = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("column", "bigint", "")), "", null, null, false, 0, new SerDeInfo("testtbl", null, (Map)ImmutableMap.of()), null, null, (Map)ImmutableMap.of());
    private final AtomicInteger accessCount = new AtomicInteger();
    private boolean throwException;

    private static ColumnStatisticsObj createTestStats() {
        ColumnStatisticsObj stats = new ColumnStatisticsObj();
        ColumnStatisticsData data = new ColumnStatisticsData();
        data.setLongStats(new LongColumnStatsData());
        stats.setStatsData(data);
        stats.setColName(TEST_COLUMN);
        return stats;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public int getAccessCount() {
        return this.accessCount.get();
    }

    public List<String> getAllDatabases() {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return ImmutableList.of((Object)TEST_DATABASE);
    }

    public List<String> getAllTables(String dbName) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)TEST_TABLE);
    }

    public Database getDatabase(String name) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!name.equals(TEST_DATABASE)) {
            throw new NoSuchObjectException();
        }
        return new Database(TEST_DATABASE, null, null, null);
    }

    public Table getTable(String dbName, String tableName) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return new Table(TEST_TABLE, TEST_DATABASE, "", 0, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("key", "string", null)), (Map)ImmutableMap.of(), "", "", TableType.MANAGED_TABLE.name());
    }

    public Table getTableWithCapabilities(String databaseName, String tableName) {
        throw new UnsupportedOperationException();
    }

    public List<FieldSchema> getFields(String databaseName, String tableName) {
        return ImmutableList.of((Object)new FieldSchema("key", "string", null));
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(databaseName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && columnNames.equals(ImmutableList.of((Object)TEST_COLUMN)))) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)MockThriftMetastoreClient.createTestStats());
    }

    public void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        throw new UnsupportedOperationException();
    }

    public void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(databaseName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && partitionNames.equals(ImmutableList.of((Object)TEST_PARTITION1)) && columnNames.equals(ImmutableList.of((Object)TEST_COLUMN)))) {
            throw new NoSuchObjectException();
        }
        return ImmutableMap.of((Object)TEST_PARTITION1, (Object)ImmutableList.of((Object)MockThriftMetastoreClient.createTestStats()));
    }

    public void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        this.accessCount.incrementAndGet();
    }

    public void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTableNamesByFilter(String databaseName, String filter) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTableNamesByType(String databaseName, String tableType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getPartitionNames(String dbName, String tableName) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2);
    }

    public List<String> getPartitionNamesFiltered(String dbName, String tableName, List<String> partValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2);
    }

    public Partition getPartition(String dbName, String tableName, List<String> partitionValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of(TEST_PARTITION_VALUES1, TEST_PARTITION_VALUES2).contains(partitionValues))) {
            throw new NoSuchObjectException();
        }
        return new Partition(partitionValues, TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
    }

    public List<Partition> getPartitionsByNames(String dbName, String tableName, List<String> names) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2).containsAll(names))) {
            throw new NoSuchObjectException();
        }
        return Lists.transform(names, name -> {
            try {
                return new Partition((List)ImmutableList.copyOf((Collection)Warehouse.getPartValuesFromPartName((String)name)), TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void createDatabase(Database database) {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String databaseName, Database database) {
        throw new UnsupportedOperationException();
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(String databaseName, String name, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterTableWithEnvironmentContext(String databaseName, String tableName, Table newTable, EnvironmentContext context) {
    }

    public int addPartitions(List<Partition> newPartitions) {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(String databaseName, String tableName, Partition partition) {
        this.accessCount.incrementAndGet();
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        throw new UnsupportedOperationException();
    }

    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) {
        throw new UnsupportedOperationException();
    }

    public List<String> getRoleNames() {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return TEST_ROLES;
    }

    public void createRole(String role, String grantor) {
    }

    public void dropRole(String role) {
    }

    public boolean grantPrivileges(PrivilegeBag privilegeBag) {
        throw new UnsupportedOperationException();
    }

    public boolean revokePrivileges(PrivilegeBag privilegeBag) {
        throw new UnsupportedOperationException();
    }

    public void grantRole(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) {
    }

    public void revokeRole(String role, String granteeName, PrincipalType granteeType, boolean grantOption) {
    }

    public List<RolePrincipalGrant> listGrantedPrincipals(String role) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<RolePrincipalGrant> listRoleGrants(String name, PrincipalType principalType) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return TEST_ROLE_GRANTS;
    }

    public void close() {
    }

    public void setUGI(String userName) {
    }

    public long openTransaction(String user) {
        throw new UnsupportedOperationException();
    }

    public void commitTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    public void sendTransactionHeartbeat(long transactionId) {
        throw new UnsupportedOperationException();
    }

    public LockResponse acquireLock(LockRequest lockRequest) {
        throw new UnsupportedOperationException();
    }

    public LockResponse checkLock(long lockId) {
        throw new UnsupportedOperationException();
    }

    public String getValidWriteIds(List<String> tableList, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    public String get_config_value(String name, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterTransactionalTable(Table table, long transactionId, long writeId, EnvironmentContext context) throws TException {
        throw new UnsupportedOperationException();
    }

    public String getDelegationToken(String userName) {
        throw new UnsupportedOperationException();
    }
}

