/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.prestosql.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.thrift.transport.TTransportException;

public class MockThriftMetastoreClientFactory
extends DefaultThriftMetastoreClientFactory {
    private Map<HostAndPort, Optional<ThriftMetastoreClient>> clients;

    public MockThriftMetastoreClientFactory(Optional<HostAndPort> socksProxy, Duration timeout, Map<String, Optional<ThriftMetastoreClient>> clients) {
        super(Optional.empty(), socksProxy, timeout, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication(), "localhost");
        this.clients = clients.entrySet().stream().collect(Collectors.toMap(entry -> MockThriftMetastoreClientFactory.createHostAndPort((String)entry.getKey()), Map.Entry::getValue));
    }

    public ThriftMetastoreClient create(HostAndPort address, Optional<String> delegationToken) throws TTransportException {
        Preconditions.checkArgument((boolean)delegationToken.isEmpty(), (Object)"delegation token is not supported");
        Optional client = this.clients.getOrDefault(address, Optional.empty());
        if (client.isEmpty()) {
            throw new TTransportException(3);
        }
        return (ThriftMetastoreClient)client.get();
    }

    private static HostAndPort createHostAndPort(String str) {
        URI uri = URI.create(str);
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
    }
}

