/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.base.Joiner;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.metastore.thrift.FailureAwareThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.MockThriftMetastoreClientFactory;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStaticMetastoreLocator {
    private static final ThriftMetastoreClient DEFAULT_CLIENT = TestStaticMetastoreLocator.createFakeMetastoreClient();
    private static final ThriftMetastoreClient FALLBACK_CLIENT = TestStaticMetastoreLocator.createFakeMetastoreClient();
    private static final String DEFAULT_URI = "thrift://default:8080";
    private static final String FALLBACK_URI = "thrift://fallback:8090";
    private static final String FALLBACK2_URI = "thrift://fallback2:8090";
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK = new StaticMetastoreConfig().setMetastoreUris(Joiner.on((char)',').join((Object)"thrift://default:8080", (Object)"thrift://fallback:8090", new Object[]{"thrift://fallback2:8090"}));
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080");
    private static final StaticMetastoreConfig CONFIG_WITH_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris(Joiner.on((char)',').join((Object)"thrift://default:8080", (Object)"thrift://fallback:8090", new Object[]{"thrift://fallback2:8090"})).setMetastoreUsername("presto");
    private static final StaticMetastoreConfig CONFIG_WITHOUT_FALLBACK_WITH_USER = new StaticMetastoreConfig().setMetastoreUris("thrift://default:8080").setMetastoreUsername("presto");
    private static final Map<String, Optional<ThriftMetastoreClient>> CLIENTS = ImmutableMap.of((Object)"thrift://default:8080", Optional.of(DEFAULT_CLIENT), (Object)"thrift://fallback:8090", Optional.of(FALLBACK_CLIENT));

    @Test
    public void testDefaultHiveMetastore() throws TException {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.of(DEFAULT_CLIENT)));
        this.assertEqualHiveClient(locator.createMetastoreClient(Optional.empty()), DEFAULT_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastore() throws TException {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty(), (Object)FALLBACK_URI, Optional.of(FALLBACK_CLIENT)));
        this.assertEqualHiveClient(locator.createMetastoreClient(Optional.empty()), FALLBACK_CLIENT);
    }

    @Test
    public void testFallbackHiveMetastoreFails() {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of());
        TestStaticMetastoreLocator.assertCreateClientFails(locator, "Failed connecting to Hive metastore: [default:8080, fallback:8090, fallback2:8090]");
    }

    @Test
    public void testMetastoreFailedWithoutFallback() {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITHOUT_FALLBACK, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty()));
        TestStaticMetastoreLocator.assertCreateClientFails(locator, "Failed connecting to Hive metastore: [default:8080]");
    }

    @Test
    public void testFallbackHiveMetastoreWithHiveUser() throws TException {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK_WITH_USER, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty(), (Object)FALLBACK_URI, Optional.empty(), (Object)FALLBACK2_URI, Optional.of(FALLBACK_CLIENT)));
        this.assertEqualHiveClient(locator.createMetastoreClient(Optional.empty()), FALLBACK_CLIENT);
    }

    @Test
    public void testMetastoreFailedWithoutFallbackWithHiveUser() {
        MetastoreLocator locator = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITHOUT_FALLBACK_WITH_USER, (Map<String, Optional<ThriftMetastoreClient>>)ImmutableMap.of((Object)DEFAULT_URI, Optional.empty()));
        TestStaticMetastoreLocator.assertCreateClientFails(locator, "Failed connecting to Hive metastore: [default:8080]");
    }

    @Test
    public void testFallbackHiveMetastoreOnTimeOut() throws TException {
        MetastoreLocator cluster = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, CLIENTS);
        ThriftMetastoreClient metastoreClient1 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient1);
        ThriftMetastoreClient metastoreClient2 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient2);
    }

    @Test
    public void testFallbackHiveMetastoreOnAllTimeOut() throws TException {
        MetastoreLocator cluster = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, CLIENTS);
        ThriftMetastoreClient metastoreClient1 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        for (int i = 0; i < 20; ++i) {
            TestStaticMetastoreLocator.assertGetTableException(metastoreClient1);
        }
        ThriftMetastoreClient metastoreClient2 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient2);
        ThriftMetastoreClient metastoreClient3 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient3, FALLBACK_CLIENT);
    }

    @Test
    public void testStickToFallbackAfterBackoff() throws TException {
        TestingTicker ticker = new TestingTicker();
        MetastoreLocator cluster = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, CLIENTS, (Ticker)ticker);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient1 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient1);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient2 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        ticker.increment(StaticMetastoreLocator.Backoff.MAX_BACKOFF, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient3 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient3, FALLBACK_CLIENT);
    }

    @Test
    public void testReturnsToDefaultClientAfterErrorOnFallback() throws TException {
        TestingTicker ticker = new TestingTicker();
        MetastoreLocator cluster = TestStaticMetastoreLocator.createMetastoreLocator(CONFIG_WITH_FALLBACK, CLIENTS, (Ticker)ticker);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient1 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient1, DEFAULT_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient1);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient2 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient2, FALLBACK_CLIENT);
        TestStaticMetastoreLocator.assertGetTableException(metastoreClient2);
        ticker.increment(10L, TimeUnit.NANOSECONDS);
        ThriftMetastoreClient metastoreClient3 = cluster.createMetastoreClient(Optional.empty());
        this.assertEqualHiveClient(metastoreClient3, DEFAULT_CLIENT);
    }

    private static void assertGetTableException(ThriftMetastoreClient client) {
        try {
            client.getTable("foo", "bar");
            Assert.fail((String)"Expected getTable to throw an exception");
        }
        catch (TException e) {
            io.airlift.testing.Assertions.assertContains((String)e.getMessage(), (String)"Read timeout");
        }
    }

    private static void assertCreateClientFails(MetastoreLocator locator, String message) {
        Assertions.assertThatThrownBy(() -> locator.createMetastoreClient(Optional.empty())).hasCauseInstanceOf(TException.class).hasMessage(message);
    }

    private static MetastoreLocator createMetastoreLocator(StaticMetastoreConfig config, Map<String, Optional<ThriftMetastoreClient>> clients) {
        return TestStaticMetastoreLocator.createMetastoreLocator(config, clients, Ticker.systemTicker());
    }

    private static MetastoreLocator createMetastoreLocator(StaticMetastoreConfig config, Map<String, Optional<ThriftMetastoreClient>> clients, Ticker ticker) {
        return new StaticMetastoreLocator(config, new ThriftMetastoreAuthenticationConfig(), (ThriftMetastoreClientFactory)new MockThriftMetastoreClientFactory(Optional.empty(), new Duration(1.0, TimeUnit.SECONDS), clients), ticker);
    }

    private static ThriftMetastoreClient createFakeMetastoreClient() {
        return new MockThriftMetastoreClient(){

            @Override
            public Table getTable(String dbName, String tableName) throws TException {
                throw new TException((Throwable)new SocketTimeoutException("Read timeout"));
            }
        };
    }

    private void assertEqualHiveClient(ThriftMetastoreClient actual, ThriftMetastoreClient expected) {
        if (actual instanceof FailureAwareThriftMetastoreClient) {
            actual = ((FailureAwareThriftMetastoreClient)actual).getDelegate();
        }
        if (expected instanceof FailureAwareThriftMetastoreClient) {
            expected = ((FailureAwareThriftMetastoreClient)expected).getDelegate();
        }
        Assert.assertEquals((Object)actual, (Object)expected);
    }
}

