/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestThriftMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ThriftMetastoreConfig)ConfigAssertions.recordDefaults(ThriftMetastoreConfig.class)).setMetastoreTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSocksProxy(null).setMaxRetries(9).setBackoffScaleFactor(2.0).setMinBackoffDelay(new Duration(1.0, TimeUnit.SECONDS)).setMaxBackoffDelay(new Duration(1.0, TimeUnit.SECONDS)).setMaxRetryTime(new Duration(30.0, TimeUnit.SECONDS)).setTlsEnabled(false).setKeystorePath(null).setKeystorePassword(null).setTruststorePath(null).setTruststorePassword(null).setImpersonationEnabled(false).setDelegationTokenCacheTtl(new Duration(1.0, TimeUnit.HOURS)).setDelegationTokenCacheMaximumSize(1000L).setDeleteFilesOnDrop(false).setMaxWaitForTransactionLock(new Duration(10.0, TimeUnit.MINUTES)).setAssumeCanonicalPartitionKeys(false));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path keystoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path truststoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.metastore-timeout", (Object)"20s").put((Object)"hive.metastore.thrift.client.socks-proxy", (Object)"localhost:1234").put((Object)"hive.metastore.thrift.client.max-retries", (Object)"15").put((Object)"hive.metastore.thrift.client.backoff-scale-factor", (Object)"3.0").put((Object)"hive.metastore.thrift.client.min-backoff-delay", (Object)"2s").put((Object)"hive.metastore.thrift.client.max-backoff-delay", (Object)"4s").put((Object)"hive.metastore.thrift.client.max-retry-time", (Object)"60s").put((Object)"hive.metastore.thrift.client.ssl.enabled", (Object)"true").put((Object)"hive.metastore.thrift.client.ssl.key", (Object)keystoreFile.toString()).put((Object)"hive.metastore.thrift.client.ssl.key-password", (Object)"keystore-password").put((Object)"hive.metastore.thrift.client.ssl.trust-certificate", (Object)truststoreFile.toString()).put((Object)"hive.metastore.thrift.client.ssl.trust-certificate-password", (Object)"truststore-password").put((Object)"hive.metastore.thrift.impersonation.enabled", (Object)"true").put((Object)"hive.metastore.thrift.delegation-token.cache-ttl", (Object)"1d").put((Object)"hive.metastore.thrift.delegation-token.cache-maximum-size", (Object)"9999").put((Object)"hive.metastore.thrift.delete-files-on-drop", (Object)"true").put((Object)"hive.metastore.thrift.txn-lock-max-wait", (Object)"5m").put((Object)"hive.metastore.thrift.assume-canonical-partition-keys", (Object)"true").build();
        ThriftMetastoreConfig expected = new ThriftMetastoreConfig().setMetastoreTimeout(new Duration(20.0, TimeUnit.SECONDS)).setSocksProxy(HostAndPort.fromParts((String)"localhost", (int)1234)).setMaxRetries(15).setBackoffScaleFactor(3.0).setMinBackoffDelay(new Duration(2.0, TimeUnit.SECONDS)).setMaxBackoffDelay(new Duration(4.0, TimeUnit.SECONDS)).setMaxRetryTime(new Duration(60.0, TimeUnit.SECONDS)).setTlsEnabled(true).setKeystorePath(keystoreFile.toFile()).setKeystorePassword("keystore-password").setTruststorePath(truststoreFile.toFile()).setTruststorePassword("truststore-password").setImpersonationEnabled(true).setDelegationTokenCacheTtl(new Duration(1.0, TimeUnit.DAYS)).setDelegationTokenCacheMaximumSize(9999L).setDeleteFilesOnDrop(true).setMaxWaitForTransactionLock(new Duration(5.0, TimeUnit.MINUTES)).setAssumeCanonicalPartitionKeys(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

