/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore.thrift;

import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.prestosql.plugin.hive.metastore.thrift.MetastoreLocator;
import io.prestosql.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public class TestingMetastoreLocator
implements MetastoreLocator {
    private static final HiveMetastoreAuthentication AUTHENTICATION = new NoHiveMetastoreAuthentication();
    private static final Duration TIMEOUT = new Duration(10.0, TimeUnit.SECONDS);
    private final DefaultThriftMetastoreClientFactory factory;
    private final HostAndPort address;

    public TestingMetastoreLocator(Optional<HostAndPort> socksProxy, HostAndPort address) {
        this.factory = new DefaultThriftMetastoreClientFactory(Optional.empty(), socksProxy, TIMEOUT, AUTHENTICATION, "localhost");
        this.address = Objects.requireNonNull(address, "address is null");
    }

    public ThriftMetastoreClient createMetastoreClient(Optional<String> delegationToken) throws TException {
        return this.factory.create(this.address, delegationToken);
    }
}

