/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.optimizer;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveColumnProjectionInfo;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastore;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.prestosql.plugin.hive.testing.TestingHiveConnectorFactory;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestConnectorPushdownRulesWithHive
extends BaseRuleTest {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private File baseDir;
    private HiveMetastore metastore;
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();

    public TestConnectorPushdownRulesWithHive() {
        super(new Plugin[0]);
    }

    protected Optional<LocalQueryRunner> createLocalQueryRunner() {
        this.baseDir = Files.createTempDir();
        HdfsConfig config = new HdfsConfig();
        HiveHdfsConfiguration configuration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(config), (Set)ImmutableSet.of());
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)configuration, config, (HdfsAuthentication)new NoHdfsAuthentication());
        this.metastore = new FileHiveMetastore(new NodeVersion("test_version"), environment, new MetastoreConfig(), new FileHiveMetastoreConfig().setCatalogDirectory(this.baseDir.toURI().toString()).setMetastoreUser("test"));
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
        this.metastore.createDatabase(new HiveIdentity(TestingConnectorSession.SESSION), database);
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)HIVE_SESSION);
        queryRunner.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory(this.metastore), (Map)ImmutableMap.of());
        return Optional.of(queryRunner);
    }

    @Test
    public void testProjectionPushdown() {
        String tableName = "projection_test";
        PushProjectionIntoTableScan pushProjectionIntoTableScan = new PushProjectionIntoTableScan(this.tester().getMetadata(), this.tester().getTypeAnalyzer());
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE  %s (struct_of_int) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) as struct_of_int where false", tableName));
        Type baseType = ROW_TYPE;
        HiveColumnHandle partialColumn = new HiveColumnHandle("struct_of_int", 0, HiveType.toHiveType((Type)baseType), baseType, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)"a"), HiveType.toHiveType((Type)BigintType.BIGINT), (Type)BigintType.BIGINT)), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(new CatalogName(HIVE_CATALOG_NAME), (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(), Optional.empty());
        HiveColumnHandle fullColumn = partialColumn.getBaseColumn();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("struct_of_int", baseType), (Expression)p.symbol("struct_of_int", baseType).toSymbolReference()), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).doesNotFire();
        this.tester().assertThat((Rule)pushProjectionIntoTableScan).on(p -> p.project(Assignments.of((Symbol)p.symbol("expr_deref", (Type)BigintType.BIGINT), (Expression)new DereferenceExpression((Expression)p.symbol("struct_of_int", baseType).toSymbolReference(), new Identifier("a"))), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("struct_of_int", baseType)), (Map)ImmutableMap.of((Object)p.symbol("struct_of_int", baseType), (Object)fullColumn)))).matches(PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_deref", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("struct_of_int#a"))), (PlanMatchPattern)PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)table.getConnectorHandle()), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"struct_of_int#a", (Object)Predicates.equalTo((Object)partialColumn)))));
        this.metastore.dropTable(new HiveIdentity(TestingConnectorSession.SESSION), SCHEMA_NAME, tableName, true);
    }

    @Test
    public void testPredicatePushdown() {
        String tableName = "predicate_test";
        this.tester().getQueryRunner().execute(String.format("CREATE TABLE %s (a, b) AS SELECT 5, 6", tableName));
        PushPredicateIntoTableScan pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getMetadata(), new TypeOperators(), this.tester().getTypeAnalyzer());
        HiveTableHandle hiveTable = new HiveTableHandle(SCHEMA_NAME, tableName, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
        TableHandle table = new TableHandle(new CatalogName(HIVE_CATALOG_NAME), (ConnectorTableHandle)hiveTable, (ConnectorTransactionHandle)new HiveTransactionHandle(), Optional.empty());
        HiveColumnHandle column = HiveColumnHandle.createBaseColumn((String)"a", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.tester().assertThat((Rule)pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression((String)"a = 5"), (PlanNode)p.tableScan(table, (List)ImmutableList.of((Object)p.symbol("a", (Type)IntegerType.INTEGER)), (Map)ImmutableMap.of((Object)p.symbol("a", (Type)IntegerType.INTEGER), (Object)column)))).matches(PlanMatchPattern.filter((String)"a = 5", (PlanMatchPattern)PlanMatchPattern.tableScan(tableHandle -> ((Map)((HiveTableHandle)tableHandle).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)5L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"a", (Object)Predicates.equalTo((Object)column)))));
        this.metastore.dropTable(new HiveIdentity(TestingConnectorSession.SESSION), SCHEMA_NAME, tableName, true);
    }

    @AfterClass(alwaysRun=true)
    protected void cleanup() throws IOException {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

