/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.optimizer;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.Session;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.TestHiveReaderProjectionsUtil;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.MetastoreConfig;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastore;
import io.prestosql.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.prestosql.plugin.hive.testing.TestingHiveConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.assertions.BasePushdownPlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestHiveProjectionPushdownIntoTableScan
extends BasePushdownPlanTest {
    private static final String HIVE_CATALOG_NAME = "hive";
    private static final String SCHEMA_NAME = "test_schema";
    private static final Session HIVE_SESSION = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("test_schema").build();
    private File baseDir;

    protected LocalQueryRunner createLocalQueryRunner() {
        this.baseDir = Files.createTempDir();
        HdfsConfig config = new HdfsConfig();
        HiveHdfsConfiguration configuration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(config), (Set)ImmutableSet.of());
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)configuration, config, (HdfsAuthentication)new NoHdfsAuthentication());
        FileHiveMetastore metastore = new FileHiveMetastore(new NodeVersion("test_version"), environment, new MetastoreConfig(), new FileHiveMetastoreConfig().setCatalogDirectory(this.baseDir.toURI().toString()).setMetastoreUser("test"));
        Database database = Database.builder().setDatabaseName(SCHEMA_NAME).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build();
        metastore.createDatabase(new HiveIdentity(HIVE_SESSION.toConnectorSession()), database);
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)HIVE_SESSION);
        queryRunner.createCatalog(HIVE_CATALOG_NAME, (ConnectorFactory)new TestingHiveConnectorFactory((HiveMetastore)metastore), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testPushdownDisabled() {
        String testTable = "test_disabled_pushdown";
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(HIVE_CATALOG_NAME, "projection_pushdown_enabled", "false").build();
        this.getQueryRunner().execute(String.format("CREATE TABLE %s (col0) AS SELECT cast(row(5, 6) as row(a bigint, b bigint)) AS col0 WHERE false", testTable));
        this.assertPlan(String.format("SELECT col0.a expr_a, col0.b expr_b FROM %s", testTable), session, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((String)"col0.a"), (Object)"expr_2", (Object)PlanMatchPattern.expression((String)"col0.b")), (PlanMatchPattern)PlanMatchPattern.tableScan((String)testTable, (Map)ImmutableMap.of((Object)"col0", (Object)"col0")))}));
    }

    @Test
    public void testDereferencePushdown() {
        String testTable = "test_simple_projection_pushdown";
        QualifiedObjectName completeTableName = new QualifiedObjectName(HIVE_CATALOG_NAME, SCHEMA_NAME, testTable);
        this.getQueryRunner().execute(String.format("CREATE TABLE %s (col0, col1) AS SELECT cast(row(5, 6) as row(x bigint, y bigint)) AS col0, 5 AS col1 WHERE false", testTable));
        Session session = this.getQueryRunner().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        Assert.assertTrue((boolean)tableHandle.isPresent(), (String)"expected the table handle to be present");
        Map columns = this.getColumnHandles(session, completeTableName);
        HiveColumnHandle column0Handle = (HiveColumnHandle)columns.get("col0");
        HiveColumnHandle column1Handle = (HiveColumnHandle)columns.get("col1");
        HiveColumnHandle columnX = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)0));
        HiveColumnHandle columnY = TestHiveReaderProjectionsUtil.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)1));
        this.assertPlan("SELECT col0.x expr_x, col0.y expr_y FROM " + testTable, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)((TableHandle)tableHandle.get()).getConnectorHandle()), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0#x", (Object)Predicates.equalTo((Object)columnX), (Object)"col0#y", (Object)Predicates.equalTo((Object)columnY)))}));
        this.assertPlan(String.format("SELECT col0.x FROM %s WHERE col0.x = col1 + 3 and col0.y = 2", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"col0_y = BIGINT '2' AND (col0_x =  cast((col1 + 3) as BIGINT))", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> ((Map)((HiveTableHandle)table).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)columnY, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0_y", (Object)Predicates.equalTo((Object)columnY), (Object)"col0_x", (Object)Predicates.equalTo((Object)columnX), (Object)"col1", (Object)Predicates.equalTo((Object)column1Handle))))}));
        this.assertPlan(String.format("SELECT col0, col0.y expr_y FROM %s WHERE col0.x = 5", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"col0_x = BIGINT '5'", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> ((Map)((HiveTableHandle)table).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"col0_x", (Object)Predicates.equalTo((Object)columnX))))}));
        this.assertPlan(String.format("SELECT T.col0.x, T.col0, T.col0.y FROM %s T join %s S on T.col1 = S.col1 WHERE (T.col0.x = 2)", testTable, testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_0_x", (Object)PlanMatchPattern.expression((String)"expr_0.x"), (Object)"expr_0", (Object)PlanMatchPattern.expression((String)"expr_0"), (Object)"expr_0_y", (Object)PlanMatchPattern.expression((String)"expr_0.y")), (PlanMatchPattern)PlanMatchPattern.join((JoinNode.Type)JoinNode.Type.INNER, (List)ImmutableList.of((Object)PlanMatchPattern.equiJoinClause((String)"t_expr_1", (String)"s_expr_1")), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((String)"expr_0_x = BIGINT '2'", (PlanMatchPattern)PlanMatchPattern.tableScan(table -> ((Map)((HiveTableHandle)table).getCompactEffectivePredicate().getDomains().get()).equals(ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"expr_0_x", (Object)Predicates.equalTo((Object)columnX), (Object)"expr_0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"t_expr_1", (Object)Predicates.equalTo((Object)column1Handle))))}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)((TableHandle)tableHandle.get()).getConnectorHandle()), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"s_expr_1", (Object)Predicates.equalTo((Object)column1Handle)))})))}));
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

