/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcDeleteDeltaPageSource {
    @Test
    public void testReadingDeletedRows() throws Exception {
        File deleteDeltaFile = new File(Resources.getResource((String)"fullacid_delete_delta_test/delete_delta_0000004_0000004_0000/bucket_00000").toURI());
        OrcDeleteDeltaPageSourceFactory pageSourceFactory = new OrcDeleteDeltaPageSourceFactory(new OrcReaderOptions(), "test", (Configuration)new JobConf(new Configuration(false)), HiveTestUtils.HDFS_ENVIRONMENT, new FileFormatDataSourceStats());
        ConnectorPageSource pageSource = (ConnectorPageSource)pageSourceFactory.createPageSource(new Path(deleteDeltaFile.toURI()), deleteDeltaFile.length()).orElseThrow();
        MaterializedResult materializedRows = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        Assert.assertEquals((int)materializedRows.getRowCount(), (int)1);
        Assert.assertEquals(materializedRows.getMaterializedRows().get(0), (Object)new MaterializedRow(5, new Object[]{2L, 0L}));
    }
}

