/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.collect.ImmutableSet;
import io.prestosql.orc.OrcReaderOptions;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcDeletedRows;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.MaterializedResult;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.mapred.JobConf;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOrcDeletedRows {
    private Path partitionDirectory;
    private Block rowIdBlock;

    @BeforeClass
    public void setUp() {
        this.partitionDirectory = new Path(TestOrcDeletedRows.class.getClassLoader().getResource("fullacid_delete_delta_test") + "/");
        this.rowIdBlock = BigintType.BIGINT.createFixedSizeBlockBuilder(1).writeLong(0L).build();
    }

    @Test
    public void testDeleteLocations() {
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 4L, 4L, OptionalInt.of(0), this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 7L, 7L, OptionalInt.of(0), this.partitionDirectory);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows((AcidInfo)acidInfoBuilder.build().orElseThrow(), "bucket_00000");
        Page testPage = this.createTestPage(0, 10);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)8);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)7L, (Object[])new Long[]{8L, 9L}));
        testPage = this.createTestPage(10, 20);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)10);
    }

    @Test
    public void testDeletedLocationsOriginalFiles() {
        Path path = new Path(TestOrcDeletedRows.class.getClassLoader().getResource("dummy_id_data_orc") + "/");
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)path);
        this.addDeleteDelta(acidInfoBuilder, 10000001L, 10000001L, OptionalInt.of(0), path);
        acidInfoBuilder.addOriginalFile(new Path(path, "000000_0"), 743L, 0);
        acidInfoBuilder.addOriginalFile(new Path(path, "000001_0"), 730L, 0);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows(acidInfoBuilder.buildWithRequiredOriginalFiles(0), "000000_0");
        Page testPage = this.createTestPage(0, 8);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.of(0L)).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)7);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object[])new Long[]{7L}));
        testPage = this.createTestPage(5, 9);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)4);
    }

    @Test
    public void testDeletedLocationsAfterMinorCompaction() {
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 4L, 4L, OptionalInt.empty(), this.partitionDirectory);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows((AcidInfo)acidInfoBuilder.build().orElseThrow(), "bucket_00000");
        Page testPage = this.createTestPage(0, 10);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)9);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object[])new Long[]{7L, 8L, 9L}));
        testPage = this.createTestPage(10, 20);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)10);
    }

    private void addDeleteDelta(AcidInfo.Builder acidInfoBuilder, long minWriteId, long maxWriteId, OptionalInt statementId, Path path) {
        Path deleteDeltaPath = statementId.isPresent() ? new Path(path, AcidUtils.deleteDeltaSubdir((long)minWriteId, (long)maxWriteId, (int)statementId.getAsInt())) : new Path(path, AcidUtils.deleteDeltaSubdir((long)minWriteId, (long)maxWriteId));
        acidInfoBuilder.addDeleteDelta(deleteDeltaPath);
    }

    private static OrcDeletedRows createOrcDeletedRows(AcidInfo acidInfo, String sourceFileName) {
        JobConf configuration = new JobConf(new Configuration(false));
        OrcDeleteDeltaPageSourceFactory pageSourceFactory = new OrcDeleteDeltaPageSourceFactory(new OrcReaderOptions(), "test", (Configuration)configuration, HiveTestUtils.HDFS_ENVIRONMENT, new FileFormatDataSourceStats());
        return new OrcDeletedRows(sourceFileName, pageSourceFactory, "test", (Configuration)configuration, HiveTestUtils.HDFS_ENVIRONMENT, acidInfo);
    }

    private Page createTestPage(int originalTransactionStart, int originalTransactionEnd) {
        int size = originalTransactionEnd - originalTransactionStart;
        BlockBuilder originalTransaction = BigintType.BIGINT.createFixedSizeBlockBuilder(size);
        for (long i = (long)originalTransactionStart; i < (long)originalTransactionEnd; ++i) {
            originalTransaction.writeLong(i);
        }
        return new Page(size, new Block[]{originalTransaction.build(), new RunLengthEncodedBlock(this.rowIdBlock, size)});
    }
}

