/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.AcidInfo;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.ReaderPageSource;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.orc.OrcPageSourceFactory;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.tpch.Nation;
import io.prestosql.tpch.NationColumn;
import io.prestosql.tpch.NationGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.mapred.JobConf;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcPageSourceFactory {
    private static final File TEST_FILE = new File(TestOrcPageSourceFactory.class.getClassLoader().getResource("nationFile25kRowsSortedOnNationKey/bucket_00000").getPath());
    private static final HivePageSourceFactory PAGE_SOURCE_FACTORY = new OrcPageSourceFactory(new OrcReaderConfig(), HiveTestUtils.HDFS_ENVIRONMENT, new FileFormatDataSourceStats(), new HiveConfig());

    @Test
    public void testFullFileRead() {
        TestOrcPageSourceFactory.assertRead((Set<NationColumn>)ImmutableSet.copyOf((Object[])NationColumn.values()), OptionalLong.empty(), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testSingleColumnRead() {
        TestOrcPageSourceFactory.assertRead((Set<NationColumn>)ImmutableSet.of((Object)NationColumn.REGION_KEY), OptionalLong.empty(), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testFullFileSkipped() {
        TestOrcPageSourceFactory.assertRead((Set<NationColumn>)ImmutableSet.copyOf((Object[])NationColumn.values()), OptionalLong.of(100L), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testSomeStripesAndRowGroupRead() {
        TestOrcPageSourceFactory.assertRead((Set<NationColumn>)ImmutableSet.copyOf((Object[])NationColumn.values()), OptionalLong.of(5L), Optional.empty(), nationKey -> false);
    }

    @Test
    public void testDeletedRows() {
        Path partitionLocation = new Path(this.getClass().getClassLoader().getResource("nation_delete_deltas") + "/");
        Optional acidInfo = AcidInfo.builder((Path)partitionLocation).addDeleteDelta(new Path(partitionLocation, AcidUtils.deleteDeltaSubdir((long)3L, (long)3L, (int)0))).addDeleteDelta(new Path(partitionLocation, AcidUtils.deleteDeltaSubdir((long)4L, (long)4L, (int)0))).build();
        TestOrcPageSourceFactory.assertRead((Set<NationColumn>)ImmutableSet.copyOf((Object[])NationColumn.values()), OptionalLong.empty(), acidInfo, nationKey -> nationKey == 5L || nationKey == 19L);
    }

    @Test
    public void testFullFileReadOriginalFilesTable() {
        File tableFile = new File(TestOrcPageSourceFactory.class.getClassLoader().getResource("fullacidNationTableWithOriginalFiles/000000_0").getPath());
        String tablePath = tableFile.getParent();
        AcidInfo acidInfo = AcidInfo.builder((Path)new Path(tablePath)).addDeleteDelta(new Path(tablePath, AcidUtils.deleteDeltaSubdir((long)10000001L, (long)10000001L, (int)0))).addOriginalFile(new Path(tablePath, "000000_0"), 1780L, 0).buildWithRequiredOriginalFiles(0);
        List<Nation> expected = TestOrcPageSourceFactory.expectedResult(OptionalLong.empty(), nationKey -> nationKey == 24L, 1);
        List<Nation> result = TestOrcPageSourceFactory.readFile((Set<NationColumn>)ImmutableSet.copyOf((Object[])NationColumn.values()), OptionalLong.empty(), Optional.of(acidInfo), tablePath + "/000000_0", 1780L);
        Assert.assertEquals((int)result.size(), (int)expected.size());
        int deletedRowKey = 24;
        String deletedRowNameColumn = "UNITED STATES";
        Assert.assertFalse((boolean)result.stream().anyMatch(acidNationRow -> acidNationRow.getName().equals(deletedRowNameColumn) && acidNationRow.getNationKey() == (long)deletedRowKey), (String)"Deleted row shouldn't be present in the result");
    }

    private static void assertRead(Set<NationColumn> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo, LongPredicate deletedRows) {
        List<Nation> actual = TestOrcPageSourceFactory.readFile(columns, nationKeyPredicate, acidInfo);
        List<Nation> expected = TestOrcPageSourceFactory.expectedResult(nationKeyPredicate, deletedRows, 1000);
        TestOrcPageSourceFactory.assertEqualsByColumns(columns, actual, expected);
    }

    private static List<Nation> expectedResult(OptionalLong nationKeyPredicate, LongPredicate deletedRows, int replicationFactor) {
        ArrayList<Nation> expected = new ArrayList<Nation>();
        for (Nation nation : ImmutableList.copyOf((Iterator)new NationGenerator().iterator())) {
            if (nationKeyPredicate.isPresent() && nationKeyPredicate.getAsLong() != nation.getNationKey() || deletedRows.test(nation.getNationKey())) continue;
            expected.addAll(Collections.nCopies(replicationFactor, nation));
        }
        return expected;
    }

    private static List<Nation> readFile(Set<NationColumn> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo) {
        return TestOrcPageSourceFactory.readFile(columns, nationKeyPredicate, acidInfo, TEST_FILE.toURI().getPath(), TEST_FILE.length());
    }

    private static List<Nation> readFile(Set<NationColumn> columns, OptionalLong nationKeyPredicate, Optional<AcidInfo> acidInfo, String filePath, long fileSize) {
        TupleDomain tupleDomain = TupleDomain.all();
        if (nationKeyPredicate.isPresent()) {
            tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TestOrcPageSourceFactory.toHiveColumnHandle(NationColumn.NATION_KEY, 0), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)nationKeyPredicate.getAsLong())));
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        List columnHandles = (List)columns.stream().map(nationColumn -> TestOrcPageSourceFactory.toHiveColumnHandle(nationColumn, atomicInteger.getAndIncrement())).collect(ImmutableList.toImmutableList());
        List columnNames = (List)columnHandles.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        Optional pageSourceWithProjections = PAGE_SOURCE_FACTORY.createPageSource((Configuration)new JobConf(new Configuration(false)), HiveTestUtils.SESSION, new Path(filePath), 0L, fileSize, fileSize, TestOrcPageSourceFactory.createSchema(), columnHandles, tupleDomain, acidInfo, OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION);
        Preconditions.checkArgument((boolean)pageSourceWithProjections.isPresent());
        Preconditions.checkArgument((boolean)((ReaderPageSource)pageSourceWithProjections.get()).getReaderColumns().isEmpty(), (Object)"projected columns not expected here");
        ConnectorPageSource pageSource = ((ReaderPageSource)pageSourceWithProjections.get()).get();
        int nationKeyColumn = columnNames.indexOf("n_nationkey");
        int nameColumn = columnNames.indexOf("n_name");
        int regionKeyColumn = columnNames.indexOf("n_regionkey");
        int commentColumn = columnNames.indexOf("n_comment");
        ImmutableList.Builder rows = ImmutableList.builder();
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            page = page.getLoadedPage();
            for (int position = 0; position < page.getPositionCount(); ++position) {
                long nationKey = -42L;
                if (nationKeyColumn >= 0) {
                    nationKey = BigintType.BIGINT.getLong(page.getBlock(nationKeyColumn), position);
                }
                String name = "<not read>";
                if (nameColumn >= 0) {
                    name = VarcharType.VARCHAR.getSlice(page.getBlock(nameColumn), position).toStringUtf8();
                }
                long regionKey = -42L;
                if (regionKeyColumn >= 0) {
                    regionKey = BigintType.BIGINT.getLong(page.getBlock(regionKeyColumn), position);
                }
                String comment = "<not read>";
                if (commentColumn >= 0) {
                    comment = VarcharType.VARCHAR.getSlice(page.getBlock(commentColumn), position).toStringUtf8();
                }
                rows.add((Object)new Nation((long)position, nationKey, name, regionKey, comment));
            }
        }
        return rows.build();
    }

    private static HiveColumnHandle toHiveColumnHandle(NationColumn nationColumn, int hiveColumnIndex) {
        BigintType prestoType;
        switch (nationColumn.getType().getBase()) {
            case IDENTIFIER: {
                prestoType = BigintType.BIGINT;
                break;
            }
            case VARCHAR: {
                prestoType = VarcharType.VARCHAR;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + nationColumn.getType().getBase());
            }
        }
        return HiveColumnHandle.createBaseColumn((String)nationColumn.getColumnName(), (int)hiveColumnIndex, (HiveType)HiveType.toHiveType((Type)prestoType), (Type)prestoType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    }

    private static Properties createSchema() {
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", HiveStorageFormat.ORC.getSerDe());
        schema.setProperty("file.inputformat", HiveStorageFormat.ORC.getInputFormat());
        schema.setProperty("transactional", "true");
        return schema;
    }

    private static void assertEqualsByColumns(Set<NationColumn> columns, List<Nation> actualRows, List<Nation> expectedRows) {
        Assert.assertEquals((int)actualRows.size(), (int)expectedRows.size(), (String)"row count");
        for (int i = 0; i < actualRows.size(); ++i) {
            Nation actual = actualRows.get(i);
            Nation expected = expectedRows.get(i);
            Assert.assertEquals((long)actual.getNationKey(), (long)(columns.contains(NationColumn.NATION_KEY) ? expected.getNationKey() : -42L));
            Assert.assertEquals((String)actual.getName(), (String)(columns.contains(NationColumn.NAME) ? expected.getName() : "<not read>"));
            Assert.assertEquals((long)actual.getRegionKey(), (long)(columns.contains(NationColumn.REGION_KEY) ? expected.getRegionKey() : -42L));
            Assert.assertEquals((String)actual.getComment(), (String)(columns.contains(NationColumn.COMMENT) ? expected.getComment() : "<not read>"));
        }
    }
}

