/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.parquet.writer.ParquetSchemaConverter;
import io.prestosql.parquet.writer.ParquetWriter;
import io.prestosql.parquet.writer.ParquetWriterOptions;
import io.prestosql.plugin.hive.AbstractTestHiveFileFormats;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.orc.OrcWriterConfig;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import io.prestosql.plugin.hive.parquet.ParquetWriterConfig;
import io.prestosql.plugin.hive.parquet.write.MapKeyValuesSchemaConverter;
import io.prestosql.plugin.hive.parquet.write.SingleLevelArrayMapKeyValuesSchemaConverter;
import io.prestosql.plugin.hive.parquet.write.SingleLevelArraySchemaConverter;
import io.prestosql.plugin.hive.parquet.write.TestMapredParquetOutputFormat;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.SqlDate;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spi.type.Varchars;
import io.prestosql.testing.TestingConnectorSession;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.testng.Assert;

public class ParquetTester {
    private static final int MAX_PRECISION_INT64 = Math.toIntExact(ParquetTester.maxPrecision(8));
    private static final boolean OPTIMIZED = true;
    private static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(ParquetTester.createHiveConfig(false));
    private static final ConnectorSession SESSION_USE_NAME = HiveTestUtils.getHiveSession(ParquetTester.createHiveConfig(true));
    private static final List<String> TEST_COLUMN = Collections.singletonList("test");
    private Set<CompressionCodecName> compressions = ImmutableSet.of();
    private Set<CompressionCodecName> writerCompressions = ImmutableSet.of();
    private Set<ParquetProperties.WriterVersion> versions = ImmutableSet.of();
    private Set<ConnectorSession> sessions = ImmutableSet.of();

    public static ParquetTester quickParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP);
        parquetTester.writerCompressions = ImmutableSet.of((Object)CompressionCodecName.GZIP);
        parquetTester.versions = ImmutableSet.of((Object)ParquetProperties.WriterVersion.PARQUET_1_0);
        parquetTester.sessions = ImmutableSet.of((Object)SESSION);
        return parquetTester;
    }

    public static ParquetTester fullParquetTester() {
        ParquetTester parquetTester = new ParquetTester();
        parquetTester.compressions = ImmutableSet.of((Object)CompressionCodecName.GZIP, (Object)CompressionCodecName.UNCOMPRESSED, (Object)CompressionCodecName.SNAPPY, (Object)CompressionCodecName.LZO, (Object)CompressionCodecName.LZ4, (Object)CompressionCodecName.ZSTD, (Object[])new CompressionCodecName[0]);
        parquetTester.writerCompressions = ImmutableSet.of((Object)CompressionCodecName.GZIP, (Object)CompressionCodecName.UNCOMPRESSED, (Object)CompressionCodecName.SNAPPY, (Object)CompressionCodecName.ZSTD);
        parquetTester.versions = ImmutableSet.copyOf((Object[])ParquetProperties.WriterVersion.values());
        parquetTester.sessions = ImmutableSet.of((Object)SESSION, (Object)SESSION_USE_NAME);
        return parquetTester;
    }

    public void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<?> writeValues, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, writeValues, parameterType);
    }

    public <W, R> void testRoundTrip(PrimitiveObjectInspector columnObjectInspector, Iterable<W> writeValues, java.util.function.Function<W, R> readTransform, Type parameterType) throws Exception {
        this.testRoundTrip((ObjectInspector)columnObjectInspector, writeValues, Iterables.transform(writeValues, readTransform::apply), parameterType);
    }

    public void testSingleLevelArraySchemaRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
        MessageType schema = SingleLevelArraySchemaConverter.convert(TEST_COLUMN, typeInfos);
        this.testSingleLevelArrayRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        if (objectInspector.getTypeName().contains("map<")) {
            schema = SingleLevelArrayMapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testSingleLevelArrayRoundTrip(objectInspector, writeValues, readValues, type, Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type) throws Exception {
        this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty(), false);
        this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.empty());
        if (objectInspector.getTypeName().contains("map<")) {
            ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)objectInspector.getTypeName());
            MessageType schema = MapKeyValuesSchemaConverter.convert(TEST_COLUMN, typeInfos);
            this.testRoundTripType(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema), false);
            this.assertRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, new Iterable[]{Iterables.transform(writeValues, (Function)Functions.constant(null))}, TEST_COLUMN, Collections.singletonList(type), Optional.of(schema));
        }
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema, false);
    }

    public void testSingleLevelArrayRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), parquetSchema, true);
    }

    public void testRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(type), parquetSchema, false);
    }

    public void testSingleLevelArrayRoundTrip(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, String columnName, Type type, Optional<MessageType> parquetSchema) throws Exception {
        this.testRoundTrip(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, Collections.singletonList(columnName), Collections.singletonList(type), parquetSchema, true);
    }

    public void testRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        this.testRoundTripType(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, this.transformToNulls(writeValues), this.transformToNulls(readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
    }

    private void testRoundTripType(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.reverse(writeValues), ParquetTester.reverse(readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, writeValues), ParquetTester.insertNullEvery(5, readValues), columnNames, columnTypes, parquetSchema, singleLevelArray);
        this.assertRoundTrip(objectInspectors, ParquetTester.insertNullEvery(5, ParquetTester.reverse(writeValues)), ParquetTester.insertNullEvery(5, ParquetTester.reverse(readValues)), columnNames, columnTypes, parquetSchema, singleLevelArray);
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema) throws Exception {
        this.assertRoundTrip(objectInspectors, writeValues, readValues, columnNames, columnTypes, parquetSchema, false);
    }

    void assertRoundTrip(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        for (ParquetProperties.WriterVersion version : this.versions) {
            for (CompressionCodecName compressionCodecName : this.compressions) {
                for (ConnectorSession session : this.sessions) {
                    try (TempFile tempFile = new TempFile("test", "parquet");){
                        JobConf jobConf = new JobConf();
                        jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
                        jobConf.setBoolean("parquet.enable.dictionary", true);
                        jobConf.setEnum("parquet.writer.version", (Enum)version);
                        ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodecName, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), ParquetTester.getIterators(writeValues), parquetSchema, singleLevelArray);
                        ParquetTester.assertFileContents(session, tempFile.getFile(), ParquetTester.getIterators(readValues), columnNames, columnTypes);
                    }
                }
            }
        }
        for (CompressionCodecName compressionCodecName : this.writerCompressions) {
            for (ConnectorSession session : this.sessions) {
                try (TempFile tempFile = new TempFile("test", "parquet");){
                    OptionalInt min = Arrays.stream(writeValues).mapToInt(Iterables::size).min();
                    Preconditions.checkState((boolean)min.isPresent());
                    ParquetTester.writeParquetColumnPresto(tempFile.getFile(), columnTypes, columnNames, ParquetTester.getIterators(readValues), min.getAsInt(), compressionCodecName);
                    ParquetTester.assertFileContents(session, tempFile.getFile(), ParquetTester.getIterators(readValues), columnNames, columnTypes);
                }
            }
        }
    }

    static void testMaxReadBytes(ObjectInspector objectInspector, Iterable<?> writeValues, Iterable<?> readValues, Type type, DataSize maxReadBlockSize) throws Exception {
        ParquetTester.assertMaxReadBytes(Collections.singletonList(objectInspector), new Iterable[]{writeValues}, new Iterable[]{readValues}, TEST_COLUMN, Collections.singletonList(type), Optional.empty(), maxReadBlockSize);
    }

    static void assertMaxReadBytes(List<ObjectInspector> objectInspectors, Iterable<?>[] writeValues, Iterable<?>[] readValues, List<String> columnNames, List<Type> columnTypes, Optional<MessageType> parquetSchema, DataSize maxReadBlockSize) throws Exception {
        CompressionCodecName compressionCodecName = CompressionCodecName.UNCOMPRESSED;
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(false), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig().setMaxReadBlockSize(maxReadBlockSize), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        try (TempFile tempFile = new TempFile("test", "parquet");){
            JobConf jobConf = new JobConf();
            jobConf.setEnum("parquet.compression", (Enum)compressionCodecName);
            jobConf.setBoolean("parquet.enable.dictionary", true);
            jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), compressionCodecName, ParquetTester.createTableProperties(columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, objectInspectors), ParquetTester.getIterators(writeValues), parquetSchema, false);
            Iterator<?>[] expectedValues = ParquetTester.getIterators(readValues);
            try (ConnectorPageSource pageSource = ParquetTester.getFileFormat().createFileFormatReader((ConnectorSession)session, HiveTestUtils.HDFS_ENVIRONMENT, tempFile.getFile(), columnNames, columnTypes);){
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource, Optional.of(HiveSessionProperties.getParquetMaxReadBlockSize((ConnectorSession)session).toBytes()));
                Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
            }
        }
    }

    private static void assertFileContents(ConnectorSession session, File dataFile, Iterator<?>[] expectedValues, List<String> columnNames, List<Type> columnTypes) throws IOException {
        try (ConnectorPageSource pageSource = ParquetTester.getFileFormat().createFileFormatReader(session, HiveTestUtils.HDFS_ENVIRONMENT, dataFile, columnNames, columnTypes);){
            if (pageSource instanceof RecordPageSource) {
                ParquetTester.assertRecordCursor(columnTypes, expectedValues, ((RecordPageSource)pageSource).getCursor());
            } else {
                ParquetTester.assertPageSource(columnTypes, expectedValues, pageSource);
            }
            Assert.assertFalse((boolean)Arrays.stream(expectedValues).allMatch(Iterator::hasNext));
        }
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource) {
        ParquetTester.assertPageSource(types, valuesByField, pageSource, Optional.empty());
    }

    private static void assertPageSource(List<Type> types, Iterator<?>[] valuesByField, ConnectorPageSource pageSource, Optional<Long> maxReadBlockSize) {
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            maxReadBlockSize.ifPresent(max -> Assert.assertTrue((page.getPositionCount() == 1 || page.getSizeInBytes() <= max ? 1 : 0) != 0));
            for (int field = 0; field < page.getChannelCount(); ++field) {
                Block block = page.getBlock(field);
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    Assert.assertTrue((boolean)valuesByField[field].hasNext());
                    Object expected = valuesByField[field].next();
                    Object actual = ParquetTester.decodeObject(types.get(field), block, i);
                    Assert.assertEquals((Object)actual, expected);
                }
            }
        }
    }

    private static void assertRecordCursor(List<Type> types, Iterator<?>[] valuesByField, RecordCursor cursor) {
        while (cursor.advanceNextPosition()) {
            for (int field = 0; field < types.size(); ++field) {
                Assert.assertTrue((boolean)valuesByField[field].hasNext());
                Object expected = valuesByField[field].next();
                Object actual = ParquetTester.getActualCursorValue(cursor, types.get(field), field);
                Assert.assertEquals((Object)actual, expected);
            }
        }
    }

    private static Object getActualCursorValue(RecordCursor cursor, Type type, int field) {
        Object fieldFromCursor = AbstractTestHiveFileFormats.getFieldFromCursor(cursor, type, field);
        if (fieldFromCursor == null) {
            return null;
        }
        if (HiveUtil.isStructuralType((Type)type)) {
            Block block = (Block)fieldFromCursor;
            if (HiveUtil.isArrayType((Type)type)) {
                Type elementType = ((ArrayType)type).getElementType();
                return ParquetTester.toArrayValue(block, elementType);
            }
            if (HiveUtil.isMapType((Type)type)) {
                MapType mapType = (MapType)type;
                return ParquetTester.toMapValue(block, mapType.getKeyType(), mapType.getValueType());
            }
            if (HiveUtil.isRowType((Type)type)) {
                return ParquetTester.toRowValue(block, type.getTypeParameters());
            }
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new SqlDecimal((BigInteger)fieldFromCursor, decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof VarcharType) {
            return new String(((Slice)fieldFromCursor).getBytes(), StandardCharsets.UTF_8);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return new SqlVarbinary(((Slice)fieldFromCursor).getBytes());
        }
        if (DateType.DATE.equals((Object)type)) {
            return new SqlDate(((Long)fieldFromCursor).intValue());
        }
        if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            return SqlTimestamp.fromMillis((int)3, (long)((Long)fieldFromCursor));
        }
        return fieldFromCursor;
    }

    private static Map<?, ?> toMapValue(Block mapBlock, Type keyType, Type valueType) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(mapBlock.getPositionCount() * 2);
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            map.put(keyType.getObjectValue(SESSION, mapBlock, i), valueType.getObjectValue(SESSION, mapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    private static List<?> toArrayValue(Block arrayBlock, Type elementType) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < arrayBlock.getPositionCount(); ++position) {
            values.add(elementType.getObjectValue(SESSION, arrayBlock, position));
        }
        return Collections.unmodifiableList(values);
    }

    private static List<?> toRowValue(Block rowBlock, List<Type> fieldTypes) {
        ArrayList<Object> values = new ArrayList<Object>(rowBlock.getPositionCount());
        for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
            values.add(fieldTypes.get(i).getObjectValue(SESSION, rowBlock, i));
        }
        return Collections.unmodifiableList(values);
    }

    private static HiveConfig createHiveConfig(boolean useParquetColumnNames) {
        return new HiveConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET).setUseParquetColumnNames(useParquetColumnNames);
    }

    private static FileFormat getFileFormat() {
        return FileFormat.PRESTO_PARQUET;
    }

    public static void writeParquetColumn(JobConf jobConf, File outputFile, CompressionCodecName compressionCodecName, Properties tableProperties, SettableStructObjectInspector objectInspector, Iterator<?>[] valuesByField, Optional<MessageType> parquetSchema, boolean singleLevelArray) throws Exception {
        FileSinkOperator.RecordWriter recordWriter = new TestMapredParquetOutputFormat(parquetSchema, singleLevelArray).getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compressionCodecName != CompressionCodecName.UNCOMPRESSED, tableProperties, () -> {});
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        while (Arrays.stream(valuesByField).allMatch(Iterator::hasNext)) {
            for (int field = 0; field < fields.size(); ++field) {
                Object value = valuesByField[field].next();
                objectInspector.setStructFieldData(row, (StructField)fields.get(field), value);
            }
            ParquetHiveSerDe serde = new ParquetHiveSerDe();
            serde.initialize((Configuration)jobConf, tableProperties, null);
            Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
    }

    public static Properties createTableProperties(List<String> columnNames, List<ObjectInspector> objectInspectors) {
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", Joiner.on((char)',').join(columnNames));
        orderTableProperties.setProperty("columns.types", Joiner.on((char)',').join(Iterables.transform(objectInspectors, ObjectInspector::getTypeName)));
        return orderTableProperties;
    }

    private static Iterator<?>[] getIterators(Iterable<?>[] values) {
        return (Iterator[])Arrays.stream(values).map(Iterable::iterator).toArray(Iterator[]::new);
    }

    private Iterable<?>[] transformToNulls(Iterable<?>[] values) {
        return (Iterable[])Arrays.stream(values).map(v -> Iterables.transform((Iterable)v, (Function)Functions.constant(null))).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] reverse(Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(ImmutableList::copyOf).map(Lists::reverse).toArray(Iterable[]::new);
    }

    private static Iterable<?>[] insertNullEvery(int n, Iterable<?>[] iterables) {
        return (Iterable[])Arrays.stream(iterables).map(itr -> ParquetTester.insertNullEvery(n, itr)).toArray(Iterable[]::new);
    }

    static <T> Iterable<T> insertNullEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        };
    }

    private static Object decodeObject(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return type.getObjectValue(SESSION, block, position);
    }

    private static void writeParquetColumnPresto(File outputFile, List<Type> types, List<String> columnNames, Iterator<?>[] values, int size, CompressionCodecName compressionCodecName) throws Exception {
        Preconditions.checkArgument((types.size() == columnNames.size() && types.size() == values.length ? 1 : 0) != 0);
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames);
        ParquetWriter writer = new ParquetWriter((OutputStream)new FileOutputStream(outputFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().setMaxPageSize(DataSize.ofBytes((long)100L)).setMaxBlockSize(DataSize.ofBytes((long)100000L)).build(), compressionCodecName);
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            Iterator<?> iterator = values[i];
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            for (int j = 0; j < size; ++j) {
                Preconditions.checkState((boolean)iterator.hasNext());
                Object value = iterator.next();
                ParquetTester.writeValue(type, blockBuilder, value);
            }
        }
        pageBuilder.declarePositions(size);
        writer.write(pageBuilder.build());
        writer.close();
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (Decimals.isShortDecimal((Type)type)) {
            type.writeLong(blockBuilder, ((SqlDecimal)value).getUnscaledValue().longValue());
        } else if (Decimals.isLongDecimal((Type)type)) {
            if (Decimals.overflows((BigInteger)((SqlDecimal)value).getUnscaledValue(), (int)MAX_PRECISION_INT64)) {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
            } else {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((long)((SqlDecimal)value).getUnscaledValue().longValue()));
            }
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (RealType.REAL.equals((Object)type)) {
            float floatValue = ((Number)value).floatValue();
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(floatValue));
        } else if (type instanceof VarcharType) {
            Slice slice = Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (type instanceof CharType) {
            Slice slice = Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((SqlVarbinary)value).getBytes()));
        } else if (DateType.DATE.equals((Object)type)) {
            long days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, days);
        } else if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            type.writeLong(blockBuilder, ((SqlTimestamp)value).getEpochMicros());
        } else if (type instanceof ArrayType) {
            List array = (List)value;
            Type elementType = (Type)type.getTypeParameters().get(0);
            BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object elementValue : array) {
                ParquetTester.writeValue(elementType, arrayBlockBuilder, elementValue);
            }
            blockBuilder.closeEntry();
        } else if (type instanceof MapType) {
            Map map = (Map)value;
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : map.entrySet()) {
                ParquetTester.writeValue(keyType, mapBlockBuilder, entry.getKey());
                ParquetTester.writeValue(valueType, mapBlockBuilder, entry.getValue());
            }
            blockBuilder.closeEntry();
        } else if (type instanceof RowType) {
            List array = (List)value;
            List fieldTypes = type.getTypeParameters();
            BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
            for (int fieldId = 0; fieldId < fieldTypes.size(); ++fieldId) {
                Type fieldType = (Type)fieldTypes.get(fieldId);
                ParquetTester.writeValue(fieldType, rowBlockBuilder, array.get(fieldId));
            }
            blockBuilder.closeEntry();
        } else {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
    }

    private static long maxPrecision(int numBytes) {
        return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    public static class TempFile
    implements Closeable {
        private final File file;

        public TempFile(String prefix, String suffix) {
            try {
                this.file = File.createTempFile(prefix, suffix);
                Verify.verify((boolean)this.file.delete());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
            if (!this.file.delete()) {
                Verify.verify((!this.file.exists() ? 1 : 0) != 0);
            }
        }
    }
}

