/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.parquet.ParquetReaderConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestParquetReaderConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ParquetReaderConfig)ConfigAssertions.recordDefaults(ParquetReaderConfig.class)).setIgnoreStatistics(false).setMaxReadBlockSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxMergeDistance(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxBufferSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"parquet.ignore-statistics", (Object)"true").put((Object)"parquet.max-read-block-size", (Object)"66kB").put((Object)"parquet.max-buffer-size", (Object)"1431kB").put((Object)"parquet.max-merge-distance", (Object)"342kB").build();
        ParquetReaderConfig expected = new ParquetReaderConfig().setIgnoreStatistics(true).setMaxReadBlockSize(DataSize.of((long)66L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxBufferSize(DataSize.of((long)1431L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxMergeDistance(DataSize.of((long)342L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

