/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import io.prestosql.plugin.hive.parquet.ParquetTester;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTimestamp {
    @Test
    public void testTimestampBackedByInt64() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_timestamp { optional int64 test (TIMESTAMP_MILLIS); }");
        ContiguousSet epochMillisValues = ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(-1000L), (Comparable)Long.valueOf(1000L)), (DiscreteDomain)DiscreteDomain.longs());
        ImmutableList.Builder timestamps = new ImmutableList.Builder();
        UnmodifiableIterator unmodifiableIterator = epochMillisValues.iterator();
        while (unmodifiableIterator.hasNext()) {
            long value = (Long)unmodifiableIterator.next();
            timestamps.add((Object)SqlTimestamp.fromMillis((int)3, (long)value));
        }
        List<JavaLongObjectInspector> objectInspectors = Collections.singletonList(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)"test");
        ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig());
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("test", "parquet");){
            JobConf jobConf = new JobConf();
            jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
            ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), CompressionCodecName.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{epochMillisValues.iterator()}, Optional.of(parquetSchema), false);
            UnmodifiableIterator expectedValues = timestamps.build().iterator();
            try (ConnectorPageSource pageSource = FileFormat.PRESTO_PARQUET.createFileFormatReader(session, HiveTestUtils.HDFS_ENVIRONMENT, tempFile.getFile(), (List<String>)columnNames, (List<Type>)ImmutableList.of((Object)TimestampType.TIMESTAMP_MILLIS));){
                Page firstPage = pageSource.getNextPage();
                Assert.assertTrue((firstPage.getPositionCount() > 0 ? 1 : 0) != 0, (String)"Expected first page to have at least 1 row");
                for (int i = 0; i < firstPage.getPositionCount(); ++i) {
                    expectedValues.next();
                }
                int pageCount = 1;
                while (!pageSource.isFinished()) {
                    Page page = pageSource.getNextPage();
                    if (page == null) continue;
                    ++pageCount;
                    Block block = page.getBlock(0);
                    for (int i = 0; i < block.getPositionCount(); ++i) {
                        Assertions.assertThat((Object)TimestampType.TIMESTAMP_MILLIS.getObjectValue(session, block, i)).isEqualTo(expectedValues.next());
                    }
                }
                ((AbstractIntegerAssert)Assertions.assertThat((int)pageCount).withFailMessage("Expected more than one page but processed %s", new Object[]{pageCount})).isGreaterThan(1);
            }
            Assert.assertFalse((boolean)expectedValues.hasNext(), (String)"Read fewer values than expected");
        }
    }
}

