/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet;

import com.google.common.io.Resources;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveTimestampPrecision;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.ReaderPageSource;
import io.prestosql.plugin.hive.acid.AcidTransaction;
import io.prestosql.plugin.hive.benchmark.FileFormat;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.MaterializedRow;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTimestampMicros {
    @Test(dataProvider="testTimestampMicrosDataProvider")
    public void testTimestampMicros(HiveTimestampPrecision timestampPrecision, LocalDateTime expected) throws Exception {
        ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig().setTimestampPrecision(timestampPrecision));
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampType columnType = TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = this.createPageSource(session, parquetFile, "created", HiveType.HIVE_TIMESTAMP, (Type)columnType);){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected))});
        }
    }

    @Test(dataProvider="testTimestampMicrosDataProvider")
    public void testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision timestampPrecision, LocalDateTime expected) throws Exception {
        ConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig().setTimestampPrecision(timestampPrecision));
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = this.createPageSource(session, parquetFile, "created", HiveType.HIVE_TIMESTAMP, (Type)columnType);){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected.atZone(ZoneId.of("UTC"))))});
        }
    }

    @DataProvider
    public static Object[][] testTimestampMicrosDataProvider() {
        return new Object[][]{{HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("2020-10-12T16:26:02.907")}, {HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668")}};
    }

    private ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, String columnName, HiveType columnHiveType, Type columnType) {
        HivePageSourceFactory pageSourceFactory = FileFormat.PRESTO_PARQUET.getHivePageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT).orElseThrow();
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", HiveStorageFormat.PARQUET.getSerDe());
        ReaderPageSource pageSourceWithProjections = (ReaderPageSource)pageSourceFactory.createPageSource(new Configuration(false), session, new Path(parquetFile.toURI()), 0L, parquetFile.length(), parquetFile.length(), schema, List.of(HiveColumnHandle.createBaseColumn((String)columnName, (int)0, (HiveType)columnHiveType, (Type)columnType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())), TupleDomain.all(), Optional.empty(), OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION).orElseThrow();
        pageSourceWithProjections.getReaderColumns().ifPresent(projections -> {
            throw new IllegalStateException("Unexpected projections: " + projections);
        });
        return pageSourceWithProjections.get();
    }
}

