/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.parquet.predicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.parquet.ParquetTypeUtils;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.parquet.ParquetPageSourceFactory;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TypeOperators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetPredicateUtils {
    @Test
    public void testParquetTupleDomainPrimitiveArray() {
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_array", (int)0, (HiveType)HiveType.valueOf((String)"array<int>"), (io.prestosql.spi.type.Type)new ArrayType((io.prestosql.spi.type.Type)IntegerType.INTEGER), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.prestosql.spi.type.Type)new ArrayType((io.prestosql.spi.type.Type)IntegerType.INTEGER))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "array_element")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true);
        Assert.assertTrue((boolean)tupleDomain.isAll());
    }

    @Test
    public void testParquetTupleDomainStructArray() {
        RowType.Field rowField = new RowType.Field(Optional.of("a"), (io.prestosql.spi.type.Type)IntegerType.INTEGER);
        RowType rowType = RowType.from((List)ImmutableList.of((Object)rowField));
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_array_struct", (int)0, (HiveType)HiveType.valueOf((String)"array<struct<a:int>>"), (io.prestosql.spi.type.Type)rowType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.prestosql.spi.type.Type)new ArrayType((io.prestosql.spi.type.Type)rowType))));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_array_struct", new Type[]{new GroupType(Type.Repetition.REPEATED, "bag", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "array_element", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a")})})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true);
        Assert.assertTrue((boolean)tupleDomain.isAll());
    }

    @Test
    public void testParquetTupleDomainPrimitive() {
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_primitive", (int)0, (HiveType)HiveType.valueOf((String)"bigint"), (io.prestosql.spi.type.Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        Domain singleValueDomain = Domain.singleValue((io.prestosql.spi.type.Type)BigintType.BIGINT, (Object)123L);
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)singleValueDomain));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "my_primitive")});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true);
        Assert.assertEquals((int)((Map)tupleDomain.getDomains().get()).size(), (int)1);
        ColumnDescriptor descriptor = (ColumnDescriptor)((Map)tupleDomain.getDomains().get()).keySet().iterator().next();
        Assert.assertEquals((int)descriptor.getPath().length, (int)1);
        Assert.assertEquals((String)descriptor.getPath()[0], (String)"my_primitive");
        Domain predicateDomain = (Domain)Iterables.getOnlyElement(((Map)tupleDomain.getDomains().get()).values());
        Assert.assertEquals((Object)predicateDomain, (Object)singleValueDomain);
    }

    @Test
    public void testParquetTupleDomainStruct() {
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (io.prestosql.spi.type.Type)IntegerType.INTEGER), RowType.field((String)"b", (io.prestosql.spi.type.Type)IntegerType.INTEGER)});
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_struct", (int)0, (HiveType)HiveType.valueOf((String)"struct<a:int,b:int>"), (io.prestosql.spi.type.Type)rowType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.prestosql.spi.type.Type)rowType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_struct", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "a"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "b")})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true);
        Assert.assertTrue((boolean)tupleDomain.isAll());
    }

    @Test
    public void testParquetTupleDomainMap() {
        MapType mapType = new MapType((io.prestosql.spi.type.Type)IntegerType.INTEGER, (io.prestosql.spi.type.Type)IntegerType.INTEGER, new TypeOperators());
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)"my_map", (int)0, (HiveType)HiveType.valueOf((String)"map<int,int>"), (io.prestosql.spi.type.Type)mapType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.notNull((io.prestosql.spi.type.Type)mapType)));
        MessageType fileSchema = new MessageType("hive_schema", new Type[]{new GroupType(Type.Repetition.OPTIONAL, "my_map", new Type[]{new GroupType(Type.Repetition.REPEATED, "map", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "key"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "value")})})});
        Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)fileSchema);
        TupleDomain tupleDomain = ParquetPageSourceFactory.getParquetTupleDomain((Map)descriptorsByPath, (TupleDomain)domain, (MessageType)fileSchema, (boolean)true);
        Assert.assertTrue((boolean)tupleDomain.isAll());
    }
}

