/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.qubole.rubix.core.CachingFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoAdlFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoAzureBlobFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoDistributedFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoGoogleHadoopFileSystem;
import com.qubole.rubix.prestosql.CachingPrestoS3FileSystem;
import com.qubole.rubix.prestosql.CachingPrestoSecureAzureBlobFileSystem;
import com.qubole.rubix.spi.CacheConfig;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.client.NodeVersion;
import io.prestosql.metadata.InternalNode;
import io.prestosql.plugin.base.CatalogName;
import io.prestosql.plugin.hive.HdfsConfig;
import io.prestosql.plugin.hive.HdfsConfiguration;
import io.prestosql.plugin.hive.HdfsConfigurationInitializer;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveHdfsConfiguration;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.authentication.HdfsAuthentication;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationConfig;
import io.prestosql.plugin.hive.authentication.NoHdfsAuthentication;
import io.prestosql.plugin.hive.orc.OrcReaderConfig;
import io.prestosql.plugin.hive.rubix.CachingLocalFileSystem;
import io.prestosql.plugin.hive.rubix.RubixConfig;
import io.prestosql.plugin.hive.rubix.RubixConfigurationInitializer;
import io.prestosql.plugin.hive.rubix.RubixEnabledConfig;
import io.prestosql.plugin.hive.rubix.RubixHdfsInitializer;
import io.prestosql.plugin.hive.rubix.RubixInitializer;
import io.prestosql.plugin.hive.rubix.RubixModule;
import io.prestosql.plugin.hive.util.RetryDriver;
import io.prestosql.spi.Node;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.TestingNodeManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRubixCaching {
    private static final DataSize SMALL_FILE_SIZE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize LARGE_FILE_SIZE = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final MBeanServer BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private Path tempDirectory;
    private org.apache.hadoop.fs.Path cacheStoragePath;
    private HdfsConfig config;
    private HdfsEnvironment.HdfsContext context;
    private RubixInitializer rubixInitializer;
    private RubixConfigurationInitializer rubixConfigInitializer;
    private FileSystem nonCachingFileSystem;
    private FileSystem cachingFileSystem;

    @BeforeClass
    public void setup() throws IOException {
        this.cacheStoragePath = this.getStoragePath("/");
        this.config = new HdfsConfig();
        List hiveSessionProperties = HiveTestUtils.getHiveSessionProperties(new HiveConfig(), new RubixEnabledConfig().setCacheEnabled(true), new OrcReaderConfig()).getSessionProperties();
        this.context = new HdfsEnvironment.HdfsContext((ConnectorSession)TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties).build(), "test");
        this.nonCachingFileSystem = this.getNonCachingFileSystem();
    }

    @AfterMethod
    @BeforeMethod
    public void deinitializeRubix() {
        CachingFileSystem.deinitialize();
    }

    private FileSystem getNonCachingFileSystem() throws IOException {
        HdfsConfigurationInitializer configurationInitializer = new HdfsConfigurationInitializer(this.config);
        HiveHdfsConfiguration configuration = new HiveHdfsConfiguration(configurationInitializer, (Set)ImmutableSet.of());
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)configuration, this.config, (HdfsAuthentication)new NoHdfsAuthentication());
        return environment.getFileSystem(this.context, this.cacheStoragePath);
    }

    private void initializeCachingFileSystem(RubixConfig rubixConfig) throws Exception {
        this.initializeRubix(rubixConfig);
        this.cachingFileSystem = this.getCachingFileSystem();
    }

    private void initializeRubix(RubixConfig rubixConfig) throws Exception {
        InternalNode coordinatorNode = new InternalNode("master", URI.create("http://" + InetAddress.getLocalHost().getHostAddress() + ":8080"), NodeVersion.UNKNOWN, true);
        this.initializeRubix(rubixConfig, (List<Node>)ImmutableList.of((Object)coordinatorNode));
    }

    private void initializeRubix(RubixConfig rubixConfig, List<Node> nodes) throws Exception {
        this.tempDirectory = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
        ImmutableList cacheDirectories = ImmutableList.of((Object)this.tempDirectory.resolve("cache1"), (Object)this.tempDirectory.resolve("cache2"));
        for (Path directory : cacheDirectories) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        rubixConfig.setStartServerOnCoordinator(true);
        rubixConfig.setCacheLocation(Joiner.on((String)",").join((Iterable)cacheDirectories.stream().map(Path::toString).collect(ImmutableList.toImmutableList())));
        HdfsConfigurationInitializer configurationInitializer = new HdfsConfigurationInitializer(this.config, (Set)ImmutableSet.of(config -> CacheConfig.setRemoteFetchProcessInterval((Configuration)config, (int)0)));
        TestingNodeManager nodeManager = new TestingNodeManager(nodes);
        this.rubixInitializer = new RubixInitializer(rubixConfig, (NodeManager)nodeManager, new CatalogName("catalog"), configurationInitializer, (RubixHdfsInitializer)new RubixModule.DefaultRubixHdfsInitializer(new HiveAuthenticationConfig()));
        this.rubixConfigInitializer = new RubixConfigurationInitializer(this.rubixInitializer);
        this.rubixInitializer.initializeRubix();
        RetryDriver.retry().run("wait for rubix to startup", () -> {
            if (!this.rubixInitializer.isServerUp()) {
                throw new IllegalStateException("Rubix server has not started");
            }
            return null;
        });
    }

    private FileSystem getCachingFileSystem() throws IOException {
        return this.getCachingFileSystem(this.context, this.cacheStoragePath);
    }

    private FileSystem getCachingFileSystem(HdfsEnvironment.HdfsContext context, org.apache.hadoop.fs.Path path) throws IOException {
        HdfsConfigurationInitializer configurationInitializer = new HdfsConfigurationInitializer(this.config, (Set)ImmutableSet.of());
        HiveHdfsConfiguration configuration = new HiveHdfsConfiguration(configurationInitializer, (Set)ImmutableSet.of((Object)this.rubixConfigInitializer, (dynamicConfig, ignoredContext, ignoredUri) -> {
            dynamicConfig.set("fs.file.impl", CachingLocalFileSystem.class.getName());
            dynamicConfig.setBoolean("fs.gs.lazy.init.enable", true);
            dynamicConfig.set("fs.azure.account.key", "Zm9vCg==");
            dynamicConfig.set("fs.adl.oauth2.client.id", "test");
            dynamicConfig.set("fs.adl.oauth2.refresh.url", "http://localhost");
            dynamicConfig.set("fs.adl.oauth2.credential", "password");
        }));
        HdfsEnvironment environment = new HdfsEnvironment((HdfsConfiguration)configuration, this.config, (HdfsAuthentication)new NoHdfsAuthentication());
        return environment.getFileSystem(context, path);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        this.nonCachingFileSystem.close();
    }

    @AfterMethod(alwaysRun=true)
    public void closeRubix() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> {
                if (this.tempDirectory != null) {
                    MoreFiles.deleteRecursively((Path)this.tempDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
                    this.tempDirectory = null;
                }
            });
            closer.register(() -> {
                if (this.cachingFileSystem != null) {
                    this.cachingFileSystem.close();
                    this.cachingFileSystem = null;
                }
            });
            closer.register(() -> {
                if (this.rubixInitializer != null) {
                    try {
                        RetryDriver.retry().run("stopRubix", () -> {
                            this.rubixInitializer.stopRubix();
                            return null;
                        });
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    this.rubixInitializer = null;
                }
            });
        }
    }

    @DataProvider
    public static Object[][] readMode() {
        return new Object[][]{{RubixConfig.ReadMode.ASYNC}, {RubixConfig.ReadMode.READ_THROUGH}};
    }

    @Test
    public void testCoordinatorNotJoining() {
        RubixConfig rubixConfig = new RubixConfig().setCacheLocation("/tmp/not/existing/dir");
        HdfsConfigurationInitializer configurationInitializer = new HdfsConfigurationInitializer(this.config, (Set)ImmutableSet.of());
        InternalNode workerNode = new InternalNode("worker", URI.create("http://127.0.0.2:8080"), NodeVersion.UNKNOWN, false);
        RubixInitializer rubixInitializer = new RubixInitializer(RetryDriver.retry().maxAttempts(1), rubixConfig.setStartServerOnCoordinator(true), (NodeManager)new TestingNodeManager((List)ImmutableList.of((Object)workerNode)), new CatalogName("catalog"), configurationInitializer, (RubixHdfsInitializer)new RubixModule.DefaultRubixHdfsInitializer(new HiveAuthenticationConfig()));
        org.assertj.core.api.Assertions.assertThatThrownBy(() -> ((RubixInitializer)rubixInitializer).initializeRubix()).hasMessage("No coordinator node available");
    }

    @Test
    public void testGetBlockLocations() throws Exception {
        RubixConfig rubixConfig = new RubixConfig();
        InternalNode coordinatorNode = new InternalNode("master", URI.create("http://" + InetAddress.getLocalHost().getHostAddress() + ":8080"), NodeVersion.UNKNOWN, true);
        InternalNode workerNode1 = new InternalNode("worker1", URI.create("http://127.0.0.2:8080"), NodeVersion.UNKNOWN, false);
        InternalNode workerNode2 = new InternalNode("worker2", URI.create("http://127.0.0.3:8080"), NodeVersion.UNKNOWN, false);
        this.initializeRubix(rubixConfig, (List<Node>)ImmutableList.of((Object)coordinatorNode, (Object)workerNode1, (Object)workerNode2));
        this.cachingFileSystem = this.getCachingFileSystem();
        FileStatus file1 = new FileStatus(3L, false, 0, 3L, 0L, new org.apache.hadoop.fs.Path("aaa"));
        FileStatus file2 = new FileStatus(3L, false, 0, 3L, 0L, new org.apache.hadoop.fs.Path("zzzz"));
        BlockLocation[] file1Locations = this.cachingFileSystem.getFileBlockLocations(file1, 0L, 3L);
        BlockLocation[] file2Locations = this.cachingFileSystem.getFileBlockLocations(file2, 0L, 3L);
        Assert.assertEquals((int)file1Locations.length, (int)1);
        Assert.assertEquals((int)file2Locations.length, (int)1);
        Assert.assertEquals((String)file1Locations[0].getHosts()[0], (String)"127.0.0.3");
        Assert.assertEquals((String)file2Locations[0].getHosts()[0], (String)"127.0.0.2");
    }

    @Test(dataProvider="readMode")
    public void testCacheRead(RubixConfig.ReadMode readMode) throws Exception {
        RubixConfig rubixConfig = new RubixConfig().setReadMode(readMode);
        this.initializeCachingFileSystem(rubixConfig);
        byte[] randomData = new byte[(int)SMALL_FILE_SIZE.toBytes()];
        new Random().nextBytes(randomData);
        org.apache.hadoop.fs.Path file = this.getStoragePath("some_file");
        this.writeFile(this.nonCachingFileSystem.create(file), randomData);
        long beforeRemoteReadsCount = this.getRemoteReadsCount();
        long beforeCachedReadsCount = this.getCachedReadsCount();
        long beforeAsyncDownloadedMb = this.getAsyncDownloadedMb(readMode);
        Assert.assertEquals((Object)this.readFile(this.cachingFileSystem, file), (Object)randomData);
        if (readMode == RubixConfig.ReadMode.ASYNC) {
            io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assert.assertEquals((long)this.getAsyncDownloadedMb(readMode), (long)(beforeAsyncDownloadedMb + 1L)));
        }
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getRemoteReadsCount()), (Comparable)Long.valueOf(beforeRemoteReadsCount));
            Assert.assertEquals((long)this.getCachedReadsCount(), (long)beforeCachedReadsCount);
        });
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            long remoteReadsCount = this.getRemoteReadsCount();
            Assert.assertEquals((Object)this.readFile(this.cachingFileSystem, file), (Object)randomData);
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getCachedReadsCount()), (Comparable)Long.valueOf(beforeCachedReadsCount));
            Assert.assertEquals((long)this.getRemoteReadsCount(), (long)remoteReadsCount);
        });
    }

    @Test(dataProvider="readMode")
    public void testCacheWrite(RubixConfig.ReadMode readMode) throws Exception {
        this.initializeCachingFileSystem(new RubixConfig().setReadMode(readMode));
        org.apache.hadoop.fs.Path file = this.getStoragePath("some_file_write");
        byte[] data = "Hello world".getBytes(StandardCharsets.UTF_8);
        this.writeFile(this.cachingFileSystem.create(file), data);
        Assert.assertEquals((Object)this.readFile(this.nonCachingFileSystem, file), (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="readMode")
    public void testLargeFile(RubixConfig.ReadMode readMode) throws Exception {
        this.initializeCachingFileSystem(new RubixConfig().setReadMode(readMode));
        byte[] randomData = new byte[(int)LARGE_FILE_SIZE.toBytes()];
        new Random().nextBytes(randomData);
        org.apache.hadoop.fs.Path file = this.getStoragePath("large_file");
        this.writeFile(this.nonCachingFileSystem.create(file), randomData);
        long beforeRemoteReadsCount = this.getRemoteReadsCount();
        long beforeCachedReadsCount = this.getCachedReadsCount();
        long beforeAsyncDownloadedMb = this.getAsyncDownloadedMb(readMode);
        Assert.assertTrue((boolean)Arrays.equals(randomData, this.readFile(this.cachingFileSystem, file)));
        if (readMode == RubixConfig.ReadMode.ASYNC) {
            io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assert.assertEquals((long)this.getAsyncDownloadedMb(readMode), (long)(beforeAsyncDownloadedMb + 100L)));
        }
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getRemoteReadsCount()), (Comparable)Long.valueOf(beforeRemoteReadsCount)));
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            long remoteReadsCount = this.getRemoteReadsCount();
            Assert.assertTrue((boolean)Arrays.equals(randomData, this.readFile(this.cachingFileSystem, file)));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getCachedReadsCount()), (Comparable)Long.valueOf(beforeCachedReadsCount));
            Assert.assertEquals((long)this.getRemoteReadsCount(), (long)remoteReadsCount);
        });
        long secondCachedReadsCount = this.getCachedReadsCount();
        long secondRemoteReadsCount = this.getRemoteReadsCount();
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        try {
            List<Callable<Object>> reads = Collections.nCopies(3, () -> {
                Assert.assertTrue((boolean)Arrays.equals(randomData, this.readFile(this.cachingFileSystem, file)));
                return null;
            });
            List futures = (List)reads.stream().map(executorService::submit).collect(ImmutableList.toImmutableList());
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            Assertions.assertGreaterThan((Comparable)Long.valueOf(this.getCachedReadsCount()), (Comparable)Long.valueOf(secondCachedReadsCount));
            Assert.assertEquals((long)this.getRemoteReadsCount(), (long)secondRemoteReadsCount);
        });
    }

    @Test
    public void testFileSystemBindings() throws Exception {
        this.initializeRubix(new RubixConfig());
        try (FileSystem fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("s3://bucket_name"));){
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoS3FileSystem.class);
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("s3a://bucket_name"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoS3FileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("s3n://bucket_name"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoS3FileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("abfs://fileanalysis@foo-bar.dfs.core.windows.net/tutorials"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoAzureBlobFileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("abfss://fileanalysis@foo-bar.dfs.core.windows.net/tutorials"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoSecureAzureBlobFileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("adl://fileanalysis@foo-bar.dfs.core.windows.net/tutorials"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoAdlFileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("gs://bucket_name"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoGoogleHadoopFileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        fileSystem = this.getCachingFileSystem(this.context, new org.apache.hadoop.fs.Path("hdfs://localhost:7897"));
        try {
            this.assertRawFileSystemInstanceOf(fileSystem, CachingPrestoDistributedFileSystem.class);
        }
        finally {
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
    }

    private void assertRawFileSystemInstanceOf(FileSystem actual, Class<? extends FileSystem> expectedType) {
        Assertions.assertInstanceOf((Object)actual, FilterFileSystem.class);
        FileSystem rawFileSystem = ((FilterFileSystem)actual).getRawFileSystem();
        Assertions.assertInstanceOf((Object)rawFileSystem, expectedType);
    }

    private byte[] readFile(FileSystem fileSystem, org.apache.hadoop.fs.Path path) {
        byte[] byArray;
        block8: {
            FSDataInputStream inputStream = fileSystem.open(path);
            try {
                byArray = ByteStreams.toByteArray((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private void writeFile(FSDataOutputStream outputStream, byte[] content) throws IOException {
        try {
            outputStream.write(content);
        }
        finally {
            outputStream.close();
        }
    }

    private org.apache.hadoop.fs.Path getStoragePath(String path) {
        return new org.apache.hadoop.fs.Path(String.format("file:///%s/storage/%s", this.tempDirectory, path));
    }

    private long getRemoteReadsCount() {
        try {
            long directRemoteReads = (Long)BEAN_SERVER.getAttribute(new ObjectName("rubix:name=stats,type=detailed,catalog=catalog"), "Direct_rrc_requests");
            long remoteReads = (Long)BEAN_SERVER.getAttribute(new ObjectName("rubix:name=stats,type=detailed,catalog=catalog"), "Remote_rrc_requests");
            return directRemoteReads + remoteReads;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private long getCachedReadsCount() {
        try {
            return (Long)BEAN_SERVER.getAttribute(new ObjectName("rubix:name=stats,type=detailed,catalog=catalog"), "Cached_rrc_requests");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private long getAsyncDownloadedMb(RubixConfig.ReadMode readMode) {
        if (readMode == RubixConfig.ReadMode.READ_THROUGH) {
            return 0L;
        }
        try {
            return (Long)BEAN_SERVER.getAttribute(new ObjectName("metrics:name=rubix.bookkeeper.count.async_downloaded_mb"), "Count");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

