/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.rubix;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.rubix.RubixConfig;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRubixConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((RubixConfig)ConfigAssertions.recordDefaults(RubixConfig.class)).setBookKeeperServerPort(8899).setDataTransferServerPort(8898).setCacheLocation(null).setCacheTtl(Duration.valueOf((String)"7d")).setDiskUsagePercentage(80).setReadMode(RubixConfig.ReadMode.ASYNC).setStartServerOnCoordinator(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.cache.read-mode", (Object)"read-through").put((Object)"hive.cache.location", (Object)"/some-directory").put((Object)"hive.cache.ttl", (Object)"5h").put((Object)"hive.cache.disk-usage-percentage", (Object)"90").put((Object)"hive.cache.bookkeeper-port", (Object)"1234").put((Object)"hive.cache.data-transfer-port", (Object)"1235").put((Object)"hive.cache.start-server-on-coordinator", (Object)"true").build();
        RubixConfig expected = new RubixConfig().setReadMode(RubixConfig.ReadMode.READ_THROUGH).setCacheLocation("/some-directory").setCacheTtl(Duration.valueOf((String)"5h")).setDiskUsagePercentage(90).setBookKeeperServerPort(1234).setDataTransferServerPort(1235).setStartServerOnCoordinator(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testReadModeFromString() {
        Assertions.assertThat((Comparable)RubixConfig.ReadMode.fromString((String)"async")).isEqualTo((Object)RubixConfig.ReadMode.ASYNC);
        Assertions.assertThat((Comparable)RubixConfig.ReadMode.fromString((String)"read-through")).isEqualTo((Object)RubixConfig.ReadMode.READ_THROUGH);
    }

    @Test
    public void testValidation() {
        ValidationAssertions.assertFailsValidation((Object)new RubixConfig().setDiskUsagePercentage(-1), (String)"diskUsagePercentage", (String)"must be greater than or equal to 0", Min.class);
        ValidationAssertions.assertFailsValidation((Object)new RubixConfig().setDiskUsagePercentage(200), (String)"diskUsagePercentage", (String)"must be less than or equal to 100", Max.class);
        ValidationAssertions.assertFailsValidation((Object)new RubixConfig().setCacheTtl(null), (String)"cacheTtl", (String)"may not be null", NotNull.class);
    }
}

