/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AbstractAmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class MockAmazonS3
extends AbstractAmazonS3 {
    private int getObjectHttpCode = 200;
    private int getObjectMetadataHttpCode = 200;
    private GetObjectMetadataRequest getObjectMetadataRequest;
    private CannedAccessControlList acl;
    private boolean hasGlacierObjects;
    private boolean hasHadoopFolderMarkerObjects;
    private final List<UploadPartRequest> uploadParts = new ArrayList<UploadPartRequest>();

    public void setGetObjectHttpErrorCode(int getObjectHttpErrorCode) {
        this.getObjectHttpCode = getObjectHttpErrorCode;
    }

    public void setGetObjectMetadataHttpCode(int getObjectMetadataHttpCode) {
        this.getObjectMetadataHttpCode = getObjectMetadataHttpCode;
    }

    public CannedAccessControlList getAcl() {
        return this.acl;
    }

    public void setHasGlacierObjects(boolean hasGlacierObjects) {
        this.hasGlacierObjects = hasGlacierObjects;
    }

    public void setHasHadoopFolderMarkerObjects(boolean hasHadoopFolderMarkerObjects) {
        this.hasHadoopFolderMarkerObjects = hasHadoopFolderMarkerObjects;
    }

    public GetObjectMetadataRequest getGetObjectMetadataRequest() {
        return this.getObjectMetadataRequest;
    }

    public List<UploadPartRequest> getUploadParts() {
        return this.uploadParts;
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) {
        this.getObjectMetadataRequest = getObjectMetadataRequest;
        if (this.getObjectMetadataHttpCode != 200) {
            AmazonS3Exception exception = new AmazonS3Exception("Failing getObjectMetadata call with " + this.getObjectMetadataHttpCode);
            exception.setStatusCode(this.getObjectMetadataHttpCode);
            throw exception;
        }
        return null;
    }

    public S3Object getObject(GetObjectRequest getObjectRequest) {
        if (this.getObjectHttpCode != 200) {
            AmazonS3Exception exception = new AmazonS3Exception("Failing getObject call with " + this.getObjectHttpCode);
            exception.setStatusCode(this.getObjectHttpCode);
            throw exception;
        }
        return null;
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        this.acl = putObjectRequest.getCannedAcl();
        return new PutObjectResult();
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) {
        String continuationToken = "continue";
        ListObjectsV2Result listingV2 = new ListObjectsV2Result();
        if ("continue".equals(listObjectsV2Request.getContinuationToken())) {
            S3ObjectSummary standardTwo = new S3ObjectSummary();
            standardTwo.setStorageClass(StorageClass.Standard.toString());
            standardTwo.setKey("test/standardTwo");
            standardTwo.setLastModified(new Date());
            listingV2.getObjectSummaries().add(standardTwo);
            if (this.hasGlacierObjects) {
                S3ObjectSummary glacier = new S3ObjectSummary();
                glacier.setStorageClass(StorageClass.Glacier.toString());
                glacier.setKey("test/glacier");
                glacier.setLastModified(new Date());
                listingV2.getObjectSummaries().add(glacier);
                S3ObjectSummary deepArchive = new S3ObjectSummary();
                deepArchive.setStorageClass(StorageClass.DeepArchive.toString());
                deepArchive.setKey("test/deepArchive");
                deepArchive.setLastModified(new Date());
                listingV2.getObjectSummaries().add(deepArchive);
            }
        } else {
            S3ObjectSummary standardOne = new S3ObjectSummary();
            standardOne.setStorageClass(StorageClass.Standard.toString());
            standardOne.setKey("test/standardOne");
            standardOne.setLastModified(new Date());
            listingV2.getObjectSummaries().add(standardOne);
            listingV2.setTruncated(true);
            listingV2.setNextContinuationToken("continue");
            if (this.hasHadoopFolderMarkerObjects) {
                S3ObjectSummary hadoopFolderMarker = new S3ObjectSummary();
                hadoopFolderMarker.setStorageClass(StorageClass.Standard.toString());
                hadoopFolderMarker.setKey("test/test_$folder$");
                hadoopFolderMarker.setLastModified(new Date());
                listingV2.getObjectSummaries().add(hadoopFolderMarker);
            }
        }
        return listingV2;
    }

    public PutObjectResult putObject(String bucketName, String key, String content) {
        return new PutObjectResult();
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws SdkClientException {
        this.acl = request.getCannedACL();
        InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
        result.setUploadId(UUID.randomUUID().toString());
        return result;
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws SdkClientException {
        this.uploadParts.add(request);
        return new UploadPartResult();
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws SdkClientException {
        return new CompleteMultipartUploadResult();
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest request) throws SdkClientException {
    }

    public void shutdown() {
    }
}

