/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.s3.S3SecurityMappingConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestS3SecurityMappingConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((S3SecurityMappingConfig)ConfigAssertions.recordDefaults(S3SecurityMappingConfig.class)).setConfigFile(null).setRoleCredentialName(null).setRefreshPeriod(null).setColonReplacement(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path securityMappingConfigFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.s3.security-mapping.config-file", (Object)securityMappingConfigFile.toString()).put((Object)"hive.s3.security-mapping.iam-role-credential-name", (Object)"credential-name").put((Object)"hive.s3.security-mapping.refresh-period", (Object)"1s").put((Object)"hive.s3.security-mapping.colon-replacement", (Object)"#").build();
        S3SecurityMappingConfig expected = new S3SecurityMappingConfig().setConfigFile(securityMappingConfigFile.toFile()).setRoleCredentialName("credential-name").setRefreshPeriod(Duration.valueOf((String)"1s")).setColonReplacement("#");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

