/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.s3select;

import io.prestosql.plugin.hive.s3select.S3SelectPushdown;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestS3SelectPushdown {
    private TextInputFormat inputFormat;

    @BeforeClass
    public void setUp() {
        this.inputFormat = new TextInputFormat();
        this.inputFormat.configure(new JobConf());
    }

    @Test
    public void testIsCompressionCodecSupported() {
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.gz")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.lz4")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.snappy")));
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.bz2")));
    }
}

