/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.statistics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveTestUtils;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.metastore.DateStatistics;
import io.prestosql.plugin.hive.metastore.DecimalStatistics;
import io.prestosql.plugin.hive.metastore.DoubleStatistics;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.IntegerStatistics;
import io.prestosql.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.prestosql.plugin.hive.util.HiveUtil;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.statistics.ColumnStatistics;
import io.prestosql.spi.statistics.DoubleRange;
import io.prestosql.spi.statistics.Estimate;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMetastoreHiveStatisticsProvider {
    private static final SchemaTableName TABLE = new SchemaTableName("schema", "table");
    private static final String PARTITION = "partition";
    private static final String COLUMN = "column";
    private static final DecimalType DECIMAL = DecimalType.createDecimalType((int)5, (int)3);
    private static final HiveColumnHandle PARTITION_COLUMN_1 = HiveColumnHandle.createBaseColumn((String)"p1", (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
    private static final HiveColumnHandle PARTITION_COLUMN_2 = HiveColumnHandle.createBaseColumn((String)"p2", (int)1, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    @Test
    public void testGetPartitionsSample() {
        HivePartition p1 = TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234");
        HivePartition p2 = TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=2345");
        HivePartition p3 = TestMetastoreHiveStatisticsProvider.partition("p1=string3/p2=3456");
        HivePartition p4 = TestMetastoreHiveStatisticsProvider.partition("p1=string4/p2=4567");
        HivePartition p5 = TestMetastoreHiveStatisticsProvider.partition("p1=string5/p2=5678");
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1), (int)1), (Collection)ImmutableList.of((Object)p1));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1), (int)2), (Collection)ImmutableList.of((Object)p1));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2), (int)2), (Collection)ImmutableList.of((Object)p1, (Object)p2));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3), (int)2), (Collection)ImmutableList.of((Object)p1, (Object)p3));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)1), (Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)1));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)3), (Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4), (int)3));
        Assert.assertEquals((Collection)MetastoreHiveStatisticsProvider.getPartitionsSample((List)ImmutableList.of((Object)p1, (Object)p2, (Object)p3, (Object)p4, (Object)p5), (int)3), (Collection)ImmutableList.of((Object)p1, (Object)p5, (Object)p4));
    }

    @Test
    public void testValidatePartitionStatistics() {
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(-1L, 0L, 0L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("fileCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, -1L, 0L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("rowCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, -1L, 0L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("inMemoryDataSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, -1L)).build(), TestMetastoreHiveStatisticsProvider.invalidPartitionStatistics("onDiskDataSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setMaxValueSizeInBytes(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("maxValueSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setTotalSizeInBytes(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("totalSizeInBytes must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("nullsCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("nullsCount must be less than or equal to rowCount. nullsCount: 1. rowCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesCount(-1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("distinctValuesCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesCount(1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("distinctValuesCount must be less than or equal to rowCount. distinctValuesCount: 1. rowCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 1L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setDistinctValuesCount(1L).setNullsCount(1L).build())).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("distinctValuesCount must be less than or equal to nonNullsCount. distinctValuesCount: 1. nonNullsCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("integerStatistics.min must be less than or equal to integerStatistics.max. integerStatistics.min: 1. integerStatistics.max: -1."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(1.0), (OptionalDouble)OptionalDouble.of(-1.0), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("doubleStatistics.min must be less than or equal to doubleStatistics.max. doubleStatistics.min: 1.0. doubleStatistics.max: -1.0."));
        MetastoreHiveStatisticsProvider.validatePartitionStatistics((SchemaTableName)TABLE, (Map)ImmutableMap.of((Object)PARTITION, (Object)PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(Double.NaN), (OptionalDouble)OptionalDouble.of(Double.NaN), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build()));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(BigDecimal.valueOf(1L)), Optional.of(BigDecimal.valueOf(-1L)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("decimalStatistics.min must be less than or equal to decimalStatistics.max. decimalStatistics.min: 1. decimalStatistics.max: -1."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createDateColumnStatistics(Optional.of(LocalDate.ofEpochDay(1L)), Optional.of(LocalDate.ofEpochDay(-1L)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("dateStatistics.min must be less than or equal to dateStatistics.max. dateStatistics.min: 1970-01-02. dateStatistics.max: 1969-12-31."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("trueCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(-1L), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("falseCount must be greater than or equal to zero: -1"));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("booleanStatistics.trueCount must be less than or equal to rowCount. booleanStatistics.trueCount: 1. rowCount: 0."));
        TestMetastoreHiveStatisticsProvider.assertInvalidStatistics(PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(0L, 0L, 0L, 0L)).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.empty()))).build(), TestMetastoreHiveStatisticsProvider.invalidColumnStatistics("booleanStatistics.falseCount must be less than or equal to rowCount. booleanStatistics.falseCount: 1. rowCount: 0."));
    }

    @Test
    public void testCalculateAverageRowsPerPartition() {
        Assertions.assertThat((OptionalDouble)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of())).isEmpty();
        Assertions.assertThat((OptionalDouble)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)PartitionStatistics.empty()))).isEmpty();
        Assertions.assertThat((OptionalDouble)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)PartitionStatistics.empty(), (Object)PartitionStatistics.empty()))).isEmpty();
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L))), (Object)OptionalDouble.of(10.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)PartitionStatistics.empty())), (Object)OptionalDouble.of(10.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(20L))), (Object)OptionalDouble.of(15.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition((Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(10L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(20L), (Object)PartitionStatistics.empty())), (Object)OptionalDouble.of(15.0));
    }

    @Test
    public void testCalculateDistinctPartitionKeys() {
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of()), (long)0L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"))), (long)1L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=1234"))), (long)2L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string2/p2=1234"))), (long)1L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235"))), (long)2L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235"))), (long)1L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=123/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235"))), (long)1L);
        Assert.assertEquals((long)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys((HiveColumnHandle)PARTITION_COLUMN_2, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=123/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"))), (long)0L);
    }

    @Test
    public void testCalculateNullsFractionForPartitioningKey() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)0.0), (Object)0.0);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)4000.0), (Object)0.0);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0, (double)4000.0), (Object)0.25);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)PartitionStatistics.empty()), (double)2000.0, (double)4000.0), (Object)0.5);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234")), (Map)ImmutableMap.of(), (double)2000.0, (double)4000.0), (Object)0.5);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(2000L)), (double)3000.0, (double)4000.0), (Object)0.75);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)PartitionStatistics.empty()), (double)3000.0, (double)4000.0), (Object)1.0);
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=4321")), (Map)ImmutableMap.of((Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=__HIVE_DEFAULT_PARTITION__/p2=4321", (Object)PartitionStatistics.empty()), (double)4000.0, (double)4000.0), (Object)1.0);
    }

    @Test
    public void testCalculateDataSizeForPartitioningKey() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)2000.0), (Object)Estimate.of((double)7000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)PartitionStatistics.empty()), (double)2000.0), (Object)Estimate.of((double)14000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=str2/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(2000L)), (double)3000.0), (Object)Estimate.of((double)15000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of((Object)"p1=string1/p2=1234", (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)"p1=str2/p2=1234", (Object)PartitionStatistics.empty()), (double)3000.0), (Object)Estimate.of((double)19000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of(), (double)3000.0), (Object)Estimate.of((double)33000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=__HIVE_DEFAULT_PARTITION__/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=str2/p2=1234")), (Map)ImmutableMap.of(), (double)3000.0), (Object)Estimate.of((double)12000.0));
    }

    @Test
    public void testCalculateRangeForPartitioningKey() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_1, (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=__HIVE_DEFAULT_PARTITION__"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1"))), Optional.of(new DoubleRange(1.0, 1.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey((HiveColumnHandle)PARTITION_COLUMN_2, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=2"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1"))), Optional.of(new DoubleRange(1.0, 2.0)));
    }

    @Test
    public void testConvertPartitionValueToDouble() {
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)BigintType.BIGINT, "123456", 123456.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)IntegerType.INTEGER, "12345", 12345.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)SmallintType.SMALLINT, "1234", 1234.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)TinyintType.TINYINT, "123", 123.0);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DoubleType.DOUBLE, "0.1", 0.1);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)RealType.REAL, "0.2", 0.2f);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DecimalType.createDecimalType((int)5, (int)2), "123.45", 123.45);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DecimalType.createDecimalType((int)25, (int)5), "12345678901234567890.12345", 1.2345678901234567E19);
        TestMetastoreHiveStatisticsProvider.assertConvertPartitionValueToDouble((Type)DateType.DATE, "1970-01-02", 1.0);
    }

    private static void assertConvertPartitionValueToDouble(Type type, String value, double expected) {
        Object prestoValue = HiveUtil.parsePartitionValue((String)String.format("p=%s", value), (String)value, (Type)type).getValue();
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.convertPartitionValueToDouble((Type)type, (Object)prestoValue), (Object)OptionalDouble.of(expected));
    }

    @Test
    public void testCreateDataColumnStatistics() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of()), (Object)ColumnStatistics.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of((Object)PartitionStatistics.empty(), (Object)PartitionStatistics.empty())), (Object)ColumnStatistics.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.createDataColumnStatistics((String)COLUMN, (Type)BigintType.BIGINT, (double)1000.0, (Collection)ImmutableList.of((Object)new PartitionStatistics(HiveBasicStatistics.createZeroStatistics(), (Map)ImmutableMap.of((Object)"column2", (Object)HiveColumnStatistics.empty())))), (Object)ColumnStatistics.empty());
    }

    @Test
    public void testCalculateDistinctValuesCount() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of()), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.empty())), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.empty(), (Object)HiveColumnStatistics.empty())), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L))), (Object)Estimate.of((double)1.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L), (Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(2L))), (Object)Estimate.of((double)2.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.distinctValuesCount(1L), (Object)HiveColumnStatistics.empty())), (Object)Estimate.of((double)1.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.of((double)1.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.of((double)2.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.of((double)1.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.of((double)0.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDistinctValuesCount((List)ImmutableList.of((Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty()), (Object)HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(1L), (OptionalLong)OptionalLong.of(10L), (OptionalLong)OptionalLong.empty()))), (Object)Estimate.of((double)2.0));
    }

    @Test
    public void testCalculateNullsFraction() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of()), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)PartitionStatistics.empty())), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L))), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)TestMetastoreHiveStatisticsProvider.nullsCount(500L))), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L), (Object)TestMetastoreHiveStatisticsProvider.nullsCount(500L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(1000L, 500L))), (Object)Estimate.of((double)0.5));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(2000L, 200L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(1000L, 100L))), (Object)Estimate.of((double)0.1));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateNullsFraction((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(0L, 0L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndNullsCount(0L, 0L))), (Object)Estimate.of((double)0.0));
    }

    @Test
    public void testCalculateDataSize() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of(), (double)0.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of(), (double)1000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)PartitionStatistics.empty()), (double)1000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)1000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L)), (double)1000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(1000L)), (double)1000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 1000L)), (double)2000.0), (Object)Estimate.of((double)4000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(0L, 0L)), (double)2000.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(0L, 0L)), (double)0.0), (Object)Estimate.zero());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 0L)), (double)2000.0), (Object)Estimate.of((double)0.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 5000L)), (double)5000.0), (Object)Estimate.of((double)20000.0));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateDataSize((String)COLUMN, (Collection)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dataSize(1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(500L, 1000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCount(3000L), (Object)TestMetastoreHiveStatisticsProvider.rowsCountAndDataSize(1000L, 5000L)), (double)5000.0), (Object)Estimate.of((double)20000.0));
    }

    @Test
    public void testCalculateRange() {
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of()), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L))), Optional.of(new DoubleRange(1.0, 2.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE))), Optional.of(new DoubleRange(-9.223372036854776E18, 9.223372036854776E18)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE))), Optional.of(new DoubleRange(-2.147483648E9, 2.147483647E9)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE))), Optional.of(new DoubleRange(-32768.0, 32767.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)TinyintType.TINYINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(Long.MIN_VALUE, Long.MAX_VALUE))), Optional.of(new DoubleRange(-128.0, 127.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 5L), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L))), Optional.of(new DoubleRange(1.0, 7.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.empty()), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L))), Optional.of(new DoubleRange(3.0, 7.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.empty(), OptionalLong.of(8L)), (Object)TestMetastoreHiveStatisticsProvider.integerRange(3L, 7L))), Optional.of(new DoubleRange(3.0, 7.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.integerRange(1L, 2L))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.empty(), OptionalDouble.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2))), Optional.of(new DoubleRange(0.1, 0.2)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25))), Optional.of(new DoubleRange(0.1, 0.25)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25))), Optional.of(new DoubleRange(0.1, 0.25)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.empty(), OptionalDouble.of(0.2)), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.15, 0.25))), Optional.of(new DoubleRange(0.15, 0.25)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NaN, 0.2))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, Double.NaN))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NaN, Double.NaN))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY))), Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)RealType.REAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY))), Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY))), Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), (Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2))), Optional.of(new DoubleRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-01", "1970-01-02"))), Optional.of(new DoubleRange(0.0, 1.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange(Optional.empty(), Optional.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange(Optional.of("1970-01-01"), Optional.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DateType.DATE, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-01", "1970-01-05"), (Object)TestMetastoreHiveStatisticsProvider.dateRange("1970-01-03", "1970-01-07"))), Optional.of(new DoubleRange(0.0, 6.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.doubleRange(0.1, 0.2))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(1L), BigDecimal.valueOf(5L)))), Optional.of(new DoubleRange(1.0, 5.0)));
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(Optional.empty(), Optional.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(Optional.of(BigDecimal.valueOf(1L)), Optional.empty()))), Optional.empty());
        Assert.assertEquals((Object)MetastoreHiveStatisticsProvider.calculateRange((Type)DECIMAL, (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(1L), BigDecimal.valueOf(5L)), (Object)TestMetastoreHiveStatisticsProvider.decimalRange(BigDecimal.valueOf(3L), BigDecimal.valueOf(7L)))), Optional.of(new DoubleRange(1.0, 7.0)));
    }

    @Test
    public void testGetTableStatistics() {
        String partitionName = "p1=string1/p2=1234";
        PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(1000L), OptionalLong.empty(), OptionalLong.empty())).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-100L), (OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(500L), (OptionalLong)OptionalLong.of(300L)))).build();
        MetastoreHiveStatisticsProvider statisticsProvider = new MetastoreHiveStatisticsProvider((session, table, hivePartitions) -> ImmutableMap.of((Object)partitionName, (Object)statistics));
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)COLUMN, (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableStatistics expected = TableStatistics.builder().setRowCount(Estimate.of((double)1000.0)).setColumnStatistics((ColumnHandle)PARTITION_COLUMN_1, ColumnStatistics.builder().setDataSize(Estimate.of((double)7000.0)).setNullsFraction(Estimate.of((double)0.0)).setDistinctValuesCount(Estimate.of((double)1.0)).build()).setColumnStatistics((ColumnHandle)PARTITION_COLUMN_2, ColumnStatistics.builder().setRange(new DoubleRange(1234.0, 1234.0)).setNullsFraction(Estimate.of((double)0.0)).setDistinctValuesCount(Estimate.of((double)1.0)).build()).setColumnStatistics((ColumnHandle)columnHandle, ColumnStatistics.builder().setRange(new DoubleRange(-100.0, 100.0)).setNullsFraction(Estimate.of((double)0.5)).setDistinctValuesCount(Estimate.of((double)300.0)).build()).build();
        Assert.assertEquals((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of((Object)"p1", (Object)PARTITION_COLUMN_1, (Object)"p2", (Object)PARTITION_COLUMN_2, (Object)COLUMN, (Object)columnHandle), (Map)ImmutableMap.of((Object)"p1", (Object)VarcharType.VARCHAR, (Object)"p2", (Object)BigintType.BIGINT, (Object)COLUMN, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName))), (Object)expected);
    }

    @Test
    public void testGetTableStatisticsUnpartitioned() {
        PartitionStatistics statistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(1000L), OptionalLong.empty(), OptionalLong.empty())).setColumnStatistics((Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(-100L), (OptionalLong)OptionalLong.of(100L), (OptionalLong)OptionalLong.of(500L), (OptionalLong)OptionalLong.of(300L)))).build();
        MetastoreHiveStatisticsProvider statisticsProvider = new MetastoreHiveStatisticsProvider((session, table, hivePartitions) -> ImmutableMap.of((Object)"<UNPARTITIONED>", (Object)statistics));
        HiveColumnHandle columnHandle = HiveColumnHandle.createBaseColumn((String)COLUMN, (int)2, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        TableStatistics expected = TableStatistics.builder().setRowCount(Estimate.of((double)1000.0)).setColumnStatistics((ColumnHandle)columnHandle, ColumnStatistics.builder().setRange(new DoubleRange(-100.0, 100.0)).setNullsFraction(Estimate.of((double)0.5)).setDistinctValuesCount(Estimate.of((double)300.0)).build()).build();
        Assert.assertEquals((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of((Object)COLUMN, (Object)columnHandle), (Map)ImmutableMap.of((Object)COLUMN, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)new HivePartition(TABLE))), (Object)expected);
    }

    @Test
    public void testGetTableStatisticsEmpty() {
        String partitionName = "p1=string1/p2=1234";
        MetastoreHiveStatisticsProvider statisticsProvider = new MetastoreHiveStatisticsProvider((session, table, hivePartitions) -> ImmutableMap.of((Object)partitionName, (Object)PartitionStatistics.empty()));
        Assert.assertEquals((Object)statisticsProvider.getTableStatistics(HiveTestUtils.SESSION, TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName))), (Object)TableStatistics.empty());
    }

    @Test
    public void testGetTableStatisticsSampling() {
        MetastoreHiveStatisticsProvider statisticsProvider = new MetastoreHiveStatisticsProvider((session, table, hivePartitions) -> {
            Assert.assertEquals((Object)table, (Object)TABLE);
            Assert.assertEquals((int)hivePartitions.size(), (int)1);
            return ImmutableMap.of();
        });
        ConnectorSession session2 = HiveTestUtils.getHiveSession(new HiveConfig().setPartitionStatisticsSampleSize(1));
        statisticsProvider.getTableStatistics(session2, TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1234"), (Object)TestMetastoreHiveStatisticsProvider.partition("p1=string1/p2=1235")));
    }

    @Test
    public void testGetTableStatisticsValidationFailure() {
        PartitionStatistics corruptedStatistics = PartitionStatistics.builder().setBasicStatistics(new HiveBasicStatistics(-1L, 0L, 0L, 0L)).build();
        String partitionName = "p1=string1/p2=1234";
        MetastoreHiveStatisticsProvider statisticsProvider = new MetastoreHiveStatisticsProvider((session, table, hivePartitions) -> ImmutableMap.of((Object)partitionName, (Object)corruptedStatistics));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statisticsProvider.getTableStatistics(HiveTestUtils.getHiveSession(new HiveConfig().setIgnoreCorruptedStatistics(false)), TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName)))).isInstanceOf(PrestoException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode());
        Assert.assertEquals((Object)statisticsProvider.getTableStatistics(HiveTestUtils.getHiveSession(new HiveConfig().setIgnoreCorruptedStatistics(true)), TABLE, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)TestMetastoreHiveStatisticsProvider.partition(partitionName))), (Object)TableStatistics.empty());
    }

    private static void assertInvalidStatistics(PartitionStatistics partitionStatistics, String expectedMessage) {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetastoreHiveStatisticsProvider.validatePartitionStatistics((SchemaTableName)TABLE, (Map)ImmutableMap.of((Object)PARTITION, (Object)partitionStatistics))).isInstanceOf(PrestoException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode())).hasMessage(expectedMessage);
    }

    private static String invalidPartitionStatistics(String message) {
        return String.format("Corrupted partition statistics (Table: %s Partition: [%s]): %s", TABLE, PARTITION, message);
    }

    private static String invalidColumnStatistics(String message) {
        return String.format("Corrupted partition statistics (Table: %s Partition: [%s] Column: %s): %s", TABLE, PARTITION, COLUMN, message);
    }

    private static HivePartition partition(String name) {
        return HivePartitionManager.parsePartition((SchemaTableName)TABLE, (String)name, (List)ImmutableList.of((Object)PARTITION_COLUMN_1, (Object)PARTITION_COLUMN_2), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
    }

    private static PartitionStatistics rowsCount(long rowsCount) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of());
    }

    private static PartitionStatistics nullsCount(long nullsCount) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(nullsCount).build()));
    }

    private static PartitionStatistics dataSize(long dataSize) {
        return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setTotalSizeInBytes(dataSize).build()));
    }

    private static PartitionStatistics rowsCountAndNullsCount(long rowsCount, long nullsCount) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setNullsCount(nullsCount).build()));
    }

    private static PartitionStatistics rowsCountAndDataSize(long rowsCount, long dataSize) {
        return new PartitionStatistics(new HiveBasicStatistics(0L, rowsCount, 0L, 0L), (Map)ImmutableMap.of((Object)COLUMN, (Object)HiveColumnStatistics.builder().setTotalSizeInBytes(dataSize).build()));
    }

    private static HiveColumnStatistics distinctValuesCount(long count) {
        return HiveColumnStatistics.builder().setDistinctValuesCount(count).build();
    }

    private static HiveColumnStatistics integerRange(long min, long max) {
        return TestMetastoreHiveStatisticsProvider.integerRange(OptionalLong.of(min), OptionalLong.of(max));
    }

    private static HiveColumnStatistics integerRange(OptionalLong min, OptionalLong max) {
        return HiveColumnStatistics.builder().setIntegerStatistics(new IntegerStatistics(min, max)).build();
    }

    private static HiveColumnStatistics doubleRange(double min, double max) {
        return TestMetastoreHiveStatisticsProvider.doubleRange(OptionalDouble.of(min), OptionalDouble.of(max));
    }

    private static HiveColumnStatistics doubleRange(OptionalDouble min, OptionalDouble max) {
        return HiveColumnStatistics.builder().setDoubleStatistics(new DoubleStatistics(min, max)).build();
    }

    private static HiveColumnStatistics dateRange(String min, String max) {
        return TestMetastoreHiveStatisticsProvider.dateRange(Optional.of(min), Optional.of(max));
    }

    private static HiveColumnStatistics dateRange(Optional<String> min, Optional<String> max) {
        return HiveColumnStatistics.builder().setDateStatistics(new DateStatistics(min.map(TestMetastoreHiveStatisticsProvider::parseDate), max.map(TestMetastoreHiveStatisticsProvider::parseDate))).build();
    }

    private static LocalDate parseDate(String date) {
        return LocalDate.parse(date);
    }

    private static HiveColumnStatistics decimalRange(BigDecimal min, BigDecimal max) {
        return TestMetastoreHiveStatisticsProvider.decimalRange(Optional.of(min), Optional.of(max));
    }

    private static HiveColumnStatistics decimalRange(Optional<BigDecimal> min, Optional<BigDecimal> max) {
        return HiveColumnStatistics.builder().setDecimalStatistics(new DecimalStatistics(min, max)).build();
    }
}

